/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes;

import CIspace.bayes.BayesCanvas;
import CIspace.bayes.BayesGraph;
import CIspace.bayes.dialogs.BayesProblemDialog;
import CIspace.bayes.dialogs.OptimizationPromptDialog;
import CIspace.bayes.help.BayesHelpCanvas;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.help.HelpFrame;
import CIspace.graphToolKit.help.HelpMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class BayesWindow
extends GraphWindow {
    public static final String FONT_NAME = "SansSerif";
    protected ImageIcon modifyProbIcon = GraphWindow.createImageIcon("images/modifyProbTable.png");
    protected ImageIcon viewProbIcon = GraphWindow.createImageIcon("images/viewProbTable.png");
    protected ImageIcon toggleMonitoringIcon = GraphWindow.createImageIcon("images/toggleMonitoring.png");
    protected ImageIcon makeObservationIcon = GraphWindow.createImageIcon("images/Zoom24.gif");
    protected ImageIcon queryEvidenceIcon = GraphWindow.createImageIcon("images/queryNetwork.png");
    protected ImageIcon queryNodeIcon = GraphWindow.createImageIcon("images/queryNode.png");
    protected ImageIcon viewDecisionIcon = GraphWindow.createImageIcon("images/viewDecision.png");
    protected ImageIcon optimizeDecisionIcon = GraphWindow.createImageIcon("images/optimizeDecision.png");
    protected ImageIcon noForgettingIcon = GraphWindow.createImageIcon("images/noforgettingarcs.png");
    protected ImageIcon quizIcon = GraphWindow.createImageIcon("images/quiz.gif");
    protected JRadioButtonMenuItem[] decimalPlaceCheckboxes;
    protected JRadioButtonMenuItem decisionModeCheckbox;
    protected JRadioButtonMenuItem beliefModeCheckbox;
    protected JRadioButtonMenuItem briefQueryCheckbox;
    protected JRadioButtonMenuItem verboseQueryCheckbox;
    protected JRadioButtonMenuItem promptQueryCheckbox;
    protected JMenuItem bifRepresentationMenuItem;
    protected JMenuItem xmlRepresentationMenuItem;
    private boolean isCheckingPoliciesEnabled;

    public BayesWindow(JApplet parent) {
        super(parent);
        this.initializeAppletInfo();
        this.setTitle(String.valueOf(GraphWindow.appletTitle) + " --- untitled.xml");
        this.construct();
        this.initialize();
        this.setSize(1010, 700);
        this.centerWindow();
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        GraphWindow.appletTitle = "Belief and Decision Network Applet Version 5.1.1";
        GraphWindow.appletName = "bayes";
        GraphWindow.aboutText = "About this Applet\n\n" + GraphWindow.appletTitle + "\n\n" + "This applet was written by Kyle Porter, David Poole, Jacek Kisynski, \n" + "Shinjiro Sueda, and Byron Knoll, with help from Alan Mackworth, \n" + "Holger Hoos, Peter Gorniak, and Cristina Conati.";
    }

    private void initialize() {
        this.setDecisionNetworkMode(false);
        this.setAlgoText("  Belief Network Mode");
        this.otherSavedButtonIndex = 4;
        this.isCheckingPoliciesEnabled = true;
        this.setFont(new Font(FONT_NAME, 0, 12));
        this.actionPerformed(new ActionEvent(this.createButModes[0], 0, this.createButModes[0].getActionCommand()));
        this.createButModes[0].setSelected(true);
    }

    private void construct() {
        this.switchTab("Create");
        this.algoText.setVisible(true);
        this.algoText.setFont(new Font("Arial", 1, 15));
        this.tabandbottom.setDividerSize(0);
        this.tabandbottom.setOneTouchExpandable(false);
        this.tabandbottom.setBottomComponent(this.algoText);
        this.tabandbottom.setResizeWeight(1.0);
    }

    protected void getCanvas() {
        this.canvas = new BayesCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 22, 32);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7000);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    protected void createToolBar() {
        super.createToolBar();
        this.createButModes[1].setActionCommand("Create Arc");
        if (this.isDecisionNetworkModeEnabled()) {
            this.setCreateButtons(5, this.modifyProbIcon, "Modify Probability/Utility");
        } else {
            this.setCreateButtons(5, this.modifyProbIcon, "Modify Probability Table");
        }
        this.createToolBarLayout();
    }

    protected void createToolBarWithText() {
        super.createToolBarWithText();
        this.createButModes[1].setText("Create Arc");
        this.createButModes[1].setActionCommand("Create Arc");
        if (this.isDecisionNetworkModeEnabled()) {
            this.setCreateButtonsWithText(5, "Modify Probability/Utility", this.modifyProbIcon, "Modify Probability/Utility");
        } else {
            this.setCreateButtonsWithText(5, "Modify Probability Table", this.modifyProbIcon, "Modify Probability Table");
        }
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        int i = 0;
        while (i < 6) {
            if (i == 5) {
                this.toolBar.addSeparator();
            }
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.createButModes[1].setToolTipText("Create Arc");
        this.createButModes[1].setToolTipText("Create Arc");
    }

    protected void solveToolBar() {
        this.solveButModes = new JToggleButton[11];
        this.setSolveButtons(0, this.makeObservationIcon, "Make Observation");
        this.setSolveButtons(1, this.queryNodeIcon, "   Query   ");
        this.setSolveButtons(2, this.queryEvidenceIcon, "P(e) Query");
        this.setSolveButtons(3, this.toggleMonitoringIcon, "Toggle Monitoring");
        this.setSolveButtons(4, this.selectIcon, "Select");
        if (this.isDecisionNetworkModeEnabled()) {
            this.setSolveButtons(5, this.viewProbIcon, "View Probability/Utility");
        } else {
            this.setSolveButtons(5, this.viewProbIcon, "View Probability Table");
        }
        this.setSolveButtons(6, this.viewDecisionIcon, "View/Modify Decision");
        this.setSolveButtons(7, this.noForgettingIcon, "Add No-forgetting Arcs");
        this.setSolveButtons(8, this.optimizeDecisionIcon, "Optimize Decisions");
        this.setSolveButtons(9, this.quizIcon, "Independence Quiz");
        this.setSolveButtons(10, this.quizIcon, "Fake");
        this.solveToolBarLayout();
    }

    protected void solveToolBarWithText() {
        this.solveButModes = new JToggleButton[11];
        this.setSolveButtonsWithText(0, "Make Observation", this.makeObservationIcon, "Make Observation");
        this.setSolveButtonsWithText(1, "   Query   ", this.queryNodeIcon, "   Query   ");
        this.setSolveButtonsWithText(2, "P(e) Query", this.queryEvidenceIcon, "P(e) Query");
        this.setSolveButtonsWithText(3, "Toggle Monitoring", this.toggleMonitoringIcon, "Toggle Monitoring");
        this.setSolveButtonsWithText(4, "   Select   ", this.selectIcon, "Select");
        if (this.isDecisionNetworkModeEnabled()) {
            this.setSolveButtonsWithText(5, "View Probability/Utility", this.viewProbIcon, "View Probability/Utility");
        } else {
            this.setSolveButtonsWithText(5, "View Probability Table", this.viewProbIcon, "View Probability Table");
        }
        this.setSolveButtonsWithText(6, "View/Modify Decision", this.viewDecisionIcon, "View/Modify Decision");
        this.setSolveButtonsWithText(7, "Add No-forgetting Arcs", this.noForgettingIcon, "Add No-forgetting Arcs");
        this.setSolveButtonsWithText(8, "Optimize Decisions", this.optimizeDecisionIcon, "Optimize Decisions");
        this.setSolveButtonsWithText(9, "Independence Quiz", this.quizIcon, "Independence Quiz");
        this.setSolveButtonsWithText(10, "Fake", this.quizIcon, "Fake");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.toolBar.removeAll();
        this.solveModeButGroup = new ButtonGroup();
        ButtonGroup solveActionButGroup = new ButtonGroup();
        if (!this.isDecisionNetworkModeEnabled()) {
            this.solveButModes[6].setEnabled(false);
            this.solveButModes[7].setEnabled(false);
            this.solveButModes[8].setEnabled(false);
        }
        this.solveButModes[10].setVisible(false);
        int i = 0;
        while (i < 7) {
            if (i == 4) {
                this.toolBar.addSeparator();
            }
            if (i != 2) {
                this.solveModeButGroup.add(this.solveButModes[i]);
            }
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.toolBar.addSeparator();
        i = 7;
        while (i < 11) {
            if (i == 9) {
                this.toolBar.addSeparator();
            }
            solveActionButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        solveActionButGroup.add(this.solveButModes[2]);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        menuBar.add((Component)this.createBayesMenu(), 3);
        return menuBar;
    }

    protected JMenu createHelpMenu() {
        return new HelpMenu("bayes", this);
    }

    protected JMenu createFileMenu() {
        JMenu m = super.createFileMenu();
        m.remove(0);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        this.bifRepresentationMenuItem = new JMenuItem("View/Edit Text Representation (.bif format)");
        this.bifRepresentationMenuItem.setMnemonic(66);
        this.bifRepresentationMenuItem.setActionCommand(this.bifRepresentationMenuItem.getText());
        this.bifRepresentationMenuItem.addActionListener(this);
        menu.add(this.bifRepresentationMenuItem);
        this.xmlRepresentationMenuItem = new JMenuItem("View/Edit Text Representation (.xml format)");
        this.xmlRepresentationMenuItem.setMnemonic(88);
        this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
        this.xmlRepresentationMenuItem.addActionListener(this);
        menu.add(this.xmlRepresentationMenuItem);
        return menu;
    }

    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.remove(5);
        return m;
    }

    protected JMenu createBayesMenu() {
        JMenu menu = new JMenu("Network Options");
        menu.setMnemonic(78);
        ButtonGroup group = new ButtonGroup();
        JMenu subMenu = new JMenu("Query Modes");
        subMenu.setMnemonic(81);
        this.briefQueryCheckbox = new JRadioButtonMenuItem("Brief Query Mode", false);
        this.briefQueryCheckbox.setActionCommand(this.briefQueryCheckbox.getText());
        this.briefQueryCheckbox.addActionListener(this);
        group.add(this.briefQueryCheckbox);
        subMenu.add(this.briefQueryCheckbox);
        this.verboseQueryCheckbox = new JRadioButtonMenuItem("Verbose Query Mode", false);
        this.verboseQueryCheckbox.setActionCommand(this.verboseQueryCheckbox.getText());
        this.verboseQueryCheckbox.addActionListener(this);
        group.add(this.verboseQueryCheckbox);
        subMenu.add(this.verboseQueryCheckbox);
        this.promptQueryCheckbox = new JRadioButtonMenuItem("Prompt for Query Mode", true);
        this.promptQueryCheckbox.setActionCommand(this.promptQueryCheckbox.getText());
        this.promptQueryCheckbox.addActionListener(this);
        group.add(this.promptQueryCheckbox);
        subMenu.add(this.promptQueryCheckbox);
        menu.add(subMenu);
        this.decimalPlaceCheckboxes = new JRadioButtonMenuItem[5];
        group = new ButtonGroup();
        subMenu = new JMenu("Decimal Places for Monitoring");
        subMenu.setMnemonic(68);
        this.decimalPlaceCheckboxes[0] = new JRadioButtonMenuItem("1", false);
        this.decimalPlaceCheckboxes[0].addActionListener(this);
        group.add(this.decimalPlaceCheckboxes[0]);
        subMenu.add(this.decimalPlaceCheckboxes[0]);
        this.decimalPlaceCheckboxes[1] = new JRadioButtonMenuItem("2", true);
        this.decimalPlaceCheckboxes[1].addActionListener(this);
        group.add(this.decimalPlaceCheckboxes[1]);
        subMenu.add(this.decimalPlaceCheckboxes[1]);
        this.decimalPlaceCheckboxes[2] = new JRadioButtonMenuItem("3", false);
        this.decimalPlaceCheckboxes[2].addActionListener(this);
        group.add(this.decimalPlaceCheckboxes[2]);
        subMenu.add(this.decimalPlaceCheckboxes[2]);
        this.decimalPlaceCheckboxes[3] = new JRadioButtonMenuItem("4", false);
        this.decimalPlaceCheckboxes[3].addActionListener(this);
        group.add(this.decimalPlaceCheckboxes[3]);
        subMenu.add(this.decimalPlaceCheckboxes[3]);
        this.decimalPlaceCheckboxes[4] = new JRadioButtonMenuItem("5", false);
        this.decimalPlaceCheckboxes[4].addActionListener(this);
        group.add(this.decimalPlaceCheckboxes[4]);
        subMenu.add(this.decimalPlaceCheckboxes[4]);
        menu.add(subMenu);
        menu.addSeparator();
        group = new ButtonGroup();
        subMenu = new JMenu("Belief/Decision Mode");
        subMenu.setMnemonic(66);
        this.beliefModeCheckbox = new JRadioButtonMenuItem("Belief Network Mode", false);
        this.beliefModeCheckbox.setActionCommand(this.beliefModeCheckbox.getText());
        this.beliefModeCheckbox.addActionListener(this);
        this.beliefModeCheckbox.setSelected(true);
        group.add(this.beliefModeCheckbox);
        subMenu.add(this.beliefModeCheckbox);
        this.decisionModeCheckbox = new JRadioButtonMenuItem("Decision Network Mode", false);
        this.decisionModeCheckbox.setActionCommand(this.decisionModeCheckbox.getText());
        this.decisionModeCheckbox.addActionListener(this);
        group.add(this.decisionModeCheckbox);
        subMenu.add(this.decisionModeCheckbox);
        menu.add(subMenu);
        return menu;
    }

    public void switchTab(String str) {
        super.switchTab(str);
        if (this.decisionModeCheckbox.isSelected()) {
            this.setAlgoText("  Decision Network Mode");
        } else {
            this.setAlgoText("  Belief Network Mode");
        }
        if (str.equals("Create")) {
            this.bifRepresentationMenuItem.setText("View/Edit Text Representation (.bif format)");
            this.bifRepresentationMenuItem.setActionCommand(this.bifRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View/Edit Text Representation (.xml format)");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            ((BayesCanvas)this.returnCanvas()).displayNodeLabels(false);
        } else if (str.equals("Solve")) {
            this.bifRepresentationMenuItem.setText("View Text Representation (.bif format)");
            this.bifRepresentationMenuItem.setActionCommand(this.bifRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View Text Representation (.xml format)");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.setQueryEvidenceButton();
            ((BayesCanvas)this.returnCanvas()).displayNodeLabels(true);
            ((BayesGraph)this.returnCanvas().graph).updateMonitoredNodes();
        }
        this.returnCanvas().repaint();
    }

    public void setAlgoText(String msg) {
        this.algoText.setText(msg);
    }

    public void setDecisionNetworkMode(boolean isEnabled) {
        int selectedIndex = 0;
        this.bifRepresentationMenuItem.setEnabled(!isEnabled);
        if (isEnabled) {
            this.decisionModeCheckbox.setSelected(true);
        } else {
            this.beliefModeCheckbox.setSelected(true);
        }
        if (this.returnCanvas().getMode() == 2220) {
            selectedIndex = this.getSelectedButtonIndex(this.createButModes);
            if (super.isButtonTextShowing()) {
                this.createToolBarWithText();
            } else {
                this.createToolBar();
            }
            if (selectedIndex != -1) {
                this.createButModes[selectedIndex].setSelected(true);
            }
        } else {
            selectedIndex = this.getSelectedButtonIndex(this.solveButModes);
            if (super.isButtonTextShowing()) {
                this.solveToolBarWithText();
            } else {
                this.solveToolBar();
            }
            if (selectedIndex != -1) {
                this.solveButModes[selectedIndex].setSelected(true);
            }
        }
        this.setQueryEvidenceButton();
        if (isEnabled) {
            this.setAlgoText("  Decision Network Mode");
            ((BayesGraph)this.returnCanvas().graph).buildDecisionNetwork();
        } else {
            this.setAlgoText("  Belief Network Mode");
            if (((BayesGraph)this.canvas.graph).getDecisionNodes().size() > 0 || ((BayesGraph)this.canvas.graph).getUtilityNodes().size() > 0) {
                this.showMessage("Warning", "This network contains Decision and/or Utility nodes. This may cause the Belief Network Mode to function incorrectly.");
            }
        }
    }

    public boolean isDecisionNetworkModeEnabled() {
        return this.decisionModeCheckbox.isSelected();
    }

    public void setIsCheckingPoliciesEnabled(boolean check) {
        this.isCheckingPoliciesEnabled = check;
    }

    protected void optimizeDecisions() {
        if (((BayesGraph)this.returnCanvas().graph).getUtilityNodes().isEmpty()) {
            this.showMessage("Error", "The network needs a Utility node to be optimized.");
            return;
        }
        if (this.isCheckingPoliciesEnabled && (((BayesCanvas)this.returnCanvas()).isOneDecisionObserved() || ((BayesCanvas)this.returnCanvas()).isOneDecisionFunctionDefined())) {
            if (new OptimizationPromptDialog((Container)this).isCancelled()) {
                return;
            }
            ((BayesGraph)this.returnCanvas().graph).clearDecisionFunctions();
        }
        if (this.isDecisionNetwork()) {
            if (!this.addNoForgettingArcs()) {
                return;
            }
        } else {
            this.showMessage("Error", "Only Decision Networks can be optimized.");
            return;
        }
        this.setPromptLabel("Optimizing the Decision nodes that are relevant to the Utility node.");
        ((BayesCanvas)this.returnCanvas()).optimizeDecisions();
        ((BayesGraph)this.returnCanvas().graph).updateMonitoredNodes();
    }

    protected boolean addNoForgettingArcs() {
        if (((BayesGraph)this.returnCanvas().graph).getUtilityNodes().isEmpty()) {
            this.showMessage("Error", "The network needs a Utility node to be optimized.");
            return false;
        }
        this.setPromptLabel("No-forgetting arcs added for Decision nodes relevant to the Utility node.");
        ((BayesGraph)this.returnCanvas().graph).addNoForgettingArcs();
        return true;
    }

    protected boolean isDecisionNetwork() {
        return ((BayesGraph)this.returnCanvas().graph).isDecisionNetwork(true);
    }

    protected int getQueryMode() {
        if (this.briefQueryCheckbox.isSelected()) {
            return 8880;
        }
        if (this.verboseQueryCheckbox.isSelected()) {
            return 8881;
        }
        return 8882;
    }

    public void setQueryMode(int mode) {
        if (mode == 8880) {
            this.briefQueryCheckbox.setSelected(true);
        } else if (mode == 8881) {
            this.verboseQueryCheckbox.setSelected(true);
        } else if (mode == 8882) {
            this.promptQueryCheckbox.setSelected(true);
        }
    }

    public void setQueryButtons(boolean isEnabled) {
        if (this.solveButModes != null) {
            this.solveButModes[1].setEnabled(isEnabled);
            this.solveButModes[3].setEnabled(isEnabled);
            this.solveButModes[8].setEnabled(isEnabled);
            this.solveButModes[9].setEnabled(isEnabled);
            this.setQueryEvidenceButton();
        }
    }

    public void setQueryEvidenceButton() {
        if (this.solveButModes != null) {
            this.solveButModes[2].setEnabled(((BayesGraph)this.canvas.graph).getObservedNodes().size() > 0);
        }
    }

    public void load(BufferedReader in) {
        try {
            if (this.fileName.toLowerCase().endsWith(".bif")) {
                ((BayesCanvas)this.returnCanvas()).parseBIF(in);
            } else if (this.fileName.toLowerCase().endsWith(".xml")) {
                ((BayesCanvas)this.returnCanvas()).parseXMLBIF(in);
            }
            this.setTitle(String.valueOf(GraphWindow.appletTitle) + " --- " + this.fileName);
            this.setDecisionNetworkMode(this.isDecisionNetwork());
        }
        catch (Exception e) {
            this.showMessage("Error", e.toString());
        }
    }

    protected void loadSampleGraph() {
        new BayesProblemDialog(this).open();
    }

    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(((BayesGraph)this.canvas.graph).generateXMLBIFTextRep());
            out.close();
            this.fileName = file.getName();
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    protected void createNewGraph() {
        super.createNewGraph();
        this.setTitle(String.valueOf(GraphWindow.appletTitle) + " --- untitled.xml");
        ((BayesCanvas)this.returnCanvas()).reset();
        ((BayesCanvas)this.returnCanvas()).setSubmode(3330);
    }

    protected void restoreProperties() {
        super.restoreProperties();
        if (this.returnCanvas().getMode() == 2221) {
            this.solveButModes[0].setSelected(true);
            this.returnCanvas().setSubmode(3337);
            this.setPromptLabel("Click on a node to make an observation about its value.");
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand().trim();
        if (this.returnCanvas().getMode() == 2220) {
            if ((arg.equals("Modify Probability Table") || e.getSource() == this.createButModes[5]) && !this.isDecisionNetworkModeEnabled()) {
                this.returnCanvas().setSubmode(3336);
                this.setPromptLabel("Click on a regular node to change its probability table.");
            } else if ((arg.equals("Modify Probability/Utility") || e.getSource() == this.createButModes[5]) && this.isDecisionNetworkModeEnabled()) {
                this.returnCanvas().setSubmode(3336);
                this.setPromptLabel("Click on a value node to change its utility table or\na regular node to change its probability table.");
            }
        } else if (this.returnCanvas().getMode() == 2221) {
            if (arg.equals("Make Observation")) {
                this.returnCanvas().setSubmode(3337);
                this.setPromptLabel("Click on a node to make an observation about its value.");
            } else if (arg.equals("Query")) {
                this.returnCanvas().setSubmode(3338);
                this.setPromptLabel("Click on a node to query its probability or utility.");
            } else if (arg.equals("P(e) Query")) {
                ((BayesCanvas)this.canvas).querySetup(null);
                this.solveButModes[10].setSelected(true);
            } else if (arg.equals("Toggle Monitoring") || e.getSource() == this.solveButModes[3]) {
                this.returnCanvas().setSubmode(3340);
                this.setPromptLabel("Click on a node to stop or start monitoring its probability.");
            } else if (arg.equals("View Probability Table")) {
                this.returnCanvas().setSubmode(3336);
                this.setPromptLabel("Click on a regular node to view its probability table.");
            } else if (arg.equals("View Probability/Utility")) {
                this.returnCanvas().setSubmode(3336);
                this.setPromptLabel("Click on a value node to view its utility table or\na regular node to view its probability table.");
            } else if (arg.equals("View/Modify Decision")) {
                this.returnCanvas().setSubmode(3341);
                this.setPromptLabel("Click on a decision node to view or change its decision function.");
            } else if (arg.equals("Independence Quiz")) {
                ((BayesCanvas)this.returnCanvas()).startQuiz();
                this.solveButModes[10].setSelected(true);
            } else if (arg.equals("Optimize Decisions")) {
                this.optimizeDecisions();
                this.solveButModes[10].setSelected(true);
            } else if (arg.equals("Add No-forgetting Arcs")) {
                this.addNoForgettingArcs();
                this.solveButModes[10].setSelected(true);
            }
        }
        if (e.getSource().equals(this.decimalPlaceCheckboxes[0])) {
            ((BayesGraph)this.returnCanvas().graph).setNumDecimalPlaces(1);
        } else if (e.getSource().equals(this.decimalPlaceCheckboxes[1])) {
            ((BayesGraph)this.returnCanvas().graph).setNumDecimalPlaces(2);
        } else if (e.getSource().equals(this.decimalPlaceCheckboxes[2])) {
            ((BayesGraph)this.returnCanvas().graph).setNumDecimalPlaces(3);
        } else if (e.getSource().equals(this.decimalPlaceCheckboxes[3])) {
            ((BayesGraph)this.returnCanvas().graph).setNumDecimalPlaces(4);
        } else if (e.getSource().equals(this.decimalPlaceCheckboxes[4])) {
            ((BayesGraph)this.returnCanvas().graph).setNumDecimalPlaces(5);
        } else if (arg.equals("Decision Network Mode")) {
            this.setDecisionNetworkMode(true);
        } else if (arg.equals("Belief Network Mode")) {
            this.setDecisionNetworkMode(false);
        } else if (arg.equals("View/Edit Text Representation (.xml format)")) {
            ((BayesCanvas)this.returnCanvas()).displayTextRep(8902, true);
        } else if (arg.equals("View/Edit Text Representation (.bif format)")) {
            if (this.isDecisionNetwork()) {
                this.showMessage("Error", "Invalid format for decision networks.");
            } else {
                ((BayesCanvas)this.returnCanvas()).displayTextRep(8901, true);
            }
        } else if (arg.equals("View Text Representation (.xml format)")) {
            ((BayesCanvas)this.returnCanvas()).displayTextRep(8902, false);
        } else if (arg.equals("View Text Representation (.bif format)")) {
            if (this.isDecisionNetwork()) {
                this.showMessage("Error", "Invalid format for decision networks.");
            } else {
                ((BayesCanvas)this.returnCanvas()).displayTextRep(8901, false);
            }
        } else if (arg.equals("Legend for Nodes/Edges")) {
            new HelpFrame("Legend", new BayesHelpCanvas(this.isAntiAliasingEnabled()), 500, 680);
        } else {
            if (arg.equals("Show Buttons")) {
                this.returnCanvas().setSubmode(3332);
                this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
            }
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
        new BayesWindow(null);
    }
}

