/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes;

import CIspace.bayes.BayesCanvas;
import CIspace.bayes.DisplayWindow;
import CIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.awt.Font;

public abstract class DisplayCanvas
extends BayesCanvas {
    public DisplayCanvas(Container parent, boolean inline) {
        super(parent, inline);
    }

    public final void changeFont(int size) {
        this.font = new Font("SansSerif", 0, size);
        this.graph.updateNodeSize();
        this.graph.updateEdgeSize();
        this.repaint();
    }

    protected abstract void popupCanvas(int var1, int var2);

    protected abstract void popupEdge(int var1, int var2);

    protected abstract void popupNode(int var1, int var2);

    public final boolean isAntiAliasingEnabled() {
        return ((DisplayWindow)this.parent).isAntiAliasingEnabled();
    }

    public final String getPromptLabel() {
        if (!this.inline) {
            return ((DisplayWindow)this.parent).getPromptLabel();
        }
        return null;
    }

    public final void setPromptLabel(String s) {
        if (!this.inline) {
            ((DisplayWindow)this.parent).setPromptLabel(s);
        }
    }

    protected final float maximizingScale() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        float visibleWidth = ((DisplayWindow)this.parent).getCanvasScrollPane().getWidth();
        float visibleHeight = ((DisplayWindow)this.parent).getCanvasScrollPane().getHeight();
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = visibleWidth / graphWidth;
        float heightRatio = visibleHeight / graphHeight;
        return Math.min(widthRatio, heightRatio) * this.graph.getScale();
    }

    public final void moveGraphToMiddle() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        float middleX = ((DisplayWindow)this.parent).getCanvasScrollPane().getHorizontalScrollBar().getValue() + ((DisplayWindow)this.parent).getCanvasScrollPane().getWidth() / 2;
        float middleY = ((DisplayWindow)this.parent).getCanvasScrollPane().getVerticalScrollBar().getValue() + ((DisplayWindow)this.parent).getCanvasScrollPane().getHeight() / 2;
        this.graph.translateAll(middleX - midX, middleY - midY);
    }
}

