/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes;

import CIspace.bayes.DisplayCanvas;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public abstract class DisplayWindow
extends JFrame
implements ActionListener {
    protected JScrollPane canvasScrollPane;
    protected LabelCanvas promptCanvas;
    protected DisplayCanvas canvas;
    private boolean isAntiAliasing;
    protected GridBagLayout gbl;
    protected GridBagConstraints gbc;

    protected final void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    protected final void centerWindow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point centerPosition = new Point(screenSize.width / 2, screenSize.height / 2);
        Dimension windowSize = this.getSize();
        this.setLocation((int)centerPosition.x - windowSize.width / 2, (int)centerPosition.y - windowSize.height / 2);
    }

    protected final JScrollPane getCanvasScrollPane() {
        return this.canvasScrollPane;
    }

    protected final String getPromptLabel() {
        return this.promptCanvas.getText();
    }

    protected final void setPromptLabel(String str) {
        this.promptCanvas.setText(str);
    }

    public final void setPromptColor(Color col) {
        this.promptCanvas.setTextColor(col);
    }

    protected final boolean isAntiAliasingEnabled() {
        return this.isAntiAliasing;
    }

    protected final void setAntiAliasing(boolean isAntiAliasing) {
        this.isAntiAliasing = isAntiAliasing;
    }

    public final void showMessage(String title, String msg) {
        this.canvas.showMessage(title, msg);
    }
}

