/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes;

import CIspace.bayes.BayesCanvas;
import CIspace.bayes.BayesGraph;
import CIspace.bayes.InlineCanvas;
import CIspace.bayes.dialogs.OptimizationPromptDialog;
import CIspace.bayes.elements.BayesNode;
import CIspace.bayes.verboseQuery.QueryWindow;
import CIspace.graphToolKit.InlineApplet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class InlineBayesApplet
extends InlineApplet {
    private boolean isCheckingPoliciesEnabled = true;
    private Container originalContentPane;
    private Container queryContentPane;
    private int queryMode = 8882;
    private String verboseQueryString;
    public JToggleButton fakeButton;
    public JToggleButton makeObservationButton;
    public JToggleButton queryButton;
    public JToggleButton PeQueryButton;
    public JToggleButton toggleMonitoringButton;
    public JToggleButton selectButton;
    public JToggleButton viewProbabilityTableButton;
    public JToggleButton viewModifyDecisionButton;
    public JToggleButton addNoForgettingArcsButton;
    public JToggleButton optimizeDecisionsButton;
    public JToggleButton independenceQuizButton;
    private boolean makeObservationButtonOn = false;
    private boolean queryButtonOn = false;
    private boolean PeQueryButtonOn = false;
    private boolean toggleMonitoringButtonOn = false;
    private boolean selectButtonOn = false;
    private boolean viewProbabilityTableButtonOn = false;
    private boolean viewModifyDecisionButtonOn = false;
    private boolean addNoForgettingArcsButtonOn = false;
    private boolean optimizeDecisionsButtonOn = false;
    private boolean independenceQuizButtonOn = false;
    public boolean fakePopupOn = false;
    public boolean makeObservationPopupOn = false;
    public boolean queryPopupOn = false;
    public boolean PeQueryPopupOn = false;
    public boolean toggleMonitoringPopupOn = false;
    public boolean addNoForgettingArcsPopupOn = false;
    public boolean optimizeDecisionsPopupOn = false;
    public boolean independenceQuizPopupOn = false;
    public boolean tablePopupOn = false;
    private boolean decisionMode = true;
    private boolean verboseQueryMode = false;

    public void init() {
        super.init();
        this.makeCanvas();
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
            this.canvas.setSize(this.getWidth(), this.getHeight());
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
            this.canvas.setSize(this.getWidth(), this.getHeight() - 50);
        }
        if (this.showButtons) {
            this.canvasPanel.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
            this.canvas.setSize(this.canvas.getWidth() - 10, this.canvas.getHeight() - 75);
        } else {
            this.canvasPanel.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.canvas.setSize(this.canvas.getWidth() - 10, this.canvas.getHeight() - 10);
            this.toolBarPanel.setVisible(false);
        }
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            this.canvasPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
        }
        this.mainPanel.add((Component)this.canvasPanel, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setPromptLabel("Click on an entity and drag the mouse to move it.");
        if (this.verboseQueryString != null && !this.verboseQueryString.equals("off")) {
            if (this.verboseQueryString.equals("optimizeDecisions")) {
                this.queryMode = 8881;
                this.verboseQueryMode = true;
                this.optimizeDecisions();
            } else {
                BayesNode queryNode = ((BayesGraph)this.canvas.graph).getNode(this.verboseQueryString);
                if (queryNode != null) {
                    this.verboseQueryMode = true;
                    this.queryMode = 8881;
                    ((BayesCanvas)this.canvas).querySetup(queryNode);
                }
            }
        }
        this.autoscale();
    }

    protected void makeCanvas() {
        this.canvas = new InlineCanvas(this);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[11];
        int index = 0;
        this.setSolveButtonsWithText(index, "Make Observation", InlineBayesApplet.createImageIcon("images/Zoom24.gif"), "Make Observation");
        this.makeObservationButton = this.buttons[index++];
        if (!this.makeObservationButtonOn) {
            this.makeObservationButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "  Query  ", InlineBayesApplet.createImageIcon("images/queryNode.png"), "Query");
        this.queryButton = this.buttons[index++];
        if (!this.queryButtonOn) {
            this.queryButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "P(e) Query", InlineBayesApplet.createImageIcon("images/queryNetwork.png"), "P(e) Query");
        this.PeQueryButton = this.buttons[index++];
        this.PeQueryButton.setEnabled(false);
        if (!this.PeQueryButtonOn) {
            this.PeQueryButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Toggle Monitoring", InlineBayesApplet.createImageIcon("images/toggleMonitoring.png"), "Toggle Monitoring");
        this.toggleMonitoringButton = this.buttons[index++];
        if (!this.toggleMonitoringButtonOn) {
            this.toggleMonitoringButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "  Select  ", InlineBayesApplet.createImageIcon("images/select.png"), "Select");
        this.selectButton = this.buttons[index++];
        if (!this.selectButtonOn) {
            this.selectButton.setVisible(false);
        }
        if (this.decisionMode) {
            this.setSolveButtonsWithText(index, "View Probability/Utility", InlineBayesApplet.createImageIcon("images/viewProbTable.png"), "View Probability/Utility");
        } else {
            this.setSolveButtonsWithText(index, "View Probability Table", InlineBayesApplet.createImageIcon("images/viewProbTable.png"), "View Probability Table");
        }
        this.viewProbabilityTableButton = this.buttons[index++];
        if (!this.viewProbabilityTableButtonOn) {
            this.viewProbabilityTableButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "View/Modify Decision", InlineBayesApplet.createImageIcon("images/viewDecision.png"), "View/Modify Decision");
        this.viewModifyDecisionButton = this.buttons[index++];
        if (!this.viewModifyDecisionButtonOn || !this.decisionMode) {
            this.viewModifyDecisionButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Add No-forgetting Arcs", InlineBayesApplet.createImageIcon("images/noforgettingarcs.png"), "Add No-forgetting Arcs");
        this.addNoForgettingArcsButton = this.buttons[index++];
        if (!this.addNoForgettingArcsButtonOn || !this.decisionMode) {
            this.addNoForgettingArcsButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Optimize Decisions", InlineBayesApplet.createImageIcon("images/optimizeDecision.png"), "Optimize Decisions");
        this.optimizeDecisionsButton = this.buttons[index++];
        if (!this.optimizeDecisionsButtonOn || !this.decisionMode) {
            this.optimizeDecisionsButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Independence Quiz", InlineBayesApplet.createImageIcon("images/quiz.gif"), "Independence Quiz");
        this.independenceQuizButton = this.buttons[index++];
        if (!this.independenceQuizButtonOn) {
            this.independenceQuizButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineBayesApplet.createImageIcon("images/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        ButtonGroup buttonGroup2 = new ButtonGroup();
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            if (this.buttons[i] != this.PeQueryButton && this.buttons[i] != this.addNoForgettingArcsButton && this.buttons[i] != this.optimizeDecisionsButton && this.buttons[i] != this.independenceQuizButton && this.buttons[i] != this.fakeButton) {
                buttonGroup.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            } else {
                buttonGroup2.add(this.buttons[i]);
                toolBar.add(this.buttons[i]);
                this.buttons[i].setFont(toolFont);
            }
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    public void load(String filename) {
        try {
            URL url = new URL(filename);
            InputStream iStream = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(iStream));
            if (filename.toLowerCase().endsWith(".bif")) {
                ((BayesCanvas)this.canvas).parseBIF(in);
            } else if (filename.toLowerCase().endsWith(".xml")) {
                ((BayesCanvas)this.canvas).parseXMLBIF(in);
            }
        }
        catch (Exception e) {
            this.canvas.showMessage("Error", e.toString());
        }
    }

    protected boolean isDecisionNetwork() {
        return ((BayesGraph)this.canvas.graph).isDecisionNetwork(true);
    }

    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("makeObservationButton");
        if (param != null) {
            if (param.equals("on")) {
                this.makeObservationButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("makeObservationButton", param);
            }
        }
        if ((param = this.getParameter("queryButton")) != null) {
            if (param.equals("on")) {
                this.queryButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("queryButton", param);
            }
        }
        if ((param = this.getParameter("PeQueryButton")) != null) {
            if (param.equals("on")) {
                this.PeQueryButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("PeQueryButton", param);
            }
        }
        if ((param = this.getParameter("toggleMonitoringButton")) != null) {
            if (param.equals("on")) {
                this.toggleMonitoringButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("toggleMonitoringButton", param);
            }
        }
        if ((param = this.getParameter("selectButton")) != null) {
            if (param.equals("on")) {
                this.selectButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("selectButton", param);
            }
        }
        if ((param = this.getParameter("viewProbabilityTableButton")) != null) {
            if (param.equals("on")) {
                this.viewProbabilityTableButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewProbabilityTableButton", param);
            }
        }
        if ((param = this.getParameter("viewModifyDecisionButton")) != null) {
            if (param.equals("on")) {
                this.viewModifyDecisionButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewModifyDecisionButton", param);
            }
        }
        if ((param = this.getParameter("addNoForgettingArcsButton")) != null) {
            if (param.equals("on")) {
                this.addNoForgettingArcsButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("addNoForgettingArcsButton", param);
            }
        }
        if ((param = this.getParameter("optimizeDecisionsButton")) != null) {
            if (param.equals("on")) {
                this.optimizeDecisionsButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("optimizeDecisionsButton", param);
            }
        }
        if ((param = this.getParameter("independenceQuizButton")) != null) {
            if (param.equals("on")) {
                this.independenceQuizButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("independenceQuizButton", param);
            }
        }
        if ((param = this.getParameter("makeObservationPopup")) != null) {
            if (param.equals("on")) {
                this.makeObservationPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("makeObservationPopup", param);
            }
        }
        if ((param = this.getParameter("queryPopup")) != null) {
            if (param.equals("on")) {
                this.queryPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("queryPopup", param);
            }
        }
        if ((param = this.getParameter("PeQueryPopup")) != null) {
            if (param.equals("on")) {
                this.PeQueryPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("PeQueryPopup", param);
            }
        }
        if ((param = this.getParameter("toggleMonitoringPopup")) != null) {
            if (param.equals("on")) {
                this.toggleMonitoringPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("toggleMonitoringPopup", param);
            }
        }
        if ((param = this.getParameter("addNoForgettingArcsPopup")) != null) {
            if (param.equals("on")) {
                this.addNoForgettingArcsPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("addNoForgettingArcsPopup", param);
            }
        }
        if ((param = this.getParameter("optimizeDecisionsPopup")) != null) {
            if (param.equals("on")) {
                this.optimizeDecisionsPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("optimizeDecisionsPopup", param);
            }
        }
        if ((param = this.getParameter("independenceQuizPopup")) != null) {
            if (param.equals("on")) {
                this.independenceQuizPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("independenceQuizPopup", param);
            }
        }
        if ((param = this.getParameter("viewProbabilityTablePopup")) != null) {
            if (param.equals("on")) {
                this.tablePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewProbabilityTablePopup", param);
            }
        }
        if ((param = this.getParameter("query")) != null) {
            if (param.equals("verbose")) {
                this.queryMode = 8881;
            } else if (param.equals("brief")) {
                this.queryMode = 8880;
            } else if (param.equals("prompt")) {
                this.queryMode = 8882;
            } else {
                this.incorrectParameter("query", param);
            }
        }
        this.verboseQueryString = this.getParameter("verboseQueryMode");
        param = this.getParameter("mode");
        if (param != null) {
            if (param.equals("belief")) {
                this.decisionMode = false;
            } else if (param.equals("decision")) {
                this.decisionMode = true;
            } else {
                this.incorrectParameter("mode", param);
            }
        } else {
            this.decisionMode = ((BayesGraph)this.canvas.graph).isDecisionNetwork(true);
        }
    }

    public boolean isDecisionNetworkModeEnabled() {
        return this.decisionMode;
    }

    public void setIsCheckingPoliciesEnabled(boolean check) {
        this.isCheckingPoliciesEnabled = check;
    }

    public void optimizeDecisions() {
        if (!this.optimizeDecisionsButton.isEnabled()) {
            return;
        }
        if (((BayesGraph)this.canvas.graph).getUtilityNodes().isEmpty()) {
            this.canvas.showMessage("Error", "The network needs a Utility node to be optimized.");
            return;
        }
        if (this.isCheckingPoliciesEnabled && (((BayesCanvas)this.canvas).isOneDecisionObserved() || ((BayesCanvas)this.canvas).isOneDecisionFunctionDefined()) && new OptimizationPromptDialog(this).isCancelled()) {
            return;
        }
        if (this.isDecisionNetwork()) {
            if (!this.addNoForgettingArcs()) {
                return;
            }
        } else {
            this.canvas.showMessage("Error", "Only Decision Networks can be optimized.");
            return;
        }
        this.setPromptLabel("Optimizing the Decision nodes that are relevant to the Utility node.");
        ((BayesCanvas)this.canvas).optimizeDecisions();
        ((BayesGraph)this.canvas.graph).updateMonitoredNodes();
    }

    public void convertToQuery(QueryWindow queryWindow) {
        if (this.verboseQueryMode) {
            queryWindow.removeBackButton();
        }
        this.originalContentPane = this.getContentPane();
        this.setContentPane(queryWindow.getContentPane());
        this.setSize(this.getWidth() - 1, this.getHeight() - 1);
    }

    public void convertToPeCalculation(QueryWindow queryWindow) {
        this.queryContentPane = this.getContentPane();
        this.setContentPane(queryWindow.getContentPane());
        this.setSize(this.getWidth() - 1, this.getHeight() - 1);
    }

    public void backToQuery() {
        this.setContentPane(this.queryContentPane);
        this.setSize(this.getWidth() + 1, this.getHeight() + 1);
    }

    public void backToSolveMode() {
        this.setContentPane(this.originalContentPane);
        this.setSize(this.getWidth() + 1, this.getHeight() + 1);
    }

    public boolean addNoForgettingArcs() {
        if (!this.addNoForgettingArcsButton.isEnabled()) {
            return false;
        }
        if (((BayesGraph)this.canvas.graph).getUtilityNodes().isEmpty()) {
            this.canvas.showMessage("Error", "The network needs a Utility node to be optimized.");
            return false;
        }
        this.setPromptLabel("No-forgetting arcs added for Decision nodes relevant to the Utility node.");
        ((BayesGraph)this.canvas.graph).addNoForgettingArcs();
        return true;
    }

    public void setQueryButtons(boolean isEnabled) {
        this.queryButton.setEnabled(isEnabled);
        this.toggleMonitoringButton.setEnabled(isEnabled);
        this.optimizeDecisionsButton.setEnabled(isEnabled);
        this.independenceQuizButton.setEnabled(isEnabled);
        this.setQueryEvidenceButton();
    }

    public void setQueryEvidenceButton() {
        if (this.PeQueryButton != null) {
            this.PeQueryButton.setEnabled(((BayesGraph)this.canvas.graph).getObservedNodes().size() > 0);
        }
    }

    public int getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(int mode) {
        this.queryMode = mode;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand().trim();
        if (arg.equals("Make Observation")) {
            this.canvas.setSubmode(3337);
            this.setPromptLabel("Click on a node to make an observation about its value.");
        } else if (arg.equals("Query")) {
            this.canvas.setSubmode(3338);
            this.setPromptLabel("Click on a node to query its probability or utility.");
        } else if (arg.equals("P(e) Query")) {
            ((BayesCanvas)this.canvas).querySetup(null);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Toggle Monitoring") || e.getSource() == this.toggleMonitoringButton) {
            this.canvas.setSubmode(3340);
            this.setPromptLabel("Click on a node to stop or start monitoring its probability.");
        } else if (arg.equals("View Probability Table")) {
            this.canvas.setSubmode(3336);
            this.setPromptLabel("Click on a regular node to view its probability table.");
        } else if (arg.equals("View Probability/Utility")) {
            this.canvas.setSubmode(3336);
            this.setPromptLabel("Click on a value node to view its utility table or\na regular node to view its probability table.");
        } else if (arg.equals("View/Modify Decision")) {
            this.canvas.setSubmode(3341);
            this.setPromptLabel("Click on a decision node to view or change its decision function.");
        } else if (arg.equals("Independence Quiz")) {
            ((BayesCanvas)this.canvas).startQuiz();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Optimize Decisions")) {
            this.optimizeDecisions();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Add No-forgetting Arcs")) {
            this.addNoForgettingArcs();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Select")) {
            this.canvas.setSubmode(3332);
            this.setPromptLabel("Click on an entity and drag the mouse to move it.");
        } else if (arg.equals("View Text Representation (.xml format)")) {
            ((BayesCanvas)this.canvas).displayTextRep(8902, false);
        } else if (arg.equals("View Text Representation (.bif format)")) {
            if (this.isDecisionNetwork()) {
                this.canvas.showMessage("Error", "Invalid format for decision networks.");
            } else {
                ((BayesCanvas)this.canvas).displayTextRep(8901, false);
            }
        }
    }

    public void PeQuery() {
        if (this.PeQueryButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.PeQueryButton, 0, "P(e) Query"));
        }
    }

    public void independenceQuiz() {
        if (this.independenceQuizButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.independenceQuizButton, 0, "Independence Quiz"));
        }
    }

    public void autoscale() {
        ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }
}

