/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes;

import CIspace.bayes.BayesCanvas;
import CIspace.bayes.BayesGraph;
import CIspace.bayes.BayesWindow;
import CIspace.bayes.InlineBayesApplet;
import CIspace.bayes.dialogs.MoreMsgDialog;
import CIspace.bayes.dialogs.PolicyDialog;
import CIspace.bayes.dialogs.ProbabilityDialog;
import CIspace.bayes.dialogs.UtilityDialog;
import CIspace.bayes.elements.BayesNode;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class InlineCanvas
extends BayesCanvas {
    public InlineCanvas(Container parent) {
        super(parent, true);
    }

    public void initializePopup() {
        if (!((InlineBayesApplet)this.parent).isPopupMenuOn()) {
            this.pop.setPopupSize(0, 0);
        }
    }

    protected void popupCanvas(int x, int y) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        JMenuItem mItem;
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
        if (((BayesGraph)this.graph).getDecisionNetwork() != null && ((InlineBayesApplet)this.parent).isDecisionNetworkModeEnabled() && ((BayesGraph)this.graph).getUtilityNodes().size() == 1) {
            if (((BayesGraph)this.graph).getObservedNodes().size() > 0) {
                mItem = new JMenuItem("P(e) Query");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                if (((InlineBayesApplet)this.parent).PeQueryPopupOn) {
                    this.pop.add(mItem);
                }
            }
            mItem = new JMenuItem("Optimize Decisions");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).optimizeDecisionsPopupOn) {
                this.pop.add(mItem);
            }
            mItem = new JMenuItem("Add No-forgetting Arcs");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).addNoForgettingArcsPopupOn) {
                this.pop.add(mItem);
            }
        }
        if (((BayesGraph)this.graph).getDecisionNetwork() != null) {
            mItem = new JMenuItem("Independence Quiz");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).independenceQuizPopupOn) {
                this.pop.add(mItem);
            }
        }
        this.pop.addSeparator();
        this.pop.add(new JLabel("View Options"));
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.addActionListener(this);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.addActionListener(this);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        if (((InlineBayesApplet)this.parent).textRepresentationPopupOn) {
            this.pop.addSeparator();
            JMenuItem repItem = new JMenuItem("View Text Representation (.bif format)");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineBayesApplet)this.parent);
            if (!((InlineBayesApplet)this.parent).isDecisionNetworkModeEnabled()) {
                this.pop.add(repItem);
            }
            repItem = new JMenuItem("View Text Representation (.xml format)");
            repItem.setActionCommand(repItem.getText());
            repItem.addActionListener((InlineBayesApplet)this.parent);
            this.pop.add(repItem);
        }
        this.pop.show(this, x, y);
    }

    protected void popupNode(int x, int y) {
        JMenuItem mItem;
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        if (((BayesNode)this.entClicked).getNodeType() != 7779) {
            if (((BayesNode)this.entClicked).isObserved()) {
                mItem = new JMenuItem("Change Observation for Node");
                mItem.setActionCommand(mItem.getText());
            } else {
                mItem = new JMenuItem("Make Observation for Node");
                mItem.setActionCommand(mItem.getText());
            }
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).makeObservationPopupOn) {
                this.pop.add(mItem);
            }
        }
        if (((BayesGraph)this.graph).getDecisionNetwork() != null) {
            mItem = new JMenuItem("Query Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).queryPopupOn) {
                this.pop.add(mItem);
            }
            mItem = new JMenuItem("Toggle Monitoring of Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).toggleMonitoringPopupOn) {
                this.pop.add(mItem);
            }
        }
        boolean decisionNetworkEnabled = this.parent instanceof BayesWindow ? ((BayesWindow)this.parent).isDecisionNetworkModeEnabled() : ((InlineBayesApplet)this.parent).isDecisionNetworkModeEnabled();
        if (((BayesNode)this.entClicked).getNodeType() == 7777) {
            mItem = new JMenuItem("View Probability Table of Node");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            if (((InlineBayesApplet)this.parent).tablePopupOn) {
                this.pop.addSeparator();
                this.pop.add(mItem);
            }
        } else if (decisionNetworkEnabled) {
            if (((BayesNode)this.entClicked).getNodeType() == 7779) {
                mItem = new JMenuItem("View Utility Table of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                if (((InlineBayesApplet)this.parent).tablePopupOn) {
                    this.pop.addSeparator();
                    this.pop.add(mItem);
                }
            } else if (((BayesNode)this.entClicked).getNodeType() == 7778) {
                mItem = new JMenuItem("View/Modify Decision of Node");
                mItem.setActionCommand(mItem.getText());
                mItem.addActionListener(this);
                if (((InlineBayesApplet)this.parent).tablePopupOn) {
                    this.pop.addSeparator();
                    this.pop.add(mItem);
                }
            }
        }
        if (((InlineBayesApplet)this.parent).tablePopupOn || ((InlineBayesApplet)this.parent).toggleMonitoringPopupOn || ((InlineBayesApplet)this.parent).queryPopupOn || ((InlineBayesApplet)this.parent).makeObservationPopupOn) {
            this.pop.show(this, x, y);
        }
    }

    public boolean isAntiAliasingEnabled() {
        return true;
    }

    protected int getQueryMode() {
        return ((InlineBayesApplet)this.parent).getQueryMode();
    }

    public void showMessage(String title, String msg, String more) {
        new MoreMsgDialog(null, title, msg, more);
    }

    public void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Add No-forgetting Arcs")) {
            ((InlineBayesApplet)this.parent).addNoForgettingArcs();
        } else if (arg.equals("Optimize Decisions")) {
            ((InlineBayesApplet)this.parent).optimizeDecisions();
        } else if (arg.equals("View Probability Table of Node")) {
            new ProbabilityDialog(null, (BayesNode)this.entClicked, this, false);
        } else if (arg.equals("View Utility Table of Node")) {
            new UtilityDialog(null, (BayesNode)this.entClicked, this, false);
        } else if (arg.equals("View/Modify Decision of Node")) {
            if (((BayesNode)this.entClicked).getNodeType() == 7778) {
                new PolicyDialog(null, (BayesNode)this.entClicked, this);
            } else {
                this.showMessage("Error", "Only Decision Nodes have decision functions.", "A decision function is a function that outputs (deterministically) what the value of the node will be, given the values of its parents.");
            }
        } else {
            super.aPerformed(e);
        }
    }
}

