/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.dialogs;

import CIspace.bayes.verboseQuery.QueryWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.ve.Factor;
import CIspace.ve.FactorCPT;
import CIspace.ve.FactorDecision;
import CIspace.ve.FactorDivide;
import CIspace.ve.FactorMax;
import CIspace.ve.FactorNormalise;
import CIspace.ve.FactorSumOut;
import CIspace.ve.FactorTimes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DerivationDialog
extends BasicDialog {
    public DerivationDialog(JFrame parent, Factor factor, String derivedFrom, ArrayList factorDerivationString, ArrayList numericDerivationString) {
        super(parent, "Derivation", true, 4);
        this.setFont(parent.getFont());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.constructTopPanel(((QueryWindow)parent).getFactorListName(factor), derivedFrom), "North");
        this.getContentPane().add((Component)this.constructCenterPanel(factor, factorDerivationString, numericDerivationString), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(factor), "South");
        this.packCenterOpen();
    }

    private JPanel constructTopPanel(String factorName, String derivedFrom) {
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        JLabel label = new JLabel(derivedFrom, 0);
        label.setFont(new Font("SansSerif", 2, this.getFont().getSize()));
        topPanel.add(label);
        return topPanel;
    }

    private JPanel constructCenterPanel(Factor factor, ArrayList factorDerivationString, ArrayList numericDerivationString) {
        JPanel centerPanel;
        block21: {
            GridBagConstraints con;
            JLabel label;
            Font labelFont;
            GridBagLayout gbl;
            block23: {
                block22: {
                    block20: {
                        centerPanel = new JPanel();
                        gbl = new GridBagLayout();
                        centerPanel.setLayout(gbl);
                        labelFont = new Font("SansSerif", 0, this.getFont().getSize());
                        label = null;
                        if (!(factor instanceof FactorCPT) && !(factor instanceof FactorNormalise)) {
                            con = new GridBagConstraints();
                            con.gridx = 0;
                            con.gridy = 0;
                            label = new JLabel("\n");
                            gbl.setConstraints(label, con);
                            centerPanel.add(label);
                        }
                        if (!(factor instanceof FactorSumOut) && !(factor instanceof FactorDivide) && !(factor instanceof FactorMax) && !(factor instanceof FactorDecision)) break block20;
                        int numPlus = 0;
                        int xIncrement = 0;
                        int i = 0;
                        while (i < factorDerivationString.size()) {
                            if (factorDerivationString.get(i).equals(" + ")) {
                                ++numPlus;
                                xIncrement = 1;
                            }
                            con = new GridBagConstraints();
                            con.gridy = 1 + numPlus;
                            con.gridx = xIncrement;
                            label = new JLabel((String)factorDerivationString.get(i), 0);
                            label.setFont(labelFont);
                            gbl.setConstraints(label, con);
                            centerPanel.add(label);
                            con = new GridBagConstraints();
                            con.gridy = 2 + numPlus + numericDerivationString.size();
                            con.gridx = xIncrement++;
                            label = new JLabel((String)numericDerivationString.get(i), 0);
                            label.setFont(labelFont);
                            gbl.setConstraints(label, con);
                            centerPanel.add(label);
                            ++i;
                        }
                        break block21;
                    }
                    if (!(factor instanceof FactorTimes)) break block22;
                    int i = 0;
                    while (i < factorDerivationString.size()) {
                        con = new GridBagConstraints();
                        con.gridy = 1;
                        con.gridx = i;
                        label = new JLabel((String)factorDerivationString.get(i), 0);
                        label.setFont(labelFont);
                        gbl.setConstraints(label, con);
                        centerPanel.add(label);
                        con = new GridBagConstraints();
                        con.gridy = 2 + numericDerivationString.size();
                        con.gridx = i;
                        label = new JLabel((String)numericDerivationString.get(i), 0);
                        label.setFont(labelFont);
                        gbl.setConstraints(label, con);
                        centerPanel.add(label);
                        ++i;
                    }
                    break block21;
                }
                if (!(factor instanceof FactorNormalise)) break block23;
                centerPanel.setLayout(new GridLayout(4, 1));
                int i = 0;
                while (i < 2) {
                    switch (i) {
                        case 0: {
                            label = new JLabel("<html><br>Summing probabilities over all domain values:</html>", 0);
                            break;
                        }
                        case 1: {
                            label = new JLabel("<html><br>Normalizing the resultant probabilities:</html>", 0);
                        }
                    }
                    label.setForeground(Color.blue);
                    label.setFont(labelFont);
                    centerPanel.add(label);
                    ArrayList stringDerivatives = (ArrayList)factorDerivationString.get(i);
                    ArrayList numericDerivatives = (ArrayList)numericDerivationString.get(i);
                    JPanel panel = new JPanel();
                    panel.setLayout(gbl);
                    if (i == 0) {
                        int n = 7;
                        int countTimes = 0;
                        int xIncrement = 0;
                        int j = 0;
                        while (j < stringDerivatives.size()) {
                            if (stringDerivatives.get(j).equals(" * ") || stringDerivatives.get(j).equals(" + ")) {
                                if (i == 0 && stringDerivatives.get(j).equals(" + ")) {
                                    while (countTimes % 7 != 0) {
                                        ++countTimes;
                                    }
                                } else {
                                    ++countTimes;
                                }
                                if (countTimes != 0 && countTimes % 7 == 0) {
                                    xIncrement = 1;
                                }
                            }
                            con = new GridBagConstraints();
                            label = new JLabel((String)stringDerivatives.get(j));
                            label.setFont(labelFont);
                            con.gridy = countTimes / 7;
                            con.gridx = xIncrement;
                            gbl.setConstraints(label, con);
                            panel.add(label);
                            con = new GridBagConstraints();
                            label = new JLabel((String)numericDerivatives.get(j));
                            label.setFont(labelFont);
                            con.gridy = 2 + countTimes / 7 + (stringDerivatives.size() - 2) / 14;
                            con.gridx = xIncrement++;
                            gbl.setConstraints(label, con);
                            panel.add(label);
                            ++j;
                        }
                        centerPanel.add(panel);
                    } else {
                        StringBuffer deriv = new StringBuffer();
                        int j = 0;
                        while (j < stringDerivatives.size()) {
                            deriv.append((String)stringDerivatives.get(j));
                            ++j;
                        }
                        j = 0;
                        while (j < numericDerivatives.size()) {
                            deriv.append((String)numericDerivatives.get(j));
                            ++j;
                        }
                        label = new JLabel(deriv.toString(), 0);
                        label.setFont(labelFont);
                        centerPanel.add(label);
                    }
                    ++i;
                }
                break block21;
            }
            if (!(factor instanceof FactorMax) && !(factor instanceof FactorDecision)) break block21;
            int i = 0;
            while (i < factorDerivationString.size()) {
                con = new GridBagConstraints();
                con.gridy = 0;
                con.gridx = i;
                label = new JLabel((String)factorDerivationString.get(i), 0);
                label.setFont(labelFont);
                gbl.setConstraints(label, con);
                centerPanel.add(label);
                ++i;
            }
        }
        return centerPanel;
    }

    private JPanel constructBottomPanel(Factor factor) {
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        bottomPanel.add(button);
        if (factor instanceof FactorDivide) {
            button = new JButton("Investigate P(e) Calculation");
            button.setActionCommand(button.getText());
            button.addActionListener(this);
            bottomPanel.add(button);
        }
        return bottomPanel;
    }

    protected boolean actionOK() {
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().trim().equals("Investigate P(e) Calculation")) {
            this.setVisible(false);
            this.dispose();
            ((QueryWindow)this.getParent()).investigatePeCalculation();
        } else {
            super.actionPerformed(e);
        }
    }
}

