/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.dialogs;

import CIspace.bayes.BayesGraph;
import CIspace.bayes.dialogs.DerivationDialog;
import CIspace.bayes.dialogs.ReorderDialog;
import CIspace.bayes.verboseQuery.QueryCanvas;
import CIspace.bayes.verboseQuery.QueryWindow;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorCPT;
import CIspace.ve.FactorDecision;
import CIspace.ve.FactorDivide;
import CIspace.ve.FactorMax;
import CIspace.ve.FactorNormalise;
import CIspace.ve.FactorObserved;
import CIspace.ve.FactorSumOut;
import CIspace.ve.FactorTimes;
import CIspace.ve.FactorUtility;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrSafe;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectFactorDialog
extends BasicDialog {
    private JComboBox factorChoiceComboBox;
    private DerivationDialog derivationDialog;
    private ReorderDialog reorderDialog;
    private String howDerived;
    private Factor curFactor;
    private Factor origFactor;
    private String[][] origContexts;
    private BayesGraph graph;
    private Variable[] variableOrder;
    private boolean isOptimizing;

    public InspectFactorDialog(JFrame parent, BayesGraph graph, Factor factor, String factorName, boolean isOptimizing) {
        super(parent, "Inspecting Factors", true, 2);
        this.graph = graph;
        this.curFactor = factor;
        this.origFactor = factor;
        this.isOptimizing = isOptimizing;
        if (parent.getFont().getSize() > 26) {
            this.setFont(new Font(parent.getFont().getFontName(), parent.getFont().getStyle(), 26));
        } else {
            this.setFont(parent.getFont());
        }
        this.getContentPane().add((Component)this.constructTopPanel(factorName), "North");
        this.getContentPane().add((Component)this.constructCenterPanel(factor, true), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(factor), "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.getHeight() > screenSize.height - 200) {
            this.setSize(this.getWidth(), screenSize.height - 200);
        }
        if (this.getWidth() > screenSize.width - 200) {
            this.setSize(screenSize.width - 200, this.getHeight());
        }
    }

    public void open() {
        this.centerWindow();
        this.setVisible(true);
    }

    private JPanel constructTopPanel(String factorName) {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 3));
        Font plain = new Font("SansSerif", 0, this.getFont().getSize());
        JButton button = new JButton("Reorder Variable Columns");
        button.setFont(plain);
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        panel.add(button);
        JLabel label = new JLabel("Inspecting Factor ", 4);
        label.setFont(plain);
        panel.add(label);
        this.factorChoiceComboBox = new JComboBox();
        this.factorChoiceComboBox.setFont(plain);
        ArrayList<Factor> factors = ((QueryCanvas)this.graph.canvas).getCurrentFactors();
        Iterator<Factor> elimFactorsItr = ((QueryCanvas)this.graph.canvas).getEliminatedFactors().iterator();
        ArrayList<Factor> decisionFunctions = ((QueryWindow)this.graph.canvas.parent).getDecisionFunctions();
        while (elimFactorsItr.hasNext()) {
            factors.add(elimFactorsItr.next());
        }
        Collections.sort(factors, new Comparator<Factor>(){

            @Override
            public int compare(Factor f1, Factor f2) {
                Integer f1Num = new Integer(InspectFactorDialog.this.getFactorNum(f1));
                Integer f2Num = new Integer(InspectFactorDialog.this.getFactorNum(f2));
                return f1Num.compareTo(f2Num);
            }
        });
        for (Factor factor : decisionFunctions) {
            factors.add(factor);
        }
        for (Factor factor : factors) {
            String name = ((QueryWindow)this.getParent()).getFactorListName(factor);
            this.factorChoiceComboBox.addItem(name);
        }
        if (factorName.lastIndexOf("Answer: ") != -1) {
            factorName = factorName.substring(8);
        }
        this.factorChoiceComboBox.setSelectedItem(factorName);
        this.factorChoiceComboBox.addActionListener(this);
        panel.add(this.factorChoiceComboBox);
        label = new JLabel("Click on a value to see its derivation or select a new factor to inspect it.", 4);
        label.setFont(plain);
        label.setForeground(Color.red);
        topPanel.add((Component)label, "North");
        topPanel.add((Component)panel, "South");
        return topPanel;
    }

    private JScrollPane constructCenterPanel(Factor factor, boolean constructOrder) {
        JScrollPane centerPanel = factor instanceof FactorDecision && this.isOptimizing ? this.constructDecisionFunctionCenterPanel(factor, constructOrder) : this.constructNormalCenterPanel(factor, constructOrder);
        if (!factor.hasBeenReordered()) {
            this.origContexts = new String[(int)factor.getSize()][factor.getVariablesNum()];
            int count = 0;
            while ((long)count < factor.getSize()) {
                this.origContexts[count] = this.buildContext(count);
                ++count;
            }
        }
        return centerPanel;
    }

    private JScrollPane constructNormalCenterPanel(Factor factor, boolean constructOrder) {
        JLabel label;
        Variable var;
        int i;
        JPanel chartPanel = new JPanel();
        Font plain = new Font("SansSerif", 0, this.getFont().getSize());
        Font bold = new Font("SansSerif", 1, this.getFont().getSize());
        chartPanel.setLayout(new GridLayout((int)factor.getSize() + 1, factor.getVariablesNum()));
        if (constructOrder || this.variableOrder == null) {
            this.variableOrder = new Variable[factor.getVariablesNum()];
            int orderIndex = 0;
            i = 0;
            while (i < this.variableOrder.length) {
                var = factor.getVariable(i);
                if (this.graph.getNode(var.getName(false)).getNodeType() != 7779) {
                    label = new JLabel(var.getName(false));
                    label.setFont(bold);
                    chartPanel.add(label);
                    this.variableOrder[orderIndex++] = var;
                }
                ++i;
            }
        } else {
            Variable[] variableArray = this.variableOrder;
            i = 0;
            int n = variableArray.length;
            while (i < n) {
                Variable element;
                var = element = variableArray[i];
                label = new JLabel(var.getName(false));
                label.setFont(bold);
                chartPanel.add(label);
                ++i;
            }
        }
        label = new JLabel("Value");
        label.setFont(bold);
        chartPanel.add(label);
        EltsIterator eltsItr = factor.iterator();
        int[] index = new int[factor.getVariablesNum()];
        int buttonIndex = 0;
        block2: while (eltsItr.hasNext()) {
            int i2 = 0;
            while (i2 < this.variableOrder.length) {
                String domainElement = this.variableOrder[i2].getDomainElement(index[i2]);
                if (!domainElement.equals("Utility")) {
                    label = new JLabel(domainElement);
                    label.setFont(plain);
                    chartPanel.add(label);
                }
                ++i2;
            }
            JButton button = new JButton(String.valueOf((double)Math.round(eltsItr.next() * 100000.0) / 100000.0));
            button.setFont(plain);
            button.addActionListener(this);
            button.setActionCommand("" + buttonIndex++);
            chartPanel.add(button);
            i2 = this.variableOrder.length - 1;
            while (i2 >= 0) {
                if (index[i2] < this.variableOrder[i2].getDomainSize() - 1) {
                    int n = i2;
                    index[n] = index[n] + 1;
                    int j = i2 + 1;
                    while (j < this.variableOrder.length) {
                        index[j] = 0;
                        ++j;
                    }
                    continue block2;
                }
                --i2;
            }
        }
        JScrollPane centerPane = new JScrollPane(chartPanel, 20, 30);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        centerPane.setMaximumSize(new Dimension(screenSize.width - 300, screenSize.height - 300));
        return centerPane;
    }

    private JScrollPane constructDecisionFunctionCenterPanel(Factor factor, boolean constructOrder) {
        JLabel label;
        Variable var;
        int i;
        JPanel chartPanel = new JPanel();
        Font plain = new Font("SansSerif", 0, this.getFont().getSize());
        Font bold = new Font("SansSerif", 1, this.getFont().getSize());
        chartPanel.setLayout(new GridLayout(((FactorDecision)factor).getDecisionFunctionSize() + 1, factor.getVariablesNum() - 1));
        if (constructOrder || this.variableOrder == null) {
            this.variableOrder = new Variable[factor.getVariablesNum() - 1];
            int orderIndex = 0;
            Iterator<Variable> parents = ((FactorDecision)factor).getParents();
            i = 0;
            while (i < this.variableOrder.length) {
                var = parents.next();
                label = new JLabel(var.getName(false));
                label.setFont(bold);
                chartPanel.add(label);
                this.variableOrder[orderIndex++] = var;
                ++i;
            }
        } else {
            Variable[] variableArray = this.variableOrder;
            int parents = 0;
            i = variableArray.length;
            while (parents < i) {
                Variable element;
                var = element = variableArray[parents];
                label = new JLabel(var.getName(false));
                label.setFont(bold);
                chartPanel.add(label);
                ++parents;
            }
        }
        label = new JLabel(((FactorDecision)factor).getChild().getName(false));
        label.setFont(bold);
        chartPanel.add(label);
        ItrSafe<String> eltsItr = ((FactorDecision)factor).getDecisionFunctionActions();
        int[] index = new int[factor.getVariablesNum()];
        int buttonIndex = 0;
        block2: while (eltsItr.hasNext()) {
            int i2 = 0;
            while (i2 < this.variableOrder.length) {
                String domainElement = this.variableOrder[i2].getDomainElement(index[i2]);
                label = new JLabel(domainElement);
                label.setFont(plain);
                chartPanel.add(label);
                ++i2;
            }
            JButton button = new JButton(((FactorDecision)factor).getDecisionFunctionAction(buttonIndex));
            eltsItr.next();
            button.setFont(plain);
            button.addActionListener(this);
            button.setActionCommand("" + buttonIndex++);
            chartPanel.add(button);
            i2 = this.variableOrder.length - 1;
            while (i2 >= 0) {
                if (index[i2] < this.variableOrder[i2].getDomainSize() - 1) {
                    int n = i2;
                    index[n] = index[n] + 1;
                    int j = i2 + 1;
                    while (j < this.variableOrder.length) {
                        index[j] = 0;
                        ++j;
                    }
                    continue block2;
                }
                --i2;
            }
        }
        JScrollPane centerPane = new JScrollPane(chartPanel, 20, 30);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        centerPane.setMaximumSize(new Dimension(screenSize.width - 300, screenSize.height - 300));
        return centerPane;
    }

    private JPanel constructBottomPanel(Factor factor) {
        Factor curFactor;
        Iterator<Factor> itr;
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        StringBuffer observationBuffer = new StringBuffer("<html><center>This factor was derived ");
        if (factor instanceof FactorCPT) {
            observationBuffer = new StringBuffer("<html><center>This factor represents " + ((FactorCPT)factor).getInterpretation(false) + ".");
        } else if (factor instanceof FactorUtility) {
            observationBuffer = new StringBuffer("<html><center>This utility factor represents ");
            observationBuffer.append(String.valueOf(((FactorUtility)factor).getInterpretation(false)) + ".");
        } else if (factor instanceof FactorSumOut) {
            observationBuffer.append("by eliminating \"");
            observationBuffer.append(((FactorSumOut)factor).getSummedOutVariables()[0].getName(false));
            observationBuffer.append("\" from the factor(s) ");
            itr = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(factor)).iterator();
            while (itr.hasNext()) {
                curFactor = itr.next();
                observationBuffer.append("f" + this.getFactorNum(curFactor) + curFactor.getName(false));
                if (!itr.hasNext()) continue;
                observationBuffer.append(", ");
            }
            observationBuffer.append(".");
        } else if (factor instanceof FactorTimes) {
            observationBuffer.append("by multiplying the factors: ");
            itr = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(factor)).iterator();
            while (itr.hasNext()) {
                observationBuffer.append(((QueryWindow)this.getParent()).getFactorListName(itr.next()));
                if (!itr.hasNext()) continue;
                observationBuffer.append(", ");
            }
            observationBuffer.append(".");
        } else if (factor instanceof FactorNormalise) {
            observationBuffer.append("by normalizing the remaining factor:<br>");
            itr = ((QueryWindow)this.getParent()).getRedElimFactors().iterator();
            while (itr.hasNext()) {
                observationBuffer.append(((QueryWindow)this.getParent()).getFactorListName(itr.next()));
                if (!itr.hasNext()) continue;
                observationBuffer.append(", ");
            }
        } else if (factor instanceof FactorObserved) {
            observationBuffer.append("from " + ((FactorObserved)factor).getInterpretation(false) + ".");
        } else if (factor instanceof FactorMax) {
            observationBuffer.append("by maximizing the decision variable ");
            observationBuffer.append(((FactorMax)factor).getDecisionFunction().getChild().getName(false));
            observationBuffer.append(" in the factor ");
            itr = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(factor)).iterator();
            while (itr.hasNext()) {
                curFactor = itr.next();
                observationBuffer.append("f" + this.getFactorNum(curFactor) + curFactor.getName(false));
                if (!itr.hasNext()) continue;
                observationBuffer.append(", ");
            }
            observationBuffer.append(".");
        } else if (factor instanceof FactorDecision) {
            observationBuffer = new StringBuffer("<html><center>This factor represents the decision function " + ((FactorDecision)factor).getInterpretation(false));
            if (((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(factor)) != null) {
                observationBuffer.append(" derived from ");
                itr = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(factor)).iterator();
                while (itr.hasNext()) {
                    curFactor = itr.next();
                    observationBuffer.append("f" + this.getFactorNum(curFactor) + curFactor.getName(false));
                    if (!itr.hasNext()) continue;
                    observationBuffer.append(", ");
                }
            }
            observationBuffer.append(".");
        } else if (factor instanceof FactorDivide) {
            observationBuffer.append("by dividing by the probability of unpruned evidence.");
        } else {
            observationBuffer.append("by unknown means.");
        }
        observationBuffer.append("</center></html>");
        this.howDerived = observationBuffer.toString();
        JLabel label = new JLabel(observationBuffer.toString());
        label.setHorizontalAlignment(0);
        label.setAlignmentX(0.5f);
        bottomPanel.add(label);
        JButton button = new JButton("OK");
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        button.setAlignmentX(0.5f);
        this.getRootPane().setDefaultButton(button);
        bottomPanel.add(button);
        return bottomPanel;
    }

    public void disposeWindows() {
        if (this.derivationDialog != null) {
            this.derivationDialog.dispose();
        }
        if (this.reorderDialog != null) {
            this.reorderDialog.dispose();
        }
    }

    @Override
    protected boolean actionOK() {
        this.disposeWindows();
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Reorder Variable Columns")) {
            this.reorderDialog = new ReorderDialog((JFrame)this.getParent(), this, this.variableOrder);
        } else if (e.getSource() == this.factorChoiceComboBox) {
            String factorName = (String)this.factorChoiceComboBox.getSelectedItem();
            Factor newFactor = ((QueryWindow)this.getParent()).getCanvas().getFactor(((QueryWindow)this.getParent()).getFactorNameIDHashMap().get(factorName));
            this.getContentPane().remove(1);
            this.getContentPane().remove(1);
            this.getContentPane().add((Component)this.constructCenterPanel(newFactor, true), "Center");
            this.getContentPane().add((Component)this.constructBottomPanel(newFactor), "South");
            this.curFactor = newFactor;
            this.origFactor = newFactor;
            this.pack();
            this.validate();
        } else if (arg.equals("Investigate Calculation of Evidence")) {
            if (!(this.curFactor instanceof FactorDivide)) {
                return;
            }
        } else if (!arg.equals("OK") && e.getSource() instanceof JButton) {
            try {
                this.openDerivationFrame(Integer.parseInt(arg), Double.parseDouble(((JButton)e.getSource()).getText()));
            }
            catch (NumberFormatException e2) {
                this.openDerivationFrame(Integer.parseInt(arg), ((JButton)e.getSource()).getText());
            }
        }
    }

    public void openDerivationFrame(int index, double value) {
        ArrayList<String> stringDerivation = new ArrayList<String>();
        ArrayList<String> numericDerivation = new ArrayList<String>();
        if (this.curFactor.hasBeenReordered()) {
            index = this.curFactor.getReorderedIndex(index);
        }
        if (this.origFactor instanceof FactorSumOut) {
            this.sumOutConstruction(index, value, stringDerivation, numericDerivation);
        } else if (this.origFactor instanceof FactorNormalise) {
            this.normaliseConstruction(index, value, stringDerivation, numericDerivation);
        } else if (this.origFactor instanceof FactorDivide) {
            this.divideConstruction(index, value, stringDerivation, numericDerivation);
        } else if (this.origFactor instanceof FactorTimes) {
            this.timesConstruction(index, value, stringDerivation, numericDerivation);
        } else if (this.origFactor instanceof FactorMax) {
            this.maxConstruction(index, value, stringDerivation, numericDerivation);
        }
        this.derivationDialog = new DerivationDialog((JFrame)this.getParent(), this.origFactor, this.howDerived, stringDerivation, numericDerivation);
    }

    public void openDerivationFrame(int index, String action) {
        ArrayList<String> stringDerivation = new ArrayList<String>();
        ArrayList<String> numericDerivation = new ArrayList<String>();
        if (this.curFactor.hasBeenReordered()) {
            index = ((FactorDecision)this.curFactor).getReorderedActionIndex(index);
        }
        this.decisionConstruction(index, action, stringDerivation, numericDerivation);
        this.derivationDialog = new DerivationDialog((JFrame)this.getParent(), this.curFactor, this.howDerived, stringDerivation, numericDerivation);
    }

    /*
     * Unable to fully structure code
     */
    public double getValueFor(String[] context, Factor factor) {
        iter = factor.iterator();
        numVariables = factor.getVariablesNum();
        index = new int[numVariables];
        curContext = new String[context.length];
        if (curContext.length != 0) ** GOTO lbl34
        return iter.next();
lbl-1000:
        // 1 sources

        {
            i = 0;
            while (i < curContext.length) {
                curContext[i] = factor.getVariable(i).getDomainElement(index[i]);
                ++i;
            }
            i = 0;
            while (i < curContext.length) {
                if (!curContext[i].equals(context[i])) break;
                if (i == curContext.length - 1) {
                    return iter.next();
                }
                ++i;
            }
            iter.next();
            i = numVariables - 1;
            while (i >= 0) {
                if (index[i] < factor.getVariable(i).getDomainSize() - 1) {
                    v0 = i;
                    index[v0] = index[v0] + 1;
                    j = i + 1;
                    while (j < numVariables) {
                        index[j] = 0;
                        ++j;
                    }
                    continue block0;
                }
                --i;
            }
lbl34:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl35:
        // 1 sources

        return -1.0;
    }

    private void sumOutConstruction(int index, double value, ArrayList<String> stringDerivation, ArrayList<String> numericDerivation) {
        String[] rowContext = this.getContextAt(index);
        Variable elimVar = ((FactorSumOut)this.origFactor).getSummedOutVariables()[0];
        ItrSafe<String> elimDomainIterator = elimVar.iterator();
        Factor[] elimFactors = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(this.origFactor)).toArray(new Factor[0]);
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        StringBuffer word = new StringBuffer("f").append(this.getFactorNum(this.origFactor)).append("(");
        int i = 0;
        while (i < rowContext.length) {
            word.append(this.origFactor.getVariable(i).getName(false));
            word.append("=");
            word.append(rowContext[i]);
            if (i < rowContext.length - 1) {
                word.append(", ");
            }
            ++i;
        }
        word.append(")");
        numericDerivation.add(decFormat.format(value));
        stringDerivation.add(word.toString());
        numericDerivation.add(" = ");
        stringDerivation.add(" = ");
        while (elimDomainIterator.hasNext()) {
            String element = (String)elimDomainIterator.next();
            int x = 0;
            int j = 0;
            while (j < elimFactors.length) {
                word = new StringBuffer();
                word.append("f");
                word.append(this.getFactorNum(elimFactors[j]));
                word.append("(");
                String[] facDomain = new String[elimFactors[j].getVariablesNum()];
                int k = 0;
                while (k < elimFactors[j].getVariablesNum()) {
                    word.append(elimFactors[j].getVariable(k).getName(false));
                    word.append("=");
                    if (elimVar.equals(elimFactors[j].getVariable(k))) {
                        word.append(element);
                        facDomain[k] = element;
                    } else {
                        if (x >= rowContext.length) {
                            x -= rowContext.length;
                        }
                        word.append(rowContext[x]);
                        facDomain[k] = rowContext[x];
                        ++x;
                    }
                    if (k != elimFactors[j].getVariablesNum() - 1) {
                        word.append(", ");
                    }
                    ++k;
                }
                word.append(")");
                stringDerivation.add(word.toString());
                numericDerivation.add(decFormat.format(this.getValueFor(facDomain, elimFactors[j])));
                if (j != elimFactors.length - 1) {
                    stringDerivation.add(" * ");
                    numericDerivation.add(" * ");
                }
                ++j;
            }
            if (!elimDomainIterator.hasNext()) continue;
            stringDerivation.add(" + ");
            numericDerivation.add(" + ");
        }
    }

    private void divideConstruction(int index, double value, ArrayList<String> stringDerivation, ArrayList<String> numericDerivation) {
        String[] rowContext = this.getContextAt(index);
        Factor[] elimFactors = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(this.origFactor)).toArray(new Factor[0]);
        ItrSafe<String> elimDomainIterator = null;
        if (elimFactors[0].getVariablesNum() > 0) {
            elimDomainIterator = elimFactors[0].getVariable(0).iterator();
        }
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        StringBuffer word = new StringBuffer("f").append(this.getFactorNum(this.origFactor)).append("(");
        int i = 0;
        while (i < rowContext.length) {
            word.append(this.origFactor.getVariable(i).getName(false));
            word.append("=");
            word.append(rowContext[i]);
            if (i < rowContext.length - 1) {
                word.append(", ");
            }
            ++i;
        }
        word.append(")");
        numericDerivation.add(decFormat.format(value));
        stringDerivation.add(word.toString());
        numericDerivation.add("  =  ( ");
        stringDerivation.add("  =  ( ");
        do {
            String element = null;
            if (elimDomainIterator != null) {
                element = (String)elimDomainIterator.next();
            }
            int j = 0;
            while (j < elimFactors.length) {
                word = new StringBuffer();
                word.append("f");
                word.append(this.getFactorNum(elimFactors[j]));
                word.append("(");
                boolean x = false;
                String[] facDomain = new String[elimFactors[j].getVariablesNum()];
                int k = 0;
                while (k < elimFactors[j].getVariablesNum()) {
                    word.append(elimFactors[j].getVariable(k).getName(false));
                    word.append("=");
                    word.append(element);
                    facDomain[k] = element;
                    if (k != elimFactors[j].getVariablesNum() - 1) {
                        word.append(", ");
                    }
                    ++k;
                }
                word.append(")");
                stringDerivation.add(word.toString());
                numericDerivation.add(decFormat.format(this.getValueFor(facDomain, elimFactors[j])));
                if (j != elimFactors.length - 1) {
                    stringDerivation.add(" * ");
                    numericDerivation.add(" * ");
                }
                ++j;
            }
            if (elimDomainIterator == null || !elimDomainIterator.hasNext()) continue;
            stringDerivation.add(" + ");
            numericDerivation.add(" + ");
        } while (elimDomainIterator != null && elimDomainIterator.hasNext());
        stringDerivation.add(" ) / ");
        numericDerivation.add(" ) / ");
        stringDerivation.add("P(e)");
        numericDerivation.add(decFormat.format(((FactorDivide)this.origFactor).getDivisor().iterator().next()));
    }

    private void timesConstruction(int index, double value, ArrayList<String> stringDerivation, ArrayList<String> numericDerivation) {
        Factor factor;
        ArrayList<String> sDeriv = new ArrayList<String>();
        ArrayList<String> nDeriv = new ArrayList<String>();
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        Variable remainingVar = this.origFactor.getVariables().next();
        String[] rowContext = this.getContextAt(index);
        StringBuffer word = new StringBuffer("f").append(this.getFactorNum(this.origFactor)).append("(");
        word.append(remainingVar.getName(false)).append("=");
        word.append(rowContext[0]).append(")");
        sDeriv.add(word.toString());
        sDeriv.add(" = ");
        nDeriv.add(decFormat.format(value));
        nDeriv.add(" = ");
        Factor[] elimFactors = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(this.origFactor)).toArray(new Factor[0]);
        ItrSafe<String> elimDomain = null;
        boolean foundExtraDomains = false;
        Factor[] factorArray = elimFactors;
        int n = 0;
        int n2 = factorArray.length;
        while (n < n2) {
            factor = factorArray[n];
            ItrSafe<Variable> itr = factor.getVariables();
            while (itr.hasNext() && !foundExtraDomains) {
                Variable var = (Variable)itr.next();
                if (var.equals(remainingVar)) continue;
                elimDomain = var.iterator();
                foundExtraDomains = true;
            }
            if (foundExtraDomains) break;
            ++n;
        }
        do {
            String element = null;
            if (foundExtraDomains) {
                element = (String)elimDomain.next();
            }
            int i = 0;
            while (i < elimFactors.length) {
                factor = elimFactors[i];
                if (factor instanceof FactorObserved) {
                    word = new StringBuffer(((QueryWindow)this.getParent()).getFactorListName(factor));
                    sDeriv.add(((QueryWindow)this.getParent()).getFactorListName(factor));
                    nDeriv.add(decFormat.format(factor.iterator().next()));
                } else {
                    word = new StringBuffer("f").append(this.getFactorNum(factor)).append("(");
                    String[] facDomain = new String[factor.getVariablesNum()];
                    int k = 0;
                    while (k < factor.getVariablesNum()) {
                        word.append(factor.getVariable(k).getName(false));
                        word.append("=");
                        if (remainingVar.equals(factor.getVariable(k))) {
                            word.append(rowContext[0]);
                            facDomain[k] = rowContext[0];
                        } else {
                            word.append(element);
                            facDomain[k] = element;
                        }
                        if (k != factor.getVariablesNum() - 1) {
                            word.append(", ");
                        }
                        ++k;
                    }
                    word.append(")");
                    sDeriv.add(word.toString());
                    nDeriv.add(decFormat.format(this.getValueFor(facDomain, factor)));
                }
                if (i != elimFactors.length - 1) {
                    sDeriv.add(" * ");
                    nDeriv.add(" * ");
                }
                ++i;
            }
            if (elimDomain == null || !elimDomain.hasNext()) continue;
            sDeriv.add(" + ");
            nDeriv.add(" + ");
        } while (elimDomain != null && elimDomain.hasNext());
        stringDerivation.addAll(sDeriv);
        numericDerivation.addAll(nDeriv);
    }

    private void normaliseConstruction(int index, double value, ArrayList<ArrayList<String>> stringDerivation, ArrayList<ArrayList<String>> numericDerivation) {
        int i;
        StringBuffer word;
        ArrayList<String> sDeriv = new ArrayList<String>();
        ArrayList<String> nDeriv = new ArrayList<String>();
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        Variable remainingVar = this.origFactor.getVariables().next();
        String[] rowContext = this.getContextAt(index);
        sDeriv = new ArrayList();
        nDeriv = new ArrayList();
        int j = 0;
        rowContext = this.getContextAt(j++);
        nDeriv.add(decFormat.format(((FactorNormalise)this.origFactor).getSum()));
        nDeriv.add(" = ");
        sDeriv.add("Normalization constant");
        sDeriv.add(" = ");
        while (rowContext != null) {
            word = new StringBuffer("f" + this.getFactorNum(((QueryWindow)this.getParent()).getRedElimFactors().get(0)) + "(");
            i = 0;
            while (i < rowContext.length) {
                word.append(this.origFactor.getVariable(i).getName(false));
                word.append("=");
                word.append(rowContext[i]);
                if (i < rowContext.length - 1) {
                    word.append(", ");
                }
                ++i;
            }
            word.append(")");
            nDeriv.add(decFormat.format(this.getValueFor(rowContext, ((FactorNormalise)this.origFactor).getOriginalFactor())));
            sDeriv.add(word.toString());
            rowContext = this.getContextAt(j++);
            if (rowContext == null) continue;
            nDeriv.add(" + ");
            sDeriv.add(" + ");
        }
        stringDerivation.add(sDeriv);
        numericDerivation.add(nDeriv);
        sDeriv = new ArrayList();
        nDeriv = new ArrayList();
        rowContext = this.getContextAt(index);
        word = new StringBuffer("f" + this.getFactorNum(this.origFactor) + "(");
        i = 0;
        while (i < rowContext.length) {
            word.append(this.origFactor.getVariable(i).getName(false));
            if (i < rowContext.length - 1) {
                word.append(", ");
            }
            ++i;
        }
        sDeriv.add(word.append(")").toString());
        sDeriv.add(" = ");
        word = new StringBuffer("(");
        word.append(decFormat.format(this.getValueFor(this.getContextAt(index), ((FactorNormalise)this.origFactor).getOriginalFactor()))).append(" / ");
        word.append(decFormat.format(((FactorNormalise)this.origFactor).getSum())).append(")");
        word.append(" = ").append(decFormat.format(value));
        nDeriv.add(word.toString());
        stringDerivation.add(sDeriv);
        numericDerivation.add(nDeriv);
    }

    private void maxConstruction(int index, double value, ArrayList<String> stringDerivation, ArrayList<String> numericDerivation) {
        String[] rowContext = this.getContextAt(index);
        Variable elimVar = ((FactorMax)this.origFactor).getDecisionFunction().getChild();
        ItrSafe<String> elimDomainIterator = elimVar.iterator();
        Factor[] elimFactors = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(this.origFactor)).toArray(new Factor[0]);
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        StringBuffer word = new StringBuffer("f").append(this.getFactorNum(this.origFactor)).append("(");
        int i = 0;
        while (i < rowContext.length) {
            word.append(this.origFactor.getVariable(i).getName(false));
            word.append("=");
            word.append(rowContext[i]);
            if (i < rowContext.length - 1) {
                word.append(", ");
            }
            ++i;
        }
        word.append(")");
        numericDerivation.add(decFormat.format(value));
        stringDerivation.add(word.toString());
        numericDerivation.add(" = max { ");
        stringDerivation.add(" = max { ");
        while (elimDomainIterator.hasNext()) {
            String element = (String)elimDomainIterator.next();
            int x = 0;
            int j = 0;
            while (j < elimFactors.length) {
                word = new StringBuffer();
                word.append("f");
                word.append(this.getFactorNum(elimFactors[j]));
                word.append("(");
                String[] facDomain = new String[elimFactors[j].getVariablesNum()];
                int k = 0;
                while (k < elimFactors[j].getVariablesNum()) {
                    word.append(elimFactors[j].getVariable(k).getName(false));
                    word.append("=");
                    if (elimVar.equals(elimFactors[j].getVariable(k))) {
                        word.append(element);
                        facDomain[k] = element;
                    } else {
                        if (x >= rowContext.length) {
                            x -= rowContext.length;
                        }
                        word.append(rowContext[x]);
                        facDomain[k] = rowContext[x];
                        ++x;
                    }
                    if (k != elimFactors[j].getVariablesNum() - 1) {
                        word.append(", ");
                    }
                    ++k;
                }
                word.append(")");
                stringDerivation.add(word.toString());
                numericDerivation.add(decFormat.format(this.getValueFor(facDomain, elimFactors[j])));
                if (j != elimFactors.length - 1) {
                    stringDerivation.add(" * ");
                    numericDerivation.add(" * ");
                }
                ++j;
            }
            if (elimDomainIterator.hasNext()) {
                stringDerivation.add(", ");
                numericDerivation.add(", ");
                continue;
            }
            stringDerivation.add(" }");
            numericDerivation.add(" }");
        }
    }

    private void decisionConstruction(int index, String value, ArrayList<String> stringDerivation, ArrayList<String> numericDerivation) {
        String[] rowContext = this.getContextAt(index);
        Variable elimVar = ((FactorDecision)this.origFactor).getChild();
        ItrSafe<String> elimDomainIterator = elimVar.iterator();
        Factor[] elimFactors = ((QueryCanvas)this.graph.canvas).getFactorsEliminated(((QueryWindow)this.getParent()).getFactorListName(this.origFactor)).toArray(new Factor[0]);
        DecimalFormat decFormat = new DecimalFormat("0.0####");
        StringBuffer word = new StringBuffer(((FactorDecision)this.origFactor).getChild().getName(false)).append("(");
        if (rowContext.length > 1) {
            Iterator<Variable> parents = ((FactorDecision)this.origFactor).getParents();
            int i = 0;
            while (i < rowContext.length) {
                word.append(parents.next().getName(false));
                word.append("=");
                word.append(rowContext[i]);
                if (i < rowContext.length - 1 && (i != rowContext.length - 2 || rowContext[i + 1] != null)) {
                    word.append(", ");
                }
                if (rowContext[i + 1] == null) {
                    ++i;
                }
                ++i;
            }
        }
        word.append(")");
        numericDerivation.add(value);
        stringDerivation.add(word.toString());
        numericDerivation.add(" = argmax(" + ((FactorDecision)this.origFactor).getChild().getName(false) + ") { ");
        stringDerivation.add(" = argmax(" + ((FactorDecision)this.origFactor).getChild().getName(false) + ") { ");
        while (elimDomainIterator.hasNext()) {
            String element = (String)elimDomainIterator.next();
            int x = 0;
            int j = 0;
            while (j < elimFactors.length) {
                word = new StringBuffer();
                word.append("f");
                word.append(this.getFactorNum(elimFactors[j]));
                word.append("(");
                String[] facDomain = new String[elimFactors[j].getVariablesNum()];
                int k = 0;
                while (k < elimFactors[j].getVariablesNum()) {
                    word.append(elimFactors[j].getVariable(k).getName(false));
                    word.append("=");
                    if (elimVar.equals(elimFactors[j].getVariable(k))) {
                        word.append(element);
                        facDomain[k] = element;
                    } else {
                        if (x >= rowContext.length) {
                            x -= rowContext.length;
                        }
                        word.append(rowContext[x]);
                        facDomain[k] = rowContext[x];
                        ++x;
                    }
                    if (k != elimFactors[j].getVariablesNum() - 1) {
                        word.append(", ");
                    }
                    ++k;
                }
                word.append(")");
                stringDerivation.add(word.toString());
                numericDerivation.add(decFormat.format(this.getValueFor(facDomain, elimFactors[j])));
                if (j != elimFactors.length - 1) {
                    stringDerivation.add(" * ");
                    numericDerivation.add(" * ");
                }
                ++j;
            }
            if (elimDomainIterator.hasNext()) {
                stringDerivation.add(", ");
                numericDerivation.add(", ");
                continue;
            }
            stringDerivation.add(" }");
            numericDerivation.add(" }");
        }
    }

    private String getFactorNum(Factor factor) {
        String name = ((QueryWindow)this.getParent()).getFactorListName(factor);
        if (name.indexOf(40) == -1) {
            return "999";
        }
        return name.substring(1, name.indexOf(40));
    }

    private String[] buildContext(int rowIndex) {
        String[] context = new String[this.origFactor.getVariablesNum()];
        EltsIterator eltsItr = this.origFactor.iterator();
        int[] index = new int[this.variableOrder.length];
        int row = -1;
        while (eltsItr.hasNext()) {
            int i;
            if (++row == rowIndex) {
                i = 0;
                while (i < this.variableOrder.length) {
                    context[i] = this.variableOrder[i].getDomainElement(index[i]);
                    ++i;
                }
                break;
            }
            i = this.variableOrder.length - 1;
            while (i >= 0) {
                if (index[i] < this.variableOrder[i].getDomainSize() - 1) {
                    int n = i;
                    index[n] = index[n] + 1;
                    int j = i + 1;
                    while (j < this.variableOrder.length) {
                        index[j] = 0;
                        ++j;
                    }
                    break;
                }
                --i;
            }
            eltsItr.next();
        }
        if (row < rowIndex) {
            return null;
        }
        return context;
    }

    private String[] getContextAt(int rowIndex) {
        return this.origContexts[rowIndex];
    }

    protected void reorderColumns(Variable[] order) {
        this.variableOrder = order;
        if (this.origFactor instanceof FactorDecision && this.isOptimizing) {
            Variable[] oldOrder = order;
            order = new Variable[oldOrder.length + 1];
            int i = 0;
            while (i < oldOrder.length) {
                order[i] = oldOrder[i];
                ++i;
            }
            order[oldOrder.length] = ((FactorDecision)this.origFactor).getChild();
        }
        this.curFactor = this.origFactor.reorder(order, false, true);
        this.getContentPane().remove(1);
        this.getContentPane().add(this.constructCenterPanel(this.curFactor, false), "Center", 1);
        this.validate();
    }
}

