/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.dialogs;

import CIspace.bayes.BayesGraph;
import CIspace.bayes.BayesWindow;
import CIspace.bayes.InlineBayesApplet;
import CIspace.bayes.elements.BayesNode;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;

public class ObservationDialog
extends BasicDialog {
    private JList domainList;
    private BayesNode node;
    private Container parent;

    public ObservationDialog(Container parent, BayesNode n) {
        super(parent instanceof BayesWindow ? (JFrame)parent : null, "Observation for " + n.getLabel(), true);
        this.node = n;
        this.parent = parent;
        JButton ok_button = new JButton("OK");
        ok_button.setActionCommand(ok_button.getText());
        ok_button.addActionListener(this);
        DefaultListModel<String> domainListModel = new DefaultListModel<String>();
        domainListModel.setSize(this.node.getDomain().size() + 2);
        this.domainList = new JList(domainListModel);
        this.domainList.setSelectionMode(0);
        domainListModel.removeAllElements();
        domainListModel.addElement("<none>");
        int domainIndex = 0;
        int i = 0;
        while (i < this.node.getDomain().size()) {
            if (this.node.getDomain().get(i).equals(this.node.getObservation())) {
                domainIndex = i + 1;
            }
            domainListModel.addElement(this.node.getDomain().get(i));
            ++i;
        }
        this.domainList.setSelectedIndex(domainIndex);
        this.getContentPane().add((Component)this.domainList, "Center");
        this.getContentPane().add((Component)ok_button, "South");
        this.packCenterOpen();
    }

    protected boolean actionOK() {
        if (this.domainList.getSelectedIndex() == 0) {
            this.node.setObservation("");
        } else {
            this.node.setObservation((String)this.domainList.getSelectedValue());
        }
        if (this.parent instanceof BayesWindow) {
            ((BayesWindow)this.parent).setQueryEvidenceButton();
            ((BayesGraph)((BayesWindow)this.parent).returnCanvas().graph).updateMonitoredNodes();
        } else {
            ((InlineBayesApplet)this.parent).setQueryEvidenceButton();
            ((BayesGraph)((InlineBayesApplet)this.parent).getCanvas().graph).updateMonitoredNodes();
        }
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }
}

