/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.dialogs;

import CIspace.bayes.BayesCanvas;
import CIspace.bayes.BayesWindow;
import CIspace.bayes.InlineBayesApplet;
import CIspace.bayes.elements.BayesNode;
import CIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class QueryTypeDialog
extends BasicDialog {
    private JRadioButton verboseModeRadioButton;
    private JRadioButton briefModeRadioButton;
    private JRadioButton promptModeRadioButton;
    private Container window;
    private BayesNode node;
    private BayesCanvas canvas;
    private boolean isOptimizing;

    public QueryTypeDialog(Container parent, BayesCanvas canvas, BayesNode node, boolean isOptimizing) {
        super(parent instanceof BayesWindow ? (JFrame)parent : null, "Query Mode", true, 0);
        this.window = parent;
        this.node = node;
        this.canvas = canvas;
        this.isOptimizing = isOptimizing;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 1));
        JLabel label = new JLabel("Please Select a Query Mode");
        label.setFont(new Font("SansSerif", 1, 14));
        label.setAlignmentX(0.5f);
        top.add(label);
        top.add(new JLabel(" "));
        JButton button = new JButton("Brief");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        button.setFont(new Font("SansSerif", 1, 14));
        button.setAlignmentX(0.5f);
        top.add(button);
        label = new JLabel("\n (brief mode selects the elimination ordering automatically)");
        label.setAlignmentX(0.5f);
        top.add(label);
        top.add(new JLabel(" "));
        button = new JButton("Verbose");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        button.setFont(new Font("SansSerif", 1, 14));
        button.setAlignmentX(0.5f);
        top.add(button);
        label = new JLabel("\n(verbose mode allows the user to eliminate variables ");
        label.setAlignmentX(0.5f);
        top.add(label);
        label = new JLabel("one-by-one and view derivation information)");
        label.setAlignmentX(0.5f);
        top.add(label);
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridLayout(2, 3));
        this.promptModeRadioButton = new JRadioButton("Always Prompt");
        this.promptModeRadioButton.setSelected(true);
        this.briefModeRadioButton = new JRadioButton("Always Brief");
        this.verboseModeRadioButton = new JRadioButton("Always Verbose");
        ButtonGroup queryMode = new ButtonGroup();
        queryMode.add(this.promptModeRadioButton);
        queryMode.add(this.briefModeRadioButton);
        queryMode.add(this.verboseModeRadioButton);
        bottom.add(new JLabel(""));
        bottom.add(new JLabel(""));
        bottom.add(new JLabel(""));
        bottom.add(this.promptModeRadioButton);
        bottom.add(this.briefModeRadioButton);
        bottom.add(this.verboseModeRadioButton);
        this.getContentPane().add((Component)top, "Center");
        this.getContentPane().add((Component)bottom, "South");
        this.packCenterOpen();
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.setQueryMode();
        if (e.getActionCommand().equals("Verbose")) {
            this.canvas.queryNode(this.node, 8881, this.isOptimizing);
        } else if (e.getActionCommand().equals("Brief")) {
            this.canvas.queryNode(this.node, 8880, this.isOptimizing);
        }
        this.dispose();
    }

    private void setQueryMode() {
        if (this.window instanceof BayesWindow) {
            if (this.verboseModeRadioButton.isSelected()) {
                ((BayesWindow)this.window).setQueryMode(8881);
            } else if (this.briefModeRadioButton.isSelected()) {
                ((BayesWindow)this.window).setQueryMode(8880);
            } else {
                ((BayesWindow)this.window).setQueryMode(8882);
            }
        } else if (this.verboseModeRadioButton.isSelected()) {
            ((InlineBayesApplet)this.window).setQueryMode(8881);
        } else if (this.briefModeRadioButton.isSelected()) {
            ((InlineBayesApplet)this.window).setQueryMode(8880);
        } else {
            ((InlineBayesApplet)this.window).setQueryMode(8882);
        }
    }

    protected boolean actionOK() {
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }
}

