/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.quiz;

import CIspace.bayes.BayesGraph;
import CIspace.bayes.DisplayCanvas;
import CIspace.bayes.elements.BayesNode;
import CIspace.bayes.quiz.BayesIndependence;
import CIspace.bayes.quiz.QuizWindow;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Point;
import CIspace.ve.DecisionNetwork;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class QuizCanvas
extends DisplayCanvas {
    public static final int QUIZ_ASK = 2222;
    public static final int QUIZ_ANSWER = 2223;
    protected BayesNode startQueryNode;
    protected BayesNode endQueryNode;
    protected ArrayList<BayesNode> givenNodes;

    public QuizCanvas(Container parent, DecisionNetwork network, boolean inline) {
        super(parent, inline);
        this.graph = new BayesGraph(this, null, network);
        this.startQueryNode = null;
        this.endQueryNode = null;
        this.givenNodes = new ArrayList(5);
        this.mode = 0;
    }

    protected void addInformationText(String text) {
        ((QuizWindow)this.parent).addInformationText(text);
    }

    public void resetNodes() {
        if (this.startQueryNode != null) {
            this.startQueryNode.setNodeAppearance(this.startQueryNode.getNodeType());
            this.startQueryNode = null;
        }
        if (this.endQueryNode != null) {
            this.endQueryNode.setNodeAppearance(this.endQueryNode.getNodeType());
            this.endQueryNode = null;
        }
        for (BayesNode curNode : this.givenNodes) {
            curNode.setNodeAppearance(curNode.getNodeType());
        }
        this.givenNodes.clear();
    }

    public void askNewQuestion() {
        int randomEndIndex;
        this.resetNodes();
        int randomStartIndex = (int)(Math.random() * (double)this.graph.numNodes());
        this.selectQueryNode((BayesNode)this.graph.nodeAt(randomStartIndex));
        while ((randomEndIndex = (int)(Math.random() * (double)this.graph.numNodes())) == randomStartIndex) {
        }
        this.selectOtherNode((BayesNode)this.graph.nodeAt(randomEndIndex));
        StringBuffer question = new StringBuffer("Is " + this.startQueryNode.getLabel() + " conditionally independent of " + this.endQueryNode.getLabel());
        int numIters = (int)(Math.random() * (double)(this.graph.numNodes() - 2));
        int i = 0;
        while (i < numIters) {
            BayesNode givenNode = (BayesNode)this.graph.nodeAt((int)(Math.random() * (double)this.graph.numNodes()));
            if (givenNode != this.startQueryNode && givenNode != this.endQueryNode && !this.givenNodes.contains(givenNode)) {
                if (this.givenNodes.size() == 0) {
                    question.append(" given " + givenNode.getLabel());
                } else if (this.givenNodes.size() != numIters - 1) {
                    question.append(", " + givenNode.getLabel());
                } else {
                    question.append(" and " + givenNode.getLabel());
                }
                this.selectGivenNode(givenNode);
            } else {
                --i;
            }
            ++i;
        }
        question.append("?");
        this.addInformationText(question.toString());
    }

    protected void selectQueryNode(BayesNode node) {
        this.startQueryNode = node;
        this.startQueryNode.setNodeAppearance(7789);
    }

    protected void selectOtherNode(BayesNode node) {
        this.endQueryNode = node;
        this.endQueryNode.setNodeAppearance(7790);
    }

    protected void selectGivenNode(BayesNode node) {
        this.givenNodes.add(node);
        node.setNodeAppearance(7791);
    }

    protected void popupCanvas(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Quiz Options"));
        JMenuItem mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    protected void popupEdge(int x, int y) {
    }

    protected void popupNode(int x, int y) {
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        if (e.getModifiers() == 4) {
            return;
        }
        if (ent == null || ent.type != 7770) {
            return;
        }
        if (this.submode == 2222) {
            if (this.startQueryNode == null) {
                this.selectQueryNode((BayesNode)ent);
                if (((QuizWindow)this.parent).getInformationText().equals("No Questions")) {
                    ((QuizWindow)this.parent).setInformationText("");
                } else {
                    this.addInformationText("\n");
                }
                ((QuizWindow)this.parent).addInformationText("Is " + ((BayesNode)ent).getLabel() + " conditionally independent of ");
                ((QuizWindow)this.parent).setPromptColor(Color.blue);
                this.setPromptLabel("Select another node");
            } else if (this.endQueryNode == null && (BayesNode)ent != this.startQueryNode) {
                this.selectOtherNode((BayesNode)ent);
                ((QuizWindow)this.parent).addInformationText(String.valueOf(((BayesNode)ent).getLabel()) + "?");
                ((QuizWindow)this.parent).setPromptColor(Color.blue);
                this.setPromptLabel("Now start selecting other nodes or click 'Get Answer'");
                ((QuizWindow)this.parent).setAnswerButtons(true);
            } else if ((BayesNode)ent != this.startQueryNode && (BayesNode)ent != this.endQueryNode && !this.givenNodes.contains(ent)) {
                String infoText = ((QuizWindow)this.parent).getInformationText();
                infoText = infoText.substring(0, infoText.length() - 1);
                if (this.givenNodes.size() == 0) {
                    ((QuizWindow)this.parent).setInformationText(String.valueOf(infoText) + " given " + ((BayesNode)ent).getLabel() + "?");
                } else {
                    ((QuizWindow)this.parent).setInformationText(String.valueOf(infoText) + " and " + ((BayesNode)ent).getLabel() + "?");
                }
                this.selectGivenNode((BayesNode)ent);
            }
        }
    }

    protected boolean getAnswer() {
        return BayesIndependence.isIndependentOf(this.graph.numNodes(), this.startQueryNode, this.endQueryNode, this.givenNodes);
    }
}

