/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.quiz;

import CIspace.bayes.BayesWindow;
import CIspace.bayes.DisplayWindow;
import CIspace.bayes.InlineBayesApplet;
import CIspace.bayes.quiz.QuizCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.ve.DecisionNetwork;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuizWindow
extends DisplayWindow
implements ChangeListener {
    private JPanel quizAnswerPanel;
    private JTextField quizScoreText;
    private JButton quizTrueButton;
    private JButton quizFalseButton;
    private JTabbedPane tabbedPane;
    private JPanel mainPanel;
    private JPanel emptyPanel1;
    private JPanel emptyPanel2;
    private JTextArea informationText;
    private JButton getAnswerButton;
    private JButton askQuestionButton;
    private int quizNumQuestionsRight;
    private int quizNumQuestionsAsked;
    private String otherTabText;

    public QuizWindow(Container parent, DecisionNetwork network) {
        this.setTitle("Conditional Independence Quiz");
        this.canvas = new QuizCanvas(this, network, false);
        if (parent instanceof BayesWindow) {
            this.setAntiAliasing(((GraphWindow)parent).isAntiAliasingEnabled());
            this.setFont(((BayesWindow)parent).getFont());
        } else {
            this.setAntiAliasing(true);
            this.setFont(((InlineBayesApplet)parent).getFont());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                QuizWindow.this.setVisible(false);
                QuizWindow.this.canvas.disposeWindows();
                QuizWindow.this.dispose();
            }
        });
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.getContentPane().setLayout(new BorderLayout());
        this.quizNumQuestionsAsked = 0;
        this.quizNumQuestionsRight = 0;
        this.otherTabText = "No Questions";
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(this.constructLeftPanel());
        splitPane.setRightComponent(this.constructRightPanel());
        splitPane.setResizeWeight(0.0);
        splitPane.setDividerLocation(0.2);
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(GraphConsts.bg.darker());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add(splitPane);
        this.mainPanel.add((Component)this.constructBottomPanel(), "South");
        this.emptyPanel1 = new JPanel();
        this.emptyPanel2 = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Quiz Yourself", null, this.mainPanel, "Click to Quiz Yourself about Conditional Independence");
        this.tabbedPane.addTab("Ask the Applet", null, this.emptyPanel2, "Click to Ask the Applet a Conditional Independence Question");
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setBackground(Color.lightGray);
        this.getContentPane().add("Center", this.tabbedPane);
        this.setPromptColor(Color.blue);
        this.setPromptLabel("Click 'Answer a Question' to get a new conditional independence question.");
        if (parent instanceof BayesWindow) {
            this.canvas.graph.setLineWidth(((BayesWindow)parent).returnCanvas().graph.getLineWidth());
        } else {
            this.canvas.graph.setLineWidth(((InlineBayesApplet)parent).getCanvas().graph.getLineWidth());
        }
        this.canvas.changeLineWidth();
        this.canvas.changeFont(this.getFont().getSize());
        this.setSize(825, 650);
        this.centerWindow();
        this.setVisible(true);
        this.canvas.autoscale();
    }

    private JPanel constructLeftPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(this.gbl);
        this.askQuestionButton = new JButton("Answer a Question");
        this.askQuestionButton.setActionCommand(this.askQuestionButton.getText());
        this.askQuestionButton.addActionListener(this);
        this.getAnswerButton = new JButton("Get Answer");
        this.getAnswerButton.setActionCommand(this.getAnswerButton.getText());
        this.getAnswerButton.addActionListener(this);
        this.quizAnswerPanel = new JPanel();
        this.quizAnswerPanel.setLayout(this.gbl);
        this.quizTrueButton = new JButton("  True  ");
        this.quizTrueButton.addActionListener(this);
        this.quizTrueButton.setActionCommand(this.quizTrueButton.getText());
        this.quizFalseButton = new JButton(" False  ");
        this.quizFalseButton.addActionListener(this);
        this.quizFalseButton.setActionCommand(this.quizFalseButton.getText());
        JLabel quizScoreLabel = new JLabel("Score:");
        this.quizScoreText = new JTextField("0/0", 3);
        this.quizScoreText.setHorizontalAlignment(4);
        this.quizScoreText.setEditable(false);
        this.quizScoreText.setBackground(Color.WHITE);
        this.addComponent(this.quizTrueButton, this.quizAnswerPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.quizFalseButton, this.quizAnswerPanel, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(" "), this.quizAnswerPanel, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(quizScoreLabel, this.quizAnswerPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.quizScoreText, this.quizAnswerPanel, 2, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.askQuestionButton, topPanel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.getAnswerButton, topPanel, 2, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.quizAnswerPanel, topPanel, 3, 0, 1, 1, 0.0, 0.0);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(this.gbl);
        JButton button = new JButton("Autoscale");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        this.addComponent(button, bottomPanel, 0, 0, 2, 1, 0.0, 0.0);
        button = new JButton("Clear Text");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        this.addComponent(button, bottomPanel, 1, 0, 2, 1, 0.0, 0.0);
        JPanel left = new JPanel();
        left.setLayout(this.gbl);
        this.addComponent(topPanel, left, 1, 0, 1, 1, 0.0, 1.0);
        this.addComponent(bottomPanel, left, 2, 0, 1, 1, 0.0, 0.0);
        this.setAnswerButtons(false);
        return left;
    }

    private JPanel constructRightPanel() {
        JPanel canvasPanel = new JPanel();
        canvasPanel.setBackground(Color.white);
        canvasPanel.setLayout(this.gbl);
        this.promptCanvas = new LabelCanvas();
        this.promptCanvas.setFontSize(this.getFont().getSize());
        this.canvasScrollPane = new JScrollPane(this.canvas, 20, 30);
        this.addComponent(this.promptCanvas, canvasPanel, 0, 0, 1, 1, 1.0, 0.135);
        this.addComponent(this.canvasScrollPane, canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        return canvasPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottom = new JPanel();
        bottom.setBackground(GraphConsts.bg);
        bottom.setLayout(new BoxLayout(bottom, 1));
        this.informationText = new JTextArea(this.otherTabText, 8, 55);
        this.informationText.setFont(new Font("SansSerif", 0, this.getFont().getSize()));
        this.informationText.setEditable(false);
        this.informationText.setBackground(Color.WHITE);
        this.informationText.setForeground(GraphConsts.fg);
        JScrollPane informationTextScroll = new JScrollPane(this.informationText, 20, 30);
        JPanel panel = new JPanel();
        panel.setBackground(GraphConsts.bg);
        JButton okButton = new JButton("Close");
        okButton.setActionCommand(okButton.getText());
        okButton.addActionListener(this);
        panel.add(okButton);
        bottom.add(informationTextScroll);
        bottom.add(panel);
        return bottom;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause || this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand().trim();
        if (arg.equals("Close")) {
            this.setVisible(false);
            this.canvas.disposeWindows();
            this.dispose();
        } else if (arg.equals("Ask a Question")) {
            if (this.canvas.graph.numNodes() <= 1) {
                this.setPromptLabel("Insufficient number of nodes to ask a question.");
                return;
            }
            this.canvas.setSubmode(2222);
            this.setPromptColor(Color.blue);
            this.setPromptLabel("Select a node");
            ((QuizCanvas)this.canvas).resetNodes();
        } else if (arg.equals("Answer a Question")) {
            if (this.canvas.graph.numNodes() <= 1) {
                this.setPromptLabel("Insufficient number of nodes to ask a question.");
                return;
            }
            this.canvas.setSubmode(2223);
            this.setPromptColor(Color.blue);
            this.setPromptLabel("Click True or False to answer the question, or Get Answer to have the applet answer.");
            if (this.informationText.getText().equals("No Questions")) {
                this.informationText.setText("");
            } else {
                this.addInformationText("\n");
            }
            this.setAnswerButtons(true);
            ((QuizCanvas)this.canvas).askNewQuestion();
        } else if (arg.equals("Get Answer")) {
            this.canvas.setSubmode(2223);
            boolean answerTrue = ((QuizCanvas)this.canvas).getAnswer();
            this.setAnswerButtons(false);
            this.addInformationText("\nCorrect Answer: ");
            if (answerTrue) {
                this.addInformationText("True\n");
                this.setPromptColor(Color.GREEN);
                this.setPromptLabel("True");
            } else {
                this.addInformationText("False\n");
                this.setPromptColor(Color.RED);
                this.setPromptLabel("False");
            }
        } else if (arg.equals("True")) {
            this.setAnswerButtons(false);
            boolean answerTrue = ((QuizCanvas)this.canvas).getAnswer();
            this.addInformationText("\nYour answer: True\nCorrect answer: ");
            if (answerTrue) {
                this.increaseQuestions(true);
                this.setPromptColor(Color.green);
                this.setPromptLabel("Correct");
                this.addInformationText("True\n");
            } else {
                this.increaseQuestions(false);
                this.setPromptColor(Color.red);
                this.setPromptLabel("Incorrect");
                this.addInformationText("False\n");
            }
        } else if (arg.equals("False")) {
            this.setAnswerButtons(false);
            boolean answerTrue = ((QuizCanvas)this.canvas).getAnswer();
            this.addInformationText("\nYour answer: False\nCorrect answer: ");
            if (answerTrue) {
                this.increaseQuestions(false);
                this.setPromptColor(Color.RED);
                this.setPromptLabel("Incorrect");
                this.addInformationText("True\n");
            } else {
                this.increaseQuestions(true);
                this.setPromptColor(Color.GREEN);
                this.setPromptLabel("Correct");
                this.addInformationText("False\n");
            }
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Clear Text")) {
            this.setAnswerButtons(false);
            this.informationText.setText("No Questions");
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.setPromptLabel("Click 'Answer a Question' to get a new conditional independence question.");
            } else {
                this.setPromptLabel("Click 'Ask a Question' to start asking the applet a new conditional independence question.");
            }
        }
    }

    public void increaseQuestions(boolean isAnswerCorrect) {
        ++this.quizNumQuestionsAsked;
        if (isAnswerCorrect) {
            ++this.quizNumQuestionsRight;
        }
        this.quizScoreText.setText(String.valueOf(this.quizNumQuestionsRight) + "/" + this.quizNumQuestionsAsked);
    }

    public void addInformationText(String text) {
        this.informationText.append(text);
        this.informationText.setCaretPosition(this.informationText.getText().length());
    }

    public void setInformationText(String text) {
        this.informationText.setText(text);
        this.informationText.setCaretPosition(this.informationText.getText().length());
    }

    public String getInformationText() {
        return this.informationText.getText();
    }

    public void setAnswerButtons(boolean isEnabled) {
        this.getAnswerButton.setEnabled(isEnabled);
        this.quizTrueButton.setEnabled(isEnabled);
        this.quizFalseButton.setEnabled(isEnabled);
    }

    public void stateChanged(ChangeEvent e) {
        String tempText = this.informationText.getText();
        this.informationText.setText(this.otherTabText);
        this.otherTabText = tempText;
        this.setPromptColor(Color.blue);
        this.setAnswerButtons(false);
        ((QuizCanvas)this.canvas).resetNodes();
        if (this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()).equals("Quiz Yourself")) {
            this.quizAnswerPanel.setVisible(true);
            this.askQuestionButton.setText("Answer a Question");
            this.askQuestionButton.setActionCommand(this.askQuestionButton.getText());
            this.tabbedPane.setComponentAt(0, this.emptyPanel1);
            this.tabbedPane.setComponentAt(1, this.emptyPanel2);
            this.tabbedPane.setComponentAt(0, this.mainPanel);
            this.tabbedPane.setSelectedIndex(0);
            this.setPromptLabel("Click 'Answer a Question' to get a new conditional independence question.");
        } else {
            this.quizAnswerPanel.setVisible(false);
            this.askQuestionButton.setText("    Ask a Question    ");
            this.askQuestionButton.setActionCommand(this.askQuestionButton.getText());
            this.tabbedPane.setComponentAt(0, this.emptyPanel1);
            this.tabbedPane.setComponentAt(1, this.emptyPanel2);
            this.tabbedPane.setComponentAt(1, this.mainPanel);
            this.tabbedPane.setSelectedIndex(1);
            this.setPromptLabel("Click 'Ask a Question' to start asking the applet a new conditional independence question.");
        }
    }
}

