/*
 * Decompiled with CFR 0.152.
 */
package CIspace.bayes.verboseQuery;

import CIspace.bayes.BayesGraph;
import CIspace.bayes.BayesWindow;
import CIspace.bayes.DisplayWindow;
import CIspace.bayes.InlineBayesApplet;
import CIspace.bayes.elements.BayesNode;
import CIspace.bayes.verboseQuery.QueryCanvas;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.GraphWindow;
import CIspace.graphToolKit.LabelCanvas;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorDecision;
import CIspace.ve.Inference;
import CIspace.ve.QueryStepByStep;
import CIspace.ve.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryWindow
extends DisplayWindow
implements MouseListener,
ComponentListener {
    private JList currentFactorList;
    private JList eliminatedFactorList;
    private JList decisionFunctionList;
    private JComboBox elimOrderComboBox;
    private HashMap<String, Integer> factorNameIDHashMap;
    private int factorNum;
    private JPanel prunePanel;
    private JButton pruneButton1;
    private JButton pruneButton2;
    private JButton projectButton;
    private JButton stepButton;
    private JButton autoElimButton;
    private JButton multiplyButton;
    private JButton normalizeButton;
    private JButton orderButton;
    private JButton resetButton;
    private JButton closeButton;
    private boolean isInvestigatingPeCalculation;
    private String savePromptString;
    protected Container parentWindow;

    public QueryWindow(Container parent, DecisionNetwork network, BayesNode queryNode, ArrayList<BayesNode> observedNodes, boolean isOptimizing) {
        this.initializeLayout(parent, network, queryNode, isOptimizing);
        BayesGraph graph = parent instanceof BayesWindow ? (BayesGraph)((BayesWindow)parent).returnCanvas().graph : (BayesGraph)((InlineBayesApplet)parent).getCanvas().graph;
        this.initializeDisplay(graph, queryNode, observedNodes, null);
        this.isInvestigatingPeCalculation = false;
    }

    public QueryWindow(Container parent, DecisionNetwork network, ArrayList<BayesNode> observedNodes, QueryStepByStep queryStep, boolean noIrrelevantVariables) {
        this.isInvestigatingPeCalculation = true;
        this.initializeLayout(parent, network, null, false);
        this.setIrrelevantButtons(false);
        BayesGraph graph = parent instanceof BayesWindow ? (BayesGraph)((BayesWindow)parent).returnCanvas().graph : (BayesGraph)((InlineBayesApplet)parent).getCanvas().graph;
        this.initializeDisplay(graph, null, observedNodes, queryStep);
        ((QueryCanvas)this.canvas).resetQuery();
        this.removeIrrelevantVariables(queryStep.getPrunedVariables());
        if (noIrrelevantVariables) {
            this.noIrrelevantMessage();
        }
        this.projectObservations();
        this.setProjectButtonText("Observations Projected");
        ((QueryCanvas)this.canvas).updateColours();
        if (parent instanceof InlineBayesApplet) {
            ((InlineBayesApplet)parent).convertToPeCalculation(this);
        }
    }

    private void initializeLayout(Container parent, DecisionNetwork network, BayesNode queryNode, boolean isOptimizing) {
        if (isOptimizing) {
            this.setTitle("Optimizing Decisions");
        } else if (queryNode == null) {
            this.setTitle("Querying Probability of Evidence");
        } else {
            this.setTitle("Querying Node " + queryNode.getLabel());
        }
        this.parentWindow = parent;
        this.canvas = new QueryCanvas(this, network, isOptimizing, false);
        this.factorNum = 0;
        this.factorNameIDHashMap = new HashMap();
        if (parent instanceof BayesWindow) {
            this.setAntiAliasing(((GraphWindow)parent).isAntiAliasingEnabled());
        } else {
            this.setAntiAliasing(true);
        }
        this.setFont(parent.getFont());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                QueryWindow.this.setVisible(false);
                QueryWindow.this.canvas.disposeWindows();
                QueryWindow.this.dispose();
            }
        });
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.getContentPane().setLayout(new BorderLayout());
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        JSplitPane centerMain = new JSplitPane(1);
        centerMain.setLeftComponent(this.constructLeftPanel());
        centerMain.setRightComponent(this.constructRightPanel());
        centerMain.setResizeWeight(0.0);
        centerMain.setDividerLocation(212);
        centerMain.addComponentListener(this);
        centerMain.getRightComponent().addComponentListener(this);
        JPanel main = new JPanel();
        main.setBackground(GraphConsts.bg.darker());
        main.setLayout(new BorderLayout());
        main.add((Component)centerMain, "Center");
        main.add((Component)this.constructBottomPanel(), "South");
        this.getContentPane().add("Center", main);
    }

    private void initializeDisplay(BayesGraph graph, BayesNode queryNode, ArrayList<BayesNode> observedNodes, QueryStepByStep queryStep) {
        this.canvas.graph.setLineWidth(graph.getLineWidth());
        this.canvas.changeLineWidth();
        this.canvas.changeFont(this.getFont().getSize());
        this.savePromptString = "";
        this.initObservedNodes(observedNodes, queryStep != null);
        if (queryNode != null) {
            ((QueryCanvas)this.canvas).setQueryNode(((BayesGraph)this.canvas.graph).getNode(queryNode.getLabel()));
        } else if (queryStep != null) {
            ((QueryCanvas)this.canvas).setQuery(queryStep);
        } else {
            ((QueryCanvas)this.canvas).setQueryNode(null);
        }
        ((QueryCanvas)this.canvas).updateColours();
        this.updatePromptLabel();
        if (this.parentWindow instanceof BayesWindow) {
            this.setSize(825, 650);
            this.centerWindow();
            this.setVisible(true);
        }
        this.canvas.autoscale();
        if (queryNode != null && queryNode.isObserved()) {
            ((QueryCanvas)this.canvas).finishQuery(false);
            return;
        }
        this.populateFactors();
    }

    private JPanel constructLeftPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(this.gbl);
        Font plain = new Font("SansSerif", 0, this.getFont().getSize());
        JPanel leftTop = new JPanel();
        leftTop.setLayout(new BoxLayout(leftTop, 1));
        leftTop.setBackground(GraphConsts.bg);
        JLabel label = new JLabel("Click on a factor to inspect it");
        label.setForeground(Color.red);
        leftTop.add(label);
        JPanel lists = new JPanel();
        lists.setLayout(new BoxLayout(lists, 1));
        label = new JLabel("Current Factors:");
        DefaultListModel defaultModel = new DefaultListModel();
        this.currentFactorList = new JList(defaultModel);
        this.currentFactorList.addMouseListener(this);
        this.currentFactorList.setFont(plain);
        this.currentFactorList.setSelectionMode(0);
        this.currentFactorList.setCellRenderer(new FactorNameRenderer());
        JScrollPane scrollPane = new JScrollPane(this.currentFactorList, 20, 30);
        lists.add(label);
        lists.add(scrollPane);
        label = new JLabel("Eliminated Factors:");
        defaultModel = new DefaultListModel();
        this.eliminatedFactorList = new JList(defaultModel);
        this.eliminatedFactorList.addMouseListener(this);
        this.eliminatedFactorList.setFont(plain);
        this.eliminatedFactorList.setSelectionMode(0);
        this.eliminatedFactorList.setCellRenderer(new FactorNameRenderer());
        scrollPane = new JScrollPane(this.eliminatedFactorList, 20, 30);
        lists.add(label);
        lists.add(scrollPane);
        label = new JLabel("Decision Functions:");
        defaultModel = new DefaultListModel();
        this.decisionFunctionList = new JList(defaultModel);
        this.decisionFunctionList.addMouseListener(this);
        this.decisionFunctionList.setFont(plain);
        this.decisionFunctionList.setSelectionMode(0);
        this.decisionFunctionList.setCellRenderer(new FactorNameRenderer());
        scrollPane = new JScrollPane(this.decisionFunctionList, 20, 30);
        if (((QueryCanvas)this.canvas).isOptimizing()) {
            lists.add(label);
            lists.add(scrollPane);
        }
        leftTop.add(lists);
        this.pruneButton1 = new JButton("Yes");
        this.pruneButton1.addActionListener(this);
        this.pruneButton1.setActionCommand(this.pruneButton1.getText());
        this.pruneButton2 = new JButton("No");
        this.pruneButton2.addActionListener(this);
        this.pruneButton2.setActionCommand(this.pruneButton2.getText());
        this.prunePanel = new JPanel(new FlowLayout());
        this.prunePanel.add(this.pruneButton1);
        this.prunePanel.add(this.pruneButton2);
        JPanel mainPrunePanel = new JPanel(new BorderLayout());
        mainPrunePanel.add((Component)new JLabel("1) Prune Irrelevant Variables:"), "West");
        mainPrunePanel.add((Component)this.prunePanel, "South");
        this.projectButton = new JButton("Project Observations");
        this.projectButton.addActionListener(this);
        this.projectButton.setActionCommand(this.projectButton.getText());
        this.projectButton.setEnabled(false);
        JPanel projectPanel = new JPanel(new BorderLayout());
        projectPanel.add((Component)new JLabel("2) Project Observations:"), "West");
        projectPanel.add((Component)this.projectButton, "South");
        this.elimOrderComboBox = new JComboBox();
        this.elimOrderComboBox.addItem("Max-Cardinality");
        this.elimOrderComboBox.addItem("Min-Degree");
        this.elimOrderComboBox.addItem("Min-Factor");
        this.elimOrderComboBox.addItem("Min-Fill");
        this.elimOrderComboBox.addItem("Random");
        this.elimOrderComboBox.addItem("Sequential");
        this.elimOrderComboBox.setSelectedIndex(3);
        this.elimOrderComboBox.addActionListener(this);
        this.elimOrderComboBox.setEnabled(false);
        JPanel heuristicPanel = new JPanel(new FlowLayout());
        heuristicPanel.add(new JLabel(" Heuristic: "));
        heuristicPanel.add(this.elimOrderComboBox);
        JPanel elimPanel1 = new JPanel(new BorderLayout());
        elimPanel1.add((Component)new JLabel("3) Elimate Variables:"), "North");
        elimPanel1.add((Component)heuristicPanel, "South");
        this.stepButton = new JButton("Eliminate Next");
        this.stepButton.addActionListener(this);
        this.stepButton.setActionCommand(this.stepButton.getText());
        this.stepButton.setEnabled(false);
        this.autoElimButton = new JButton("Auto-Eliminate");
        this.autoElimButton.addActionListener(this);
        this.autoElimButton.setActionCommand(this.autoElimButton.getText());
        this.autoElimButton.setEnabled(false);
        JPanel elimPanel2 = new JPanel(new BorderLayout());
        elimPanel2.add((Component)this.stepButton, "North");
        elimPanel2.add((Component)this.autoElimButton, "South");
        this.multiplyButton = new JButton("Multiply Final Factors");
        this.multiplyButton.addActionListener(this);
        this.multiplyButton.setActionCommand(this.multiplyButton.getText());
        this.multiplyButton.setEnabled(false);
        JPanel multiplyPanel = new JPanel(new BorderLayout());
        multiplyPanel.add((Component)new JLabel("4) Multiply:"), "West");
        multiplyPanel.add((Component)this.multiplyButton, "South");
        this.normalizeButton = new JButton("Normalize Final Factor");
        this.normalizeButton.addActionListener(this);
        this.normalizeButton.setActionCommand(this.normalizeButton.getText());
        this.normalizeButton.setEnabled(false);
        JPanel normalizePanel = new JPanel(new BorderLayout());
        normalizePanel.add((Component)new JLabel("5) Normalize:"), "West");
        normalizePanel.add((Component)this.normalizeButton, "South");
        JPanel leftBottom = new JPanel();
        leftBottom.setBackground(GraphConsts.bg);
        leftBottom.setLayout(new GridLayout(6, 1));
        leftBottom.add(mainPrunePanel);
        leftBottom.add(projectPanel);
        leftBottom.add(elimPanel1);
        leftBottom.add(elimPanel2);
        leftBottom.add(multiplyPanel);
        leftBottom.add(normalizePanel);
        this.addComponent(leftTop, leftPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.addComponent(leftBottom, leftPanel, 3, 0, 1, 1, 1.0, 0.0);
        this.addComponent(new JLabel(" "), leftPanel, 4, 0, 1, 1, 0.0, 0.0);
        return leftPanel;
    }

    private JPanel constructRightPanel() {
        JPanel rightPanel = new JPanel();
        rightPanel.setBackground(Color.white);
        rightPanel.setLayout(this.gbl);
        this.promptCanvas = new LabelCanvas();
        this.promptCanvas.setFontSize(this.getFont().getSize());
        this.canvasScrollPane = new JScrollPane(this.canvas, 20, 30);
        this.addComponent(this.promptCanvas, rightPanel, 0, 0, 1, 1, 1.0, 0.135);
        this.addComponent(this.canvasScrollPane, rightPanel, 1, 0, 1, 1, 1.0, 1.0);
        return rightPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBackground(GraphConsts.bg);
        bottomPanel.setLayout(this.gbl);
        this.closeButton = new JButton("Close");
        if (this.parentWindow instanceof InlineBayesApplet) {
            this.closeButton.setText("Back");
        }
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand(this.closeButton.getText());
        this.addComponent(this.closeButton, bottomPanel, 0, 0, 2, 1, 0.0, 0.0);
        this.resetButton = new JButton("Reset Query");
        this.resetButton.addActionListener(this);
        this.resetButton.setActionCommand(this.resetButton.getText());
        this.addComponent(this.resetButton, bottomPanel, 0, 2, 2, 1, 0.0, 0.0);
        this.orderButton = new JButton("Elimination Order");
        this.orderButton.addActionListener(this);
        this.orderButton.setActionCommand(this.orderButton.getText());
        this.orderButton.setEnabled(false);
        this.addComponent(this.orderButton, bottomPanel, 0, 4, 2, 1, 0.0, 0.0);
        return bottomPanel;
    }

    protected void resetQuery() {
        this.stopAutoEliminate();
        if (((QueryCanvas)this.canvas).getQueryNode() != null && ((QueryCanvas)this.canvas).getQueryNode().isObserved()) {
            return;
        }
        this.pruneButton1.setEnabled(true);
        this.pruneButton2.setEnabled(true);
        this.projectButton.setEnabled(false);
        this.projectButton.setText("Project Observations");
        this.setEliminationItems(false);
        this.stepButton.setText("Eliminate Next");
        this.multiplyButton.setEnabled(false);
        this.multiplyButton.setText("Multiply Final Factors");
        this.normalizeButton.setEnabled(false);
        this.normalizeButton.setText("Normalize Final Factor");
        this.setOrderButton(false);
        this.factorNameIDHashMap.clear();
        this.factorNum = 0;
        ((QueryCanvas)this.canvas).resetQuery();
        ((DefaultListModel)this.currentFactorList.getModel()).clear();
        ((DefaultListModel)this.eliminatedFactorList.getModel()).clear();
        ((DefaultListModel)this.decisionFunctionList.getModel()).clear();
        if (this.isInvestigatingPeCalculation) {
            this.removeIrrelevantVariables(((QueryCanvas)this.canvas).getQuery().getPrunedVariables());
            ((QueryCanvas)this.canvas).updateColours();
        }
        this.populateFactors();
        this.updatePromptLabel();
    }

    public void addDecisionFunction(FactorDecision decisionFunction) {
        DefaultListModel model = (DefaultListModel)this.decisionFunctionList.getModel();
        String factorName = "r";
        factorName = String.valueOf(factorName) + decisionFunction.getInterpretation(false);
        this.factorNameIDHashMap.put(factorName.substring(1), new Integer(decisionFunction.getId()));
        model.addElement(factorName);
    }

    public ArrayList<Factor> getDecisionFunctions() {
        ListModel model = this.decisionFunctionList.getModel();
        ArrayList<Factor> factors = new ArrayList<Factor>();
        int count = 0;
        while (count < model.getSize()) {
            factors.add(((QueryCanvas)this.canvas).getFactor(this.factorNameIDHashMap.get(((String)model.getElementAt(count)).substring(1))));
            ++count;
        }
        return factors;
    }

    protected void populateFactors() {
        DefaultListModel model = (DefaultListModel)this.currentFactorList.getModel();
        boolean isInitialRun = false;
        if (model.size() == 0) {
            isInitialRun = true;
        }
        model.clear();
        if (((QueryCanvas)this.canvas).getQueryNode() != null && ((QueryCanvas)this.canvas).getQueryNode().isObserved()) {
            model.addElement("bAnswer: f0(" + ((QueryCanvas)this.canvas).getQueryNode().getLabel() + ")");
            return;
        }
        for (Factor factor : ((QueryCanvas)this.canvas).getCurrentFactors()) {
            StringBuffer factorName;
            if (!this.factorNameIDHashMap.containsKey(this.getFactorListName(factor))) {
                factorName = new StringBuffer("f").append(this.factorNum++).append(factor.getName(false));
                this.factorNameIDHashMap.put(factorName.toString(), new Integer(factor.getId()));
                if (isInitialRun) {
                    factorName.insert(0, "b");
                } else {
                    factorName.insert(0, "r");
                }
                ((QueryCanvas)this.canvas).addTriangulationArcs(factor);
            } else {
                factorName = new StringBuffer("b").append(this.getFactorListName(factor));
            }
            model.addElement(factorName.toString());
        }
        Iterator<Factor> itr = ((QueryCanvas)this.canvas).getEliminatedFactors().iterator();
        model = (DefaultListModel)this.eliminatedFactorList.getModel();
        int numOldElim = model.size();
        if (model.size() > 0 && model.get(0).equals("_ ")) {
            --numOldElim;
        }
        model.clear();
        int i = 0;
        while (itr.hasNext()) {
            Factor factor;
            factor = itr.next();
            if (++i > numOldElim) {
                model.addElement("r" + this.getFactorListName(factor));
                continue;
            }
            model.addElement("b" + this.getFactorListName(factor));
        }
        if (model.size() == 0) {
            model.addElement("_ ");
            this.eliminatedFactorList.setEnabled(false);
        } else {
            this.eliminatedFactorList.setEnabled(true);
        }
        model = (DefaultListModel)this.decisionFunctionList.getModel();
        int count = 0;
        while (count < model.getSize()) {
            String newName = (String)model.remove(0);
            if (newName.charAt(0) == 'r') {
                newName = "b" + newName.substring(1);
            }
            model.addElement(newName);
            ++count;
        }
    }

    protected ArrayList<Factor> moveRemainingCurrent() {
        ArrayList<Factor> movedFactors = new ArrayList<Factor>();
        Iterator<Factor> itr = ((QueryCanvas)this.canvas).getEliminatedFactors().iterator();
        DefaultListModel elimModel = (DefaultListModel)this.eliminatedFactorList.getModel();
        elimModel.clear();
        while (itr.hasNext()) {
            elimModel.addElement("b" + this.getFactorListName(itr.next()));
        }
        DefaultListModel curModel = (DefaultListModel)this.currentFactorList.getModel();
        while (curModel.size() > 0) {
            String factorListName = curModel.firstElement().toString().substring(1);
            elimModel.addElement("r" + factorListName);
            movedFactors.add(((QueryCanvas)this.canvas).getFactor(this.factorNameIDHashMap.get(factorListName)));
            curModel.remove(0);
        }
        return movedFactors;
    }

    protected void updatePromptLabel() {
        if (!this.savePromptString.equals("")) {
            this.setPromptLabel(this.savePromptString);
            this.savePromptString = "";
        } else if (this.areIrrelevantButtonsEnabled()) {
            this.setPromptLabel("Start by choosing whether or not to prune all irrelevant variables.");
        } else if (this.isProjectButtonEnabled()) {
            this.setPromptLabel("Project observations by clicking on an observed node or by pressing \"Project Observations\".");
        } else if (this.areElimButtonsEnabled()) {
            this.setPromptLabel("Eliminate a variable by clicking on a node or by pressing \"Eliminate Next\".\nPress \"Auto-Eliminate\" to automatically eliminate all variables based on the chosen heuristic.");
        } else if (this.isMultiplyButtonEnabled()) {
            this.setPromptLabel("Multiply final factors by pressing \"Multiply Final Factors\".");
        } else if (this.isNormalizeButtonEnabled()) {
            this.setPromptLabel("Normalize the final factor by pressing \"Normalize Final Factor\".");
        } else if (((QueryCanvas)this.canvas).isFinished()) {
            this.setPromptLabel("Press \"Reset Query\" to restart the query.");
        } else {
            this.setPromptLabel("");
        }
    }

    protected void setElimPromptLabel(String str) {
        this.promptCanvas.setText("Eliminate a variable by clicking on a node or by pressing \"Eliminate Next\".\n" + str);
    }

    public Factor getNewestFactor() {
        ListModel model = this.currentFactorList.getModel();
        return ((QueryCanvas)this.canvas).getFactor(this.factorNameIDHashMap.get(model.getElementAt(model.getSize() - 1).toString().substring(1)));
    }

    public String getNewestFactorName() {
        ListModel model = this.currentFactorList.getModel();
        return model.getElementAt(model.getSize() - 1).toString().substring(1);
    }

    public String getNewestDecisionFunctionName() {
        ListModel model = this.decisionFunctionList.getModel();
        return model.getElementAt(model.getSize() - 1).toString().substring(1);
    }

    public void addAnswerFactor(Factor factor, boolean increaseFactorNum) {
        DefaultListModel model = (DefaultListModel)this.currentFactorList.getModel();
        String factorName = "f";
        factorName = increaseFactorNum ? String.valueOf(factorName) + this.factorNum++ + factor.getName(false) : String.valueOf(factorName) + (this.factorNum - 1) + factor.getName(false);
        this.factorNameIDHashMap.put(factorName, new Integer(factor.getId()));
        model.addElement("a" + factorName);
    }

    public void clearCurrentFactors() {
        ((DefaultListModel)this.currentFactorList.getModel()).clear();
    }

    public HashMap<String, Integer> getFactorNameIDHashMap() {
        return this.factorNameIDHashMap;
    }

    public String getFactorListName(Factor factor) {
        for (Map.Entry<String, Integer> entry : this.factorNameIDHashMap.entrySet()) {
            if (entry.getValue().intValue() != factor.getId()) continue;
            return entry.getKey();
        }
        return "";
    }

    public QueryCanvas getCanvas() {
        return (QueryCanvas)this.canvas;
    }

    protected Inference.Heuristics getEliminationHeuristic() {
        String selected = (String)this.elimOrderComboBox.getSelectedItem();
        if (selected.equals("Max-Cardinality")) {
            return Inference.Heuristics.MAX_CARDINALITY;
        }
        if (selected.equals("Min-Degree")) {
            return Inference.Heuristics.MIN_DEGREE;
        }
        if (selected.equals("Min-Factor")) {
            return Inference.Heuristics.MIN_FACTOR;
        }
        if (selected.equals("Min-Fill")) {
            return Inference.Heuristics.MIN_FILL;
        }
        if (selected.equals("Random")) {
            return Inference.Heuristics.RANDOM;
        }
        if (selected.equals("Sequential")) {
            return Inference.Heuristics.SEQUENTIAL;
        }
        return null;
    }

    public ArrayList<Factor> getRedElimFactors() {
        ArrayList<Factor> redElimFactors = new ArrayList<Factor>();
        DefaultListModel model = (DefaultListModel)this.eliminatedFactorList.getModel();
        int i = 0;
        while (i < model.size()) {
            if (model.getElementAt(i).toString().startsWith("r")) {
                redElimFactors.add(((QueryCanvas)this.canvas).getFactor(this.factorNameIDHashMap.get(model.getElementAt(i).toString().substring(1))));
            }
            ++i;
        }
        return redElimFactors;
    }

    public void removeBackButton() {
        this.closeButton.setVisible(false);
    }

    protected boolean areElimButtonsEnabled() {
        return this.stepButton.isEnabled();
    }

    protected boolean isInvestigatingPeCalculation() {
        return this.isInvestigatingPeCalculation;
    }

    protected void step() {
        ((QueryCanvas)this.canvas).step(true);
    }

    protected void startAutoEliminate() {
        ((QueryCanvas)this.canvas).startAutoEliminate();
        this.setEliminationItems(false);
    }

    protected void stopAutoEliminate() {
        ((QueryCanvas)this.canvas).stopAutoEliminate();
        this.setAutoElimText(false);
        this.setEliminationItems(true);
    }

    protected void removeIrrelevantVariables(Iterator<Variable> prunedItr) {
        ((QueryCanvas)this.canvas).removeIrrelevantVars(prunedItr);
        this.populateFactors();
        if (((QueryCanvas)this.canvas).isFinished()) {
            this.projectButton.setText("No Observations Projected");
            this.stepButton.setText("No Variables Eliminated");
            this.multiplyButton.setText("No Multiplication Needed");
            ((QueryCanvas)this.canvas).getQuery().initializeHeuristics();
            this.setIrrelevantButtons(false);
            ((QueryCanvas)this.canvas).updateColours();
            if (((QueryCanvas)this.canvas).getQuery().normalizationNeeded()) {
                this.normalizeButton.setEnabled(true);
            } else {
                this.normalizeButton.setText("No Normalization Needed");
                ((QueryCanvas)this.canvas).finishQuery(false);
            }
        } else if (((QueryCanvas)this.canvas).isMoreToProject()) {
            this.setIrrelevantButtons(false);
            ((QueryCanvas)this.canvas).updateColours();
            this.projectButton.setEnabled(true);
        } else {
            this.projectButton.setText("No Observations to Project");
            ((QueryCanvas)this.canvas).getQuery().initializeHeuristics();
            this.setIrrelevantButtons(false);
            ((QueryCanvas)this.canvas).updateColours();
            this.updateElimButtonText();
            this.setEliminationItems(true);
        }
        this.updatePromptLabel();
    }

    public void dontPrune() {
        this.setIrrelevantButtons(false);
        if (((QueryCanvas)this.canvas).isMoreToProject()) {
            this.projectButton.setEnabled(true);
        } else {
            this.projectButton.setText("No Observations to Project");
            if (((QueryCanvas)this.canvas).getQuery() != null) {
                ((QueryCanvas)this.canvas).getQuery().initializeHeuristics();
            }
            this.updateElimButtonText();
            this.setEliminationItems(true);
        }
        this.updatePromptLabel();
        ((QueryCanvas)this.canvas).updateColours();
    }

    public void noIrrelevantMessage() {
        this.prunePanel.removeAll();
        JLabel label = new JLabel("No Irrelevant Variables");
        label.setForeground(Color.gray);
        this.prunePanel.add(label);
    }

    protected void projectObservations() {
        ((QueryCanvas)this.canvas).projectAllObservations();
        this.updatePromptLabel();
    }

    protected void initObservedNodes(ArrayList<BayesNode> observedNodes, boolean isDrawingExtra) {
        int i = 0;
        while (i < observedNodes.size()) {
            BayesNode curNode = ((BayesGraph)this.canvas.graph).getNode(observedNodes.get(i).getLabel());
            curNode.setObservation(observedNodes.get(i).getObservation());
            curNode.setDrawingExtra(isDrawingExtra);
            curNode.setIsEliminated(isDrawingExtra);
            ++i;
        }
    }

    public void investigatePeCalculation() {
        this.canvas.disposeWindows();
        new QueryWindow(this.parentWindow, ((BayesGraph)this.canvas.graph).getDecisionNetwork(), ((BayesGraph)this.canvas.graph).getObservedNodes(), ((QueryCanvas)this.canvas).getEvidenceQuery(), this.prunePanel.getComponents().length == 1).toFront();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        String arg = e.getActionCommand();
        if (arg.equals("Eliminate")) {
            if (this.canvas.getSubmode() != 4573) {
                this.canvas.setSubmode(4573);
                this.updatePromptLabel();
            }
        } else if (arg.equals("Select")) {
            if (this.canvas.getSubmode() != 3332) {
                this.canvas.setSubmode(3332);
                this.updatePromptLabel();
            }
        } else if (arg.equals("Close")) {
            this.stopAutoEliminate();
            this.setVisible(false);
            this.dispose();
        } else if (arg.equals("Back")) {
            if (this.isInvestigatingPeCalculation) {
                ((InlineBayesApplet)this.parentWindow).backToQuery();
            } else {
                ((InlineBayesApplet)this.parentWindow).backToSolveMode();
            }
        } else if (arg.equals("Auto-Eliminate")) {
            this.startAutoEliminate();
        } else if (arg.equals("Stop Auto-Elimination")) {
            this.stopAutoEliminate();
        } else if (arg.startsWith("Eliminate Next")) {
            this.step();
        } else if (arg.equals("Yes")) {
            this.removeIrrelevantVariables(null);
        } else if (arg.equals("No")) {
            this.dontPrune();
        } else if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Multiply Final Factors")) {
            ((QueryCanvas)this.canvas).multiplyFinalFactors();
        } else if (arg.equals("Normalize Final Factor")) {
            ((QueryCanvas)this.canvas).normalize();
        } else if (arg.equals("Elimination Order")) {
            ((QueryCanvas)this.canvas).showOrder();
        } else if (arg.equals("Reset Query")) {
            this.resetQuery();
        } else if (arg.equals("Project Observations")) {
            this.projectObservations();
        } else if (e.getSource() instanceof JComboBox) {
            this.updateElimButtonText();
        }
    }

    protected void setEliminationItems(boolean isEnabled) {
        this.elimOrderComboBox.setEnabled(isEnabled);
        this.stepButton.setEnabled(isEnabled);
        this.autoElimButton.setEnabled(isEnabled);
    }

    protected void setAutoElimText(boolean isElimStarted) {
        if (isElimStarted) {
            this.autoElimButton.setText("Stop Auto-Elimination");
            this.autoElimButton.setActionCommand(this.autoElimButton.getText());
        } else {
            this.autoElimButton.setText("Auto-Eliminate");
            this.autoElimButton.setActionCommand(this.autoElimButton.getText());
        }
    }

    protected void setStepButtonText(String text) {
        this.stepButton.setText(text);
    }

    protected void setResetButton(boolean isEnabled) {
        this.resetButton.setEnabled(isEnabled);
    }

    protected void setOrderButton(boolean isEnabled) {
        this.orderButton.setEnabled(isEnabled);
    }

    protected boolean isOrderButtonEnabled() {
        return this.orderButton.isEnabled();
    }

    protected void setProjectButton(boolean isEnabled) {
        this.projectButton.setEnabled(isEnabled);
    }

    protected void setProjectButtonText(String text) {
        this.projectButton.setText(text);
    }

    protected boolean isProjectButtonEnabled() {
        return this.projectButton.isEnabled();
    }

    protected void setMultiplyButton(boolean isEnabled) {
        this.multiplyButton.setEnabled(isEnabled);
    }

    protected void setMultiplyButtonText(String text) {
        this.multiplyButton.setText(text);
    }

    protected boolean isMultiplyButtonEnabled() {
        return this.multiplyButton.isEnabled();
    }

    protected void setNormalizeButton(boolean isEnabled) {
        this.normalizeButton.setEnabled(isEnabled);
    }

    protected void setNormalizeButtonText(String text) {
        this.normalizeButton.setText(text);
    }

    protected boolean isNormalizeButtonEnabled() {
        return this.normalizeButton.isEnabled();
    }

    protected void updateElimButtonText() {
        try {
            if (((QueryCanvas)this.canvas).isMoreToEliminate()) {
                this.stepButton.setText("Eliminate Next (" + ((QueryCanvas)this.canvas).getNextName() + ")");
            } else {
                this.stepButton.setText("Variables Eliminated");
            }
        }
        catch (Exception e) {
            this.stepButton.setText("Eliminate Next");
            System.err.println(e.getMessage());
        }
        this.stepButton.setActionCommand(this.stepButton.getText());
    }

    protected void setIrrelevantButtons(boolean isEnabled) {
        this.pruneButton1.setEnabled(isEnabled);
        this.pruneButton2.setEnabled(isEnabled);
    }

    protected boolean areIrrelevantButtonsEnabled() {
        return this.pruneButton1.isEnabled() && this.pruneButton2.isEnabled();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String factorName = "";
        if (e.getSource() == this.currentFactorList) {
            if (this.currentFactorList.getSelectedValue() == null) {
                return;
            }
            factorName = this.currentFactorList.getSelectedValue().toString();
            this.eliminatedFactorList.clearSelection();
        } else if (e.getSource() == this.eliminatedFactorList) {
            factorName = (String)this.eliminatedFactorList.getSelectedValue();
            if (factorName == null) {
                return;
            }
            this.currentFactorList.clearSelection();
        } else if (e.getSource() == this.decisionFunctionList) {
            factorName = (String)this.decisionFunctionList.getSelectedValue();
            if (factorName == null) {
                return;
            }
            this.decisionFunctionList.clearSelection();
        } else {
            return;
        }
        factorName = factorName.substring(1);
        Factor factor = ((QueryCanvas)this.canvas).getFactor(this.factorNameIDHashMap.get(factorName));
        if (factor == null) {
            ((QueryCanvas)this.canvas).finishQuery(false);
            return;
        }
        ((QueryCanvas)this.canvas).openInspectFactorDialog(this, (BayesGraph)this.canvas.graph, factor, factorName);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.canvas.autoscale();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected class FactorNameRenderer
    extends JLabel
    implements ListCellRenderer {
        public FactorNameRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String val = (String)value;
            if (val.startsWith("r")) {
                this.setForeground(Color.RED);
                this.setText(val.substring(1));
            } else if (val.startsWith("a")) {
                this.setForeground(Color.RED);
                this.setText("Answer: " + val.substring(1));
            } else {
                this.setText(val.substring(1));
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

