/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit.elements;

import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class EdgeLabel
extends Entity {
    public Point offsetPoint;
    public Edge parent;
    private FontMetrics fm;

    public EdgeLabel(Graph graph, Edge parent) {
        super(graph);
        this.parent = parent;
        this.offsetPoint = new Point(0.5f, 0.0f);
        this.type = 7772;
    }

    public void reset() {
        this.offsetPoint.move(0.5f, 0.0f);
    }

    public void draw(Graphics g, boolean moving) {
        this.fm = this.graph.canvas.getFontMetrics();
        Point center = new Point(this.parent.getB()[0]);
        center.translate(this.changeVecBasis());
        this.drawLabel(g, moving, center, false);
    }

    public void drawForPrinting(Graphics g, boolean moving) {
        this.fm = this.graph.canvas.getFontMetrics();
        Point center = new Point(this.parent.getP()[0]);
        center.translate(this.changeVecBasisForPrinting());
        this.drawLabel(g, moving, center, false);
    }

    public void drawStructure(Graphics g, boolean moving) {
    }

    public void drawLabel(Graphics g, boolean moving, Point center, boolean drawAnyways) {
        this.label[0] = this.parent.label[0];
        if (this.label[0].equals("")) {
            return;
        }
        if (this.parent.start.equals(this.parent.end) && !drawAnyways) {
            this.drawLabel2(g, moving);
            return;
        }
        int w = this.fm.stringWidth(this.label[0]);
        int h = this.fm.getHeight();
        int l = this.fm.getLeading();
        int a = this.fm.getAscent();
        if (this.isBold) {
            g.setColor(Color.black);
        } else {
            g.setColor(Color.white);
        }
        g.fillRect((int)(center.x - (float)(w / 2) - 2.0f), (int)(center.y - (float)(h / 2) - 2.0f), w + 4, h + 4);
        if (this.isBold) {
            g.setColor(Color.white);
        } else {
            g.setColor(Color.black);
        }
        g.drawString(this.label[0], (int)center.x - w / 2, (int)center.y - h / 2 + l + a);
    }

    private void drawLabel2(Graphics g, boolean moving) {
        float dy = this.parent.start.height + GraphConsts.selfDy;
        Point n = new Point(this.parent.start.pos.x, this.parent.start.pos.y - dy);
        n.translate(this.changeVecBasis());
        this.drawLabel(g, moving, n, true);
    }

    public Point changeVecBasis() {
        if (this.parent.start.equals(this.parent.end)) {
            return new Point((float)((double)this.offsetPoint.x - 0.5), this.offsetPoint.y);
        }
        float dx = this.parent.getDx();
        float dy = this.parent.getDy();
        float vx = dx * this.offsetPoint.x - dy * this.offsetPoint.y / this.parent.getLength();
        float vy = dy * this.offsetPoint.x + dx * this.offsetPoint.y / this.parent.getLength();
        return new Point(vx, vy);
    }

    public Point changeVecBasisForPrinting() {
        if (this.parent.start.equals(this.parent.end)) {
            return new Point((float)((double)this.offsetPoint.x - 0.5), this.offsetPoint.y);
        }
        float dx = this.parent.getPx();
        float dy = this.parent.getPy();
        float vx = dx * this.offsetPoint.x - dy * this.offsetPoint.y / this.parent.getLength();
        float vy = dy * this.offsetPoint.x + dx * this.offsetPoint.y / this.parent.getLength();
        return new Point(vx, vy);
    }

    public Point[] getBounds() {
        this.fm = this.graph.canvas.getFontMetrics();
        this.label[0] = this.parent.label[0];
        if (this.label[0].equals("")) {
            return null;
        }
        Point center = new Point(this.parent.getB()[0]);
        center.translate(this.changeVecBasis());
        int w = this.fm.stringWidth(this.label[0]);
        int h = this.fm.getHeight();
        Point min = new Point(center);
        min.translate(-w / 2 - 2, -h / 2 - 2);
        Point max = new Point(min);
        max.translate(w + 4, h + 4);
        Point[] tmp = new Point[]{min, max};
        return tmp;
    }

    public boolean contains(Point p) {
        if (this.label[0].equals("")) {
            return false;
        }
        Point center = new Point(this.parent.getB()[0]);
        center.translate(this.changeVecBasis());
        return this.contains1(p, center, false);
    }

    public boolean contains1(Point p, Point center, boolean checkAnyways) {
        if (this.parent.start.equals(this.parent.end) && !checkAnyways) {
            return this.contains2(p);
        }
        int w = this.fm.stringWidth(this.label[0]);
        int h = this.fm.getHeight();
        Point nw = new Point(center);
        nw.translate(-w / 2 - 1, -h / 2 - 1);
        Point se = new Point(nw);
        se.translate(w + 2, h + 2);
        return nw.x < p.x && p.x < se.x && nw.y < p.y && p.y < se.y;
    }

    public boolean contains2(Point p) {
        float dy = this.parent.start.height + GraphConsts.selfDy;
        Point n = new Point(this.parent.start.pos.x, this.parent.start.pos.y - dy);
        n.translate(this.changeVecBasis());
        return this.contains1(p, n, true);
    }

    public boolean isInRect(Point a, Point b) {
        return false;
    }

    public void translate(float dx, float dy) {
    }

    public void move(Point p) {
        float moveX;
        if (this.parent.start.equals(this.parent.end)) {
            moveX = p.x - this.parent.start.pos.x;
            if (moveX > this.parent.getLength()) {
                moveX = this.parent.getLength();
            } else if (moveX < -this.parent.getLength()) {
                moveX = -this.parent.getLength();
            }
        } else {
            float y;
            float cx = p.x - this.parent.getB()[0].x;
            float cy = p.y - this.parent.getB()[0].y;
            float x = this.parent.getDx();
            moveX = (x * cx + (y = this.parent.getDy()) * cy) / (x * x + y * y);
            if (moveX > 1.0f) {
                moveX = 1.0f;
            } else if (moveX < 0.0f) {
                moveX = 0.0f;
            }
        }
        this.offsetPoint.move(moveX, 0.0f);
    }

    public boolean equals(Entity ent) {
        if (ent.type == 7772) {
            return this.parent.equals(((EdgeLabel)ent).parent);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.label[0]) + " for edge:( " + this.parent + " )";
    }
}

