/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Inference;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrSafe;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class Configuration
implements Cloneable {
    private boolean factorSavingForTracing;
    private double factorStructuredThreshold;
    private boolean pruneIrrelevantVariables;
    private Inference.Heuristics eliminationHeuristic;
    private Variable[] eliminationOrdering;

    public void setFactorSavingForTracing(boolean val) {
        this.factorSavingForTracing = val;
    }

    public boolean getFactorSavingForTracing() {
        return this.factorSavingForTracing;
    }

    public void setFactorStructuredThreshold(double threshold) {
        this.factorStructuredThreshold = threshold;
    }

    public double getFactorStructuredThreshold() {
        return this.factorStructuredThreshold;
    }

    public void setPruneIrrelevantVariables(boolean val) {
        this.pruneIrrelevantVariables = val;
    }

    public boolean getPruneIrrelevantVariables() {
        return this.pruneIrrelevantVariables;
    }

    public void setEliminationHeuristic(Inference.Heuristics heuristic) {
        if (heuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            throw new IllegalArgumentException("Illegal elimination heuristic.");
        }
        if (heuristic.equals((Object)Inference.Heuristics.RANDOM) || heuristic.equals((Object)Inference.Heuristics.SEQUENTIAL) || heuristic.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            this.eliminationHeuristic = heuristic;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_FACTOR) || heuristic.equals((Object)Inference.Heuristics.MIN_WEIGHT)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_FACTOR;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_DEGREE) || heuristic.equals((Object)Inference.Heuristics.MIN_SIZE)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_DEGREE;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_FILL) || heuristic.equals((Object)Inference.Heuristics.MIN_DEFICIENCY) || heuristic.equals((Object)Inference.Heuristics.MIN_DISCREPANCY) || heuristic.equals((Object)Inference.Heuristics.DEFAULT)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_FILL;
        } else {
            throw new IllegalArgumentException("Illegal elimination heuristic.");
        }
        this.eliminationOrdering = null;
    }

    public void setEliminationHeuristic(Variable[] ordering) {
        this.eliminationHeuristic = Inference.Heuristics.GIVEN;
        this.eliminationOrdering = new Variable[ordering.length];
        System.arraycopy(ordering, 0, this.eliminationOrdering, 0, ordering.length);
    }

    public Inference.Heuristics getEliminationHeuristic() {
        return this.eliminationHeuristic;
    }

    Variable[] eliminationOrdering() {
        return this.eliminationOrdering;
    }

    public ItrSafe<Variable> getEliminationOrdering() {
        if (this.eliminationHeuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            return new ItrArray<Variable>(this.eliminationOrdering, this.eliminationOrdering.length);
        }
        throw new UnsupportedOperationException("Elimination ordering was not specified.");
    }

    public Configuration() {
        this.factorSavingForTracing = false;
        this.factorStructuredThreshold = 1.0E-15;
        this.pruneIrrelevantVariables = true;
        this.eliminationHeuristic = Inference.ELIMINATION_HEURISTIC_DEFAULT;
        this.eliminationOrdering = null;
    }

    private Configuration(Configuration configuration) {
        this.factorSavingForTracing = configuration.factorSavingForTracing;
        this.factorStructuredThreshold = configuration.factorStructuredThreshold;
        this.pruneIrrelevantVariables = configuration.pruneIrrelevantVariables;
        this.eliminationHeuristic = configuration.eliminationHeuristic;
        this.eliminationOrdering = configuration.eliminationOrdering;
    }

    public void save() {
    }

    public void load() {
    }

    public Configuration clone() {
        return new Configuration(this);
    }

    public String toString(boolean withId) {
        StringBuilder output = new StringBuilder();
        output.append("Factor/DecisionNetwork: savingForTracing = " + this.factorSavingForTracing + "\n");
        output.append("FactorCPT: threshold = " + this.factorStructuredThreshold + "\n");
        output.append("Query/Policy: pruning of irrelevant variables = " + this.pruneIrrelevantVariables + "\n");
        if (this.eliminationHeuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            output.append("Query/Policy: elimination ordering given = <");
            int i = 0;
            while (i < this.eliminationOrdering.length - 1) {
                output.append(String.valueOf(this.eliminationOrdering[i].getName(withId)) + ", ");
                ++i;
            }
            output.append(String.valueOf(this.eliminationOrdering[this.eliminationOrdering.length - 1].getName(true)) + ">");
        } else {
            output.append("Query/Policy: eliminationHeuristic = " + (Object)((Object)this.eliminationHeuristic));
        }
        return output.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

