/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Configuration;
import CIspace.ve.Factor;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorInterpretable;
import CIspace.ve.FactorUtility;
import CIspace.ve.Property;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;
import CIspace.ve.VariableNature;
import CIspace.ve.tools.ItrIterator;
import CIspace.ve.tools.ItrSafe;
import CIspace.ve.tools.PairComparable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecisionNetwork {
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;
    private String name = "";
    private final UserPropertiesHolder networkProperties = new UserPropertiesHolder();
    private boolean isDecisionNetwork = false;
    private boolean isPolicyDefined = true;
    private boolean isNoForgetting;
    private final boolean factorSavingForTracing;
    private final double factorStructuredThreshold;
    private UserPropertiesHolder utilityProperties;
    private final TreeMap<Variable, VariableProperties> variableToProperties;
    private final HashMap<String, Variable> nameToVar;
    private final LinkedList<Factor> factors;
    private long maxFactorSize;
    private Graph graph;
    private boolean constructionFinished;

    public final int getId() {
        return this.uniqueId;
    }

    public final void setName(String name) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Provided name is null.");
        }
        this.name = name;
    }

    public final String getName(boolean withId) {
        if (withId) {
            return String.valueOf(this.name) + "[#" + this.uniqueId + "]";
        }
        return this.name;
    }

    public final void addProperty(Property property) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (property == null) {
            throw new IllegalArgumentException("Provided property is null.");
        }
        if (!this.networkProperties.add(property)) {
            throw new IllegalArgumentException("Provided property ('" + property.getName() + "') is already in the network.");
        }
    }

    public final void addProperties(Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        this.networkProperties.add(propertiesIterator);
    }

    public final UserPropertiesHolder properties() {
        return this.networkProperties;
    }

    public final boolean isDecisionNetwork() {
        return this.isDecisionNetwork;
    }

    public final boolean isPolicyDefined() {
        if (!this.isDecisionNetwork) {
            throw new UnsupportedOperationException("This is not a decision network.");
        }
        return this.isPolicyDefined;
    }

    public final boolean isNoForgetting() {
        return this.isNoForgetting;
    }

    public final boolean factorSavingForTracing() {
        return this.factorSavingForTracing;
    }

    public final double factorStructuredThreshold() {
        return this.factorStructuredThreshold;
    }

    public final UserPropertiesHolder utilityProperties() {
        return this.utilityProperties;
    }

    public final FactorUtility getUtility() {
        if (this.isDecisionNetwork) {
            return (FactorUtility)this.factors.getFirst();
        }
        throw new UnsupportedOperationException("This is not a decision network.");
    }

    public final void addUtility(FactorUtility utility, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (this.factors.getFirst() != null) {
            throw new UnsupportedOperationException("Utility is already defined for this network.");
        }
        ItrSafe<Variable> variablesIterator = utility.getVariables();
        while (variablesIterator.hasNext()) {
            Variable variable = (Variable)variablesIterator.next();
            if (this.variableToProperties.containsKey(variable)) continue;
            throw new UnsupportedOperationException("Variable " + variable.getName(false) + " is not in the network.");
        }
        this.utilityProperties = new UserPropertiesHolder(propertiesIterator);
        this.factors.removeFirst();
        if (utility.isProperlyOrdered()) {
            this.factors.addFirst(utility);
        } else {
            this.factors.addFirst(utility.reorder(this.factorSavingForTracing));
        }
        this.isDecisionNetwork = true;
    }

    public final void addVariable(Variable variable, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        Variable previousValue = this.nameToVar.put(variable.getName(false), variable);
        if (previousValue != null) {
            this.nameToVar.put(variable.getName(false), previousValue);
            throw new IllegalArgumentException("Variable with the same name (" + variable.getName(false) + ") is already in the network.");
        }
        try {
            this.variableToProperties.put(variable, new VariableProperties(propertiesIterator));
        }
        catch (IllegalArgumentException e) {
            this.nameToVar.remove(variable);
            throw e;
        }
        this.graph.addVariable(variable);
        if (variable instanceof VariableDecision) {
            this.isDecisionNetwork = true;
        }
    }

    public final int getNumVariables() {
        return this.variableToProperties.size();
    }

    public final boolean containsVariable(Variable variable) {
        return this.variableToProperties.containsKey(variable);
    }

    public final ItrSafe<Variable> getVariables() {
        return new ItrIterator<Variable>(this.variableToProperties.keySet().iterator());
    }

    public final Variable getVariable(String variableName) {
        return this.nameToVar.get(variableName);
    }

    public final VariableProperties variableProperties(Variable variable) {
        VariableProperties allProperties = this.variableToProperties.get(variable);
        if (allProperties == null) {
            throw new IllegalArgumentException("Variable '" + variable.getName(false) + "' is not in the network.");
        }
        return allProperties;
    }

    public final void addFactor(Factor factor, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (!(factor instanceof FactorDistribution)) {
            throw new IllegalArgumentException("Factor does not specify a child variable.");
        }
        Variable child = ((FactorDistribution)((Object)factor)).getChild();
        if (this.graph.getParentsNum(child) != 0) {
            throw new IllegalArgumentException("Parents for this variable ('" + child.getName(false) + "') are already in the network.");
        }
        if (!((FactorDistribution)((Object)factor)).isDistribution(this.factorStructuredThreshold)) {
            throw new IllegalArgumentException("Factor does not represent a conditional probability distribution with a required precision.");
        }
        if (!factor.isProperlyOrdered()) {
            factor = factor.reorder(this.factorSavingForTracing);
        }
        VariableProperties childProperties = this.variableToProperties.get(child);
        try {
            childProperties.definitionProperties.add(propertiesIterator);
        }
        catch (IllegalArgumentException e) {
            childProperties.definitionProperties.clear();
            throw e;
        }
        ItrSafe<Variable> variablesIterator = factor.getVariables();
        int index = 0;
        try {
            while (variablesIterator.hasNext()) {
                if (index++ != ((FactorDistribution)((Object)factor)).getChildIndex()) {
                    this.graph.addParent(child, (Variable)variablesIterator.next());
                    continue;
                }
                variablesIterator.next();
            }
        }
        catch (IllegalArgumentException e) {
            childProperties.definitionProperties.clear();
            this.graph.removeParents(child);
            throw e;
        }
        this.factors.add(factor);
        childProperties.factor = factor;
        if (factor.getSize() > this.maxFactorSize) {
            this.maxFactorSize = factor.getSize();
        }
    }

    public final void addParents(VariableDecision decisionVariable, Variable[] parents, Iterator<Property> propertiesIterator) {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        if (this.graph.getParentsNum(decisionVariable) != 0) {
            throw new IllegalArgumentException("Parents for this variable ('" + decisionVariable.getName(false) + "') are already in the network.");
        }
        try {
            this.variableToProperties.get(decisionVariable).definitionProperties.add(propertiesIterator);
        }
        catch (IllegalArgumentException e) {
            this.variableToProperties.get(decisionVariable).definitionProperties.clear();
            throw e;
        }
        try {
            int i = 0;
            while (i < parents.length) {
                this.graph.addParent(decisionVariable, parents[i]);
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            this.variableToProperties.get(decisionVariable).definitionProperties.clear();
            this.graph.removeParents(decisionVariable);
            throw e;
        }
    }

    public final ItrSafe<Factor> getFactors(boolean withUtility) {
        ItrIterator<Factor> iterator = new ItrIterator<Factor>(this.factors.iterator());
        if (!withUtility || !this.isDecisionNetwork) {
            ((ItrSafe)iterator).next();
        }
        return iterator;
    }

    public final int getNumProbFactors() {
        return this.factors.size() - 1;
    }

    public final long getMaxFactorSize() {
        return this.maxFactorSize;
    }

    public final long getSize() {
        Iterator iterator = this.factors.iterator();
        long count = 0L;
        if (!this.isDecisionNetwork) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            count += ((Factor)iterator.next()).getSize();
        }
        return count;
    }

    final Graph getGraph() {
        return this.graph.clone();
    }

    public final ItrSafe<Variable> getParents(Variable child) {
        return this.graph.getParents(child);
    }

    public final int getParentsNum(Variable child) {
        return this.graph.getParentsNum(child);
    }

    public final boolean isConstructionFinished() {
        return this.constructionFinished;
    }

    public final void finishConstruction(boolean checkNoForgetting) throws Exception {
        if (this.constructionFinished) {
            throw new UnsupportedOperationException("Network is already constructed.");
        }
        for (Variable variable : this.variableToProperties.keySet()) {
            if (variable instanceof VariableNature) {
                if (this.variableToProperties.get(variable).factor != null) continue;
                throw new Exception("Probability distribution not specified for the random variable (" + variable.getName(false) + ").");
            }
            boolean bl = this.isPolicyDefined = this.isPolicyDefined && this.variableToProperties.get(variable).factor != null;
        }
        if (this.isDecisionNetwork) {
            if (this.factors.getFirst() == null) {
                throw new Exception("Utility is not specified for the decision network.");
            }
            if (checkNoForgetting) {
                TreeSet<PairComparable<Integer, Variable>> totalOrdering = new TreeSet<PairComparable<Integer, Variable>>();
                int decisionFunctionsCount = 0;
                for (Variable variable : this.variableToProperties.keySet()) {
                    if (!(variable instanceof VariableDecision)) continue;
                    int numDecisionParents = 0;
                    ItrSafe<Variable> parentsIterator = this.graph.getParents(variable);
                    while (parentsIterator.hasNext()) {
                        if (!(parentsIterator.next() instanceof VariableDecision)) continue;
                        ++numDecisionParents;
                    }
                    totalOrdering.add(new PairComparable<Integer, Variable>(numDecisionParents, variable));
                    if (this.variableToProperties.get(variable).factor == null) continue;
                    ++decisionFunctionsCount;
                }
                int expectedNumDecisionsParents = 0;
                int score = totalOrdering.size() - decisionFunctionsCount + 1;
                Variable previousVariable = null;
                for (PairComparable pairComparable : totalOrdering) {
                    VariableProperties decisionVariableProperties;
                    ItrSafe<Variable> currentParentsIterator;
                    if ((Integer)pairComparable.getFirstElement() != expectedNumDecisionsParents) {
                        throw new Exception("Decision network is not a proper no-forgetting decision network.");
                    }
                    Variable decisionVariable = (Variable)pairComparable.getSecondElement();
                    if (expectedNumDecisionsParents != 0) {
                        ItrSafe<Variable> previousParentsIterator = this.graph.getParents(previousVariable);
                        currentParentsIterator = this.graph.getParents(decisionVariable);
                        boolean previousVariabIesParent = false;
                        while (previousParentsIterator.hasNext()) {
                            Variable previousParent = (Variable)previousParentsIterator.next();
                            boolean previousParentFound = false;
                            while (!previousParentFound && currentParentsIterator.hasNext()) {
                                Variable currentParent = (Variable)currentParentsIterator.next();
                                previousParentFound = currentParent.equals(previousParent);
                                boolean bl = previousVariabIesParent = previousVariabIesParent || currentParent.equals(previousVariable);
                            }
                            if (previousParentFound) continue;
                            throw new Exception("Decision network is not a proper no-forgetting decision network.");
                        }
                        while (!previousVariabIesParent && currentParentsIterator.hasNext()) {
                            boolean bl = previousVariabIesParent = previousVariabIesParent || ((Variable)currentParentsIterator.next()).equals(previousVariable);
                        }
                        if (!previousVariabIesParent) {
                            throw new Exception("Decision network is not a proper no-forgetting decision network.");
                        }
                    }
                    if ((decisionVariableProperties = this.variableProperties(decisionVariable)).factor == null) {
                        currentParentsIterator = this.graph.getParents(decisionVariable);
                        while (currentParentsIterator.hasNext()) {
                            VariableProperties parentProperties = this.variableProperties((Variable)currentParentsIterator.next());
                            if (parentProperties.getDecisionHierarchyScore() != 0) continue;
                            parentProperties.decisionHierarchyScore = score;
                        }
                        decisionVariableProperties.decisionHierarchyScore = --score;
                    }
                    ++expectedNumDecisionsParents;
                    previousVariable = (Variable)pairComparable.getSecondElement();
                }
                this.isNoForgetting = true;
            }
        }
        this.constructionFinished = true;
    }

    public DecisionNetwork(Configuration configuration) {
        this.factorSavingForTracing = configuration.getFactorSavingForTracing();
        this.factorStructuredThreshold = configuration.getFactorStructuredThreshold();
        this.variableToProperties = new TreeMap();
        this.factors = new LinkedList();
        this.factors.addFirst(null);
        this.nameToVar = new HashMap();
        this.graph = new Graph();
        this.uniqueId = nextId.getAndIncrement();
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    public String toString(boolean brief, boolean withId) {
        StringBuilder output = new StringBuilder();
        Iterator factorsIterator = this.factors.iterator();
        if (this.isDecisionNetwork) {
            output.append("Decision Network \"");
        } else {
            output.append("Belief Network \"");
            factorsIterator.next();
        }
        output.append(this.getName(withId)).append("\":\n");
        output.append("\n - variables:");
        Iterator<Variable> variablesIterator = this.variableToProperties.keySet().iterator();
        while (variablesIterator.hasNext()) {
            output.append("\n").append(variablesIterator.next().toString(withId));
        }
        output.append("\n\n - factors:");
        while (factorsIterator.hasNext()) {
            Factor factor = (Factor)factorsIterator.next();
            output.append("\nFactor ").append(((FactorInterpretable)((Object)factor)).getInterpretation(withId)).append(":");
            if (brief) {
                output.append(" ").append(factor.getName(withId)).append("\n");
            } else {
                output.append("\n").append(factor.toString("   ", withId)).append("\n");
            }
            output.append("Size: ").append(factor.getSize()).append("\n");
        }
        output.append("\nNumber of factors: ");
        if (this.isDecisionNetwork) {
            output.append(this.factors.size());
        } else {
            output.append(this.factors.size() - 1);
        }
        output.append(".\nNumer of parameters: ").append(this.getSize()).append(".\n");
        output.append("\n - structure:\n").append(this.graph.toString(withId, false));
        if (this.isDecisionNetwork) {
            output.append("\nparents(UTILITY) = {");
            ItrSafe<Variable> parentsIterator = this.factors.getFirst().getVariables();
            if (parentsIterator.hasNext()) {
                output.append(((Variable)parentsIterator.next()).getName(withId));
            }
            while (parentsIterator.hasNext()) {
                output.append(", ").append(((Variable)parentsIterator.next()).getName(withId));
            }
            output.append("}");
        }
        return output.toString();
    }

    public String toString() {
        return this.toString(false, true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Decision network has its own unique ID. It can't be cloned. Also it is immutable so there is no point in cloning.");
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        throw new UnsupportedOperationException("DecisionNetwork class can not save \"" + decisionNetwork.getName(false) + "\" network to string. Use one of derived classes instead.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    final class Graph {
        private final TreeMap<Variable, TreeSet<Variable>> parents = new TreeMap();
        private final HashMap<Variable, HashSet<Variable>> ancestors = new HashMap();

        Graph() {
        }

        boolean inGraph(Variable variable) {
            return this.parents.containsKey(variable);
        }

        void addVariable(Variable variable) {
            TreeSet previousValue = this.parents.put(variable, new TreeSet());
            if (previousValue != null) {
                this.parents.put(variable, previousValue);
                throw new IllegalArgumentException("Variable '" + variable.getName(false) + "' is already in the graph.");
            }
            this.ancestors.put(variable, new HashSet());
        }

        void removeVariable(Variable variable) {
            if (!this.parents.containsKey(variable)) {
                throw new IllegalArgumentException("Variable '" + variable.getName(false) + "' is not in the graph.");
            }
            for (Map.Entry<Variable, TreeSet<Variable>> entry : this.parents.entrySet()) {
                if (!entry.getValue().remove(variable)) continue;
                this.rebuildAncestors(entry.getKey());
            }
            this.parents.remove(variable);
            this.ancestors.remove(variable);
        }

        Iterator<Variable> getVariables() {
            return this.parents.keySet().iterator();
        }

        int getVariablesNum() {
            return this.parents.size();
        }

        boolean isParent(Variable child, Variable parent) {
            if (!this.parents.containsKey(child)) {
                throw new IllegalArgumentException("Variable '" + child.getName(false) + "' is not in the graph.");
            }
            if (!this.parents.containsKey(parent)) {
                throw new IllegalArgumentException("Variable '" + parent.getName(false) + "' is not in the graph.");
            }
            return this.parents.get(child).contains(parent);
        }

        boolean couldBeParent(Variable child, Variable parent) {
            if (!this.parents.containsKey(child)) {
                throw new IllegalArgumentException("Variable '" + child.getName(false) + "' is not in the graph.");
            }
            if (!this.parents.containsKey(parent)) {
                throw new IllegalArgumentException("Variable '" + parent.getName(false) + "' is not in the graph.");
            }
            return !this.ancestors.get(parent).contains(child);
        }

        void addParent(Variable child, Variable parent) {
            if (child.equals(parent)) {
                throw new IllegalArgumentException("Variable can not be its' own parent.");
            }
            if (this.ancestors.get(parent).contains(child)) {
                throw new IllegalArgumentException("Edge from variable '" + parent.getName(false) + "' to variable '" + child.getName(false) + "' introduces a directed cycle in the graph.");
            }
            if (!this.parents.containsKey(parent)) {
                throw new IllegalArgumentException("Variable '" + parent.getName(false) + "' is not in the graph.");
            }
            TreeSet<Variable> variableParents = this.parents.get(child);
            if (variableParents == null) {
                throw new IllegalArgumentException("Child variable '" + child.getName(false) + "' is not in the graph.");
            }
            if (!variableParents.add(parent)) {
                throw new IllegalArgumentException("Variable '" + parent.getName(false) + "' is already registered as a parent of the variable '" + child.getName(false) + "'.");
            }
            HashSet<Variable> parentAncestors = this.ancestors.get(parent);
            for (Map.Entry<Variable, HashSet<Variable>> entry : this.ancestors.entrySet()) {
                HashSet<Variable> variableAncestors = entry.getValue();
                if (!entry.getKey().equals(child) && !variableAncestors.contains(child)) continue;
                variableAncestors.add(parent);
                Iterator<Variable> parentAncestorsIterator = parentAncestors.iterator();
                while (parentAncestorsIterator.hasNext()) {
                    variableAncestors.add(parentAncestorsIterator.next());
                }
            }
        }

        void removeParents(Variable child) {
            TreeSet<Variable> variableParents = this.parents.get(child);
            if (variableParents == null) {
                throw new IllegalArgumentException("Variable '" + child.getName(false) + "' is not in the graph.");
            }
            variableParents.clear();
            this.rebuildAncestors(child);
        }

        ItrSafe<Variable> getParents(Variable child) {
            TreeSet<Variable> variableParents = this.parents.get(child);
            if (variableParents == null) {
                throw new IllegalArgumentException("Variable '" + child.getName(false) + "' is not in the graph.");
            }
            return new ItrIterator<Variable>(variableParents.iterator());
        }

        int getParentsNum(Variable child) {
            TreeSet<Variable> variableParents = this.parents.get(child);
            if (variableParents == null) {
                throw new IllegalArgumentException("Variable '" + child.getName(false) + "' is not in the Graph.");
            }
            return variableParents.size();
        }

        private void rebuildAncestors(Variable descendant) {
            HashSet<Variable> descendantAncestors = this.ancestors.get(descendant);
            descendantAncestors.clear();
            for (Variable parent : this.parents.get(descendant)) {
                descendantAncestors.add(parent);
                Iterator<Variable> parentAncestorsIterator = this.ancestors.get(parent).iterator();
                while (parentAncestorsIterator.hasNext()) {
                    descendantAncestors.add(parentAncestorsIterator.next());
                }
            }
            for (Map.Entry<Variable, TreeSet<Variable>> entry : this.parents.entrySet()) {
                if (!entry.getValue().contains(descendant)) continue;
                this.rebuildAncestors(entry.getKey());
            }
        }

        ItrSafe<Variable> getAncestors(Variable descendant) {
            HashSet<Variable> variableAncestors = this.ancestors.get(descendant);
            if (variableAncestors == null) {
                throw new IllegalArgumentException("Variable '" + descendant.getName(false) + "' is not in the graph.");
            }
            return new ItrIterator<Variable>(variableAncestors.iterator());
        }

        int getAncestorsNum(Variable descendant) {
            HashSet<Variable> variableAncestors = this.ancestors.get(descendant);
            if (variableAncestors == null) {
                throw new IllegalArgumentException("Variable '" + descendant.getName(false) + "' is not in the Graph.");
            }
            return variableAncestors.size();
        }

        int markRelevant(Set<Variable> relevantVariables, Variable relevantVariable) {
            int result = 0;
            if (!relevantVariables.contains(relevantVariable)) {
                relevantVariables.add(relevantVariable);
                result = 1;
                TreeSet<Variable> variableParents = this.parents.get(relevantVariable);
                if (variableParents == null) {
                    throw new IllegalArgumentException("Variable '" + relevantVariable.getName(false) + "' is not in the graph.");
                }
                Iterator<Variable> parentsIterator = variableParents.iterator();
                while (parentsIterator.hasNext()) {
                    result += this.markRelevant(relevantVariables, parentsIterator.next());
                }
            }
            return result;
        }

        public Graph clone() {
            Graph clone = new Graph();
            for (Map.Entry<Variable, TreeSet<Variable>> entry : this.parents.entrySet()) {
                clone.parents.put(entry.getKey(), new TreeSet(entry.getValue()));
            }
            for (Map.Entry<Variable, HashSet<Variable>> entry : this.ancestors.entrySet()) {
                clone.ancestors.put(entry.getKey(), new HashSet(entry.getValue()));
            }
            return clone;
        }

        public String toString() {
            return this.toString(true, true);
        }

        public String toString(boolean withId, boolean withAncestors) {
            StringBuilder output = new StringBuilder();
            for (Map.Entry<Variable, TreeSet<Variable>> entry : this.parents.entrySet()) {
                output.append("parents(").append(entry.getKey().getName(withId)).append(") = {");
                Iterator<Variable> parentsIterator = entry.getValue().iterator();
                if (parentsIterator.hasNext()) {
                    output.append(parentsIterator.next().getName(withId));
                }
                while (parentsIterator.hasNext()) {
                    output.append(", ").append(parentsIterator.next().getName(withId));
                }
                output.append("}\n");
            }
            if (withAncestors) {
                output.append("\n");
                for (Map.Entry<Variable, HashSet<Variable>> entry : this.ancestors.entrySet()) {
                    output.append("ancestors(").append(entry.getKey().getName(withId)).append(") = {");
                    Iterator<Variable> ancestorsIterator = entry.getValue().iterator();
                    if (ancestorsIterator.hasNext()) {
                        output.append(ancestorsIterator.next().getName(withId));
                    }
                    while (ancestorsIterator.hasNext()) {
                        output.append(", ").append(ancestorsIterator.next().getName(withId));
                    }
                    output.append("}\n");
                }
            }
            if (output.length() > 0) {
                output.delete(output.length() - 1, output.length());
            }
            return output.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public final class VariableProperties {
        private final UserPropertiesHolder variableProperties;
        private final UserPropertiesHolder definitionProperties;
        private Factor factor;
        private int decisionHierarchyScore;

        public final UserPropertiesHolder getVariableProperties() {
            return this.variableProperties;
        }

        public final UserPropertiesHolder getDefinitionProperties() {
            return this.definitionProperties;
        }

        public final Factor getFactor() {
            return this.factor;
        }

        final int getDecisionHierarchyScore() {
            return this.decisionHierarchyScore;
        }

        private VariableProperties(Iterator<Property> propertiesIterator) {
            this.variableProperties = new UserPropertiesHolder(propertiesIterator);
            this.definitionProperties = new UserPropertiesHolder();
            this.factor = null;
            this.decisionHierarchyScore = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NotThreadSafe
    public final class UserPropertiesHolder {
        private final HashMap<String, Property> properties = new HashMap();

        private UserPropertiesHolder() {
        }

        private UserPropertiesHolder(Iterator<Property> propertiesIterator) {
            if (propertiesIterator != null) {
                while (propertiesIterator.hasNext()) {
                    Property property = propertiesIterator.next();
                    if (property == null) {
                        throw new IllegalArgumentException("Null property.");
                    }
                    if (this.properties.put(property.getName(), property) == null) continue;
                    throw new IllegalArgumentException("Duplicate property '" + property.getName() + "'.");
                }
            }
        }

        private boolean add(Property property) {
            Property previous = this.properties.put(property.getName(), property);
            if (previous != null) {
                this.properties.put(previous.getName(), previous);
                return false;
            }
            return true;
        }

        private void add(Iterator<Property> propertiesIterator) {
            if (propertiesIterator != null) {
                while (propertiesIterator.hasNext()) {
                    Property property = propertiesIterator.next();
                    if (property == null) {
                        throw new IllegalArgumentException("Null property.");
                    }
                    if (this.properties.put(property.getName(), property) == null) continue;
                    throw new IllegalArgumentException("Duplicate property ('" + property.getName() + ").");
                }
            }
        }

        private void clear() {
            this.properties.clear();
        }

        public Property get(String propertyName) {
            return this.properties.get(propertyName);
        }

        public ItrSafe<Property> get() {
            return new ItrIterator<Property>(this.properties.values().iterator());
        }

        public int getNum() {
            return this.properties.size();
        }
    }
}

