/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.EltsIterator;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorStored;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrSafe;
import java.util.Arrays;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Factor
implements Comparable<Factor> {
    static final boolean SAVING_FOR_TRACING_DEFAULT = false;
    public static final int PRECISION_DEFAULT = 3;
    protected final Variable[] variables;
    private final long size;
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;
    protected boolean hasBeenReordered = false;
    protected int[] newToOldIndex = null;
    protected Factor reorderedFactor = null;

    public final int getVariablesNum() {
        return this.variables.length;
    }

    public final Variable getVariable(int i) {
        if (i >= 0 && i < this.variables.length) {
            return this.variables[i];
        }
        throw new IllegalArgumentException("Variable's index is out of range (" + i + ")!");
    }

    public final ItrSafe<Variable> getVariables() {
        return new ItrArray<Variable>(this.variables, this.variables.length);
    }

    public final Variable[] getVariablesArray() {
        Variable[] result = new Variable[this.variables.length];
        System.arraycopy(this.variables, 0, result, 0, this.variables.length);
        return result;
    }

    public final long getSize() {
        return this.size;
    }

    public final int getId() {
        return this.uniqueId;
    }

    public Factor(Variable[] variables, boolean copyVariables) {
        if (copyVariables) {
            this.variables = new Variable[variables.length];
            System.arraycopy(variables, 0, this.variables, 0, variables.length);
        } else {
            this.variables = variables;
        }
        int tSize = 1;
        Variable[] variableArray = this.variables;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            if (Long.MAX_VALUE / (long)variable.getDomainSize() < this.size) {
                throw new OutOfMemoryError("New factor size is too large (greater than Long.Max_VALUE).");
            }
            tSize *= variable.getDomainSize();
            ++n;
        }
        this.size = tSize;
        this.uniqueId = nextId.getAndIncrement();
    }

    public abstract EltsIterator iterator();

    public final boolean hasBeenReordered() {
        return this.hasBeenReordered;
    }

    public int getReorderedIndex(int newIndex) {
        if (this.newToOldIndex == null) {
            throw new UnsupportedOperationException("Information was not saved for tracing.");
        }
        if (newIndex < 0 || newIndex >= this.newToOldIndex.length) {
            throw new IllegalArgumentException("Given index " + newIndex + " is invalid.");
        }
        return this.newToOldIndex[newIndex];
    }

    public Factor getReorderedFactor() {
        if (!this.hasBeenReordered) {
            throw new UnsupportedOperationException("Factor hasn't been reordered.");
        }
        if (this.reorderedFactor == null) {
            throw new UnsupportedOperationException("Factors are not being saved for tracing.");
        }
        return this.reorderedFactor;
    }

    public Factor reorder(boolean saveForTracing) {
        return this.reorder(Variable.sort(this.variables), false, saveForTracing);
    }

    public Factor reorder(Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        int[] newToOldIndex = null;
        if (saveForTracing && Integer.MAX_VALUE >= this.size) {
            newToOldIndex = new int[(int)this.size];
        }
        FactorStored result = new FactorStored(newOrder, copyOrder, Factor.reorderValues(this, newOrder, newToOldIndex), false);
        if (saveForTracing) {
            result.reorderedFactor = this;
            result.newToOldIndex = newToOldIndex;
        }
        result.hasBeenReordered = true;
        return result;
    }

    public final boolean isProperlyOrdered() {
        int i = 1;
        while (i < this.variables.length) {
            if (this.variables[i - 1].compareTo(this.variables[i]) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean contains(Variable v) {
        return Arrays.binarySearch(this.variables, v) >= 0;
    }

    public final String getName(boolean withId) {
        StringBuilder nameString = withId ? new StringBuilder("[" + this.uniqueId + "]" + "(") : new StringBuilder("(");
        if (this.variables.length > 0) {
            nameString.append(this.variables[0].getName(withId));
        }
        int i = 1;
        while (i < this.variables.length) {
            nameString.append(", ").append(this.variables[i].getName(withId));
            ++i;
        }
        return nameString.append(")").toString();
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    public final String toString(String indent, boolean withId) {
        return this.toString(indent, 1, withId);
    }

    private final String toString(String indent, int digits, boolean withId) {
        Formatter output = new Formatter();
        int valueDigits = digits;
        output.format("%s", indent);
        String[] columnFormat = new String[this.variables.length + 1];
        int totalWidth = 0;
        int i = 0;
        while (i < this.variables.length) {
            int width;
            String name = this.variables[i].getName(withId);
            if (this instanceof FactorDistribution && ((FactorDistribution)((Object)this)).getChildIndex() == i) {
                width = Math.max(name.length() + 2, this.variables[i].getMaxElementLength()) + 1;
                columnFormat[i] = "%-" + width + "s";
                totalWidth += width;
                output.format(columnFormat[i], "|" + name + "|");
            } else {
                width = Math.max(name.length(), this.variables[i].getMaxElementLength()) + 1;
                columnFormat[i] = "%-" + width + "s";
                totalWidth += width;
                output.format(columnFormat[i], name);
            }
            ++i;
        }
        if (this.variables.length > 0) {
            output.format("%s", "| ");
            totalWidth += 2;
        }
        columnFormat[this.variables.length] = "%s";
        output.format("%" + Math.max(digits + 1, 5) + "s\n", "Value");
        char[] array = new char[totalWidth + Math.max(digits + 1, 5)];
        Arrays.fill(array, '-');
        output.format("%s\n", String.valueOf(indent) + String.valueOf(array));
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            output.format("%s", indent);
            int i2 = 0;
            while (i2 < this.variables.length) {
                output.format(columnFormat[i2], this.variables[i2].getDomainElement(index[i2]));
                ++i2;
            }
            if (this.variables.length > 0) {
                output.format("%s", "| ");
            }
            double value = iter.next();
            valueDigits = Math.max(valueDigits, String.format("%.1f", value).indexOf(46));
            output.format(columnFormat[this.variables.length], value);
            if (!iter.hasNext()) continue;
            output.format("\n", "");
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.variables.length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        if (valueDigits != digits && valueDigits + 1 > 5) {
            output = null;
            return this.toString(indent, valueDigits, withId);
        }
        return output.toString();
    }

    public final String toString() {
        return this.toString("", 3, true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Factor has its own unique ID. It can't be cloned. Also, it is immutable so there is no point in cloning.");
    }

    public final boolean equals(Object factor) {
        return this.uniqueId == ((Factor)factor).uniqueId;
    }

    @Override
    public final int compareTo(Factor factor) {
        return this.uniqueId - factor.getId();
    }

    public final boolean equalTo(Factor factor) {
        ItrSafe<Variable> thisVariables = this.getVariables();
        ItrSafe<Variable> factorVariables = factor.getVariables();
        while (thisVariables.hasNext() && factorVariables.hasNext()) {
            if (thisVariables.next().equals(factorVariables.next())) continue;
            return false;
        }
        if (thisVariables.hasNext() == factorVariables.hasNext()) {
            EltsIterator thisIterator = this.iterator();
            EltsIterator factorIterator = factor.iterator();
            while (thisIterator.hasNext() && factorIterator.hasNext()) {
                if (thisIterator.next() == factorIterator.next()) continue;
                return false;
            }
            return thisIterator.hasNext() == factorIterator.hasNext();
        }
        return false;
    }

    public final boolean isRedundant(Variable variable) {
        int before = 1;
        int dom = variable.getDomainSize();
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != variable) {
            before *= this.variables[pos++].getDomainSize();
        }
        if (pos == this.variables.length) {
            throw new IllegalArgumentException("Variable is not in the factor!");
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double val = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    if (val != its[i3].next()) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    public final boolean isRedundant(Variable variable, double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Threshold can not be a negative number!");
        }
        int before = 1;
        int dom = variable.getDomainSize();
        int after = 1;
        int pos = 0;
        while (pos < this.variables.length && !this.variables[pos].equals(variable)) {
            before *= this.variables[pos++].getDomainSize();
        }
        if (pos == this.variables.length) {
            throw new IllegalArgumentException("Variable is not in the factor!");
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double min;
                double max = min = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    double nextval = its[i3].next();
                    if (max < nextval) {
                        max = nextval;
                    } else if (min > nextval) {
                        min = nextval;
                    }
                    if (max - min > threshold) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    protected static final double[] reorderValues(Factor originalFactor, Variable[] newOrder, int[] newToOldIndex) {
        if (originalFactor.variables.length != newOrder.length) {
            throw new IllegalArgumentException("Original factor and new order have different number of variables.");
        }
        boolean[] found = new boolean[originalFactor.variables.length];
        int[] newBase = new int[newOrder.length];
        int base = 1;
        int i = newOrder.length - 1;
        while (i >= 0) {
            boolean notFound = true;
            int j = 0;
            while (notFound && j < newOrder.length) {
                if (originalFactor.variables[j].equals(newOrder[i])) {
                    if (found[j]) {
                        throw new IllegalArgumentException("New order contains the same variable multiple times.");
                    }
                    found[j] = true;
                    newBase[j] = base;
                    base *= newOrder[i].getDomainSize();
                    notFound = false;
                }
                ++j;
            }
            if (notFound) {
                throw new IllegalArgumentException("New order contains a variable not present in the original factor.");
            }
            --i;
        }
        if (Integer.MAX_VALUE < originalFactor.getSize()) {
            throw new OutOfMemoryError("Original factor is too large (size greater than Integer.Max_VALUE).");
        }
        double[] values = new double[(int)originalFactor.getSize()];
        int[] oldIndex = new int[newOrder.length];
        int newIndex = 0;
        EltsIterator originalFactorIterator = originalFactor.iterator();
        int index = 0;
        while (originalFactorIterator.hasNext()) {
            values[newIndex] = originalFactorIterator.next();
            if (newToOldIndex != null) {
                newToOldIndex[newIndex] = index++;
            }
            boolean incj = true;
            int j = newOrder.length - 1;
            while (incj && j >= 0) {
                int n = j;
                oldIndex[n] = oldIndex[n] + 1;
                if (oldIndex[n] == originalFactor.variables[j].getDomainSize()) {
                    oldIndex[j] = 0;
                    newIndex -= (originalFactor.variables[j].getDomainSize() - 1) * newBase[j];
                } else {
                    newIndex += newBase[j];
                    incj = false;
                }
                --j;
            }
        }
        return values;
    }
}

