/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorDeterministic;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;
import CIspace.ve.tools.ItrSafe;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorDecision
extends FactorDeterministic {
    private Factor originalFactor;

    public Factor getOriginalFactor() {
        if (this.originalFactor == null) {
            throw new UnsupportedOperationException("Factor was not saved for tracing!");
        }
        return this.originalFactor;
    }

    public int getDecisionFunctionValue(int i) {
        if (i >= 0 && i < this.indices.length) {
            return this.indices[i];
        }
        throw new IllegalArgumentException("Action's index is out of range (" + i + ")!");
    }

    public String getDecisionFunctionAction(int i) {
        if (i >= 0 && i < this.indices.length) {
            return this.variables[this.childIndex].getDomainElement(this.indices[i]);
        }
        throw new IllegalArgumentException("Action's index is out of range (" + i + ")!");
    }

    public int getDecisionFunctionSize() {
        return this.indices.length;
    }

    public ItrSafe<Integer> getDecisionFunctionValues() {
        return new ItrSafe<Integer>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < FactorDecision.this.indices.length;
            }

            @Override
            public Integer next() {
                if (this.cursor == FactorDecision.this.indices.length) {
                    throw new NoSuchElementException();
                }
                return FactorDecision.this.indices[this.cursor++];
            }
        };
    }

    public ItrSafe<String> getDecisionFunctionActions() {
        return new ItrSafe<String>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < FactorDecision.this.indices.length;
            }

            @Override
            public String next() {
                if (this.cursor == FactorDecision.this.indices.length) {
                    throw new NoSuchElementException();
                }
                return FactorDecision.this.variables[FactorDecision.this.childIndex].getDomainElement(FactorDecision.this.indices[this.cursor++]);
            }
        };
    }

    FactorDecision(Variable[] variables, int childIndex, int preSize, int curSize, int postSize, int[] actions) {
        super(variables, childIndex, preSize, curSize, postSize, actions);
    }

    FactorDecision(Variable[] variables, int childIndex, int preSize, int curSize, int postSize, int[] actions, Factor originalFactor) {
        super(variables, childIndex, preSize, curSize, postSize, actions);
        this.originalFactor = originalFactor;
    }

    public FactorDecision(Variable[] parents, VariableDecision decisionVariable, String actions, Pattern separator) {
        super(parents, (Variable)decisionVariable, actions, separator);
    }

    public FactorDecision(Variable[] parents, VariableDecision decisionVariable, int[] actions, boolean copyActions) {
        super(parents, (Variable)decisionVariable, actions, copyActions);
    }

    static FactorDecision createSimple(VariableDecision variable, ItrSafe<Variable> parentsIterator, int parentsNum) {
        Variable parent;
        Variable[] variables = new Variable[parentsNum + 1];
        int dpos = 0;
        int preVaIs = 1;
        int postVals = 1;
        int i = 0;
        boolean before = true;
        while (parentsIterator.hasNext() && before) {
            parent = parentsIterator.next();
            if (parent.compareTo(variable) < 0) {
                variables[i++] = parent;
                preVaIs *= parent.getDomainSize();
                continue;
            }
            before = false;
        }
        variables[i++] = variable;
        while (parentsIterator.hasNext()) {
            parent = parentsIterator.next();
            variables[i++] = parent;
            postVals *= parent.getDomainSize();
        }
        int[] decisionFunctionArray = new int[preVaIs * postVals];
        return new FactorDecision(variables, dpos, preVaIs, variable.getDomainSize(), postVals, decisionFunctionArray);
    }

    @Override
    public String getInterpretationFunctor() {
        return "DF";
    }

    @Override
    public String getInterpretation(boolean withId) {
        StringBuilder nameString = new StringBuilder(String.valueOf(this.getChild().getName(withId)) + "(");
        Iterator<Variable> parentsIterator = this.getParents();
        while (parentsIterator.hasNext()) {
            nameString.append(parentsIterator.next().getName(withId)).append(", ");
        }
        if (this.getVariablesNum() > 1) {
            nameString.delete(nameString.length() - 2, nameString.length());
        }
        return nameString.append(")").toString();
    }

    public String toStringActions(String indent, boolean withId) {
        Formatter output = new Formatter();
        output.format("%s", indent);
        String[] columnFormat = new String[this.variables.length + 1];
        int totalWidth = 0;
        int i = 0;
        while (i < this.variables.length) {
            int width;
            String name = this.variables[i].getName(withId);
            if (i == this.childIndex) {
                width = Math.max(name.length() + 1, this.variables[i].getMaxElementLength());
                columnFormat[i] = "%" + width + "s";
            } else {
                width = Math.max(name.length(), this.variables[i].getMaxElementLength()) + 1;
                columnFormat[i] = "%-" + width + "s";
                output.format(columnFormat[i], name);
            }
            totalWidth += width;
            ++i;
        }
        if (this.variables.length > 1) {
            output.format("%s", "| ");
            totalWidth += 2;
        }
        output.format(String.valueOf(columnFormat[this.childIndex]) + "\n", String.valueOf(this.variables[this.childIndex].getName(withId)) + "?");
        char[] array = new char[totalWidth];
        Arrays.fill(array, '-');
        output.format("%s\n", String.valueOf(indent) + String.valueOf(array));
        int[] index = new int[this.variables.length];
        int policyIndex = 0;
        while (policyIndex < this.indices.length) {
            output.format("%s", indent);
            int i2 = 0;
            while (i2 < this.variables.length) {
                if (i2 != this.childIndex) {
                    output.format(columnFormat[i2], this.variables[i2].getDomainElement(index[i2]));
                }
                ++i2;
            }
            if (this.variables.length > 1) {
                output.format("%s", "| ");
            }
            output.format(columnFormat[this.childIndex], this.variables[this.childIndex].getDomainElement(this.indices[policyIndex++]));
            if (policyIndex >= this.indices.length) continue;
            output.format("\n", "");
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (i3 != this.childIndex && index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.variables.length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return output.toString();
    }

    static FactorDecision expandFactor(FactorDecision factor, DecisionNetwork decisionNetwork) {
        Variable decisionVariable = factor.variables[factor.childIndex];
        int parentsNum = decisionNetwork.getParentsNum(decisionVariable);
        if (factor.variables.length != parentsNum + 1) {
            Variable[] variables = new Variable[parentsNum + 1];
            ItrSafe<Variable> parentsIterator = decisionNetwork.getParents(decisionVariable);
            int i = 0;
            int childIndex = 0;
            int preSize = 1;
            int postSize = 1;
            boolean inserted = false;
            while (parentsIterator.hasNext()) {
                Variable parent = (Variable)parentsIterator.next();
                if (!inserted && parent.compareTo(decisionVariable) > 0) {
                    childIndex = i;
                    variables[i++] = decisionVariable;
                    inserted = true;
                }
                variables[i++] = parent;
                if (inserted) {
                    postSize *= parent.getDomainSize();
                    continue;
                }
                preSize *= parent.getDomainSize();
            }
            if (!inserted) {
                childIndex = i;
                variables[i] = decisionVariable;
            }
            int[] actions = new int[preSize * postSize];
            int expand = actions.length / factor.indices.length;
            int k = 0;
            while (k < factor.indices.length) {
                int action = factor.indices[k];
                int j = 0;
                while (j < expand) {
                    actions[k * expand + j] = action;
                    ++j;
                }
                ++k;
            }
            return new FactorDecision(variables, childIndex, preSize, decisionVariable.getDomainSize(), postSize, actions);
        }
        return factor;
    }

    public final int getReorderedActionIndex(int newIndex) {
        if (this.newToOldIndex == null) {
            throw new UnsupportedOperationException("Information was not saved for tracing.");
        }
        if (newIndex < 0 || newIndex >= this.newToOldIndex.length) {
            throw new IllegalArgumentException("Given index " + newIndex + " is invalid.");
        }
        return this.newToOldIndex[newIndex];
    }

    @Override
    public FactorDecision getReorderedFactor() {
        return (FactorDecision)super.getReorderedFactor();
    }

    private FactorDecision(FactorDecision originalFactor, Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        super(originalFactor, newOrder, copyOrder, saveForTracing);
    }

    @Override
    public FactorDecision reorder(boolean saveForTracing) {
        return this.reorder(Variable.sort(this.variables), false, saveForTracing);
    }

    @Override
    public FactorDecision reorder(Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        return new FactorDecision(this, newOrder, copyOrder, saveForTracing);
    }
}

