/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorInterpretable;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArraySkip;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactorDeterministic
extends Factor
implements FactorDistribution,
FactorInterpretable {
    protected int childIndex;
    protected final int[] indices;
    private final int preSize;
    private final int curSize;
    private int postSize;

    @Override
    public final int getChildIndex() {
        return this.childIndex;
    }

    @Override
    public final Variable getChild() {
        return this.variables[this.childIndex];
    }

    @Override
    public Iterator<Variable> getParents() {
        return new ItrArraySkip<Variable>(this.variables, this.childIndex);
    }

    @Override
    public boolean isDistribution(double threshold) {
        return true;
    }

    FactorDeterministic(Variable[] variables, int childIndex, int preSize, int curSize, int postSize, int[] indices) {
        super(variables, false);
        this.childIndex = childIndex;
        this.preSize = preSize;
        this.curSize = curSize;
        this.postSize = postSize;
        this.indices = indices;
        this.hasBeenReordered = false;
    }

    public FactorDeterministic(Variable[] parents, Variable childVariable, String indices, Pattern separator) {
        this(parents, childVariable, FactorDeterministic.stringToIndices(indices, separator), false);
    }

    public FactorDeterministic(Variable[] parents, Variable childVariable, int[] indices, boolean copyIndices) {
        super(Variable.insert(childVariable, parents), false);
        this.hasBeenReordered = false;
        int vpos = 0;
        long prevals = 1L;
        while (!this.variables[vpos].equals(childVariable)) {
            prevals *= (long)this.variables[vpos++].getDomainSize();
        }
        this.childIndex = vpos;
        long postvals = 1L;
        int i = vpos + 1;
        while (i < this.variables.length) {
            postvals *= (long)this.variables[i].getDomainSize();
            ++i;
        }
        if (prevals * postvals != (long)indices.length) {
            throw new IllegalArgumentException("Parents size does not match indices length.");
        }
        this.preSize = (int)prevals;
        this.curSize = this.variables[this.childIndex].getDomainSize();
        this.postSize = (int)postvals;
        if (copyIndices) {
            this.indices = new int[indices.length];
            i = 0;
            while (i < this.indices.length) {
                int action = indices[i];
                if (action < 0 || action >= this.curSize) {
                    throw new IllegalArgumentException("Index is not within the domain of the child variable.");
                }
                this.indices[i] = action;
                ++i;
            }
        } else {
            this.indices = indices;
            i = 0;
            while (i < this.indices.length) {
                if (this.indices[i] < 0 || this.indices[i] >= this.curSize) {
                    throw new IllegalArgumentException("Index is not within the domain of the child variable.");
                }
                ++i;
            }
        }
    }

    @Override
    public EltsIterator iterator() {
        return new EltsIterator(){
            private int prepos = 0;
            private int curpos = 0;
            private int postpos = 0;
            private int actionpos = 0;

            public boolean hasNext() {
                return this.prepos + 1 < FactorDeterministic.this.preSize || this.curpos + 1 < FactorDeterministic.this.curSize || this.postpos < FactorDeterministic.this.postSize;
            }

            public double next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.postpos == FactorDeterministic.this.postSize) {
                    if (this.curpos + 1 < FactorDeterministic.this.curSize) {
                        ++this.curpos;
                    } else {
                        this.curpos = 0;
                        ++this.prepos;
                    }
                    this.actionpos = this.prepos * FactorDeterministic.this.postSize;
                    this.postpos = 0;
                }
                ++this.postpos;
                if (this.curpos == FactorDeterministic.this.indices[this.actionpos++]) {
                    return 1.0;
                }
                return 0.0;
            }

            public long currPos() {
                return (this.prepos * FactorDeterministic.this.curSize + this.curpos) * FactorDeterministic.this.postSize + this.postpos;
            }

            public void backTo(long pos) {
                if (!(pos >= 0L & pos < FactorDeterministic.this.getSize())) {
                    throw new IllegalArgumentException();
                }
                this.postpos = (int)(pos % (long)FactorDeterministic.this.postSize);
                this.curpos = (int)((pos /= (long)FactorDeterministic.this.postSize) % (long)FactorDeterministic.this.curSize);
                this.prepos = (int)(pos / (long)FactorDeterministic.this.curSize);
                this.actionpos = this.prepos * FactorDeterministic.this.postSize + this.postpos;
            }
        };
    }

    @Override
    public String getInterpretationFunctor() {
        return "P";
    }

    @Override
    public String getInterpretation(boolean withId) {
        if (this.childIndex < 0) {
            return this.getName(withId);
        }
        StringBuilder nameString = withId ? new StringBuilder("[" + this.getId() + "]" + this.getInterpretationFunctor() + "(") : new StringBuilder(String.valueOf(this.getInterpretationFunctor()) + "(");
        nameString.append(this.variables[this.childIndex].getName(withId));
        if (this.variables.length > 1) {
            nameString.append(" | ");
            int i = 0;
            while (i < this.variables.length) {
                if (i != this.childIndex) {
                    nameString.append(this.variables[i].getName(withId)).append(", ");
                }
                ++i;
            }
            nameString.delete(nameString.length() - 2, nameString.length());
        }
        return nameString.append(")").toString();
    }

    @Override
    public final int getReorderedIndex(int newIndex) {
        if (this.newToOldIndex == null) {
            throw new UnsupportedOperationException("Information was not saved for tracing.");
        }
        if (newIndex < 0 || (long)newIndex >= this.getSize()) {
            throw new IllegalArgumentException("Given index " + newIndex + " is invalid.");
        }
        int newNewIndex = newIndex / this.postSize;
        int oldActionpos = this.newToOldIndex[newNewIndex / this.curSize * this.postSize + newIndex % this.postSize];
        return (oldActionpos / this.getReorderedFactor().postSize * this.getReorderedFactor().curSize + newNewIndex % this.curSize) * this.getReorderedFactor().postSize + oldActionpos % this.getReorderedFactor().postSize;
    }

    @Override
    public FactorDeterministic getReorderedFactor() {
        return (FactorDeterministic)super.getReorderedFactor();
    }

    protected FactorDeterministic(FactorDeterministic originalFactor, Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        super(newOrder, copyOrder);
        this.curSize = originalFactor.curSize;
        this.indices = new int[originalFactor.indices.length];
        if (originalFactor.variables.length != this.variables.length) {
            throw new IllegalArgumentException("Original Factor and this Factor have different number of Variables!");
        }
        if (saveForTracing) {
            this.reorderedFactor = originalFactor;
            this.newToOldIndex = new int[originalFactor.indices.length];
        }
        this.hasBeenReordered = true;
        boolean[] found = new boolean[originalFactor.variables.length];
        int[] newBase = new int[this.variables.length];
        int base = 1;
        int tempSize = 1;
        int i = this.variables.length - 1;
        while (i >= 0) {
            boolean notFound = true;
            int j = 0;
            while (notFound && j < this.variables.length) {
                if (originalFactor.variables[j].equals(this.variables[i])) {
                    if (found[j]) {
                        throw new IllegalArgumentException("This Factor contains the same Variable multiple times!");
                    }
                    found[j] = true;
                    notFound = false;
                    if (originalFactor.childIndex == j) {
                        this.childIndex = i;
                        this.postSize = tempSize;
                        tempSize = 1;
                    } else {
                        newBase[j] = base;
                        int domainSize = this.variables[i].getDomainSize();
                        base *= domainSize;
                        tempSize *= domainSize;
                    }
                }
                ++j;
            }
            if (notFound) {
                throw new IllegalArgumentException("This Factor contains a Variable not present in the original Factor!");
            }
            --i;
        }
        this.preSize = tempSize;
        int[] oldIndex = new int[this.variables.length];
        int newIndex = 0;
        int i2 = 0;
        while (i2 < originalFactor.indices.length) {
            this.indices[newIndex] = originalFactor.indices[i2];
            if (this.newToOldIndex != null) {
                this.newToOldIndex[newIndex] = i2;
            }
            boolean incj = true;
            int j = this.variables.length - 1;
            while (incj && j >= 0) {
                if (j != originalFactor.childIndex) {
                    int n = j;
                    oldIndex[n] = oldIndex[n] + 1;
                    if (oldIndex[n] == originalFactor.variables[j].getDomainSize()) {
                        oldIndex[j] = 0;
                        newIndex -= (originalFactor.variables[j].getDomainSize() - 1) * newBase[j];
                    } else {
                        newIndex += newBase[j];
                        incj = false;
                    }
                }
                --j;
            }
            ++i2;
        }
    }

    @Override
    public FactorDeterministic reorder(boolean saveForTracing) {
        return this.reorder(Variable.sort(this.variables), false, saveForTracing);
    }

    @Override
    public FactorDeterministic reorder(Variable[] newOrder, boolean copyOrder, boolean saveForTracing) {
        return new FactorDeterministic(this, newOrder, copyOrder, saveForTracing);
    }

    private static int[] stringToIndices(String string, Pattern separator) {
        LinkedList<Integer> indicesList = new LinkedList<Integer>();
        Scanner scanner = new Scanner(string);
        scanner.useDelimiter(separator);
        while (scanner.hasNextInt()) {
            indicesList.add(scanner.nextInt());
        }
        int[] indices = new int[indicesList.size()];
        int i = 0;
        for (Integer index : indicesList) {
            indices[i++] = index;
        }
        return indices;
    }
}

