/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorDecision;
import CIspace.ve.FactorStored;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;

public final class FactorMax
extends FactorStored {
    private Factor originalFactor;
    private final FactorDecision decisionFunction;

    public Factor getOriginalFactor() {
        if (this.originalFactor == null) {
            throw new UnsupportedOperationException("Factor was not saved for tracing!");
        }
        return this.originalFactor;
    }

    public FactorDecision getDecisionFunction() {
        return this.decisionFunction;
    }

    private FactorMax(Variable[] variables, double[] values, FactorDecision decisionFunction) {
        super(variables, false, values, false);
        this.decisionFunction = decisionFunction;
    }

    private FactorMax(Variable[] variables, double[] values, FactorDecision decisionFunction, Factor originalFactor) {
        super(variables, false, values, false);
        this.decisionFunction = decisionFunction;
        this.originalFactor = originalFactor;
    }

    public static FactorMax create(Factor factor, VariableDecision decisionVariable, boolean saveForTracing) {
        long size = factor.getSize() / (long)decisionVariable.getDomainSize();
        if (size > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("New factor size is too large (greater than Integer.Max_VALUE).");
        }
        Variable[] variables = Variable.removeVariable(factor.variables, decisionVariable);
        double[] factorValues = new double[(int)size];
        int vpos = 0;
        int prevals = 1;
        int[] decisionFunctionArray = new int[(int)size];
        while (!factor.variables[vpos].equals(decisionVariable)) {
            prevals *= factor.variables[vpos++].getDomainSize();
        }
        int varvals = decisionVariable.getDomainSize();
        int dpos = vpos;
        int postvals = 1;
        int i = vpos + 1;
        while (i < factor.variables.length) {
            postvals *= factor.variables[i].getDomainSize();
            ++i;
        }
        EltsIterator f1Iter = factor.iterator();
        int pos = 0;
        int prepos = 0;
        while (prepos < prevals) {
            int firstpos = pos;
            int postpos = 0;
            while (postpos < postvals) {
                factorValues[pos++] = f1Iter.next();
                ++postpos;
            }
            int varpos = 1;
            while (varpos < varvals) {
                pos = firstpos;
                int postpos2 = 0;
                while (postpos2 < postvals) {
                    double nextVal = f1Iter.next();
                    if (factorValues[pos] < nextVal) {
                        factorValues[pos] = nextVal;
                        decisionFunctionArray[pos] = varpos;
                    }
                    ++pos;
                    ++postpos2;
                }
                ++varpos;
            }
            ++prepos;
        }
        if (saveForTracing) {
            return new FactorMax(variables, factorValues, new FactorDecision(factor.variables, dpos, prevals, varvals, postvals, decisionFunctionArray, factor), factor);
        }
        return new FactorMax(variables, factorValues, new FactorDecision(factor.variables, dpos, prevals, varvals, postvals, decisionFunctionArray));
    }
}

