/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorStore;
import CIspace.ve.Inference;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrSafe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
abstract class FactorStoreIndexed<T extends Comparable<T>>
implements FactorStore {
    final DecisionNetwork dnet;
    VariableToEliminate<T>[] varsPQ;
    int numVariablesToEliminate;
    private Inference.Heuristics how;
    private VariableToEliminate<T> last = null;
    final HashMap<Variable, VariableToEliminate<T>> varToVarInQuery;
    private Factor[] finalFactors;
    private int numFinalFactors;
    final HashMap<Variable, HashSet<Factor>> factorIndex;

    FactorStoreIndexed(DecisionNetwork decisionNetwork, Variable[] toEliminate, Iterator<Factor> initFactorsIterator, int nrInitFactors, Iterator<Variable> variablesIterator, int numVariables, Inference.Heuristics how) {
        int i;
        this.dnet = decisionNetwork;
        this.numVariablesToEliminate = toEliminate.length;
        this.varToVarInQuery = new HashMap(this.numVariablesToEliminate * 3 / 2);
        if (nrInitFactors < 1) {
            throw new IllegalArgumentException("Number of initial factors has to be greater than 0.");
        }
        this.finalFactors = new Factor[nrInitFactors + 1];
        this.numFinalFactors = 0;
        if (!(how.equals((Object)Inference.Heuristics.GIVEN) || how.equals((Object)Inference.Heuristics.MIN_FACTOR) || how.equals((Object)Inference.Heuristics.MIN_DEGREE) || how.equals((Object)Inference.Heuristics.MIN_FILL) || how.equals((Object)Inference.Heuristics.MAX_CARDINALITY))) {
            throw new IllegalArgumentException("Wrong ordering heuristic!");
        }
        this.how = how;
        this.createHeapSpace(toEliminate, numVariables);
        this.factorIndex = new HashMap((int)Math.round(1.4 * (double)numVariables));
        while (variablesIterator.hasNext()) {
            this.factorIndex.put(variablesIterator.next(), new HashSet());
        }
        while (initFactorsIterator.hasNext()) {
            this.add(initFactorsIterator.next());
        }
        if (this.how.equals((Object)Inference.Heuristics.MIN_DEGREE)) {
            i = 0;
            while (i < this.numVariablesToEliminate) {
                this.varsPQ[i].setMinDegree();
                ++i;
            }
        } else if (this.how.equals((Object)Inference.Heuristics.MIN_FILL)) {
            i = 0;
            while (i < this.numVariablesToEliminate) {
                this.varsPQ[i].setMinFill();
                ++i;
            }
        } else if (this.how.equals((Object)Inference.Heuristics.MIN_FACTOR)) {
            i = 0;
            while (i < this.numVariablesToEliminate) {
                this.varsPQ[i].setMinFactor();
                ++i;
            }
        } else if (this.how.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            i = 0;
            while (i < this.numVariablesToEliminate) {
                this.varsPQ[i].setMaxCardinality();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.numVariablesToEliminate) {
                this.varToVarInQuery.get(toEliminate[i]).setGiven(i);
                ++i;
            }
        }
        i = 1;
        while (i < this.numVariablesToEliminate) {
            this.shuffleUp(i);
            ++i;
        }
    }

    FactorStoreIndexed(FactorStoreIndexed<T> factorStore) {
        this.dnet = factorStore.dnet;
        this.numVariablesToEliminate = factorStore.numVariablesToEliminate;
        this.how = factorStore.how;
        this.last = factorStore.last;
        this.varToVarInQuery = new HashMap();
        this.finalFactors = new Factor[factorStore.finalFactors.length];
        System.arraycopy(factorStore.finalFactors, 0, this.finalFactors, 0, factorStore.finalFactors.length);
        this.numFinalFactors = factorStore.numFinalFactors;
        this.factorIndex = new HashMap();
        for (Map.Entry<Variable, HashSet<Factor>> entry : factorStore.factorIndex.entrySet()) {
            this.factorIndex.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    abstract void createHeapSpace(Variable[] var1, int var2);

    @Override
    public final boolean hasNext() {
        return this.numVariablesToEliminate > 0;
    }

    final Variable nextToEliminate() {
        return this.varsPQ[0].var;
    }

    @Override
    public final Variable next() {
        this.last = this.varsPQ[0];
        this.varsPQ[0] = this.varsPQ[--this.numVariablesToEliminate];
        if (this.how.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            Variable[] variableArray = ((VariableToEliminate)this.last).neighbors;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                VariableToEliminate<T> vte = this.varToVarInQuery.get(neighbour);
                if (vte != null) {
                    vte.setMaxCardinality();
                }
                ++n;
            }
            int i = this.numVariablesToEliminate / 2 - 1;
            while (i >= 0) {
                this.shuffleDown(i);
                --i;
            }
        } else {
            this.shuffleDown(0);
        }
        this.factorIndex.remove(this.last.var);
        return this.last.var;
    }

    final void remove(Variable variable) {
        int i = 0;
        while (!variable.equals(this.varsPQ[i].var)) {
            ++i;
        }
        this.last = this.varsPQ[i];
        this.varsPQ[i] = this.varsPQ[--this.numVariablesToEliminate];
        if (this.how.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            int j = 0;
            while (j < this.last.numNeighbors) {
                VariableToEliminate<T> vte = this.varToVarInQuery.get(((VariableToEliminate)this.last).neighbors[j]);
                if (vte != null) {
                    vte.setMaxCardinality();
                }
                ++j;
            }
            j = this.numVariablesToEliminate / 2 - 1;
            while (j >= 0) {
                this.shuffleDown(j);
                --j;
            }
        } else {
            this.shuffleDown(i);
        }
        this.factorIndex.remove(this.last.var);
        for (Factor factor : this.last.factors) {
            ItrSafe<Variable> variablesIterator = factor.getVariables();
            while (variablesIterator.hasNext()) {
                Variable var = variablesIterator.next();
                VariableToEliminate<T> vte = this.varToVarInQuery.get(var);
                if (vte != null) {
                    if (vte != this.last) {
                        this.factorIndex.get(var).remove(factor);
                    }
                    vte.removeNeighbors(factor);
                    continue;
                }
                this.factorIndex.get(var).remove(factor);
            }
        }
    }

    private void shuffleDown(int pos) {
        int smallest = 2 * pos + 1 < this.numVariablesToEliminate && this.varsPQ[2 * pos + 1].heuristicValue.compareTo(this.varsPQ[pos].heuristicValue) < 0 ? 2 * pos + 1 : pos;
        if (2 * pos + 2 < this.numVariablesToEliminate && this.varsPQ[2 * pos + 2].heuristicValue.compareTo(this.varsPQ[smallest].heuristicValue) < 0) {
            smallest = 2 * pos + 2;
        }
        if (smallest != pos) {
            VariableToEliminate<T> tmp = this.varsPQ[pos];
            this.varsPQ[pos] = this.varsPQ[smallest];
            this.varsPQ[smallest] = tmp;
            this.shuffleDown(smallest);
        }
    }

    private void shuffleUp(int pos) {
        VariableToEliminate<T> tmp = this.varsPQ[pos];
        while (pos > 0 & tmp.heuristicValue.compareTo(this.varsPQ[(pos - 1) / 2].heuristicValue) < 0) {
            this.varsPQ[pos] = this.varsPQ[(pos - 1) / 2];
            pos = (pos - 1) / 2;
        }
        this.varsPQ[pos] = tmp;
    }

    @Override
    public final void addFactorComputed(Factor factor) {
        this.add(factor);
        if (!this.how.equals((Object)Inference.Heuristics.MAX_CARDINALITY) && !this.how.equals((Object)Inference.Heuristics.GIVEN)) {
            VariableToEliminate<T> vte;
            ItrSafe<Variable> variablesIterator;
            if (this.how.equals((Object)Inference.Heuristics.MIN_DEGREE)) {
                variablesIterator = factor.getVariables();
                while (variablesIterator.hasNext()) {
                    vte = this.varToVarInQuery.get(variablesIterator.next());
                    if (vte == null) continue;
                    vte.setMinDegree();
                }
            } else if (this.how.equals((Object)Inference.Heuristics.MIN_FILL)) {
                HashSet<VariableToEliminate<T>> toUpdate = new HashSet<VariableToEliminate<T>>();
                ItrSafe<Variable> variablesIterator2 = factor.getVariables();
                while (variablesIterator2.hasNext()) {
                    VariableToEliminate<T> vte2 = this.varToVarInQuery.get(variablesIterator2.next());
                    if (vte2 == null) continue;
                    toUpdate.add(vte2);
                    int i = 0;
                    while (i < vte2.numNeighbors) {
                        VariableToEliminate<T> vte22 = this.varToVarInQuery.get(((VariableToEliminate)vte2).neighbors[i]);
                        if (vte22 != null) {
                            toUpdate.add(vte22);
                        }
                        ++i;
                    }
                }
                Iterator toUpdateIterator = toUpdate.iterator();
                while (toUpdateIterator.hasNext()) {
                    ((VariableToEliminate)toUpdateIterator.next()).setMinFill();
                }
            } else {
                variablesIterator = factor.getVariables();
                while (variablesIterator.hasNext()) {
                    vte = this.varToVarInQuery.get(variablesIterator.next());
                    if (vte == null) continue;
                    vte.setMinFactor();
                }
            }
            int i = this.numVariablesToEliminate / 2 - 1;
            while (i >= 0) {
                this.shuffleDown(i);
                --i;
            }
        }
    }

    @Override
    public final ItrSafe<Factor> enumFactorsRemoved() {
        return new ItrSafe<Factor>(){
            private Iterator<Factor> factorsIterator;
            {
                this.factorsIterator = ((FactorStoreIndexed)FactorStoreIndexed.this).last.factors.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.factorsIterator.hasNext();
            }

            @Override
            public Factor next() {
                Factor res = this.factorsIterator.next();
                ItrSafe<Variable> variablesIterator = res.getVariables();
                while (variablesIterator.hasNext()) {
                    Variable variable = variablesIterator.next();
                    VariableToEliminate vte = FactorStoreIndexed.this.varToVarInQuery.get(variable);
                    if (vte != null) {
                        if (vte != FactorStoreIndexed.this.last) {
                            FactorStoreIndexed.this.factorIndex.get(variable).remove(res);
                        }
                        vte.removeNeighbors(res);
                        continue;
                    }
                    FactorStoreIndexed.this.factorIndex.get(variable).remove(res);
                }
                return res;
            }
        };
    }

    @Override
    public final ItrSafe<Factor> enumFactorsFinal() {
        return new ItrArray<Factor>(this.finalFactors, this.numFinalFactors);
    }

    @Override
    public int getNumFactorsFinal() {
        return this.numFinalFactors;
    }

    private void add(Factor factor) {
        boolean noVariablesToEliminate = true;
        ItrSafe<Variable> variablesIterator = factor.getVariables();
        while (variablesIterator.hasNext()) {
            Variable variable = variablesIterator.next();
            HashSet<Factor> variableFactorsIndex = this.factorIndex.get(variable);
            variableFactorsIndex.add(factor);
            VariableToEliminate<T> vte = this.varToVarInQuery.get(variable);
            if (vte == null) continue;
            noVariablesToEliminate = false;
            vte.factors = variableFactorsIndex;
            vte.addNeighbors(factor);
        }
        if (noVariablesToEliminate) {
            this.finalFactors[this.numFinalFactors++] = factor;
        }
    }

    @Override
    public abstract FactorStoreIndexed<T> clone();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class VariableToEliminate<T1 extends T> {
        final Variable var;
        private Variable[] neighbors;
        private int[] neighborsCount;
        int numNeighbors;
        HashSet<Factor> factors;
        private int numFactors;
        private long maxCardinality;
        T1 heuristicValue;

        VariableToEliminate(Variable variable, int maxNumNeighs) {
            this.var = variable;
            this.neighbors = new Variable[maxNumNeighs];
            this.numNeighbors = 0;
        }

        VariableToEliminate(VariableToEliminate<T1> variable) {
            this.var = variable.var;
            this.neighbors = new Variable[variable.neighbors.length];
            System.arraycopy(variable.neighbors, 0, this.neighbors, 0, variable.neighbors.length);
            if (variable.neighborsCount != null) {
                this.neighborsCount = new int[variable.neighborsCount.length];
                System.arraycopy(variable.neighborsCount, 0, this.neighborsCount, 0, variable.neighborsCount.length);
            }
            this.numNeighbors = variable.numNeighbors;
            this.numFactors = variable.numFactors;
            this.maxCardinality = variable.maxCardinality;
            this.heuristicValue = variable.cloneHeuristicValue();
        }

        final void addNeighbors(Factor factor) {
            Variable[] newNeighbours = new Variable[this.numNeighbors + factor.getVariablesNum()];
            int[] newNeighboursCount = new int[this.numNeighbors + factor.getVariablesNum()];
            int vPos = 0;
            int nbsPos = 0;
            int newPos = 0;
            while (vPos < factor.getVariablesNum() && nbsPos < this.numNeighbors) {
                if (factor.getVariable(vPos).equals(this.var)) {
                    ++vPos;
                    continue;
                }
                if (factor.getVariable(vPos).equals(this.neighbors[nbsPos])) {
                    newNeighbours[newPos] = factor.getVariable(vPos++);
                    newNeighboursCount[newPos++] = this.neighborsCount[nbsPos++] + 1;
                    continue;
                }
                if (factor.getVariable(vPos).compareTo(this.neighbors[nbsPos]) < 0) {
                    newNeighbours[newPos] = factor.getVariable(vPos++);
                    newNeighboursCount[newPos++] = 1;
                    continue;
                }
                newNeighbours[newPos] = this.neighbors[nbsPos];
                newNeighboursCount[newPos++] = this.neighborsCount[nbsPos++];
            }
            while (vPos < factor.getVariablesNum()) {
                if (factor.getVariable(vPos).equals(this.var)) {
                    ++vPos;
                    continue;
                }
                newNeighbours[newPos] = factor.getVariable(vPos++);
                newNeighboursCount[newPos++] = 1;
            }
            while (nbsPos < this.numNeighbors) {
                newNeighbours[newPos] = this.neighbors[nbsPos];
                newNeighboursCount[newPos++] = this.neighborsCount[nbsPos++];
            }
            this.neighbors = newNeighbours;
            this.neighborsCount = newNeighboursCount;
            this.numNeighbors = newPos;
        }

        final void removeNeighbors(Factor factor) {
            int vPos = 0;
            int nbsPos = 0;
            int newPos = 0;
            while (vPos < factor.getVariablesNum()) {
                if (factor.getVariable(vPos).equals(this.var)) {
                    ++vPos;
                    continue;
                }
                if (factor.getVariable(vPos).equals(this.neighbors[nbsPos])) {
                    if (this.neighborsCount[nbsPos] == 1) {
                        ++vPos;
                        ++nbsPos;
                        continue;
                    }
                    this.neighborsCount[newPos] = this.neighborsCount[nbsPos++] - 1;
                    this.neighbors[newPos++] = factor.getVariable(vPos++);
                    continue;
                }
                this.neighborsCount[newPos] = this.neighborsCount[nbsPos];
                this.neighbors[newPos++] = this.neighbors[nbsPos++];
            }
            while (nbsPos < this.numNeighbors) {
                this.neighborsCount[newPos] = this.neighborsCount[nbsPos];
                this.neighbors[newPos++] = this.neighbors[nbsPos++];
            }
            this.numNeighbors = newPos;
        }

        abstract void setMinDegree();

        final long recomputeMinFill() {
            long result = 0L;
            int i = 0;
            while (i < this.numNeighbors - 1) {
                boolean[] neighboursAdj = new boolean[this.numNeighbors - (i + 1)];
                for (Factor factor : FactorStoreIndexed.this.factorIndex.get(this.neighbors[i])) {
                    int nbsAdjPos = 0;
                    int nbsPos = i + 1;
                    int fctPos = 0;
                    while (factor.getVariable(fctPos).compareTo(this.neighbors[i]) < 0) {
                        ++fctPos;
                    }
                    ++fctPos;
                    while (fctPos < factor.getVariablesNum() && nbsPos < this.numNeighbors) {
                        if (factor.getVariable(fctPos).equals(this.neighbors[nbsPos])) {
                            neighboursAdj[nbsAdjPos++] = true;
                            ++fctPos;
                            ++nbsPos;
                            continue;
                        }
                        if (factor.getVariable(fctPos).compareTo(this.neighbors[nbsPos]) < 0) {
                            ++fctPos;
                            continue;
                        }
                        ++nbsPos;
                        ++nbsAdjPos;
                    }
                }
                boolean[] blArray = neighboursAdj;
                int n = 0;
                int n2 = blArray.length;
                while (n < n2) {
                    boolean isAdjacent = blArray[n];
                    if (!isAdjacent) {
                        ++result;
                    }
                    ++n;
                }
                ++i;
            }
            return result;
        }

        abstract void setMinFill();

        final long recomputeMinFactor() {
            long result = 1L;
            int i = 0;
            while (i < this.numNeighbors) {
                result *= (long)this.neighbors[i].getDomainSize();
                ++i;
            }
            return result;
        }

        abstract void setMinFactor();

        final long recomputeMaxCardinality() {
            return this.maxCardinality--;
        }

        abstract void setMaxCardinality();

        abstract void setGiven(int var1);

        abstract T1 cloneHeuristicValue();

        public final String toString() {
            StringBuilder buffer = new StringBuilder(this.var + " N[");
            int i = 0;
            while (i < this.numNeighbors) {
                buffer.append(this.neighbors[i] + "-" + this.neighborsCount[i] + " ");
                ++i;
            }
            buffer.append("] F(" + this.numFactors + ") H(" + this.heuristicValue + ")");
            return buffer.toString();
        }
    }
}

