/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorStoreIndexed;
import CIspace.ve.FactorStoreIndexedBN;
import CIspace.ve.FactorStoreUnordered;
import CIspace.ve.FactorTimes;
import CIspace.ve.Inference;
import CIspace.ve.QueryStepByStep;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrIterator;
import CIspace.ve.tools.ItrSafe;
import CIspace.ve.tools.Pair;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class InferenceStepByStep<FS extends FactorStoreIndexed, BP, R extends Inference.Result>
extends Inference {
    protected final DecisionNetwork decisionNetwork;
    protected State<FS, R> state;
    protected final LinkedList<Pair<Operations, State<FS, R>>> trace;

    protected InferenceStepByStep(DecisionNetwork decisionNetwork, Configuration configuration) {
        super(configuration);
        this.decisionNetwork = decisionNetwork;
        this.state = new State();
        this.trace = new LinkedList();
    }

    protected InferenceStepByStep(InferenceStepByStep<FS, BP, R> inferenceStepByStep) {
        super(inferenceStepByStep);
        this.decisionNetwork = inferenceStepByStep.decisionNetwork;
        this.state = inferenceStepByStep.state.clone();
        this.trace = new LinkedList<Pair<Operations, State<FS, R>>>(inferenceStepByStep.trace);
    }

    protected int save(Operations operation) {
        this.trace.add(new Pair<Operations, Object>(operation, this.state.clone()));
        return this.trace.size();
    }

    protected Operations load(int stateNr) {
        Pair<Operations, State<FS, R>> toLoad;
        if (stateNr < 0 || stateNr >= this.trace.size()) {
            throw new IllegalArgumentException("StateNr is less than zero or greater or equal to the number of states stored in the trace object.");
        }
        if (stateNr == 0) {
            toLoad = this.trace.getFirst();
            this.trace.clear();
        } else if (stateNr == this.trace.size() - 1) {
            toLoad = this.trace.getLast();
            this.trace.removeLast();
        } else {
            toLoad = this.trace.get(stateNr);
            int i = this.trace.size();
            while (i > stateNr) {
                this.trace.removeLast();
                --i;
            }
        }
        this.state = toLoad.getSecondElement();
        return toLoad.getFirstElement();
    }

    protected void undoSave() {
        if (this.trace.size() == 0) {
            throw new UnsupportedOperationException("There is no save operation to undo.");
        }
        this.trace.removeLast();
    }

    public final Iterator<Factor> getFactorsRemoved() {
        if (this.state.flags.contains((Object)Flags.ELIMINATION_STARTED) && !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE) && !this.state.flags.contains((Object)Flags.NORMALIZATION_DONE)) {
            return this.state.factorStoreST.enumFactorsRemoved();
        }
        return new ItrIterator<Factor>(this.state.removedFactors.iterator());
    }

    public final Iterator<Factor> getFactorsOld() {
        return new ItrIterator<Factor>(this.state.oldFactors.iterator());
    }

    public final Iterator<Factor> getFactorsComputed() {
        if (this.state.flags.contains((Object)Flags.ELIMINATION_STARTED) && !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE) && !this.state.flags.contains((Object)Flags.NORMALIZATION_DONE)) {
            return new ItrArray<Factor>(new Factor[]{this.state.factorStoreST.factorComputed()}, 1);
        }
        return new ItrIterator<Factor>(this.state.computedFactors.iterator());
    }

    public final Iterator<Factor> getFactorsRemaining() {
        if (this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED) && (!this.state.flags.contains((Object)Flags.ELIMINATION_DONE) || !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE) && !this.state.flags.contains((Object)Flags.NORMALIZATION_DONE) && (this.state.flags.contains((Object)Flags.MULTIPLICATION_NECESSARY) || this.state.flags.contains((Object)Flags.NORMALIZATION_NECESSARY)))) {
            return new ItrSafe<Factor>(){
                private Iterator<Factor> finalFactorsIterator;
                private Iterator<Factor> remainingFactorsIterator;
                {
                    this.finalFactorsIterator = InferenceStepByStep.this.state.factorStoreST.enumFactorsFinal();
                    this.remainingFactorsIterator = InferenceStepByStep.this.state.factorStoreST.enumFactorsRemaining();
                }

                @Override
                public boolean hasNext() {
                    return this.remainingFactorsIterator.hasNext() || this.finalFactorsIterator.hasNext();
                }

                @Override
                public Factor next() {
                    if (this.finalFactorsIterator.hasNext()) {
                        return this.finalFactorsIterator.next();
                    }
                    return this.remainingFactorsIterator.next();
                }
            };
        }
        return new ItrIterator<Factor>(this.state.remainingFactors.iterator());
    }

    public final boolean isIrrelevant(Variable variable) {
        if (this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics have already been initialized. Pruning has to be done before.");
        }
        if (this.state.flags.contains((Object)Flags.PROJECTION_DONE)) {
            throw new UnsupportedOperationException("Observations have already been projected. Pruning has to be done before.");
        }
        if (this.state.flags.contains((Object)Flags.PROJECTION_STARTED)) {
            throw new UnsupportedOperationException("Observations are already being projected. Pruning has to be done before.");
        }
        if (!this.decisionNetwork.containsVariable(variable)) {
            throw new IllegalArgumentException("Variable '" + variable.getName(false) + "' is not in the network.");
        }
        return !this.state.relevantVariables.contains(variable);
    }

    public abstract Iterator<Variable> pruneIrrelevantVariables();

    public final Iterator<Variable> getPrunedVariables() {
        return ((Inference.Result)this.state.result).getPrunedVariables();
    }

    public final boolean moreToProject() {
        return this.state.flags.contains((Object)Flags.PROJECTION_NECESSARY) && !this.state.flags.contains((Object)Flags.PROJECTION_DONE);
    }

    public abstract void projectObservation(Variable var1);

    public final Iterator<Variable> getObservedVariables() {
        return new ItrIterator<Variable>(this.state.observedVars.iterator());
    }

    public abstract void initializeHeuristics();

    public final boolean moreToEliminate() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        return this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) && !this.state.flags.contains((Object)Flags.ELIMINATION_DONE);
    }

    public final Variable getProposedVariable(Inference.Heuristics heuristic) {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        if (!this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) || this.state.flags.contains((Object)Flags.ELIMINATION_DONE)) {
            throw new UnsupportedOperationException("All variables have been already eliminated.");
        }
        if (heuristic.equals((Object)Inference.Heuristics.MIN_FACTOR) || heuristic.equals((Object)Inference.Heuristics.MIN_WEIGHT)) {
            return ((FactorStoreIndexed)this.state.min_factor_Store).nextToEliminate();
        }
        if (heuristic.equals((Object)Inference.Heuristics.MIN_DEGREE) || heuristic.equals((Object)Inference.Heuristics.MIN_SIZE)) {
            return ((FactorStoreIndexed)this.state.min_degree_Store).nextToEliminate();
        }
        if (heuristic.equals((Object)Inference.Heuristics.MIN_FILL) || heuristic.equals((Object)Inference.Heuristics.MIN_DEFICIENCY) || heuristic.equals((Object)Inference.Heuristics.MIN_DISCREPANCY) || heuristic.equals((Object)Inference.Heuristics.DEFAULT)) {
            return ((FactorStoreIndexed)this.state.min_fill_Store).nextToEliminate();
        }
        if (heuristic.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            return ((FactorStoreIndexed)this.state.max_cardinality_Store).nextToEliminate();
        }
        if (heuristic.equals((Object)Inference.Heuristics.SEQUENTIAL)) {
            return ((FactorStoreIndexed)this.state.sequential_Store).nextToEliminate();
        }
        if (heuristic.equals((Object)Inference.Heuristics.RANDOM)) {
            return ((FactorStoreIndexed)this.state.random_Store).nextToEliminate();
        }
        throw new IllegalArgumentException("Wrong ordering heuristic.");
    }

    public abstract BP eliminate(Variable var1);

    public final Iterator<Variable> getPartialEliminationOrdering() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        return new ItrIterator<Variable>(((Inference.Result)this.state.result).eliminationOrdering.iterator());
    }

    public final boolean finalMultiplicationNeeded() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        if (this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) && !this.state.flags.contains((Object)Flags.ELIMINATION_DONE)) {
            throw new UnsupportedOperationException("Some variables have not been eliminated yet.");
        }
        if (this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE)) {
            throw new UnsupportedOperationException("Final factors have already been multiplied.");
        }
        return this.state.flags.contains((Object)Flags.MULTIPLICATION_NECESSARY) && !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE);
    }

    public final void multiplyFinalFactors() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        if (this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) && !this.state.flags.contains((Object)Flags.ELIMINATION_DONE)) {
            throw new UnsupportedOperationException("Some variables have not been eliminated yet.");
        }
        if (this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE)) {
            throw new UnsupportedOperationException("Final factors have already been multiplied.");
        }
        if (!this.state.flags.contains((Object)Flags.MULTIPLICATION_NECESSARY)) {
            throw new UnsupportedOperationException("There is only one final factor, multiplication is not necessary.");
        }
        this.save(Operations.MULTIPLICATION);
        Iterator<Factor> previouslyRemovedFactors = this.getFactorsRemoved();
        while (previouslyRemovedFactors.hasNext()) {
            this.state.oldFactors.add(previouslyRemovedFactors.next());
        }
        ItrSafe<Factor> finalFactors = this.state.factorStoreST.enumFactorsFinal();
        Factor product = this.state.factorStoreST.existsFactorComputed() ? this.state.factorStoreST.factorComputed() : (Factor)finalFactors.next();
        this.state.removedFactors.clear();
        this.state.removedFactors.add(product);
        while (finalFactors.hasNext()) {
            Factor finalFactor = (Factor)finalFactors.next();
            product = new FactorTimes(product, finalFactor);
            this.state.removedFactors.add(finalFactor);
        }
        if (((Inference.Result)this.state.result).maxFactorSize < product.getSize()) {
            ((Inference.Result)this.state.result).maxFactorSize = product.getSize();
        }
        this.state.computedFactors.clear();
        this.state.computedFactors.add(product);
        this.state.factorsArchive.put(product.getId(), product);
        this.state.flags.add(Flags.MULTIPLICATION_DONE);
        if (!this.state.flags.contains((Object)Flags.NORMALIZATION_NECESSARY)) {
            ((Inference.Result)this.state.result).factor = product;
            if (!this.state.flags.contains((Object)Flags.EVIDENCE_QUERY)) {
                ((Inference.Result)this.state.result).normFactor = ((Inference.Result)this.state.result).factor;
            }
        }
    }

    public final boolean normalizationNeeded() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        if (this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) && !this.state.flags.contains((Object)Flags.ELIMINATION_DONE)) {
            throw new UnsupportedOperationException("Some variables have not been eliminated yet.");
        }
        if (this.state.flags.contains((Object)Flags.MULTIPLICATION_NECESSARY) && !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE)) {
            throw new UnsupportedOperationException("Final factors have not been multiplied yet.");
        }
        return this.state.flags.contains((Object)Flags.NORMALIZATION_NECESSARY);
    }

    public abstract void normalize();

    public abstract QueryStepByStep getEvidenceQuery();

    public final R getResult() {
        if (!this.state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
            throw new UnsupportedOperationException("Heuristics haven't been initialized yet.");
        }
        if (this.state.flags.contains((Object)Flags.ELIMINATION_NECESSARY) && !this.state.flags.contains((Object)Flags.ELIMINATION_DONE)) {
            throw new UnsupportedOperationException("Some variables have not been eliminated yet.");
        }
        if (this.state.flags.contains((Object)Flags.MULTIPLICATION_NECESSARY) && !this.state.flags.contains((Object)Flags.MULTIPLICATION_DONE)) {
            throw new UnsupportedOperationException("Final factors have not been multiplied yet.");
        }
        if (this.state.flags.contains((Object)Flags.NORMALIZATION_NECESSARY) && !this.state.flags.contains((Object)Flags.NORMALIZATION_DONE)) {
            throw new UnsupportedOperationException("Final factor has not been normalized yet.");
        }
        return (R)((Inference.Result)this.state.result).clone();
    }

    public final Factor getFactor(int uniqueId) {
        Factor factor = this.state.factorsArchive.get(uniqueId);
        if (factor == null) {
            throw new IllegalArgumentException("Factor with given uniqueId hasn't been encountered during computation.");
        }
        return factor;
    }

    public final long getMaxFactorSizeSoFar() {
        return ((Inference.Result)this.state.result).maxFactorSize;
    }

    public final long getMaxStoredFactorSize() {
        return ((Inference.Result)this.state.result).maxStoredFactorSize;
    }

    public final EnumSet<Flags> getInferenceFlags() {
        return this.state.flags.clone();
    }

    public Operations getLastStep() {
        if (this.trace.size() == 0) {
            throw new UnsupportedOperationException("No step was performed.");
        }
        return this.trace.getLast().getFirstElement();
    }

    public abstract InferenceStepByStep<FS, BP, R> clone();

    public final void reset() {
        if (this.trace.size() > 0) {
            this.load(0);
        }
    }

    public final Operations back() {
        if (this.trace.size() == 0) {
            throw new UnsupportedOperationException("There is no step to reverse.");
        }
        return this.load(this.trace.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        UTILITY_QUERY,
        EVIDENCE_QUERY,
        PRUNING_DONE,
        PROJECTION_NECESSARY,
        PROJECTION_STARTED,
        PROJECTION_DONE,
        HEURISTICS_INITIALIZED,
        ELIMINATION_NECESSARY,
        ELIMINATION_STARTED,
        ELIMINATION_DONE,
        MULTIPLICATION_NECESSARY,
        MULTIPLICATION_DONE,
        NORMALIZATION_NECESSARY,
        NORMALIZATION_DONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operations {
        PRUNING,
        PROJECTION,
        INITIALIZATION,
        ELIMINATION,
        MULTIPLICATION,
        NORMALIZATION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class State<FSbis extends FactorStoreIndexed, Rbis extends Inference.Result> {
        protected LinkedList<Variable> variables;
        protected LinkedList<Variable> observedVars;
        protected LinkedList<Variable> toBeObservedVars;
        protected LinkedList<Integer> toBeObservedVals;
        protected LinkedList<Factor> removedFactors;
        protected LinkedList<Factor> oldFactors;
        protected LinkedList<Factor> computedFactors;
        protected LinkedList<Factor> remainingFactors;
        protected HashSet<Variable> relevantVariables;
        protected HashSet<Variable> observedVariables;
        protected FSbis min_factor_Store;
        protected FSbis min_degree_Store;
        protected FSbis min_fill_Store;
        protected FSbis max_cardinality_Store;
        protected FSbis sequential_Store;
        protected FSbis random_Store;
        protected FactorStoreUnordered factorStoreST;
        protected FactorStoreIndexedBN factorStorePE;
        protected LinkedList<Factor> remainingFactorsPE;
        protected Rbis result;
        protected HashMap<Integer, Factor> factorsArchive;
        protected EnumSet<Flags> flags;

        State() {
        }

        private State(State<FSbis, Rbis> state) {
            this.variables = new LinkedList<Variable>(state.variables);
            this.observedVars = new LinkedList<Variable>(state.observedVars);
            this.toBeObservedVars = new LinkedList<Variable>(state.toBeObservedVars);
            this.toBeObservedVals = new LinkedList<Integer>(state.toBeObservedVals);
            this.removedFactors = new LinkedList<Factor>(state.removedFactors);
            this.oldFactors = new LinkedList<Factor>(state.oldFactors);
            this.computedFactors = new LinkedList<Factor>(state.computedFactors);
            this.remainingFactors = new LinkedList<Factor>(state.remainingFactors);
            if (state.relevantVariables != null) {
                this.relevantVariables = new HashSet<Variable>(state.relevantVariables);
            }
            if (state.observedVariables != null) {
                this.observedVariables = new HashSet<Variable>(state.observedVariables);
            }
            if (state.flags.contains((Object)Flags.HEURISTICS_INITIALIZED)) {
                this.min_factor_Store = ((FactorStoreIndexed)state.min_factor_Store).clone();
                this.min_degree_Store = ((FactorStoreIndexed)state.min_degree_Store).clone();
                this.min_fill_Store = ((FactorStoreIndexed)state.min_fill_Store).clone();
                this.max_cardinality_Store = ((FactorStoreIndexed)state.max_cardinality_Store).clone();
                this.sequential_Store = ((FactorStoreIndexed)state.sequential_Store).clone();
                this.random_Store = ((FactorStoreIndexed)state.random_Store).clone();
                this.factorStoreST = state.factorStoreST.clone();
                if (state.factorStorePE != null) {
                    this.factorStorePE = state.factorStorePE.clone();
                    this.remainingFactorsPE = new LinkedList<Factor>(state.remainingFactorsPE);
                }
            }
            this.result = ((Inference.Result)state.result).clone();
            this.factorsArchive = new HashMap<Integer, Factor>(state.factorsArchive);
            this.flags = state.flags.clone();
        }

        public final State<FSbis, Rbis> clone() {
            return new State<FSbis, Rbis>(this);
        }
    }
}

