/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.DecisionNetwork;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrSafe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class MoralGraph {
    private final HashMap<Variable, HashSet<Variable>> neighbors = new HashMap();

    MoralGraph(DecisionNetwork.Graph dag) {
        Iterator<Variable> variablesIterator = dag.getVariables();
        while (variablesIterator.hasNext()) {
            this.neighbors.put(variablesIterator.next(), new HashSet());
        }
        variablesIterator = dag.getVariables();
        while (variablesIterator.hasNext()) {
            Variable child = variablesIterator.next();
            ItrSafe<Variable> parentsIterator = dag.getParents(child);
            HashSet<Variable> neighboursSet = this.neighbors.get(child);
            while (parentsIterator.hasNext()) {
                neighboursSet.add((Variable)parentsIterator.next());
            }
            parentsIterator = dag.getParents(child);
            while (parentsIterator.hasNext()) {
                Variable parent = (Variable)parentsIterator.next();
                neighboursSet = this.neighbors.get(parent);
                neighboursSet.add(child);
                ItrSafe<Variable> parentsIteratorBis = dag.getParents(child);
                while (parentsIteratorBis.hasNext()) {
                    Variable parentBis = (Variable)parentsIteratorBis.next();
                    if (parent.equals(parentBis)) continue;
                    neighboursSet.add(parentBis);
                }
            }
        }
    }

    int markRelevant(Set<Variable> relevantVariables, Variable relevantVariable, Set<Variable> observedVariables, DecisionNetwork decisionNetwork) {
        int result = 0;
        if (!relevantVariables.contains(relevantVariable)) {
            relevantVariables.add(relevantVariable);
            result = 1;
            if (!observedVariables.contains(relevantVariable)) {
                Iterator<Variable> neighborsIterator = this.neighbors.get(relevantVariable).iterator();
                while (neighborsIterator.hasNext()) {
                    result += this.markRelevant(relevantVariables, neighborsIterator.next(), observedVariables, decisionNetwork);
                }
            }
        }
        return result;
    }
}

