/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Factor;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorObserved;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrSafe;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
final class ObservedFactorsIterator
extends ItrSafe<Factor> {
    private final Iterator<Factor> factorsIterator;
    private final Variable[] observedVars;
    private final int[] observedVals;
    private final boolean countRelevantObservations;
    private int relevantObsNum;
    private final boolean saveForTracing;

    int getRelevantObsNum() {
        if (!this.countRelevantObservations) {
            throw new UnsupportedOperationException("Iterator wasn't counting relevantObservations.");
        }
        return this.relevantObsNum;
    }

    ObservedFactorsIterator(Iterator<Factor> factorsIterator, Variable[] observedVars, int[] observedVals, boolean countRelevantObservations, boolean saveForTracing) {
        this.factorsIterator = factorsIterator;
        this.observedVars = observedVars;
        this.observedVals = observedVals;
        this.countRelevantObservations = countRelevantObservations;
        this.saveForTracing = saveForTracing;
    }

    @Override
    public boolean hasNext() {
        return this.factorsIterator.hasNext();
    }

    @Override
    public Factor next() {
        if (this.factorsIterator.hasNext()) {
            Factor originalFactor = this.factorsIterator.next();
            if (this.countRelevantObservations && originalFactor instanceof FactorDistribution && Arrays.binarySearch(this.observedVars, ((FactorDistribution)((Object)originalFactor)).getChild()) >= 0) {
                ++this.relevantObsNum;
            }
            try {
                return FactorObserved.projectObservation(originalFactor, this.observedVars, this.observedVals, this.saveForTracing);
            }
            catch (IllegalArgumentException e) {
                return originalFactor;
            }
        }
        throw new NoSuchElementException();
    }
}

