/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorDecision;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorDivide;
import CIspace.ve.FactorMax;
import CIspace.ve.FactorStoreIndexedBN;
import CIspace.ve.FactorStoreIndexedDN;
import CIspace.ve.FactorStored;
import CIspace.ve.FactorSumOut;
import CIspace.ve.FactorTimes;
import CIspace.ve.FactorUtility;
import CIspace.ve.Inference;
import CIspace.ve.ObservedFactorsIterator;
import CIspace.ve.Policy;
import CIspace.ve.QueryCompute;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrSafe;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public final class PolicyCompute
extends Policy {
    public PolicyCompute(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(decisionNetwork, observedVars, observedVals, configuration);
        Variable[] toEliminate;
        Inference.Heuristics heuristic;
        ObservedFactorsIterator observedFactorsIteratorST;
        int factorsNum;
        int variablesNum;
        Iterator<Variable> variablesIteratorST;
        this.result.maxFactorSize = decisionNetwork.getMaxFactorSize();
        this.result.maxStoredFactorSize = decisionNetwork.getMaxFactorSize();
        Iterator<Variable> variablesIteratorTE = decisionNetwork.getVariables();
        Iterator<Variable> variablesIteratorPE = null;
        Iterator<Factor> factorsIteratorST = decisionNetwork.getFactors(true);
        Iterator<Factor> factorsIteratorPE = null;
        if (configuration.getPruneIrrelevantVariables()) {
            HashSet<Variable> relevantVariables = new HashSet<Variable>();
            HashSet<Variable> observedVariables = new HashSet<Variable>();
            Policy.markRelevantNodes(decisionNetwork, new ItrArray<Variable>(observedVars, observedVars.length), relevantVariables, observedVariables);
            LinkedList<Variable> variablesList = new LinkedList<Variable>();
            while (variablesIteratorTE.hasNext()) {
                Variable variable = (Variable)variablesIteratorTE.next();
                if (relevantVariables.contains(variable)) {
                    variablesList.add(variable);
                    continue;
                }
                this.result.prunedVariables.add(variable);
                if (!(variable instanceof VariableDecision)) continue;
                this.result.decisionToDecisionFunction.put((VariableDecision)variable, FactorDecision.createSimple((VariableDecision)variable, decisionNetwork.getParents(variable), decisionNetwork.getParentsNum(variable)));
            }
            variablesIteratorTE = variablesList.iterator();
            variablesIteratorST = variablesList.iterator();
            variablesNum = variablesList.size();
            Variable[] observedVarsTemp = new Variable[observedVars.length];
            int[] observedValsTemp = new int[observedVals.length];
            int posInTemp = 0;
            int i = 0;
            while (i < observedVars.length) {
                if (relevantVariables.contains(observedVars[i])) {
                    observedVarsTemp[posInTemp] = observedVars[i];
                    observedValsTemp[posInTemp++] = observedVals[i];
                } else {
                    this.result.prunedVariables.add(observedVars[i]);
                }
                ++i;
            }
            observedVars = new Variable[posInTemp];
            observedVals = new int[posInTemp];
            System.arraycopy(observedVarsTemp, 0, observedVars, 0, posInTemp);
            System.arraycopy(observedValsTemp, 0, observedVals, 0, posInTemp);
            LinkedList<Factor> factorsList = new LinkedList<Factor>();
            block2: while (factorsIteratorST.hasNext()) {
                Factor factor = (Factor)factorsIteratorST.next();
                if (!(factor instanceof FactorUtility)) {
                    Variable childVariable = ((FactorDistribution)((Object)factor)).getChild();
                    if (!relevantVariables.contains(childVariable)) continue;
                    if (!observedVariables.contains(childVariable)) {
                        factorsList.add(factor);
                        continue;
                    }
                    int i2 = 0;
                    while (i2 < factor.getVariablesNum()) {
                        Variable factorVariable;
                        if (i2 != ((FactorDistribution)((Object)factor)).getChildIndex() && !observedVariables.contains(factorVariable = factor.getVariable(i2))) {
                            if (!relevantVariables.contains(factorVariable)) continue block2;
                            factorsList.add(factor);
                            continue block2;
                        }
                        ++i2;
                    }
                    continue;
                }
                factorsList.add(factor);
            }
            factorsIteratorST = factorsList.iterator();
            factorsNum = factorsList.size();
            if (observedVars.length != 0 && factorsNum > 1) {
                variablesIteratorPE = variablesList.iterator();
                factorsIteratorPE = factorsList.listIterator(1);
            }
        } else {
            variablesIteratorST = decisionNetwork.getVariables();
            variablesNum = decisionNetwork.getNumVariables();
            factorsNum = decisionNetwork.getNumProbFactors() + 1;
            if (observedVars.length != 0) {
                variablesIteratorPE = decisionNetwork.getVariables();
                factorsIteratorPE = decisionNetwork.getFactors(false);
            }
        }
        ObservedFactorsIterator observedFactorsIteratorPE = null;
        if (observedVars.length != 0) {
            observedFactorsIteratorST = new ObservedFactorsIterator(factorsIteratorST, observedVars, observedVals, configuration.getPruneIrrelevantVariables() && factorsIteratorPE != null, this.configuration.getFactorSavingForTracing());
            if (factorsIteratorPE != null) {
                observedFactorsIteratorPE = new ObservedFactorsIterator(factorsIteratorPE, observedVars, observedVals, false, this.configuration.getFactorSavingForTracing());
            }
        } else {
            observedFactorsIteratorST = factorsIteratorST;
        }
        if ((heuristic = this.configuration.getEliminationHeuristic()).equals((Object)Inference.Heuristics.GIVEN)) {
            toEliminate = this.result.prunedVariables.size() == 0 ? this.configuration.eliminationOrdering() : Variable.diffVars2(this.configuration.eliminationOrdering(), this.result.prunedVariables);
        } else {
            toEliminate = Policy.determineToEliminate(variablesIteratorTE, variablesNum, observedVars);
            if (heuristic.equals((Object)Inference.Heuristics.SEQUENTIAL)) {
                heuristic = Inference.Heuristics.GIVEN;
            } else if (this.configuration.getEliminationHeuristic().equals((Object)Inference.Heuristics.RANDOM)) {
                Variable.shuffle(toEliminate);
                heuristic = Inference.Heuristics.GIVEN;
            }
        }
        FactorStoreIndexedDN factors = new FactorStoreIndexedDN(decisionNetwork, toEliminate, observedFactorsIteratorST, factorsNum, variablesIteratorST, variablesNum, heuristic);
        FactorStoreIndexedBN factorsPE = null;
        if (!(observedFactorsIteratorPE == null || this.configuration.getPruneIrrelevantVariables() && observedFactorsIteratorST.getRelevantObsNum() <= 0)) {
            factorsPE = new FactorStoreIndexedBN(decisionNetwork, toEliminate, observedFactorsIteratorPE, factorsNum - 1, variablesIteratorPE, variablesNum, heuristic);
        }
        while (factors.hasNext()) {
            FactorStored newFac;
            Variable elimVar = factors.next();
            this.result.eliminationOrdering.add(elimVar);
            ItrSafe<Factor> toMultiply = factors.enumFactorsRemoved();
            Factor product = (Factor)toMultiply.next();
            while (toMultiply.hasNext()) {
                Factor nextProd = (Factor)toMultiply.next();
                product = new FactorTimes(product, nextProd);
            }
            if (this.result.maxFactorSize < product.getSize()) {
                this.result.maxFactorSize = product.getSize();
            }
            if (elimVar instanceof VariableDecision && decisionNetwork.variableProperties(elimVar).getFactor() == null) {
                newFac = FactorMax.create(product, (VariableDecision)elimVar, this.configuration.getFactorSavingForTracing());
                this.result.decisionToDecisionFunction.put((VariableDecision)elimVar, ((FactorMax)newFac).getDecisionFunction());
                if (factorsPE != null) {
                    factorsPE.addFactorComputed(((FactorMax)newFac).getDecisionFunction());
                }
            } else {
                Variable[] sumOut = new Variable[]{elimVar};
                newFac = FactorSumOut.create(product, sumOut, this.configuration.getFactorSavingForTracing());
            }
            if (this.result.maxStoredFactorSize < newFac.getSize()) {
                this.result.maxStoredFactorSize = newFac.getSize();
            }
            factors.addFactorComputed(newFac);
        }
        ItrSafe<Factor> remainingFactors = factors.enumFactorsFinal();
        Factor product = (Factor)remainingFactors.next();
        while (remainingFactors.hasNext()) {
            product = new FactorTimes(product, (Factor)remainingFactors.next());
        }
        if (this.result.maxFactorSize < product.getSize()) {
            this.result.maxFactorSize = product.getSize();
        }
        this.result.factor = product;
        if (factorsPE == null) {
            this.result.normFactor = this.result.factor;
        } else {
            this.result.evidenceQueryResult = new QueryCompute(factorsPE, configuration).getResult();
            if (this.result.evidenceQueryResult.getFactor().iterator().next() == 0.0) {
                throw new ArithmeticException("Probability of evidence is 0.0!");
            }
            this.result.normFactor = new FactorDivide(this.result.factor, this.result.evidenceQueryResult.getFactor(), this.configuration.getFactorSavingForTracing());
        }
    }
}

