/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Property;
import CIspace.ve.PropertyGeneric;
import net.jcip.annotations.Immutable;

@Immutable
public class PropertyPosition
extends Property {
    private final double posX;
    private final double posY;

    public final double getPosX() {
        return this.posX;
    }

    public final double getPosY() {
        return this.posY;
    }

    public PropertyPosition(double posX, double posY) {
        super("position");
        this.posX = posX;
        this.posY = posY;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "(" + this.posX + ", " + this.posY + ")";
    }

    public static PropertyPosition parsePosition(String valueString) {
        String valueStringTrimmed = valueString.trim();
        if (valueStringTrimmed.indexOf(40) != 0) {
            throw new IllegalArgumentException("Expected '('.");
        }
        if (valueStringTrimmed.lastIndexOf(41) != valueStringTrimmed.length() - 1) {
            throw new IllegalArgumentException("Expected ')'.");
        }
        int indexOfColon = valueStringTrimmed.indexOf(44);
        if (indexOfColon == -1) {
            throw new IllegalArgumentException("Expected ','.");
        }
        try {
            return new PropertyPosition(Double.parseDouble(valueStringTrimmed.substring(1, indexOfColon).trim()), Double.parseDouble(valueStringTrimmed.substring(indexOfColon + 1, valueStringTrimmed.length() - 1).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid number describing variable's position.");
        }
    }

    public static PropertyPosition parse(String propertyString) {
        if (!Property.parseName(propertyString).toLowerCase().equals("position")) {
            throw new IllegalArgumentException("It is not a position property.");
        }
        return PropertyPosition.parsePosition(PropertyGeneric.parseValue(propertyString));
    }
}

