/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorStore;
import CIspace.ve.FactorSumOut;
import CIspace.ve.FactorTimes;
import CIspace.ve.Query;
import CIspace.ve.Variable;
import CIspace.ve.tools.ItrSafe;

public final class QueryCompute
extends Query {
    public QueryCompute(Variable[] queryVars, DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(queryVars, decisionNetwork, observedVars, observedVals, configuration);
        this.performInference(queryVars, decisionNetwork, observedVars, observedVals);
    }

    public QueryCompute(DecisionNetwork decisionNetwork, Variable[] observedVars, int[] observedVals, Configuration configuration) {
        super(decisionNetwork, observedVars, observedVals, configuration);
        this.performInference(decisionNetwork, observedVars, observedVals);
    }

    QueryCompute(FactorStore factors, Configuration configuration) {
        super(configuration);
        this.result.factor = this.eliminateVariables(factors);
    }

    Factor eliminateVariables(FactorStore factors) {
        while (factors.hasNext()) {
            Variable[] sumOut;
            FactorSumOut newFac;
            Variable elimVar = factors.next();
            this.result.eliminationOrdering.add(elimVar);
            ItrSafe<Factor> toMultiply = factors.enumFactorsRemoved();
            Factor product = (Factor)toMultiply.next();
            while (toMultiply.hasNext()) {
                Factor nextProd = (Factor)toMultiply.next();
                product = new FactorTimes(product, nextProd);
            }
            if (this.result.maxFactorSize < product.getSize()) {
                this.result.maxFactorSize = product.getSize();
            }
            if (this.result.maxStoredFactorSize < (newFac = FactorSumOut.create(product, sumOut = new Variable[]{elimVar}, this.configuration.getFactorSavingForTracing())).getSize()) {
                this.result.maxStoredFactorSize = newFac.getSize();
            }
            factors.addFactorComputed(newFac);
        }
        ItrSafe<Factor> remainingFactors = factors.enumFactorsFinal();
        Factor product = (Factor)remainingFactors.next();
        while (remainingFactors.hasNext()) {
            product = new FactorTimes(product, (Factor)remainingFactors.next());
        }
        if (this.result.maxFactorSize < product.getSize()) {
            this.result.maxFactorSize = product.getSize();
        }
        return product;
    }
}

