/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.tools.ItrSafe;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Variable
implements Comparable<Variable> {
    protected final String name;
    private AtomicInteger maxElementLength = new AtomicInteger(0);
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final int uniqueId;

    public final String getName(boolean withId) {
        if (withId) {
            return String.valueOf(this.name) + "[" + this.uniqueId + "]";
        }
        return this.name;
    }

    public abstract String getDomainElement(int var1);

    public abstract int getElementIndex(String var1);

    public abstract int getDomainSize();

    public abstract ItrSafe<String> iterator();

    public int getMaxElementLength() {
        if (this.maxElementLength.get() == 0) {
            int result = 0;
            ItrSafe<String> domainIterator = this.iterator();
            while (domainIterator.hasNext()) {
                result = Math.max(result, ((String)domainIterator.next()).length());
            }
            this.maxElementLength.set(result);
        }
        return this.maxElementLength.get();
    }

    public final int getId() {
        return this.uniqueId;
    }

    Variable(String varName) {
        this.name = varName;
        this.uniqueId = nextId.getAndIncrement();
    }

    public boolean equals(Object var) {
        return this.uniqueId == ((Variable)var).uniqueId;
    }

    @Override
    public int compareTo(Variable var) {
        return this.uniqueId - var.uniqueId;
    }

    public final int hashCode() {
        return this.uniqueId;
    }

    public String toString(boolean withId) {
        StringBuilder output = new StringBuilder(this.name);
        if (withId) {
            output.append("[").append(this.uniqueId).append("]");
        }
        output.append(", domain = {");
        ItrSafe<String> domainIterator = this.iterator();
        while (domainIterator.hasNext()) {
            output.append((String)domainIterator.next()).append(", ");
        }
        output.delete(output.length() - 2, output.length());
        output.append("}");
        return output.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public final Object clone() {
        throw new UnsupportedOperationException("Variable has its own unique ID. It can't be cloned. Also it is virtually immutable so there is no point in cloning.");
    }

    protected static final String[] stringToValues(String string) {
        Scanner scanner = new Scanner(string);
        scanner.useLocale(Locale.US);
        scanner.useDelimiter("\\s*,\\s*");
        LinkedList<String> resultList = new LinkedList<String>();
        while (scanner.hasNext()) {
            resultList.add(scanner.next());
        }
        String[] result = new String[resultList.size()];
        return resultList.toArray(result);
    }

    protected static final boolean duplicates(String[] array) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = array;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            if (!set.add(s)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static final Variable[] unionVars(Variable[] variables1, Variable[] variables2) {
        Variable[] variables = new Variable[variables1.length + variables2.length];
        int pos = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < variables1.length && i2 < variables2.length) {
            if (variables1[i1].equals(variables2[i2])) {
                variables[pos++] = variables1[i1++];
                ++i2;
                continue;
            }
            variables[pos++] = variables1[i1].compareTo(variables2[i2]) < 0 ? variables1[i1++] : variables2[i2++];
        }
        while (i1 < variables1.length) {
            variables[pos++] = variables1[i1++];
        }
        while (i2 < variables2.length) {
            variables[pos++] = variables2[i2++];
        }
        Variable[] result = new Variable[pos];
        System.arraycopy(variables, 0, result, 0, pos);
        return result;
    }

    static final Variable[] diffVars(Variable[] variables1, Variable[] variables2) {
        Variable[] variables = new Variable[variables1.length];
        int pos = 0;
        int i1 = 0;
        int i2 = 0;
        while (i1 < variables1.length && i2 < variables2.length) {
            if (variables1[i1].equals(variables2[i2])) {
                ++i1;
                ++i2;
                continue;
            }
            if (variables1[i1].compareTo(variables2[i2]) < 0) {
                variables[pos++] = variables1[i1++];
                continue;
            }
            ++i2;
        }
        while (i1 < variables1.length) {
            variables[pos++] = variables1[i1++];
        }
        Variable[] result = new Variable[pos];
        System.arraycopy(variables, 0, result, 0, pos);
        return result;
    }

    static final Variable[] diffVars2(Variable[] variables1, List<Variable> variables2) {
        LinkedHashSet tempVars1 = new LinkedHashSet(Arrays.asList(variables1));
        Iterator<Variable> vars2Iterator = variables2.iterator();
        while (vars2Iterator.hasNext()) {
            tempVars1.remove(vars2Iterator.next());
        }
        return tempVars1.toArray(new Variable[tempVars1.size()]);
    }

    static final Variable[] removeVariable(Variable[] variables, Variable variable) {
        Variable[] result = new Variable[variables.length - 1];
        int pos = 0;
        while (variables[pos].compareTo(variable) < 0) {
            result[pos] = variables[pos++];
        }
        while (pos < result.length) {
            result[pos++] = variables[pos];
        }
        return result;
    }

    static final Variable[] insert(Variable variable, Variable[] variables) {
        Variable[] result = new Variable[variables.length + 1];
        int pos = 0;
        while (pos < variables.length && variables[pos].compareTo(variable) < 0) {
            result[pos] = variables[pos++];
        }
        if (pos < variables.length && variables[pos].equals(variable)) {
            throw new IllegalArgumentException("Variable " + variable + " is already among list of variables!");
        }
        result[pos] = variable;
        while (pos < variables.length) {
            result[pos + 1] = variables[pos++];
        }
        return result;
    }

    static final Variable[] attach(Variable[] variables, Variable variable) {
        Variable[] result = new Variable[variables.length + 1];
        System.arraycopy(variables, 0, result, 0, variables.length);
        result[variables.length] = variable;
        return result;
    }

    static final Variable[] sort(Variable[] array) {
        Object[] sorted = new Variable[array.length];
        System.arraycopy(array, 0, sorted, 0, array.length);
        Arrays.sort(sorted);
        return sorted;
    }

    static final void shuffle(Variable[] variables) {
        int i = variables.length - 1;
        while (i > 0) {
            int pos = (int)(Math.random() * (double)(i + 1));
            if (pos != i) {
                Variable tmp = variables[i];
                variables[i] = variables[pos];
                variables[pos] = tmp;
            }
            --i;
        }
    }
}

