/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.Variable;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrSafe;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class VariableDecision
extends Variable {
    private final String[] domain;

    @Override
    public String getDomainElement(int index) {
        if (index < 0 || index >= this.domain.length) {
            throw new IllegalArgumentException("");
        }
        return this.domain[index];
    }

    @Override
    public int getDomainSize() {
        return this.domain.length;
    }

    @Override
    public int getElementIndex(String element) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public ItrSafe<String> iterator() {
        return new ItrArray<String>(this.domain, this.domain.length);
    }

    public VariableDecision(String varName, String domain) {
        this(varName, Variable.stringToValues(domain), false);
    }

    public VariableDecision(String varName, String[] domainArray, boolean copyDomain) {
        super(varName);
        if (domainArray.length == 0) {
            throw new IllegalArgumentException("Domain of variable '" + varName + "' is empty!");
        }
        if (Variable.duplicates(domainArray)) {
            throw new IllegalArgumentException("Domain of variable '" + varName + "' contains duplicate elements!");
        }
        if (copyDomain) {
            this.domain = new String[domainArray.length];
            System.arraycopy(domainArray, 0, this.domain, 0, domainArray.length);
        } else {
            this.domain = domainArray;
        }
    }

    @Override
    public String toString(boolean withId) {
        StringBuilder output = new StringBuilder("decision variable ");
        output.append(super.toString(withId));
        return output.toString();
    }
}

