/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve;

import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorInterpretable;
import CIspace.ve.FactorSumOut;
import CIspace.ve.FactorTimes;
import CIspace.ve.Variable;
import CIspace.ve.VariableNatureStored;
import CIspace.ve._FactorDeltaMin;
import CIspace.ve._FactorParentMin;
import CIspace.ve._VariableMaxMin;
import CIspace.ve.tools.ItrArray;
import CIspace.ve.tools.ItrArraySkip;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class _FactorNoisyMin
extends Factor
implements FactorDistribution,
FactorInterpretable {
    private final int childIndex;
    private _VariableMaxMin childPrim;
    private Factor[] factorization;
    private Factor expandedFactor = null;

    @Override
    public int getChildIndex() {
        return this.childIndex;
    }

    @Override
    public Variable getChild() {
        return this.variables[this.childIndex];
    }

    @Override
    public Iterator<Variable> getParents() {
        return new ItrArraySkip<Variable>(this.variables, this.childIndex);
    }

    public _VariableMaxMin getChildPrim() {
        return this.childPrim;
    }

    @Override
    public boolean isDistribution(double threshold) {
        return true;
    }

    public Iterator<Factor> getFactorization() {
        return new ItrArray<Factor>(this.factorization, this.factorization.length);
    }

    public void clearExpandedFactor() {
        this.expandedFactor = null;
    }

    public _FactorNoisyMin(Variable[] parents, Variable child, double[] leak, double[][][] parameters) {
        super(Variable.attach(parents, child), false);
        this.create(leak, parameters);
        this.childIndex = parents.length;
    }

    public _FactorNoisyMin(Variable[] parents, Variable child, double[][][] parameters) {
        super(Variable.attach(parents, child), false);
        double[] leak = new double[child.getDomainSize()];
        leak[child.getDomainSize() - 1] = 1.0;
        this.create(leak, parameters);
        this.childIndex = parents.length;
    }

    private void create(double[] leak, double[][][] parameters) {
        int childLevels = this.variables[this.childIndex].getDomainSize();
        if (this.variables.length < 2) {
            throw new IllegalArgumentException("Not enough Variables in Noisy-MIN Factor!");
        }
        if (leak.length != childLevels) {
            throw new IllegalArgumentException("Incorrect number of parameters for Noisy-MIN leak node!");
        }
        double[] dArray = leak;
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double leakP = dArray[n];
            if (leakP < 0.0 || leakP > 1.0) {
                throw new IllegalArgumentException("Noisy-MIN leak node's parameter outside of the range [0, 1.0] !");
            }
            ++n;
        }
        if (parameters.length != this.variables.length - 1) {
            throw new IllegalArgumentException("Incorrect number of parameters for Noisy-MIN!");
        }
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].length != this.variables[i].getDomainSize() - 1) {
                throw new IllegalArgumentException("Incorrect number of parameters for Noisy-MIN!");
            }
            int j = 0;
            while (j < parameters[i].length) {
                if (parameters[i][j].length != childLevels) {
                    throw new IllegalArgumentException("Incorrect number of parameters for Noisy-MIN!");
                }
                int k = 0;
                while (k < parameters[i][j].length) {
                    if (parameters[i][j][k] < 0.0 || parameters[i][j][k] > 1.0) {
                        throw new IllegalArgumentException("Noisy-MIN parameter outside of the range [0, 1.0] !");
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        double[] leakC = new double[leak.length];
        leakC[childLevels - 1] = leak[childLevels - 1];
        int i2 = childLevels - 2;
        while (i2 >= 0) {
            leakC[i2] = leakC[i2 + 1] + leak[i2];
            --i2;
        }
        if (leakC[0] != 1.0) {
            throw new IllegalArgumentException("Noisy-MIN leak node's parameters do not form a probability distribution!");
        }
        this.childPrim = new _VariableMaxMin((VariableNatureStored)this.variables[this.childIndex]);
        this.factorization = new Factor[this.variables.length];
        this.factorization[this.factorization.length - 1] = new _FactorDeltaMin(this.childPrim, leakC);
        leakC = null;
        int parentIndex = 0;
        int i3 = 0;
        while (i3 < this.variables.length - 1) {
            if (i3 != this.childIndex) {
                double[] probabilitiesC = new double[parameters[parentIndex].length * childLevels];
                int probabilitiesIndex = childLevels - 1;
                int j = 0;
                while (j < parameters[parentIndex].length - 1) {
                    probabilitiesC[probabilitiesIndex--] = parameters[parentIndex][j][childLevels - 1];
                    int k = childLevels - 2;
                    while (k >= 0) {
                        probabilitiesC[probabilitiesIndex] = probabilitiesC[probabilitiesIndex + 1] + parameters[parentIndex][j][k];
                        --k;
                        --probabilitiesIndex;
                    }
                    if (probabilitiesC[0] != 1.0) {
                        throw new IllegalArgumentException("Noisy-MIN parameters do not form a probability distribution!");
                    }
                    probabilitiesIndex += 2 * childLevels - 1;
                    ++j;
                }
                Arrays.fill(probabilitiesC, probabilitiesIndex - childLevels + 1, probabilitiesIndex, 1.0);
                this.factorization[parentIndex++] = new _FactorParentMin(new Variable[]{this.variables[i3], this.childPrim}, probabilitiesC);
                probabilitiesC = null;
            }
            ++i3;
        }
    }

    @Override
    public String getInterpretationFunctor() {
        return "P";
    }

    @Override
    public String getInterpretation(boolean withId) {
        if (this.childIndex < 0) {
            return this.getName(withId);
        }
        StringBuilder nameString = withId ? new StringBuilder("[" + this.getId() + "]" + this.getInterpretationFunctor() + "(") : new StringBuilder(String.valueOf(this.getInterpretationFunctor()) + "(");
        nameString.append(this.variables[this.childIndex].getName(withId));
        if (this.variables.length > 1) {
            nameString.append(" | ");
            int i = 0;
            while (i < this.variables.length) {
                if (i != this.childIndex) {
                    nameString.append(this.variables[i].getName(withId)).append(", ");
                }
                ++i;
            }
            nameString.delete(nameString.length() - 2, nameString.length() - 1);
        }
        return nameString.append(")").toString();
    }

    @Override
    public EltsIterator iterator() {
        if (this.expandedFactor == null) {
            this.expandedFactor = this.factorization[0];
            Factor[] factorArray = this.factorization;
            int n = 0;
            int n2 = factorArray.length;
            while (n < n2) {
                Factor factor = factorArray[n];
                this.expandedFactor = new FactorTimes(this.expandedFactor, factor);
                ++n;
            }
            this.expandedFactor = FactorSumOut.create(this.expandedFactor, new Variable[]{this.childPrim}, false);
        }
        return this.expandedFactor.iterator();
    }
}

