/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.examples;

import CIspace.ve.Configuration;
import CIspace.ve.Query;
import CIspace.ve.QueryCompute;
import CIspace.ve.Variable;
import CIspace.ve.examples.FireXMLBIF;
import CIspace.ve.parsers.BIFv0_10.DecisionNetworkFromBIFv0_10;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class FireBIF {
    public static void main(String[] args) {
        DecisionNetworkFromBIFv0_10 beliefNetwork;
        Configuration configuration = new Configuration();
        System.out.println("\n* Configuration:");
        System.out.println(configuration.toString(false));
        System.out.println("* Loading the network.");
        try {
            beliefNetwork = new DecisionNetworkFromBIFv0_10(new BufferedReader(new InputStreamReader(FireXMLBIF.class.getResourceAsStream("fire.bif"))), configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("* '" + beliefNetwork.getName(false) + "' network loaded.");
        System.out.println();
        System.out.println(beliefNetwork.toString(false, false));
        System.out.println("\n*** Querying 'report':");
        QueryCompute query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[0], new int[0], configuration);
        Query.Result result = query.getResult();
        System.out.println("* Result:");
        System.out.println(result.toString(false));
        System.out.println("\n*** Querying 'report' given observation 'smoke' = 'T':");
        query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration);
        System.out.println("* Result:");
        System.out.println(query.getResult().toString(false));
        System.out.println("\n*** Computing probability of evidence 'smoke' = 'T':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(new Variable[0], beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration).getResult().toString(false));
    }
}

