/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.examples;

import CIspace.ve.Configuration;
import CIspace.ve.Factor;
import CIspace.ve.FactorCPT;
import CIspace.ve.Query;
import CIspace.ve.QueryCompute;
import CIspace.ve.Variable;
import CIspace.ve.VariableNatureStored;
import CIspace.ve.parsers.factors.DecisionNetworkFromFactors;

public class FireFactors {
    public static void main(String[] args) {
        DecisionNetworkFromFactors beliefNetwork;
        Configuration configuration = new Configuration();
        System.out.println("\n* Configuration:");
        System.out.println(configuration.toString(false));
        VariableNatureStored tampering = new VariableNatureStored("tampering", new String[]{"T", "F"}, false);
        VariableNatureStored fire = new VariableNatureStored("fire", new String[]{"T", "F"}, false);
        VariableNatureStored alarm = new VariableNatureStored("alarm", new String[]{"T", "F"}, false);
        VariableNatureStored smoke = new VariableNatureStored("smoke", new String[]{"T", "F"}, false);
        VariableNatureStored leaving = new VariableNatureStored("leaving", new String[]{"T", "F"}, false);
        VariableNatureStored report = new VariableNatureStored("report", new String[]{"T", "F"}, false);
        Factor[] factors = new Factor[]{new FactorCPT(new Variable[]{tampering}, false, 0, new double[]{0.02, 0.98}, false, 0.0), new FactorCPT(new Variable[]{fire}, false, 0, new double[]{0.01, 0.99}, false, 0.0), new FactorCPT(new Variable[]{tampering, fire, alarm}, false, 2, new double[]{0.5, 0.5, 0.85, 0.15, 0.99, 0.01, 1.0E-4, 0.9999}, false, 0.0), new FactorCPT(new Variable[]{fire, smoke}, false, 1, new double[]{0.9, 0.1, 0.01, 0.99}, false, 0.0), new FactorCPT(new Variable[]{alarm, leaving}, false, 1, new double[]{0.88, 0.12, 0.001, 0.999}, false, 0.0), new FactorCPT(new Variable[]{leaving, report}, false, 1, new double[]{0.75, 0.25, 0.01, 0.99}, false, 0.0)};
        try {
            beliefNetwork = new DecisionNetworkFromFactors("Fire Alarm Belief Network", new Variable[]{tampering, fire, alarm, smoke, leaving, report}, factors, null, null, configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("* '" + beliefNetwork.getName(false) + "' network created.");
        System.out.println();
        System.out.println(beliefNetwork.toString(false, false));
        System.out.println("\n*** Querying 'report':");
        QueryCompute query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[0], new int[0], configuration);
        Query.Result result = query.getResult();
        System.out.println("* Result:");
        System.out.println(result.toString(false));
        System.out.println("\n*** Querying 'report' given observation 'smoke' = 'T':");
        query = new QueryCompute(new Variable[]{beliefNetwork.getVariable("report")}, beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration);
        System.out.println("* Result:");
        System.out.println(query.getResult().toString(false));
        System.out.println("\n*** Computing probability of evidence 'smoke' = 'T':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(new Variable[0], beliefNetwork, new Variable[]{beliefNetwork.getVariable("smoke")}, new int[1], configuration).getResult().toString(false));
    }
}

