/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.examples;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.Factor;
import CIspace.ve.FactorCPT;
import CIspace.ve.FactorUtility;
import CIspace.ve.Policy;
import CIspace.ve.PolicyCompute;
import CIspace.ve.Query;
import CIspace.ve.QueryCompute;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;
import CIspace.ve.VariableNatureStored;
import CIspace.ve.parsers.factors.DecisionNetworkFromFactors;
import CIspace.ve.tools.Pair;

public class UmbrellaFactors {
    public static void main(String[] args) {
        DecisionNetworkFromFactors decisionNetworkBis;
        DecisionNetworkFromFactors decisionNetwork;
        Configuration configuration = new Configuration();
        System.out.println("\n* Configuration:");
        System.out.println(configuration.toString(false));
        VariableNatureStored weather = new VariableNatureStored("Weather", new String[]{"Sunshine", "Rain"}, false);
        VariableNatureStored forecast = new VariableNatureStored("Forecast", new String[]{"Sunny", "Cloudy", "Rainy"}, false);
        VariableDecision umbrella = new VariableDecision("Umbrella", new String[]{"Take It", "Leave At Home"}, false);
        Factor[] factors = new Factor[]{new FactorCPT(new Variable[]{weather}, false, 0, new double[]{0.7, 0.3}, false, 0.0), new FactorCPT(new Variable[]{weather, forecast}, false, 1, new double[]{0.7, 0.2, 0.1, 0.15, 0.25, 0.6}, false, 1.0E-15)};
        FactorUtility utility = new FactorUtility(new Variable[]{weather, umbrella}, false, new double[]{20.0, 100.0, 70.0, 0.0}, false, "Satisfaction");
        Pair[] parents = new Pair[]{new Pair<VariableDecision, Variable[]>(umbrella, new Variable[]{forecast})};
        try {
            decisionNetwork = new DecisionNetworkFromFactors("Simple Umbrella Decision", new Variable[]{weather, forecast, umbrella}, factors, parents, utility, configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("* '" + decisionNetwork.getName(false) + "' network created.");
        System.out.println();
        System.out.println(decisionNetwork.toString(false, false));
        System.out.println("\n*** Optimizing decisions:");
        PolicyCompute policy = new PolicyCompute(decisionNetwork, new Variable[0], new int[0], configuration);
        Policy.Result resultPolicy = policy.getResult();
        System.out.println("* Result:");
        System.out.println(resultPolicy.toString(false, true, false));
        try {
            decisionNetworkBis = new DecisionNetworkFromFactors((DecisionNetwork)decisionNetwork, resultPolicy.getPolicy(false), configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("\n*** New decision network with optimal decision function:");
        System.out.println(decisionNetworkBis.toString(false, false));
        System.out.println("\n*** Querying 'Umbrella':");
        QueryCompute query = new QueryCompute(new Variable[]{decisionNetworkBis.getVariable("Umbrella")}, decisionNetworkBis, new Variable[0], new int[0], configuration);
        Query.Result resultQuery = query.getResult();
        System.out.println("* Result:");
        System.out.println(resultQuery.toString(false));
        System.out.println("\n*** Querying 'Umbrella' given observation 'Weather' = 'Rain':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(new Variable[]{decisionNetworkBis.getVariable("Umbrella")}, decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration).getResult().toString(false));
        System.out.println("\n*** Computing expected utility given observation 'Weather' = 'Rain':");
        System.out.println("* Result:");
        System.out.println(new QueryCompute(decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration).getResult().toString(false));
        System.out.println("\n*** Optimizing decisions in the original network given observation 'Weather' = 'Rain':");
        policy = new PolicyCompute(decisionNetwork, new Variable[]{decisionNetworkBis.getVariable("Weather")}, new int[]{1}, configuration);
        resultPolicy = policy.getResult();
        System.out.println("* Result:");
        System.out.println(resultPolicy.toString(false, true, false));
        try {
            decisionNetworkBis = new DecisionNetworkFromFactors((DecisionNetwork)decisionNetwork, resultPolicy.getPolicy(false), configuration);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.toString());
            return;
        }
        System.out.println("\n*** New decision network with optimal decision function (for observation 'Weather' = 'Rain'):");
        System.out.println(decisionNetworkBis.toString(false, false));
        System.out.println("\n*** Computing expected utility in the new network given observations 'Weather' = 'Rain' and 'Umbrella' = 'Leave_At_Home':");
        System.out.println("* Result:");
        try {
            System.out.println(new QueryCompute(decisionNetworkBis, new Variable[]{decisionNetworkBis.getVariable("Weather"), decisionNetworkBis.getVariable("Umbrella")}, new int[]{1, 1}, configuration).getResult().toString(false));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

