/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.parsers.BIFv0_10;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorDistribution;
import CIspace.ve.Property;
import CIspace.ve.Variable;
import CIspace.ve.parsers.BIFv0_10.ParserBIFv0_10;
import CIspace.ve.tools.ItrSafe;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Formatter;

public class DecisionNetworkFromBIFv0_10
extends DecisionNetwork {
    public DecisionNetworkFromBIFv0_10(String string, Configuration configuration) throws Exception {
        this(new BufferedReader(new StringReader(string)), configuration);
    }

    public DecisionNetworkFromBIFv0_10(BufferedReader file, Configuration configuration) throws Exception {
        super(configuration);
        ParserBIFv0_10 parser = new ParserBIFv0_10(file);
        parser.network(this);
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        Variable curVar;
        if (decisionNetwork.isDecisionNetwork()) {
            throw new UnsupportedOperationException("Decision Network can not be stored in BIF format!");
        }
        Formatter output = new Formatter();
        String name = decisionNetwork.getName(false);
        if (!DecisionNetworkFromBIFv0_10.isBIFname(name)) {
            throw new UnsupportedOperationException("Network's name \"" + name + "\" is not a proper name in BIF 0.10 format!");
        }
        if (name == null || name.trim().equals("")) {
            name = "Untitled";
        }
        output.format("network %s {\n", name);
        ItrSafe<Property> networkPropertiesIterator = decisionNetwork.properties().get();
        while (networkPropertiesIterator.hasNext()) {
            output.format("  property %s;\n", ((Property)networkPropertiesIterator.next()).toString());
        }
        output.format("%s\n", "}");
        ItrSafe<Variable> varsIterator = decisionNetwork.getVariables();
        while (varsIterator.hasNext()) {
            curVar = (Variable)varsIterator.next();
            if (!DecisionNetworkFromBIFv0_10.isBIFname(curVar.getName(false))) {
                throw new UnsupportedOperationException("Variable's name \"" + curVar.getName(false) + "\" is not a proper name in BIF 0.10 format!");
            }
            output.format("variable %s", curVar.getName(false));
            output.format(" {\n  type discrete [%s]{", curVar.getDomainSize());
            ItrSafe<String> domainIterator = curVar.iterator();
            if (domainIterator.hasNext()) {
                output.format("%s", domainIterator.next());
            }
            while (domainIterator.hasNext()) {
                output.format(", %s", domainIterator.next());
            }
            output.format("%s\n", "};");
            ItrSafe<Property> variablePropertiesIterator = decisionNetwork.variableProperties(curVar).getVariableProperties().get();
            while (variablePropertiesIterator.hasNext()) {
                output.format("  property %s;\n", ((Property)variablePropertiesIterator.next()).toString());
            }
            output.format("%s\n", "}");
        }
        ItrSafe<Factor> factorsIterator = decisionNetwork.getFactors(false);
        int i = 0;
        while (i < decisionNetwork.getNumProbFactors()) {
            EltsIterator eltsItr;
            boolean noParents;
            Factor curFactor = (Factor)factorsIterator.next();
            if (((FactorDistribution)((Object)curFactor)).getChildIndex() != curFactor.getVariablesNum() - 1) {
                Variable[] variables = new Variable[curFactor.getVariablesNum()];
                ItrSafe<Variable> variablesIterator = curFactor.getVariables();
                int index = ((FactorDistribution)((Object)curFactor)).getChildIndex();
                int j = 0;
                while (j < index) {
                    variables[j++] = (Variable)variablesIterator.next();
                }
                variables[variables.length - 1] = (Variable)variablesIterator.next();
                while (variablesIterator.hasNext()) {
                    variables[j++] = (Variable)variablesIterator.next();
                }
                curFactor = curFactor.reorder(variables, false, false);
            }
            curVar = ((FactorDistribution)((Object)curFactor)).getChild();
            ItrSafe<Variable> safeItr = decisionNetwork.getParents(curVar);
            Variable childVariable = ((FactorDistribution)((Object)curFactor)).getChild();
            output.format("probability (%s", childVariable.getName(false));
            boolean bl = noParents = !safeItr.hasNext();
            if (noParents) {
                output.format("%s\n", ") {");
            } else {
                output.format(" | %s", safeItr.next().getName(false));
                while (safeItr.hasNext()) {
                    output.format(", %s", safeItr.next().getName(false));
                }
                output.format(") {\n", new Object[0]);
            }
            ItrSafe<Property> definitionPropertiesIterator = decisionNetwork.variableProperties(childVariable).getDefinitionProperties().get();
            while (definitionPropertiesIterator.hasNext()) {
                output.format("  property %s;\n", ((Property)definitionPropertiesIterator.next()).toString());
            }
            if (noParents) {
                eltsItr = curFactor.iterator();
                output.format("  table %s", eltsItr.next());
                while (eltsItr.hasNext()) {
                    output.format(", %s", eltsItr.next());
                }
                output.format(";\n}\n", new Object[0]);
            } else {
                eltsItr = curFactor.iterator();
                int[] index = new int[curFactor.getVariablesNum()];
                block10: while (eltsItr.hasNext()) {
                    output.format("  (", new Object[0]);
                    int j = 0;
                    while (j < curFactor.getVariablesNum() - 1) {
                        if (j != 0) {
                            output.format(", ", new Object[0]);
                        }
                        output.format("%s", curFactor.getVariable(j).getDomainElement(index[j]));
                        ++j;
                    }
                    output.format(") ", new Object[0]);
                    j = 0;
                    while (j < curVar.getDomainSize()) {
                        if (j != 0) {
                            output.format(", ", new Object[0]);
                        }
                        output.format("%s", eltsItr.next());
                        ++j;
                    }
                    output.format(";\n", new Object[0]);
                    if (!eltsItr.hasNext()) continue;
                    j = curFactor.getVariablesNum() - 2;
                    while (j >= 0) {
                        if (index[j] < curFactor.getVariable(j).getDomainSize() - 1) {
                            int n = j;
                            index[n] = index[n] + 1;
                            int k = j + 1;
                            while (k < curFactor.getVariablesNum()) {
                                index[k] = 0;
                                ++k;
                            }
                            continue block10;
                        }
                        --j;
                    }
                }
                output.format("}\n", new Object[0]);
            }
            ++i;
        }
        return output.toString();
    }

    private static boolean isBIFname(String name) {
        return name.indexOf(40) == -1 && name.indexOf(41) == -1 && name.indexOf(91) == -1 && name.indexOf(93) == -1 && name.indexOf(123) == -1 && name.indexOf(125) == -1 && name.indexOf(47) == -1 && name.indexOf(124) == -1 && name.indexOf(61) == -1 && name.indexOf(59) == -1 && name.indexOf(44) == -1;
    }
}

