/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.parsers.factors;

import CIspace.ve.Configuration;
import CIspace.ve.DecisionNetwork;
import CIspace.ve.EltsIterator;
import CIspace.ve.Factor;
import CIspace.ve.FactorDecision;
import CIspace.ve.FactorDistribution;
import CIspace.ve.FactorUtility;
import CIspace.ve.Property;
import CIspace.ve.PropertyGeneric;
import CIspace.ve.PropertyPosition;
import CIspace.ve.Variable;
import CIspace.ve.VariableDecision;
import CIspace.ve.VariableNaturePretend;
import CIspace.ve.VariableNatureStored;
import CIspace.ve.tools.ItrSafe;
import CIspace.ve.tools.Pair;
import CIspace.ve.tools.Triple;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionNetworkFromFactors
extends DecisionNetwork {
    public DecisionNetworkFromFactors(String name, Variable[] variables, Factor[] factors, Pair<VariableDecision, Variable[]>[] parents, FactorUtility utility, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        Object[] objectArray = variables;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Variable variable = objectArray[n];
            this.addVariable(variable, null);
            ++n;
        }
        objectArray = factors;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Comparable<Variable> factor = objectArray[n];
            this.addFactor((Factor)factor, null);
            ++n;
        }
        if (parents != null) {
            objectArray = parents;
            n = 0;
            n2 = objectArray.length;
            while (n < n2) {
                Object pair = objectArray[n];
                this.addParents((VariableDecision)((Pair)pair).getFirstElement(), (Variable[])((Pair)pair).getSecondElement(), null);
                ++n;
            }
        }
        if (utility != null) {
            this.addUtility(utility, null);
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Pair<Variable, Iterator<Property>>[] variables, Pair<Factor, Iterator<Property>>[] factors, Triple<VariableDecision, Variable[], Iterator<Property>>[] parents, Pair<FactorUtility, Iterator<Property>> utility, Iterator<Property> properties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        Object[] objectArray = variables;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Pair<Variable, Iterator<Property>> variable = objectArray[n];
            this.addVariable(variable.getFirstElement(), variable.getSecondElement());
            ++n;
        }
        objectArray = factors;
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Pair<Comparable<Variable>, Iterator<Property>> factor = objectArray[n];
            this.addFactor((Factor)factor.getFirstElement(), factor.getSecondElement());
            ++n;
        }
        if (parents != null) {
            objectArray = parents;
            n = 0;
            n2 = objectArray.length;
            while (n < n2) {
                Object triple = objectArray[n];
                this.addParents((VariableDecision)((Triple)triple).getFirstElement(), (Variable[])((Triple)triple).getSecondElement(), (Iterator)((Triple)triple).getThirdElement());
                ++n;
            }
        }
        if (utility != null) {
            this.addUtility(utility.getFirstElement(), utility.getSecondElement());
        }
        this.addProperties(properties);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Iterator<Variable> variables, Iterator<Factor> factors, Iterator<Pair<VariableDecision, Variable[]>> parents, FactorUtility utility, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        while (variables.hasNext()) {
            this.addVariable(variables.next(), null);
        }
        while (factors.hasNext()) {
            this.addFactor(factors.next(), null);
        }
        if (parents != null) {
            while (parents.hasNext()) {
                Pair<VariableDecision, Variable[]> pair = parents.next();
                this.addParents(pair.getFirstElement(), pair.getSecondElement(), null);
            }
        }
        if (utility != null) {
            this.addUtility(utility, null);
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(String name, Iterator<Pair<Variable, Iterator<Property>>> variables, Iterator<Pair<Factor, Iterator<Property>>> factors, Iterator<Triple<VariableDecision, Variable[], Iterator<Property>>> parents, Pair<FactorUtility, Iterator<Property>> utility, Iterator<Property> properties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(name);
        while (variables.hasNext()) {
            Pair<Variable, Iterator<Property>> variable = variables.next();
            this.addVariable(variable.getFirstElement(), variable.getSecondElement());
        }
        while (factors.hasNext()) {
            Pair<Factor, Iterator<Property>> factor = factors.next();
            this.addFactor(factor.getFirstElement(), factor.getSecondElement());
        }
        if (parents != null) {
            while (parents.hasNext()) {
                Triple<VariableDecision, Variable[], Iterator<Property>> triple = parents.next();
                this.addParents(triple.getFirstElement(), triple.getSecondElement(), triple.getThirdElement());
            }
        }
        if (utility != null) {
            this.addUtility(utility.getFirstElement(), utility.getSecondElement());
        }
        this.addProperties(properties);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, FactorDecision[] policy, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        ItrSafe<Variable> variables = decisionNetwork.getVariables();
        while (variables.hasNext()) {
            this.addVariable((Variable)variables.next(), null);
        }
        ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
        while (factors.hasNext()) {
            this.addFactor((Factor)factors.next(), null);
        }
        FactorDecision[] factorDecisionArray = policy;
        int n = 0;
        int n2 = factorDecisionArray.length;
        while (n < n2) {
            FactorDecision decisionFunction = factorDecisionArray[n];
            this.addFactor(decisionFunction, null);
            ++n;
        }
        this.addUtility(decisionNetwork.getUtility(), null);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Pair<FactorDecision, Iterator<Property>>[] policy, Iterator<Property> networkProperties, boolean copyProperties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        if (copyProperties) {
            ItrSafe<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                Variable variable = (Variable)variables.next();
                this.addVariable(variable, decisionNetwork.variableProperties(variable).getVariableProperties().get());
            }
            ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                Factor factor = (Factor)factors.next();
                this.addFactor(factor, decisionNetwork.variableProperties(((FactorDistribution)((Object)factor)).getChild()).getDefinitionProperties().get());
            }
            Pair<FactorDecision, Iterator<Property>>[] pairArray = policy;
            int n = 0;
            int n2 = pairArray.length;
            while (n < n2) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = pairArray[n];
                if (decisionFunction.getSecondElement() == null) {
                    this.addFactor(decisionFunction.getFirstElement(), decisionNetwork.variableProperties(decisionFunction.getFirstElement().getChild()).getDefinitionProperties().get());
                } else {
                    this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
                }
                ++n;
            }
            this.addUtility(decisionNetwork.getUtility(), decisionNetwork.utilityProperties().get());
            if (networkProperties == null) {
                this.addProperties(decisionNetwork.properties().get());
            } else {
                this.addProperties(networkProperties);
            }
        } else {
            ItrSafe<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                this.addVariable((Variable)variables.next(), null);
            }
            ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                this.addFactor((Factor)factors.next(), null);
            }
            Pair<FactorDecision, Iterator<Property>>[] pairArray = policy;
            int n = 0;
            int n3 = pairArray.length;
            while (n < n3) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = pairArray[n];
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
                ++n;
            }
            this.addUtility(decisionNetwork.getUtility(), null);
            if (networkProperties != null) {
                while (networkProperties.hasNext()) {
                    this.addProperty(networkProperties.next());
                }
            }
        }
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Iterator<FactorDecision> policy, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        ItrSafe<Variable> variables = decisionNetwork.getVariables();
        while (variables.hasNext()) {
            this.addVariable((Variable)variables.next(), null);
        }
        ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
        while (factors.hasNext()) {
            this.addFactor((Factor)factors.next(), null);
        }
        while (policy.hasNext()) {
            this.addFactor(policy.next(), null);
        }
        this.addUtility(decisionNetwork.getUtility(), null);
        this.finishConstruction(true);
    }

    public DecisionNetworkFromFactors(DecisionNetwork decisionNetwork, Iterator<Pair<FactorDecision, Iterator<Property>>> policy, Iterator<Property> networkProperties, boolean copyProperties, Configuration configuration) throws Exception {
        super(configuration);
        this.setName(String.valueOf(decisionNetwork.getName(false)) + "-bis");
        if (copyProperties) {
            ItrSafe<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                Variable variable = (Variable)variables.next();
                this.addVariable(variable, decisionNetwork.variableProperties(variable).getVariableProperties().get());
            }
            ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                Factor factor = (Factor)factors.next();
                this.addFactor(factor, decisionNetwork.variableProperties(((FactorDistribution)((Object)factor)).getChild()).getDefinitionProperties().get());
            }
            while (policy.hasNext()) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = policy.next();
                if (decisionFunction.getSecondElement() == null) {
                    this.addFactor(decisionFunction.getFirstElement(), decisionNetwork.variableProperties(decisionFunction.getFirstElement().getChild()).getDefinitionProperties().get());
                    continue;
                }
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
            }
            this.addUtility(decisionNetwork.getUtility(), decisionNetwork.utilityProperties().get());
            if (networkProperties == null) {
                this.addProperties(decisionNetwork.properties().get());
            } else {
                this.addProperties(networkProperties);
            }
        } else {
            ItrSafe<Variable> variables = decisionNetwork.getVariables();
            while (variables.hasNext()) {
                this.addVariable((Variable)variables.next(), null);
            }
            ItrSafe<Factor> factors = decisionNetwork.getFactors(false);
            while (factors.hasNext()) {
                this.addFactor((Factor)factors.next(), null);
            }
            while (policy.hasNext()) {
                Pair<FactorDecision, Iterator<Property>> decisionFunction = policy.next();
                this.addFactor(decisionFunction.getFirstElement(), decisionFunction.getSecondElement());
            }
            this.addUtility(decisionNetwork.getUtility(), null);
            if (networkProperties != null) {
                while (networkProperties.hasNext()) {
                    this.addProperty(networkProperties.next());
                }
            }
        }
        this.finishConstruction(true);
    }

    public static String saveToString(DecisionNetwork decisionNetwork) {
        String networkName = decisionNetwork.getName(false);
        if (!DecisionNetworkFromFactors.isJavaIdentifier(networkName)) {
            throw new UnsupportedOperationException("Network's name \"" + networkName + "\" is not a valid Java identifier!");
        }
        Formatter output = new Formatter();
        output.format("%s\n", "import java.util.Arrays;");
        output.format("%s\n\n", "import java.util.Iterator;");
        output.format("%s\n", "import CIspace.ve.Configuration;");
        output.format("%s\n", "import CIspace.ve.DecisionNetwork;");
        output.format("%s\n", "import CIspace.ve.Factor;");
        output.format("%s\n", "import CIspace.ve.FactorCPT;");
        output.format("%s\n", "import CIspace.ve.FactorUtility;");
        output.format("%s\n", "import CIspace.ve.Pair;");
        output.format("%s\n", "import CIspace.ve.Property;");
        output.format("%s\n", "import CIspace.ve.PropertyGeneric;");
        output.format("%s\n", "import CIspace.ve.PropertyPosition;");
        output.format("%s\n", "import CIspace.ve.Triple;");
        output.format("%s\n", "import CIspace.ve.Variable;");
        output.format("%s\n", "import CIspace.ve.VariableDecision;");
        output.format("%s\n", "import CIspace.ve.VariableNatureStored;");
        output.format("%s\n", "import CIspace.ve.VariableNaturePretend;");
        output.format("%s\n", "import CIspace.ve.parsers.factors.DecisionNetworkFromFactors;");
        output.format("\n%s\n", "/**");
        output.format(" * Generated by CIspace.ve.Factors.DecisionNetworkFromFactors.saveToString() from \"%s\".\n", networkName);
        output.format("%s\n", " */");
        output.format("public class %s {\n", networkName);
        output.format("\n\t%s\n", "/**");
        output.format("\t%s\n", " * @param args not used.");
        output.format("\t%s\n", " */");
        output.format("\t%s\n", "@SuppressWarnings(\"unchecked\")");
        output.format("\t%s\n", "public static void main(String[] args) {");
        output.format("\t\t%s\n", "// Set up inference configuration");
        output.format("\t\t%s\n", "Configuration configuration = new Configuration();");
        output.format("\t\tconfiguration.setFactorSavingForTracing(%b);\n", decisionNetwork.factorSavingForTracing());
        output.format("\t\tconfiguration.setFactorStructuredThreshold(%s);\n", decisionNetwork.factorStructuredThreshold());
        output.format("\n\t\t%s\n", "// Create the network");
        output.format("\t\t%s\n", "// Variables");
        output.format("\t\tPair<Variable, Iterator<Property>>[] variables = new Pair[%d]; // @SuppressWarnings(\"unchecked\")\n", decisionNetwork.getNumVariables());
        ItrSafe<Variable> variablesIterator = decisionNetwork.getVariables();
        int i = 0;
        LinkedList<VariableDecision> decisionVariables = new LinkedList<VariableDecision>();
        HashMap<Variable, Integer> variableToIndex = new HashMap<Variable, Integer>();
        while (variablesIterator.hasNext()) {
            Variable variable = (Variable)variablesIterator.next();
            variableToIndex.put(variable, i);
            DecisionNetwork.VariableProperties variableProperties = decisionNetwork.variableProperties(variable);
            if (variable instanceof VariableDecision && variableProperties.getFactor() == null) {
                decisionVariables.add((VariableDecision)variable);
            }
            if (variable instanceof VariableNaturePretend) {
                output.format("\t\tvariables[%d] = new Pair<Variable, Iterator<Property>>(new VariableNaturePretend(\"%s\", %d), %s);\n", i++, DecisionNetworkFromFactors.replaceWithEscapes(variable.getName(false)), variable.getDomainSize(), DecisionNetworkFromFactors.generateProperties(variableProperties.getVariableProperties().get()));
                continue;
            }
            output.format("\t\tvariables[%d] = new Pair<Variable, Iterator<Property>>(new Variable%s(\"%s\", new String[]{\"%s\"", i++, variable instanceof VariableNatureStored ? "NatureStored" : "Decision", DecisionNetworkFromFactors.replaceWithEscapes(variable.getName(false)), DecisionNetworkFromFactors.replaceWithEscapes(variable.getDomainElement(0)));
            int j = 1;
            while (j < variable.getDomainSize()) {
                output.format(",\"%s\"", DecisionNetworkFromFactors.replaceWithEscapes(variable.getDomainElement(j)));
                ++j;
            }
            output.format("}, false), %s);\n", DecisionNetworkFromFactors.generateProperties(variableProperties.getVariableProperties().get()));
        }
        output.format("\n\t\t%s\n", "// Factors");
        output.format("\t\tPair<Factor, Iterator<Property>>[] factors = new Pair[%d]; // @SuppressWarnings(\"unchecked\")\n", decisionNetwork.getNumProbFactors());
        ItrSafe<Factor> factorsIterator = decisionNetwork.getFactors(false);
        i = 0;
        while (factorsIterator.hasNext()) {
            Factor factor = (Factor)factorsIterator.next();
            output.format("\t\tfactors[%d] = new Pair<Factor, Iterator<Property>>(new FactorCPT(new Variable[]{%s", i++, factor.getVariablesNum() != 0 ? "variables[" + variableToIndex.get(factor.getVariable(0)) + "].getFirstElement()" : "");
            int j = 1;
            while (j < factor.getVariablesNum()) {
                output.format(",variables[%d].getFirstElement()", variableToIndex.get(factor.getVariable(j)));
                ++j;
            }
            EltsIterator elementsIterator = factor.iterator();
            output.format("}, false, %d, new double[]{%s", ((FactorDistribution)((Object)factor)).getChildIndex(), elementsIterator.next());
            while (elementsIterator.hasNext()) {
                output.format(",%s", elementsIterator.next());
            }
            output.format("}, false, %s), %s);\n", decisionNetwork.factorStructuredThreshold(), DecisionNetworkFromFactors.generateProperties(decisionNetwork.variableProperties(((FactorDistribution)((Object)factor)).getChild()).getDefinitionProperties().get()));
        }
        if (decisionNetwork.isDecisionNetwork()) {
            FactorUtility utility = decisionNetwork.getUtility();
            output.format("\n\t\t%s\n", "// Utility factor");
            output.format("\t\tPair<FactorUtility,Iterator<Property>> utility = new Pair(new FactorUtility(new Variable[]{%s", utility.getVariablesNum() != 0 ? "variables[" + variableToIndex.get(utility.getVariable(0)) + "].getFirstElement()" : "");
            int j = 1;
            while (j < utility.getVariablesNum()) {
                output.format(",variables[%s].getFirstElement()", variableToIndex.get(utility.getVariable(j)));
                ++j;
            }
            EltsIterator elementsIterator = utility.iterator();
            output.format("}, false, new double[]{%s", elementsIterator.next());
            while (elementsIterator.hasNext()) {
                output.format(",%s", elementsIterator.next());
            }
            output.format("}, false, \"%s\"), %s);\n", DecisionNetworkFromFactors.replaceWithEscapes(utility.getUtilityName()), DecisionNetworkFromFactors.generateProperties(decisionNetwork.utilityProperties().get()));
            output.format("\n\t\t%s\n", "// Parents of decision variables");
            output.format("\t\t%s", "Triple<VariableDecision, Variable[], Iterator<Property>>[] parents = new Triple[]{");
            boolean firstDV = true;
            Iterator decisionVariablesIterator = decisionVariables.iterator();
            while (decisionVariablesIterator.hasNext()) {
                if (firstDV) {
                    firstDV = false;
                } else {
                    output.format("%s", ", ");
                }
                VariableDecision decisionVariable = (VariableDecision)decisionVariablesIterator.next();
                output.format("new Triple<VariableDecision, Variable[], Iterator<Property>>((VariableDecision) variables[%d].getFirstElement(), new Variable[]{", variableToIndex.get(decisionVariable));
                boolean firstP = true;
                ItrSafe<Variable> parentsIterator = decisionNetwork.getParents(decisionVariable);
                while (parentsIterator.hasNext()) {
                    if (firstP) {
                        firstP = false;
                    } else {
                        output.format("%s", ", ");
                    }
                    output.format("variables[%d].getFirstElement()", variableToIndex.get(parentsIterator.next()));
                }
                output.format("}, %s)", DecisionNetworkFromFactors.generateProperties(decisionNetwork.variableProperties(decisionVariable).getDefinitionProperties().get()));
            }
            output.format("%s\n", "}; // @SuppressWarnings(\"unchecked\")");
        }
        String prefix = decisionNetwork.isDecisionNetwork() ? "decision" : "belief";
        output.format("\n\t\t%s\n", "// Network");
        output.format("\t\tDecisionNetwork %sNetwork;\n", prefix);
        output.format("\t\t%s\n", "try {");
        if (decisionNetwork.isDecisionNetwork()) {
            output.format("\t\t\tdecisionNetwork = new DecisionNetworkFromFactors(\"%s\", variables, factors, parents, utility, %s, configuration);\n", networkName, DecisionNetworkFromFactors.generateProperties(decisionNetwork.properties().get()));
        } else {
            output.format("\t\t\tbeliefNetwork = new DecisionNetworkFromFactors(\"%s\", variables, factors, null, null, %s, configuration);\n", networkName, DecisionNetworkFromFactors.generateProperties(decisionNetwork.properties().get()));
        }
        output.format("\t\t%s\n", "} catch (Exception e) {");
        output.format("\t\t\t%s\n", "System.out.println(\"Error: \" + e.toString());");
        output.format("\t\t\t%s\n", "return;");
        output.format("\t\t%s\n", "}");
        output.format("\t\tSystem.out.println(\"* '\" + %sNetwork.getName(false) + \"' network created.\");\n", prefix);
        output.format("\n\t\t%s\n", "// Display the network on the screen");
        output.format("\t\tSystem.out.println(\"\\n\" + %sNetwork.toString(false, false)); // In expanded form, without unique id-s\n", prefix);
        output.format("\t%s\n", "}");
        output.format("%s", "}");
        return output.toString();
    }

    private static boolean isJavaIdentifier(String string) {
        if (string.length() == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < string.length()) {
            if (!Character.isJavaIdentifierPart(string.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String replaceWithEscapes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static String generateProperties(Iterator<Property> propertiesIterator) {
        if (!propertiesIterator.hasNext()) {
            return "null";
        }
        Formatter output = new Formatter();
        output.format("Arrays.asList(new Property[]{", new Object[0]);
        while (propertiesIterator.hasNext()) {
            Property property = propertiesIterator.next();
            if (property instanceof PropertyPosition) {
                output.format("new PropertyPosition(%s, %s)", ((PropertyPosition)property).getPosX(), ((PropertyPosition)property).getPosX());
            } else {
                output.format("new PropertyGeneric(\"%s\", \"%s\")", DecisionNetworkFromFactors.replaceWithEscapes(property.getName()), DecisionNetworkFromFactors.replaceWithEscapes(((PropertyGeneric)property).getValue()));
            }
            if (!propertiesIterator.hasNext()) continue;
            output.format(",", new Object[0]);
        }
        output.format("}).iterator()", new Object[0]);
        return output.toString();
    }
}

