/*
 * Decompiled with CFR 0.152.
 */
package CIspace.ve.tools;

import CIspace.ve.tools.ItrSafe;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ItrArray<T>
extends ItrSafe<T> {
    private int cursor;
    private final T[] array;
    private final int length;

    public ItrArray(T[] array, int length) {
        if (array == null || array.length < length) {
            throw new IllegalArgumentException("Array does not contain enough elements.");
        }
        this.cursor = 0;
        this.array = array;
        this.length = length;
    }

    public ItrArray(T[] array, int start, int end) {
        if (array == null || start < 0 || array.length < end + 1) {
            throw new IllegalArgumentException("Wrong range specified.");
        }
        this.cursor = start;
        this.array = array;
        this.length = end + 1;
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.length;
    }

    @Override
    public T next() {
        if (this.cursor == this.length) {
            throw new NoSuchElementException();
        }
        return this.array[this.cursor++];
    }
}

