/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.BayesWindow;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnswerDialog
extends BasicDialog {
    public AnswerDialog(Container parent, BayesNode queryNode, double[] results, ArrayList<BayesNode> observedNodes) {
        super(parent instanceof BayesWindow ? (JFrame)parent : null, "Query Results", true, 2);
        StringBuffer title = null;
        title = queryNode != null ? new StringBuffer("Query Results for Variable " + queryNode.getLabel()) : new StringBuffer("Query Results for P(e)");
        if (observedNodes.size() > 0) {
            for (BayesNode curNode : observedNodes) {
                title.append(" [" + curNode.getLabel() + "=" + curNode.getObservation() + "]");
            }
        }
        JLabel titleLabel = new JLabel(title.toString());
        titleLabel.setFont(new Font("SansSerif", 1, parent.getFont().getSize()));
        Font plain = new Font("SansSerif", 0, parent.getFont().getSize());
        this.getContentPane().setLayout(new GridLayout(results.length + 2, 1));
        this.getContentPane().add(titleLabel);
        if (queryNode != null) {
            int i = 0;
            while (i < queryNode.getDomain().size()) {
                JPanel panel = new JPanel();
                JLabel label = queryNode.getNodeType() != 7779 ? new JLabel("   P ( " + queryNode.getLabel() + " = " + queryNode.getDomain().get(i) + " )") : new JLabel(" Expected Utility");
                label.setForeground(Color.blue);
                label.setFont(plain);
                panel.add(label);
                label = new JLabel(" = " + (double)Math.round(results[i] * 100000.0) / 100000.0);
                label.setFont(plain);
                panel.add(label);
                this.getContentPane().add(panel);
                if (queryNode.getNodeType() != 7779) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            JPanel panel = new JPanel();
            JLabel label = new JLabel(" P(e)");
            label.setForeground(Color.blue);
            label.setFont(plain);
            panel.add(label);
            label = new JLabel(" = " + (double)Math.round(results[0] * 100000.0) / 100000.0);
            label.setFont(plain);
            panel.add(label);
            this.getContentPane().add(panel);
        }
        JButton okButton = new JButton("OK");
        okButton.addActionListener(this);
        okButton.setActionCommand(okButton.getText());
        this.getContentPane().add(okButton);
        this.packCenterOpen();
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }
}

