/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.BayesGraph;
import AIspace.bayes.BayesWindow;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NodeDialog
extends BasicDialog {
    private JPanel nodeTypePanel;
    private JPanel domainPanel;
    private JRadioButton[] nodeTypeButtons;
    private ButtonGroup nodeTypeGroup;
    private JTextField textNodeName;
    private JLabel example;
    private JLabel labelDomain;
    private JTextField textDomain;
    private String stringDomainSaved;
    private boolean isCancelled = true;
    private BayesNode selectedNode;
    private BayesGraph graph;

    public NodeDialog(JFrame parent, BayesGraph graph, Point loc) {
        super(parent, "Node Properties", true, 2);
        this.graph = graph;
        this.setPanels(((BayesWindow)parent).isDecisionNetworkModeEnabled());
        this.pack();
        this.ensureOnScreen(loc);
    }

    private void setPanels(boolean isDecisionMode) {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.nodeTypeGroup = new ButtonGroup();
        this.nodeTypeButtons = new JRadioButton[3];
        JPanel buttonPanel = new JPanel();
        this.gbc.fill = 1;
        this.gbc.gridheight = 4;
        this.getContentPane().setLayout(this.gbl);
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel, 0));
        namePanel.add(new JLabel("Node name:\t\t"));
        this.textNodeName = new JTextField("", 20);
        this.textNodeName.addActionListener(this);
        namePanel.add(this.textNodeName);
        this.nodeTypePanel = new JPanel();
        this.nodeTypePanel.setLayout(new BoxLayout(this.nodeTypePanel, 0));
        JLabel typeLabel = new JLabel("Node type:\t\t");
        this.nodeTypePanel.add(typeLabel);
        buttonPanel.setLayout(new FlowLayout());
        JRadioButton RegularButton = new JRadioButton("Regular");
        RegularButton.setActionCommand(RegularButton.getText());
        RegularButton.addActionListener(this);
        this.nodeTypeGroup.add(RegularButton);
        this.nodeTypeButtons[0] = RegularButton;
        buttonPanel.add(RegularButton);
        JRadioButton DecisionButton = new JRadioButton("Decision");
        DecisionButton.setActionCommand(DecisionButton.getText());
        DecisionButton.addActionListener(this);
        this.nodeTypeGroup.add(DecisionButton);
        this.nodeTypeButtons[1] = DecisionButton;
        buttonPanel.add(DecisionButton);
        JRadioButton UtilityButton = new JRadioButton("Utility");
        UtilityButton.setActionCommand(UtilityButton.getText());
        UtilityButton.addActionListener(this);
        this.nodeTypeGroup.add(UtilityButton);
        this.nodeTypeButtons[2] = UtilityButton;
        buttonPanel.add(UtilityButton);
        if (!isDecisionMode) {
            RegularButton.setEnabled(false);
            DecisionButton.setEnabled(false);
            UtilityButton.setEnabled(false);
            typeLabel.setEnabled(false);
        }
        this.nodeTypePanel.add(buttonPanel);
        this.domainPanel = new JPanel();
        this.domainPanel.setLayout(new BoxLayout(this.domainPanel, 0));
        JPanel temp = new JPanel();
        temp.setLayout(new BoxLayout(temp, 1));
        this.labelDomain = new JLabel("Domain:\t\t\t\t");
        this.domainPanel.add(this.labelDomain);
        this.domainPanel.add(Box.createHorizontalGlue());
        this.textDomain = new JTextField("", 20);
        temp.add(this.textDomain);
        this.domainPanel.add(new JLabel());
        this.example = new JLabel("Use commas to separate domain values: d1, d2, ... , dn");
        temp.add(this.example);
        this.domainPanel.add(temp);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottomPanel.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottomPanel.add(button);
        this.addComponent(namePanel, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(this.nodeTypePanel, this, 1, 0, -1, 1, 1.0, 1.0);
        this.addComponent(this.domainPanel, this, 2, 0, -1, 2, 1.0, 1.0);
        this.addComponent(bottomPanel, this, 4, 0, -1, 1, 0.0, 0.0);
    }

    public void open(BayesNode node) {
        this.selectedNode = node;
        if (this.selectedNode.getLabel().equals("")) {
            this.textNodeName.setText("Node " + node.index);
        } else {
            this.textNodeName.setText(this.selectedNode.getLabel());
        }
        if (((BayesWindow)this.graph.canvas.parent).isDecisionNetworkModeEnabled() && (node.getNodeType() == 7779 || this.graph.getUtilityNodes().size() == 0)) {
            this.nodeTypeButtons[2].setEnabled(true);
        } else {
            this.nodeTypeButtons[2].setEnabled(false);
        }
        switch (node.getNodeType()) {
            case 7777: {
                this.nodeTypeButtons[0].setSelected(true);
                break;
            }
            case 7778: {
                this.nodeTypeButtons[1].setSelected(true);
                break;
            }
            case 7779: {
                this.nodeTypeButtons[2].setSelected(true);
            }
        }
        if (node.getNodeType() == 7779) {
            this.setDomainObjects(false);
            this.domainPanel.setForeground(Color.gray);
            this.textDomain.setText("Utility");
            this.stringDomainSaved = "T, F";
        } else {
            this.textDomain.setText(node.getDomain().toString().substring(1, node.getDomain().toString().length() - 1));
            this.stringDomainSaved = this.textDomain.getText();
        }
        this.isCancelled = true;
        this.setSize(450, 200);
        this.setVisible(true);
    }

    private boolean setProperties() {
        if (this.textNodeName.getText().trim().equals("")) {
            this.graph.showMessage("Error in Name", "Name cannot be blank.");
            return false;
        }
        if (this.nodeTypeButtons[2].isSelected() && this.selectedNode.getChildren().size() != 0) {
            this.graph.showMessage("Error", "Utility nodes cannot have outgoing edges.");
            return false;
        }
        if (!(this.selectedNode.getLabel().equals(this.textNodeName.getText()) && this.graph.getAllNodes().contains(this.selectedNode) || this.graph.isNodeNameAllowed(this.textNodeName.getText(), this.selectedNode))) {
            this.graph.showMessage("Error in Name", "Name has already been used.");
            return false;
        }
        this.selectedNode.setLabel(this.textNodeName.getText().trim());
        ArrayList<String> newDomain = this.getDomain();
        if (newDomain.size() == 0) {
            this.graph.showMessage("Domain Error", "Domain cannot be empty.");
            return false;
        }
        if (this.nodeTypeButtons[0].isEnabled()) {
            if (this.nodeTypeButtons[0].isSelected()) {
                this.selectedNode.setNodeType(7777);
            } else if (this.nodeTypeButtons[1].isSelected()) {
                this.selectedNode.setNodeType(7778);
            } else {
                this.selectedNode.setNodeType(7779);
            }
        } else {
            this.selectedNode.setNodeType(7777);
        }
        int i = 0;
        while (i < newDomain.size()) {
            if (!this.selectedNode.getDomain().contains(newDomain.get(i))) {
                this.selectedNode.addDomainElement(newDomain.get(i));
            }
            ++i;
        }
        i = this.selectedNode.getDomain().size() - 1;
        while (i >= 0) {
            if (!newDomain.contains(this.selectedNode.getDomain().get(i))) {
                this.selectedNode.removeDomainElement(this.selectedNode.getDomain().get(i));
            }
            --i;
        }
        if (this.selectedNode.isObserved() && !this.selectedNode.getDomain().contains(this.selectedNode.getObservation())) {
            this.selectedNode.setObservation("");
        }
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private ArrayList<String> getDomain() {
        StringTokenizer sTok = new StringTokenizer(this.textDomain.getText(), " ,\t\n\r\f", false);
        ArrayList<String> newDomain = new ArrayList<String>();
        while (sTok.hasMoreTokens()) {
            String nextToken = sTok.nextToken();
            if (newDomain.contains(nextToken)) continue;
            newDomain.add(nextToken);
        }
        return newDomain;
    }

    private void setDomainObjects(boolean isEnabled) {
        this.textDomain.setEnabled(isEnabled);
        this.labelDomain.setEnabled(isEnabled);
        this.example.setEnabled(isEnabled);
    }

    @Override
    protected boolean actionOK() {
        if (this.setProperties()) {
            this.isCancelled = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Utility") {
            this.stringDomainSaved = this.textDomain.getText();
            this.textDomain.setText("Utility");
            this.setDomainObjects(false);
            this.domainPanel.setForeground(Color.gray);
        } else if (e.getActionCommand() == "Regular") {
            this.setDomainObjects(true);
            this.domainPanel.setForeground(Color.black);
            this.textDomain.setText(this.stringDomainSaved);
        } else if (e.getActionCommand() == "Decision") {
            this.setDomainObjects(true);
            this.domainPanel.setForeground(Color.black);
            this.textDomain.setText(this.stringDomainSaved);
        }
    }
}

