/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.BayesCanvas;
import AIspace.bayes.BayesGraph;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;

public class PolicyDialog
extends BasicDialog
implements ItemListener {
    private ArrayList<ButtonGroup> checkboxGroupArrayList;
    private BayesCanvas canvas;
    private BayesNode node;
    private boolean hasChanged;
    private JSplitPane top;

    public PolicyDialog(JFrame parent, BayesNode node, BayesCanvas canvas) {
        super(parent, "Decision Function for " + node.getLabel(), true, 2);
        this.node = node;
        this.canvas = canvas;
        if (canvas.getFont().getSize() > 26) {
            this.setFont(new Font(canvas.getFont().getFontName(), canvas.getFont().getStyle(), 26));
        } else {
            this.setFont(canvas.getFont());
        }
        this.hasChanged = false;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.constructTopPanel(), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(), "South");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.getHeight() > screenSize.height - 200) {
            this.setSize(this.getWidth(), screenSize.height - 200);
        }
        if (this.getWidth() > screenSize.width - 200) {
            this.setSize(screenSize.width - 200, this.getHeight());
        }
        this.setSize(this.getWidth() + 10, this.getHeight() + 10);
        this.centerWindow();
        this.setVisible(true);
    }

    private JSplitPane constructTopPanel() {
        String createString;
        GridBagConstraints con;
        JLabel label;
        this.checkboxGroupArrayList = this.node.getContext().size() == 0 ? new ArrayList(this.node.getContext().size() * this.node.getDomain().size()) : new ArrayList(this.node.getDomain().size());
        JPanel gridPanel = new JPanel();
        GridBagLayout gl = new GridBagLayout();
        gridPanel.setLayout(gl);
        int headerSize = this.node.getParents().size();
        Font plainFont = new Font("SansSerif", 0, this.getFont().getSize());
        int i = 0;
        while (i < headerSize) {
            label = new JLabel("   " + this.node.getParents().get(i).getLabel());
            label.setForeground(Color.blue);
            label.setFont(plainFont);
            con = new GridBagConstraints();
            con.gridy = 0;
            con.gridx = i++;
            con.gridwidth = 1;
            con.gridheight = 1;
            gl.setConstraints(label, con);
            gridPanel.add(label);
        }
        label = new JLabel(this.node.getLabel());
        label.setForeground(Color.red);
        label.setFont(plainFont);
        con = new GridBagConstraints();
        con.gridy = 0;
        con.gridx = headerSize;
        con.gridheight = 1;
        con.gridwidth = this.node.getDomain().size();
        gl.setConstraints(label, con);
        gridPanel.add(label);
        FactorDecision policy = this.node.getDecisionFunction();
        int i2 = 0;
        while (i2 < this.node.getContext().size()) {
            ArrayList<String> curContext = this.node.getContext().get(i2);
            int j = 0;
            while (j < curContext.size()) {
                label = new JLabel(curContext.get(j));
                if (label.getText().equals("Prior Probability ")) break;
                label.setFont(plainFont);
                con = new GridBagConstraints();
                con.gridwidth = 1;
                con.gridheight = 1;
                con.gridx = j++;
                con.gridy = i2 + 1;
                gl.setConstraints(label, con);
                gridPanel.add(label);
            }
            ButtonGroup checkGroup = new ButtonGroup();
            this.checkboxGroupArrayList.add(checkGroup);
            JCheckBox checkBox = new JCheckBox("Fake");
            checkBox.setSelected(true);
            checkBox.setVisible(false);
            checkGroup.add(checkBox);
            int k = 0;
            while (k < this.node.getDomain().size()) {
                checkBox = new JCheckBox(this.node.getDomain().get(k));
                checkBox.addItemListener(this);
                checkGroup.add(checkBox);
                if (this.node.hasDecisionFunction() && policy.getDecisionFunctionValue(i2) == k) {
                    checkBox.setSelected(true);
                }
                con = new GridBagConstraints();
                con.gridwidth = 1;
                con.gridheight = 1;
                con.gridx = headerSize + k;
                if (headerSize == 0) {
                    con.gridx = k + 1;
                }
                con.gridy = i2 + 1;
                gl.setConstraints(checkBox, con);
                gridPanel.add(checkBox);
                ++k;
            }
            ++i2;
        }
        switch (this.node.getDecisionFunctionCreatedBy()) {
            case 7784: {
                createString = "was created by optimizing.";
                break;
            }
            case 7786: {
                createString = "was created automatically, since this node is irrelevant.";
                break;
            }
            case 7785: {
                createString = "was defined by the user.";
                break;
            }
            case 7788: {
                createString = "was loaded from a file.";
                break;
            }
            default: {
                createString = "is undefined.";
            }
        }
        label = new JLabel("This decision function " + createString, 0);
        JScrollPane gridPane = new JScrollPane(gridPanel, 20, 30);
        this.top = new JSplitPane(0);
        this.top.setTopComponent(gridPane);
        this.top.setBottomComponent(label);
        this.top.setResizeWeight(1.0);
        this.top.setDividerLocation(0.7);
        this.top.setDividerSize(0);
        this.top.setOneTouchExpandable(false);
        return this.top;
    }

    private JPanel constructBottomPanel() {
        JPanel bottom = new JPanel();
        Font plainFont = new Font("SansSerif", 0, this.getFont().getSize());
        JButton button = new JButton("Clear");
        button.setFont(plainFont);
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        bottom.add(button);
        button = new JButton("OK");
        button.setFont(plainFont);
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        bottom.add(button);
        this.getRootPane().setDefaultButton(button);
        button = new JButton("Cancel");
        button.setFont(plainFont);
        button.addActionListener(this);
        button.setActionCommand(button.getText());
        bottom.add(button);
        return bottom;
    }

    public boolean savePolicy() {
        int[] newPolicy = new int[this.node.getContext().size()];
        JCheckBox checkBox = null;
        int i = 0;
        while (i < this.checkboxGroupArrayList.size()) {
            Enumeration<AbstractButton> checked = this.checkboxGroupArrayList.get(i).getElements();
            while (checked.hasMoreElements()) {
                checkBox = (JCheckBox)checked.nextElement();
                if (checkBox.isSelected()) break;
                checkBox = null;
            }
            if (checkBox == null) {
                return this.isIncomplete();
            }
            newPolicy[i] = this.node.getDomain().indexOf(checkBox.getText());
            ++i;
        }
        DecisionNetwork network = ((BayesGraph)this.canvas.graph).getDecisionNetwork();
        VariableDecision nodeVariable = (VariableDecision)network.getVariable(this.node.getLabel());
        Iterator<Variable> itr = network.getParents(nodeVariable);
        Variable[] nodeParents = new Variable[this.node.getParents().size()];
        int i2 = 0;
        while (itr.hasNext()) {
            nodeParents[i2++] = itr.next();
        }
        this.node.setDecisionFunction(new FactorDecision(nodeParents, nodeVariable, newPolicy, false));
        return true;
    }

    @Override
    protected boolean actionOK() {
        if (!this.hasChanged) {
            return true;
        }
        if (this.isCleared()) {
            this.node.setDecisionFunctionCreatedBy(7787);
            this.node.setDecisionFunction(null);
            ((BayesGraph)this.canvas.graph).updateMonitoredNodes();
            return true;
        }
        if (!this.isIncomplete() && this.savePolicy()) {
            this.node.setDecisionFunctionCreatedBy(7785);
            ((BayesGraph)this.canvas.graph).updateMonitoredNodes();
            return true;
        }
        return false;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals("Clear")) {
            this.hasChanged = true;
            this.clearCheckBoxes();
            this.top.setBottomComponent(new JLabel("This decision function is undefined.", 0));
        }
    }

    private boolean isCleared() {
        int i = 0;
        while (i < this.checkboxGroupArrayList.size()) {
            JCheckBox curBox;
            Enumeration<AbstractButton> checkBoxes = this.checkboxGroupArrayList.get(i).getElements();
            if (checkBoxes.hasMoreElements() && !(curBox = (JCheckBox)checkBoxes.nextElement()).isSelected() && curBox.getText().equals("Fake")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isIncomplete() {
        int i = 0;
        while (i < this.checkboxGroupArrayList.size()) {
            JCheckBox curBox;
            Enumeration<AbstractButton> checkBoxes = this.checkboxGroupArrayList.get(i).getElements();
            if (checkBoxes.hasMoreElements() && (curBox = (JCheckBox)checkBoxes.nextElement()).isSelected() && curBox.getText().equals("Fake")) {
                Iterator<String> itr = this.node.getContext().get(i).iterator();
                StringBuffer context = new StringBuffer();
                int j = 0;
                while (itr.hasNext()) {
                    context.append(this.node.getParents().get(j++).getLabel()).append("=");
                    context.append(itr.next());
                    if (!itr.hasNext()) continue;
                    context.append(", ");
                }
                this.canvas.showMessage("Error", "Policy at row (" + (i + 1) + ") " + context.toString() + " is undefined.");
                return true;
            }
            ++i;
        }
        return false;
    }

    private void clearCheckBoxes() {
        int i = 0;
        while (i < this.checkboxGroupArrayList.size()) {
            Enumeration<AbstractButton> checkBoxes = this.checkboxGroupArrayList.get(i).getElements();
            if (checkBoxes.hasMoreElements()) {
                JCheckBox curBox = (JCheckBox)checkBoxes.nextElement();
                curBox.setSelected(true);
            }
            ++i;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.hasChanged = true;
    }
}

