/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.dialogs;

import AIspace.bayes.BayesCanvas;
import AIspace.bayes.elements.BayesNode;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProbabilityDialog
extends BasicDialog
implements KeyListener {
    private ArrayList<Component> field_list;
    private BayesNode node;
    private BayesCanvas canvas;
    private boolean isEditable;

    public ProbabilityDialog(JFrame parent, BayesNode bNode, BayesCanvas canvas, boolean isEditable) {
        super(parent, "Probability Table for " + bNode.getLabel(), true, 2);
        GridBagConstraints con;
        JLabel label;
        this.setFont(canvas.getFont());
        this.canvas = canvas;
        this.node = bNode;
        this.isEditable = isEditable;
        ArrayList<BayesNode> nodeParents = this.node.getParents();
        this.getContentPane().setLayout(new BorderLayout());
        this.field_list = new ArrayList(this.node.getNumProbabilities());
        int contextSize = this.node.getContext().size();
        int domainSize = this.node.getDomain().size();
        JPanel gridPanel = new JPanel();
        GridBagLayout gl = new GridBagLayout();
        gridPanel.setLayout(gl);
        Font bold = new Font(this.getFont().getFontName(), 1, this.getFont().getSize());
        Font italic = new Font(this.getFont().getFontName(), 2, this.getFont().getSize());
        int j = 0;
        while (j < nodeParents.size()) {
            label = new JLabel("   " + nodeParents.get(j).getLabel() + "   ");
            label.setForeground(Color.blue);
            label.setFont(bold);
            con = new GridBagConstraints();
            con.gridy = 0;
            con.gridx = j++;
            con.gridwidth = 1;
            con.gridheight = 1;
            gl.setConstraints(label, con);
            gridPanel.add(label);
        }
        j = 0;
        while (j < domainSize) {
            label = new JLabel("   P( " + this.node.getLabel() + "=" + this.node.getDomain().get(j) + " )   ");
            label.setForeground(Color.black);
            label.setFont(italic);
            con = new GridBagConstraints();
            con.gridx = j + nodeParents.size();
            con.gridy = 0;
            con.gridwidth = 1;
            con.gridheight = 1;
            if (nodeParents.size() == 0) {
                con.gridx = j + 1;
            }
            gl.setConstraints(label, con);
            gridPanel.add(label);
            ++j;
        }
        int i = 0;
        while (i < contextSize) {
            ArrayList<String> curContext = this.node.getContext().get(i);
            int j2 = 0;
            while (j2 < curContext.size()) {
                label = new JLabel(curContext.get(j2));
                label.setFont(this.getFont());
                con = new GridBagConstraints();
                con.gridwidth = 1;
                con.gridheight = 1;
                con.gridx = j2++;
                con.gridy = i + 1;
                gl.setConstraints(label, con);
                gridPanel.add(label);
            }
            j2 = 0;
            while (j2 < domainSize) {
                Double prob = this.node.getProbabilities().get(i).get(j2);
                con = new GridBagConstraints();
                con.gridwidth = 1;
                con.gridheight = 1;
                con.gridx = this.node.getParents().size() + j2;
                if (this.node.getParents().size() == 0) {
                    con.gridx = j2 + 1;
                }
                con.gridy = i + 1;
                if (isEditable) {
                    JTextField tf = new JTextField(5);
                    tf.setText(prob.toString());
                    tf.setCaretPosition(0);
                    tf.setFont(this.getFont());
                    tf.addKeyListener(this);
                    gl.setConstraints(tf, con);
                    gridPanel.add(tf);
                    this.field_list.add(tf);
                } else {
                    label = new JLabel(prob.toString());
                    label.setFont(this.getFont());
                    gl.setConstraints(label, con);
                    gridPanel.add(label);
                    this.field_list.add(label);
                }
                ++j2;
            }
            ++i;
        }
        JLabel observationLabel = new JLabel("No observed value for this node.");
        if (!this.node.getObservation().equals("")) {
            observationLabel.setText("Observed value : " + this.node.getObservation());
        }
        observationLabel.setFont(this.getFont());
        observationLabel.setAlignmentX(0.5f);
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 1));
        bottom.add(observationLabel);
        JPanel buttons = new JPanel();
        JButton button = new JButton("OK");
        button.setActionCommand(button.getText());
        button.setFont(this.getFont());
        button.addActionListener(this);
        buttons.add(button);
        this.getRootPane().setDefaultButton(button);
        if (isEditable) {
            button = new JButton("Cancel");
            button.setActionCommand(button.getText());
            button.addActionListener(this);
            button.setFont(this.getFont());
            buttons.add(button);
        }
        bottom.add(buttons);
        JScrollPane gridPane = new JScrollPane(gridPanel, 20, 30);
        this.getContentPane().add((Component)gridPane, "Center");
        this.getContentPane().add((Component)bottom, "South");
        this.pack();
        this.setSize(gridPanel.getWidth() + 50, this.getHeight());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.getHeight() > screenSize.height - 200) {
            this.setSize(this.getWidth(), screenSize.height - 200);
        }
        if (this.getWidth() > screenSize.width - 200) {
            this.setSize(screenSize.width - 200, this.getHeight());
        }
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setProperties() {
        int curProbFieldNum = 0;
        double probSum = 0.0;
        double curProb = 0.0;
        int error = 0;
        ArrayList<Double> probList = new ArrayList<Double>(this.field_list.size());
        int i = 0;
        try {
            i = 0;
            while (i < this.field_list.size()) {
                curProb = Double.parseDouble(((JTextField)this.field_list.get(i)).getText());
                if ((curProb = (double)Math.round(curProb * 100000.0) / 100000.0) > 1.0 || curProb < 0.0) {
                    error = 3;
                    break;
                }
                probSum += curProb;
                if (++curProbFieldNum == this.node.getDomain().size()) {
                    curProbFieldNum = 0;
                    if (Math.round(probSum * 100000.0) != 100000L) {
                        error = 1;
                        break;
                    }
                    probSum = 0.0;
                }
                probList.add(new Double(curProb));
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            error = 2;
        }
        int row = 1 + i / this.node.getDomain().size();
        switch (error) {
            case 0: {
                this.node.initProbs(probList);
                return true;
            }
            case 1: {
                this.canvas.showMessage("Error", "Probabilities for row " + row + " must add up to 1.");
                break;
            }
            case 2: {
                this.canvas.showMessage("Error", "Probability field in row " + row + ", column " + (curProbFieldNum + 1) + " contains a non-numeric value.");
                break;
            }
            case 3: {
                this.canvas.showMessage("Error", "Probability field in row " + row + ", column " + (curProbFieldNum + 1) + " must be between 0 and 1.");
                break;
            }
        }
        return false;
    }

    @Override
    protected boolean actionOK() {
        return !this.isEditable || this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        int row = 0;
        double sum = 0.0;
        int i = 0;
        while (i < this.field_list.size()) {
            row = i / this.node.getDomain().size();
            if (arg0.getSource() == (JTextField)this.field_list.get(i)) {
                int firstIndex = row * this.node.getDomain().size();
                JTextField lastField = (JTextField)this.field_list.get(firstIndex + this.node.getDomain().size() - 1);
                if (arg0.getSource() == lastField) {
                    return;
                }
                try {
                    int j = 0;
                    while (j < this.node.getDomain().size() - 1) {
                        sum += Double.parseDouble("0" + ((JTextField)this.field_list.get(j + firstIndex)).getText());
                        ++j;
                    }
                }
                catch (NumberFormatException nfe) {
                    return;
                }
                lastField.setText(String.valueOf((double)Math.round((1.0 - sum) * 100000.0) / 100000.0));
                break;
            }
            ++i;
        }
    }
}

