/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.elements;

import AIspace.bayes.BayesGraph;
import AIspace.graphToolKit.elements.HistogramNode;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.Variable;
import org.AIspace.ve.properties.Property;
import org.AIspace.ve.properties.PropertyPosition;

public class BayesNode
extends HistogramNode {
    public static final int NODE_REGULAR = 7777;
    public static final int NODE_DECISION = 7778;
    public static final int NODE_UTILITY = 7779;
    public static final int QUERY_QUERY_NODE = 7780;
    public static final int QUERY_ELIMINATED_NODE = 7781;
    public static final int QUERY_VALID_ELIM_NODE = 7782;
    public static final int QUERY_INVALID_ELIM_NODE = 7783;
    public static final int POLICY_OPTIMIZE = 7784;
    public static final int POLICY_USER_DEFINED = 7785;
    public static final int POLICY_IRRELEVANT = 7786;
    public static final int POLICY_UNDEFINED = 7787;
    public static final int POLICY_FROM_FILE = 7788;
    public static final int INDEPENDENCE_START_NODE = 7789;
    public static final int INDEPENDENCE_END_NODE = 7790;
    public static final int INDEPENDENCE_GIVEN_NODE = 7791;
    private ArrayList<BayesNode> parents = new ArrayList(2);
    private ArrayList<BayesNode> children = new ArrayList(2);
    private ArrayList<String> domain;
    private ArrayList<ArrayList<String>> context = new ArrayList(2);
    private ArrayList<ArrayList<Double>> probabilities;
    private LinkedList<Property> variableProperties;
    private LinkedList<Property> definitionProperties;
    private double[] monitorProbs;
    private int nodeType = 7777;
    private boolean isEliminated;
    private boolean isMonitored;
    private String observedValue;
    private boolean isDrawingExtra;
    private int decisionFunctionCreatedBy;
    protected FactorDecision decisionFunction;

    public BayesNode(BayesGraph graph) {
        super(graph);
        this.domain = new ArrayList(2);
        this.variableProperties = new LinkedList();
        this.definitionProperties = new LinkedList();
        this.label[1] = "";
        this.label[0] = "";
        this.hPad = 20;
        this.wPad = 20;
        this.isMonitored = false;
        this.isEliminated = false;
        this.isDrawingExtra = true;
        this.observedValue = "";
        this.decisionFunctionCreatedBy = 7787;
        this.decisionFunction = null;
        this.domain.add("T");
        this.domain.add("F");
        this.context = this.buildContext();
        this.initProbs();
        this.updateSize();
    }

    public void addDomainElement(String element) {
        if (!this.domain.contains(element) && !element.trim().equals("") && this.nodeType != 7779) {
            this.domain.add(element);
            this.setDecisionFunction(null);
            int i = 0;
            while (i < this.children.size()) {
                BayesNode curNode = this.children.get(i);
                if (curNode.nodeType != 7778) {
                    curNode.setContext(curNode.buildContext());
                    curNode.updateAddProbabilities(false, curNode.getParents().indexOf(this));
                }
                ++i;
            }
            if (this.nodeType != 7778) {
                this.updateAddProbabilities(false, 0);
            }
        }
    }

    public void clearDomain() {
        this.domain.clear();
    }

    public void removeDomainElement(String element) {
        if (this.domain.contains(element) && !element.trim().equals("") && this.nodeType != 7779) {
            if (this.nodeType != 7778) {
                this.updateRemoveProbabilities(this, element);
            }
            this.domain.remove(element);
            this.setDecisionFunction(null);
            int i = 0;
            while (i < this.children.size()) {
                BayesNode curNode = this.children.get(i);
                if (curNode.nodeType != 7778) {
                    curNode.updateRemoveProbabilities(this, element);
                    curNode.setContext(curNode.buildContext());
                }
                ++i;
            }
        }
    }

    public boolean equals(BayesNode node) {
        return node != null && this.label[0].equals(node.getLabel());
    }

    protected void addDoubleHistogramValue(double newValue, int addToTotal) {
        this.values.add(new Double(newValue));
        this.totalValue += addToTotal;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        int oldType = this.nodeType;
        this.nodeType = type;
        if (oldType != type) {
            this.setObservation("");
            this.isMonitored = false;
            if (oldType == 7778) {
                this.initProbs();
                this.setDecisionFunction(null);
            } else if (type == 7778) {
                this.setDecisionFunction(null);
            }
        }
        if (oldType != 7779 && type == 7779) {
            this.domain = new ArrayList();
            this.domain.add("Utility");
            this.initProbs();
        } else if (oldType == 7779 && type != 7779) {
            this.domain = new ArrayList();
            this.domain.add("T");
            this.domain.add("F");
            this.initProbs();
        }
        this.setNodeAppearance(this.nodeType);
        this.updateSize();
    }

    @Override
    public int getWidth() {
        FontMetrics fm = this.graph.canvas.getFontMetrics();
        try {
            if (this.label[1].equals("")) {
                return fm.stringWidth(this.label[0]) + this.wPad;
            }
            int curWidth = 0;
            String[] stringArray = this.label;
            int n = this.label.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                int width1 = element == null || element.equals("") ? 0 : fm.stringWidth(element) + this.wPad;
                curWidth = Math.max(width1, curWidth);
                ++n2;
            }
            return curWidth;
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.label[0]) + ", " + this.label[1]);
            return 10;
        }
    }

    @Override
    protected int getHeight() {
        int height = this.graph.canvas.getFontMetrics().getHeight() + this.hPad;
        if (!this.label[1].equals("")) {
            height *= this.label.length;
        }
        return height;
    }

    public boolean isEliminated() {
        return this.isEliminated;
    }

    public void setIsEliminated(boolean isEliminated) {
        this.isEliminated = isEliminated;
    }

    public boolean isObserved() {
        return !this.observedValue.equals("");
    }

    public String getObservation() {
        return this.observedValue;
    }

    public boolean isMonitored() {
        return this.isMonitored;
    }

    public void setIsMonitored(boolean isMonitored) {
        this.isMonitored = isMonitored;
        if (!isMonitored && this.nodeType == 7779) {
            this.label[1] = "";
        }
    }

    public void setObservation(String observedValue) {
        this.observedValue = observedValue;
        if (observedValue.equals("") || !this.domain.contains(observedValue)) {
            this.label[1] = "";
            if (this.isMonitored()) {
                this.showHistogram = true;
            }
        } else {
            if (this.isMonitored()) {
                this.showHistogram = false;
            }
            String nodeName = this.label[0];
            this.label = new String[2];
            this.label[0] = nodeName;
            this.label[1] = "Observed Value: " + observedValue;
        }
        this.updateSize();
    }

    public void setHistogramProbabilities(int decimals) {
        this.numdecimalplaces = decimals;
        this.numFormat.setMaximumFractionDigits(this.numdecimalplaces);
        this.numFormat.setMinimumFractionDigits(this.numdecimalplaces);
        String nodeName = this.label[0];
        this.label = new String[this.monitorProbs.length + 1];
        this.label[0] = nodeName;
        this.clearHistogram();
        this.setHistogramCaption(nodeName);
        int i = 0;
        while (i < this.monitorProbs.length) {
            double histValue = (double)Math.round(this.monitorProbs[i] * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
            if (this.nodeType != 7779) {
                this.addHistogramLabel(String.valueOf(this.domain.get(i)) + "  ");
                this.addDoubleHistogramValue(histValue, (int)(histValue * Math.pow(10.0, decimals)));
                this.label[1] = "";
            } else {
                this.label[1] = "E(V) = " + histValue;
            }
            ++i;
        }
        this.updateSize();
    }

    @Override
    protected void drawLabel(Graphics graphics) {
        FontMetrics fm = this.graph.canvas.getFontMetrics();
        int h = fm.getAscent();
        int width1 = fm.stringWidth(this.label[0]) + this.wPad;
        int width2 = fm.stringWidth(this.label[1]) + this.wPad;
        if (this.isBold) {
            graphics.setColor(Color.white);
        } else if (this.isEliminated) {
            graphics.setColor(this.color);
        } else {
            graphics.setColor(Color.black);
        }
        if (this.label[1].equals("")) {
            graphics.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y + h / 2);
        } else {
            int i = 0;
            while (i < this.label.length) {
                graphics.drawString(this.label[i], (int)this.pos.x - fm.stringWidth(this.label[i]) / 2, (int)this.pos.y - (this.height - this.hPad) / (this.label.length * 2) + h / 2 + i * (this.height - this.hPad) / (this.label.length * 2));
                ++i;
            }
        }
    }

    @Override
    public void draw(Graphics graphics, boolean moving) {
        super.draw(graphics, moving);
        if (!moving) {
            if (!this.isMonitored) {
                this.drawLabel(graphics);
            }
            if (this.isSelected && this.graph.canvas.getSubmode() == 3332) {
                graphics.setColor(Color.magenta);
                graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
                graphics.fillRect((int)((double)this.pos.x - (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y + (double)this.height / 1.5) - 2, 4, 4);
                graphics.fillRect((int)((double)this.pos.x + (double)this.width / 1.5) - 2, (int)((double)this.pos.y - (double)this.height / 1.5) - 2, 4, 4);
            }
        }
    }

    @Override
    protected void drawRows(Graphics g) {
        int currentRowY = (int)this.nw.y + 2 * this.lineHeight + 6;
        int barX = (int)this.nw.x + this.width - 50;
        int valueX = barX - 6 - this.fontMetrics.charsWidth(this.data, 0, this.numdecimalplaces + 2);
        g.drawLine(barX - 1, (int)this.nw.y + this.lineHeight + 3, barX - 1, (int)this.nw.y + this.height);
        this.drawDashedLines(g, barX, (int)this.nw.y + this.lineHeight + 3, (int)this.nw.x + this.width, (int)this.nw.y + this.height);
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.labels.size()) {
            double currentValue = (Double)this.values.get(i);
            if (this.histogramNodeShape == 1113) {
                g.drawString((String)this.labels.get(i), (int)(this.nw.x + 3.0f) + 6, currentRowY);
            } else if (this.histogramNodeShape == 1111) {
                g.drawString((String)this.labels.get(i), (int)(this.nw.x + 3.0f), currentRowY);
            }
            g.drawString(this.numFormat.format(currentValue), valueX, currentRowY);
            g.fillRect(barX, currentRowY - this.lineHeight + 5, (int)(50.0 * currentValue), this.lineHeight - 3);
            currentRowY += this.lineHeight + 3;
            ++i;
        }
    }

    public ArrayList<String> getDomain() {
        return this.domain;
    }

    public ArrayList<BayesNode> getParents() {
        return this.parents;
    }

    public ArrayList<BayesNode> getChildren() {
        return this.children;
    }

    public ArrayList<ArrayList<Double>> getProbabilities() {
        return this.probabilities;
    }

    public int getNumProbabilities() {
        int size = 0;
        int i = 0;
        while (i < this.probabilities.size()) {
            size += this.probabilities.get(i).size();
            ++i;
        }
        return size;
    }

    public double[] flattenProbabilities() {
        double[] flattened = new double[this.getNumProbabilities()];
        if (this.nodeType == 7778) {
            return flattened;
        }
        int probNum = this.context.size();
        int count = 0;
        int i = 0;
        while (i < probNum) {
            int j = 0;
            while (j < this.domain.size()) {
                flattened[count] = this.probabilities.get(i).get(j);
                ++count;
                ++j;
            }
            ++i;
        }
        return flattened;
    }

    public int getDecisionFunctionCreatedBy() {
        return this.decisionFunctionCreatedBy;
    }

    public void setDecisionFunctionCreatedBy(int createdBy) {
        this.decisionFunctionCreatedBy = createdBy;
    }

    public void setDecisionFunction(FactorDecision policy) {
        if (policy == null) {
            this.decisionFunctionCreatedBy = 7787;
        }
        if (this.getNodeType() == 7778) {
            this.decisionFunction = policy;
            this.probabilities = null;
            if (policy != null) {
                this.parents.clear();
                Iterator<Variable> itr = this.decisionFunction.getVariables();
                while (itr.hasNext()) {
                    this.parents.add(((BayesGraph)this.graph).getNode(itr.next().getName(false)));
                }
                this.parents.remove(this);
                this.setContext(this.buildContext());
            }
        } else {
            this.decisionFunction = null;
        }
    }

    public boolean hasDecisionFunction() {
        return this.decisionFunction != null;
    }

    public FactorDecision getDecisionFunction() {
        return this.decisionFunction;
    }

    public void addParent(BayesNode parentNode) {
        if (!this.parents.contains(parentNode)) {
            this.parents.add(parentNode);
            this.setContext(this.buildContext());
            parentNode.addChild(this);
            if (this.getNodeType() == 7778) {
                this.setDecisionFunction(null);
            } else {
                this.updateAddProbabilities(true, 0);
            }
        }
    }

    public void removeParent(BayesNode parent) {
        if (this.getNodeType() != 7778) {
            this.updateRemoveProbabilities(parent, null);
        }
        this.parents.remove(parent);
        this.setContext(this.buildContext());
        if (this.getNodeType() == 7778) {
            this.setDecisionFunction(null);
        }
    }

    private boolean sameExcept(ArrayList v1, ArrayList v2, int index) {
        if (v1.size() != v2.size()) {
            return false;
        }
        int i = 0;
        while (i < v1.size()) {
            String s2;
            String s1;
            if (i != index && !(s1 = (String)v1.get(i)).equals(s2 = (String)v2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeChild(BayesNode child) {
        this.children.remove(child);
    }

    public void addChild(BayesNode childNode) {
        if (!this.children.contains(childNode)) {
            this.children.add(childNode);
            childNode.addParent(this);
        }
    }

    public void initProbs() {
        this.probabilities = new ArrayList(this.context.size());
        Double uniformVal = new Double(1.0 / (double)this.domain.size());
        uniformVal = (double)((int)(uniformVal * 10000.0)) / 10000.0;
        int timesAdded = this.domain.size();
        if (this.nodeType == 7779) {
            uniformVal = new Double(0.0);
            timesAdded = 1;
        }
        int i = 0;
        while (i < this.context.size()) {
            ArrayList<Double> vec = new ArrayList<Double>(this.domain.size());
            double total = 0.0;
            int j = 0;
            while (j < timesAdded) {
                if (j == timesAdded - 1) {
                    double newVal = 1.0 - total;
                    newVal = (double)((int)(newVal * 10000.0)) / 10000.0;
                    vec.add(newVal);
                } else {
                    total += uniformVal.doubleValue();
                    vec.add(uniformVal);
                }
                ++j;
            }
            this.probabilities.add(vec);
            ++i;
        }
    }

    public void initProbs(ArrayList<Double> flatVec) {
        this.probabilities = new ArrayList(this.context.size());
        Double value = new Double(1.0 / (double)this.domain.size());
        int numAdded = 0;
        int i = 0;
        while (i < this.context.size()) {
            ArrayList<Double> v = new ArrayList<Double>(this.domain.size());
            int j = 0;
            while (j < this.domain.size()) {
                if (numAdded < flatVec.size()) {
                    v.add(flatVec.get(numAdded));
                } else {
                    v.add(value);
                }
                ++numAdded;
                ++j;
            }
            this.probabilities.add(v);
            ++i;
        }
    }

    public boolean isDrawingExtra() {
        return this.isDrawingExtra;
    }

    public void setDrawingExtra(boolean isDrawingExtra) {
        this.isDrawingExtra = isDrawingExtra;
        this.showHistogram = this.isMonitored && isDrawingExtra && !this.isObserved();
        this.label[1] = this.isObserved() && isDrawingExtra ? "Observed Value: " + this.observedValue : "";
        this.updateSize();
    }

    public void setMonitoredProbs(double[] probs) {
        this.monitorProbs = probs;
    }

    public void updateAddProbabilities(boolean parentAdded, int parentIndex) {
        Double zeroVal = new Double(0.0);
        Double uniformVal = new Double(1.0 / (double)this.domain.size());
        uniformVal = (double)((int)(uniformVal * 10000.0)) / 10000.0;
        if (this.nodeType == 7779) {
            uniformVal = new Double(0.0);
        }
        if (this.probabilities.size() > this.context.size()) {
            return;
        }
        if (this.probabilities.size() < this.context.size()) {
            if (this.probabilities.size() == 0) {
                int i = this.probabilities.size();
                while (i < this.context.size()) {
                    ArrayList<Double> vec = new ArrayList<Double>(this.domain.size());
                    double total = 0.0;
                    int j = 0;
                    while (j < this.domain.size()) {
                        if (j != this.domain.size() - 1) {
                            vec.add(uniformVal);
                            total += uniformVal.doubleValue();
                        } else {
                            double newVal = (double)((int)((1.0 - total) * 10000.0)) / 10000.0;
                            vec.add(newVal);
                        }
                        ++j;
                    }
                    this.probabilities.add(vec);
                    ++i;
                }
            } else if (!parentAdded) {
                int timesOccurring = parentIndex == 0 ? 1 : this.getParents().get(parentIndex - 1).getDomain().size();
                int difSize = this.context.size();
                int i = 0;
                while (i < parentIndex) {
                    difSize /= this.getParents().get(i).getDomain().size();
                    ++i;
                }
                int repeatSize = (this.context.size() - this.probabilities.size()) / timesOccurring;
                int index = difSize - repeatSize;
                int i2 = 0;
                while (i2 < timesOccurring) {
                    ArrayList<Double> vec = new ArrayList<Double>(this.domain.size());
                    double total = 0.0;
                    int j = 0;
                    while (j < this.domain.size()) {
                        if (j != this.domain.size() - 1) {
                            vec.add(uniformVal);
                            total += uniformVal.doubleValue();
                        } else {
                            double newVal = (double)((int)((1.0 - total) * 10000.0)) / 10000.0;
                            vec.add(newVal);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < repeatSize) {
                        this.probabilities.add(index, vec);
                        ++j;
                    }
                    index += difSize;
                    ++i2;
                }
            } else {
                ArrayList oldProbs = new ArrayList();
                int i = 0;
                while (i < this.probabilities.size()) {
                    oldProbs.add(new ArrayList());
                    int j = 0;
                    while (j < this.domain.size()) {
                        ((ArrayList)oldProbs.get(i)).add(this.probabilities.get(i).get(j));
                        ++j;
                    }
                    ++i;
                }
                int numDuplicated = 0;
                int index = 0;
                while (index < this.context.size()) {
                    ArrayList<Double> vec = new ArrayList<Double>(this.domain.size());
                    int j = 0;
                    while (j < this.domain.size()) {
                        vec.add((Double)((ArrayList)oldProbs.get(numDuplicated)).get(j));
                        ++j;
                    }
                    ++numDuplicated;
                    j = 0;
                    while (j < this.parents.get((int)(this.parents.size() - 1)).domain.size()) {
                        if (index < this.probabilities.size()) {
                            this.probabilities.set(index, vec);
                        } else {
                            this.probabilities.add(vec);
                        }
                        ++index;
                        ++j;
                    }
                }
            }
        } else {
            int i = 0;
            while (i < this.probabilities.size()) {
                ArrayList<Double> vec = this.probabilities.get(i);
                int j = vec.size();
                while (j < this.domain.size()) {
                    vec.add(zeroVal);
                    ++j;
                }
                ++i;
            }
        }
    }

    public void updateRemoveProbabilities(BayesNode parent, String element) {
        if (parent.getLabel().equals(this.label[0])) {
            int elementIndex = this.domain.indexOf(element);
            int i = 0;
            while (i < this.probabilities.size()) {
                block17: {
                    double prob;
                    ArrayList<Double> curList = this.probabilities.get(i);
                    try {
                        prob = curList.get(elementIndex);
                    }
                    catch (IndexOutOfBoundsException e) {
                        break block17;
                    }
                    curList.remove(elementIndex);
                    prob /= (double)curList.size();
                    double total = 0.0;
                    int index = 0;
                    while (index < curList.size()) {
                        double newValue;
                        if (index != curList.size() - 1) {
                            newValue = curList.get(index);
                            newValue += prob;
                            newValue = (double)((int)(newValue * 10000.0)) / 10000.0;
                            curList.set(index, newValue);
                            total += newValue;
                        } else {
                            newValue = (double)((int)((1.0 - total) * 10000.0)) / 10000.0;
                            curList.set(index, newValue);
                        }
                        ++index;
                    }
                }
                ++i;
            }
        } else if (element == null) {
            int parentIndex = this.parents.indexOf(parent);
            if (parentIndex == -1) {
                return;
            }
            int newProbsSize = this.context.size() / parent.getDomain().size();
            int parIndex = this.parents.indexOf(parent);
            int i = 0;
            while (i < newProbsSize) {
                ArrayList<String> keepVec = this.context.get(i);
                int j = i + 1;
                while (j < this.context.size()) {
                    ArrayList<String> testVec = this.context.get(j);
                    if (this.sameExcept(keepVec, testVec, parIndex)) {
                        this.context.remove(testVec);
                        this.probabilities.remove(j);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            int parentIndex = this.parents.indexOf(parent);
            if (parentIndex == -1) {
                return;
            }
            int i = this.context.size() - 1;
            while (i >= 0) {
                ArrayList<String> contextVec = this.context.get(i);
                if (element.equals(contextVec.get(parentIndex))) {
                    this.probabilities.remove(i);
                }
                --i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected ArrayList<ArrayList<String>> buildContext() {
        newContext = new ArrayList<ArrayList<String>>();
        numContexts = 1;
        if (this.parents.isEmpty()) {
            vec = new ArrayList<String>(1);
            if (this.nodeType == 7779) {
                vec.add("Prior Utility ");
            } else if (this.nodeType == 7777) {
                vec.add("Prior Probability ");
            } else {
                vec.add("Decision ");
            }
            newContext.add(vec);
            return newContext;
        }
        i = 0;
        while (i < this.parents.size()) {
            numContexts *= this.parents.get(i).getDomain().size();
            ++i;
        }
        i = 0;
        while (i < numContexts) {
            newContext.add(new ArrayList<E>());
            ++i;
        }
        timesToDuplicateEachElement = numContexts;
        i = 0;
        while (i < this.parents.size()) {
            curNode = this.parents.get(i);
            timesToAddElement = timesToDuplicateEachElement /= curNode.getDomain().size();
            curContextNum = 0;
            while (curContextNum < numContexts) {
                m = 0;
                ** GOTO lbl45
                {
                    newContext.get(curContextNum).add(curNode.getDomain().get(m));
                    ++curContextNum;
                    do {
                        if (curContextNum < timesToAddElement) continue block4;
                        timesToAddElement += timesToDuplicateEachElement;
                        ++m;
lbl45:
                        // 2 sources

                    } while (m < curNode.getDomain().size());
                }
            }
            ++i;
        }
        return newContext;
    }

    private void setContext(ArrayList<ArrayList<String>> context) {
        this.context = context;
    }

    public ArrayList<ArrayList<String>> getContext() {
        return this.context;
    }

    public void setNodeAppearance(int type) {
        this.xw = 0;
        switch (type) {
            case 7777: {
                this.shape = 1110;
                this.color = Color.BLUE;
                break;
            }
            case 7778: {
                this.shape = 1111;
                this.color = Color.ORANGE;
                break;
            }
            case 7779: {
                this.shape = 1112;
                this.color = Color.RED;
                break;
            }
            case 7780: {
                this.color = Color.GREEN;
                this.xw = 2;
                break;
            }
            case 7781: {
                this.color = Color.LIGHT_GRAY;
                break;
            }
            case 7782: {
                this.color = Color.MAGENTA;
                this.xw = 3;
                break;
            }
            case 7783: {
                this.xw = 0;
                break;
            }
            case 7789: {
                this.color = Color.RED;
                this.xw = 2;
                break;
            }
            case 7791: {
                this.color = Color.BLUE;
                this.xw = 2;
                break;
            }
            case 7790: {
                this.color = Color.MAGENTA;
                this.xw = 2;
                break;
            }
            default: {
                this.shape = 1110;
                this.color = Color.BLACK;
            }
        }
    }

    public void removeNodeAsParent() {
        int i = 0;
        while (i < this.children.size()) {
            BayesNode curNode = this.children.get(i);
            int ind = curNode.getParents().indexOf(this);
            if (BayesNode.isParentOf(this, curNode)) {
                curNode.removeParent(this);
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.label[0];
    }

    /*
     * Unable to fully structure code
     */
    public PropertyPosition setVariableProperties(Iterator<Property> propertiesIterator, boolean extractPosition) {
        if (!extractPosition) ** GOTO lbl14
        position = null;
        while (propertiesIterator.hasNext()) {
            property = propertiesIterator.next();
            if (property instanceof PropertyPosition) {
                position = (PropertyPosition)property;
                continue;
            }
            this.variableProperties.add(property);
        }
        return position;
lbl-1000:
        // 1 sources

        {
            this.variableProperties.add(propertiesIterator.next());
lbl14:
            // 2 sources

            ** while (propertiesIterator.hasNext())
        }
lbl15:
        // 1 sources

        return null;
    }

    public Iterator<Property> getVariableProperties(boolean includePosition) {
        if (includePosition) {
            LinkedList<Property> properties = new LinkedList<Property>(this.variableProperties);
            properties.add(new PropertyPosition(this.pos.x, this.pos.y));
            return properties.iterator();
        }
        return this.variableProperties.iterator();
    }

    /*
     * Unable to fully structure code
     */
    public PropertyPosition setDefinitionProperties(Iterator<Property> propertiesIterator, boolean extractPosition) {
        if (!extractPosition) ** GOTO lbl14
        position = null;
        while (propertiesIterator.hasNext()) {
            property = propertiesIterator.next();
            if (property instanceof PropertyPosition) {
                position = (PropertyPosition)property;
                continue;
            }
            this.definitionProperties.add(property);
        }
        return position;
lbl-1000:
        // 1 sources

        {
            this.definitionProperties.add(propertiesIterator.next());
lbl14:
            // 2 sources

            ** while (propertiesIterator.hasNext())
        }
lbl15:
        // 1 sources

        return null;
    }

    public Iterator<Property> getDefinitionProperties(boolean includePosition) {
        if (includePosition) {
            LinkedList<Property> properties = new LinkedList<Property>(this.definitionProperties);
            properties.add(new PropertyPosition(this.pos.x, this.pos.y));
            return properties.iterator();
        }
        return this.definitionProperties.iterator();
    }

    public void setPosition(Point p) {
        this.pos = p;
    }

    public static boolean isParentOf(BayesNode node, ArrayList nodeList) {
        int i = 0;
        while (i < nodeList.size()) {
            BayesNode tmpNode = (BayesNode)nodeList.get(i);
            if (tmpNode.getParents().contains(node)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isParentOf(BayesNode parent, BayesNode child) {
        return child.getParents().contains(parent);
    }

    public static boolean isDescendentOf(BayesNode firstNode, BayesNode secondNode) {
        if (firstNode.getParents().contains(secondNode)) {
            return true;
        }
        int i = 0;
        while (i < secondNode.getChildren().size()) {
            if (BayesNode.isDescendentOf(firstNode, secondNode.getChildren().get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isChildOf(BayesNode parent, BayesNode child) {
        return child.getParents().contains(parent);
    }

    public static boolean isAncestorOf(BayesNode firstNode, BayesNode secondNode) {
        if (secondNode.getParents().contains(firstNode)) {
            return true;
        }
        int i = 0;
        while (i < secondNode.getParents().size()) {
            BayesNode tmpNode = secondNode.getParents().get(i);
            if (BayesNode.isDescendentOf(firstNode, tmpNode)) {
                return true;
            }
            if (BayesNode.isAncestorOf(firstNode, tmpNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDirectAncestorOf(BayesNode firstNode, BayesNode secondNode) {
        if (secondNode.getParents().contains(firstNode)) {
            return true;
        }
        int i = 0;
        while (i < secondNode.getParents().size()) {
            if (BayesNode.isDirectAncestorOf(firstNode, secondNode.getParents().get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

