/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.quiz;

import AIspace.bayes.elements.BayesNode;
import java.util.ArrayList;
import java.util.Iterator;

public class BayesIndependence {
    private static final int INDEPENDENCE_CHAIN = 2224;
    private static final int INDEPENDENCE_FORK = 2225;
    private static final int INDEPENDENCE_COLLIDER = 2226;

    public static boolean isIndependentOf(int totalNumOfNodes, BayesNode firstNode, BayesNode secondNode, ArrayList<BayesNode> givenNodes) {
        ArrayList<BayesNode> curPath = new ArrayList<BayesNode>(totalNumOfNodes);
        curPath.add(firstNode);
        return !BayesIndependence.findDConnected(totalNumOfNodes, firstNode, curPath, givenNodes, new ArrayList<BayesNode>(5)).contains(secondNode);
    }

    private static ArrayList<BayesNode> findDConnected(int totalNumOfNodes, BayesNode firstNode, ArrayList<BayesNode> curPath, ArrayList<BayesNode> givenNodes, ArrayList<BayesNode> dConnected) {
        if (curPath.size() >= totalNumOfNodes || BayesIndependence.allInside(firstNode, curPath)) {
            return dConnected;
        }
        ArrayList<BayesNode> connected = new ArrayList<BayesNode>(firstNode.getParents().size() + firstNode.getChildren().size());
        for (BayesNode curNode : firstNode.getParents()) {
            if (curPath.contains(curNode)) continue;
            connected.add(curNode);
        }
        for (BayesNode curNode : firstNode.getChildren()) {
            if (curPath.contains(curNode)) continue;
            connected.add(curNode);
        }
        for (BayesNode curNode : connected) {
            ArrayList<BayesNode> nextPath = new ArrayList<BayesNode>(curPath);
            nextPath.add(curNode);
            if (BayesIndependence.isBlockedBy(nextPath, givenNodes)) continue;
            if (!dConnected.contains(curNode)) {
                dConnected.add(curNode);
            }
            BayesIndependence.findDConnected(totalNumOfNodes, curNode, nextPath, givenNodes, dConnected);
        }
        return dConnected;
    }

    private static boolean allInside(BayesNode node, ArrayList<BayesNode> path) {
        Iterator<BayesNode> itr = node.getParents().iterator();
        while (itr.hasNext()) {
            if (path.contains(itr.next())) continue;
            return false;
        }
        itr = node.getChildren().iterator();
        while (itr.hasNext()) {
            if (path.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockedBy(ArrayList<BayesNode> path, ArrayList<BayesNode> Z) {
        if (path.size() < 3) {
            return false;
        }
        BayesNode node = path.get(path.size() - 2);
        int type = BayesIndependence.getTypeOf(node, path);
        if ((type == 2224 || type == 2225) && Z.contains(node)) {
            return true;
        }
        boolean descendentInZ = false;
        if (type == 2226 && !Z.contains(node)) {
            Iterator<BayesNode> itr = Z.iterator();
            while (itr.hasNext()) {
                if (!BayesNode.isDescendentOf(itr.next(), node)) continue;
                descendentInZ = true;
                break;
            }
            if (!descendentInZ) {
                return true;
            }
        }
        return false;
    }

    private static int getTypeOf(BayesNode node, ArrayList<BayesNode> path) {
        int index = path.indexOf(node);
        if (index < 1 || index > path.size() - 1) {
            return -1;
        }
        BayesNode earlier = path.get(index - 1);
        BayesNode later = path.get(index + 1);
        if (node.getParents().contains(earlier)) {
            if (node.getParents().contains(later)) {
                return 2226;
            }
            return 2224;
        }
        if (node.getChildren().contains(later)) {
            return 2225;
        }
        return 2224;
    }
}

