/*
 * Decompiled with CFR 0.152.
 */
package AIspace.bayes.verboseQuery;

import AIspace.bayes.BayesGraph;
import AIspace.bayes.BayesWindow;
import AIspace.bayes.DisplayCanvas;
import AIspace.bayes.InlineBayesApplet;
import AIspace.bayes.dialogs.ElimOrderDialog;
import AIspace.bayes.dialogs.InspectFactorDialog;
import AIspace.bayes.elements.BayesNode;
import AIspace.bayes.verboseQuery.QueryAutoElim;
import AIspace.bayes.verboseQuery.QueryWindow;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import org.AIspace.ve.Configuration;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDecision;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.Inference;
import org.AIspace.ve.InferenceStepByStep;
import org.AIspace.ve.Policy;
import org.AIspace.ve.PolicyStepByStep;
import org.AIspace.ve.Query;
import org.AIspace.ve.QueryStepByStep;
import org.AIspace.ve.Variable;
import org.AIspace.ve.VariableDecision;

public class QueryCanvas
extends DisplayCanvas {
    public static final int VERBOSE_ELIMINATE = 4573;
    private InspectFactorDialog inspectFactorDialog;
    private QueryAutoElim autoElim;
    private BayesNode queryNode;
    private InferenceStepByStep<?, ?, ?> query;
    private ArrayList<Factor> eliminatedFactors;
    private HashMap<String, ArrayList<Factor>> factorToFactorsEliminatedHashMap;
    private boolean isOptimizing;
    private boolean isEliminatingByMouse;

    public QueryCanvas(Container parent, DecisionNetwork network, boolean isOptimizing, boolean inline) {
        super(parent, inline);
        this.graph = new BayesGraph(this, new ArrayList<BayesNode>(), network);
        this.mode = 2221;
        this.submode = 4573;
        this.isOptimizing = isOptimizing;
        this.isEliminatingByMouse = true;
        this.eliminatedFactors = new ArrayList();
        this.factorToFactorsEliminatedHashMap = new HashMap();
    }

    @Override
    protected void popupCanvas(int x, int y) {
        JMenuItem mItem;
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Canvas Options"));
        if (((QueryWindow)this.parent).areIrrelevantButtonsEnabled()) {
            mItem = new JMenuItem("Prune Irrelevant Variables");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Don't Prune Irrelevant Variables");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isProjectButtonEnabled()) {
            mItem = new JMenuItem("Project Observations");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).areElimButtonsEnabled()) {
            mItem = new JMenuItem("Eliminate Next (" + this.getNextName() + ")");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Auto Eliminate");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isMultiplyButtonEnabled()) {
            mItem = new JMenuItem("Multiply Final Factors");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isNormalizeButtonEnabled()) {
            mItem = new JMenuItem("Normalize Final Factor");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isOrderButtonEnabled()) {
            mItem = new JMenuItem("Current Elimination Order");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isUndoButtonEnabled()) {
            mItem = new JMenuItem("Undo");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        if (((QueryWindow)this.parent).isResetButtonEnabled()) {
            mItem = new JMenuItem("Reset Query");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            this.pop.add(mItem);
        }
        this.pop.addSeparator();
        mItem = new JMenuItem("Autoscale");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupEdge(int x, int y) {
    }

    @Override
    protected void popupNode(int x, int y) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        Point p = new Point(e.getX(), e.getY());
        Entity ent = this.graph.searchEntities(p);
        this.mPressedPos.move(p);
        this.mDraggedPos.move(p);
        if (e.getModifiers() == 4 || ent == null || ent.type != 7770) {
            return;
        }
        BayesNode curNode = (BayesNode)ent;
        if (!this.isEliminatingByMouse) {
            this.showMessage("Error", "Out of memory, please click \"Reset Query\"");
            return;
        }
        if (((QueryWindow)this.parent).areIrrelevantButtonsEnabled()) {
            if (curNode.color == Color.magenta) {
                ((QueryWindow)this.parent).removeIrrelevantVariables(null);
            }
            return;
        }
        if (this.isValidNodeToEliminate(curNode)) {
            ((QueryWindow)this.parent).setIrrelevantButtons(false);
            if (curNode.isObserved()) {
                this.projectObservation(curNode);
                ((QueryWindow)this.parent).populateFactors();
                ((QueryWindow)this.parent).updateView();
                return;
            }
            try {
                this.step(curNode, true);
            }
            catch (Error er) {
                this.isEliminatingByMouse = false;
                ((QueryWindow)this.parent).setEliminationItems(false);
                this.showMessage("Error", "Error in VE (Memory Error): " + er.getLocalizedMessage());
            }
        } else if (!((QueryWindow)this.parent).areElimButtonsEnabled() && curNode.equals(this.queryNode)) {
            if (((QueryWindow)this.parent).isMultiplyButtonEnabled()) {
                this.multiplyFinalFactors();
            } else if (((QueryWindow)this.parent).isNormalizeButtonEnabled()) {
                this.normalize();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 4) {
            return;
        }
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        this.mDraggedSelect();
    }

    @Override
    protected void mReleasedSelect(Entity ent, boolean ctrlDown) {
        if (this.submode == 4573) {
            return;
        }
        super.mReleasedSelect(ent, ctrlDown);
    }

    protected BayesNode getQueryNode() {
        return this.queryNode;
    }

    protected QueryStepByStep getEvidenceQuery() {
        return this.query.getEvidenceQuery();
    }

    public InferenceStepByStep<?, ?, ?> getQuery() {
        return this.query;
    }

    @Override
    public void aPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Auto Eliminate")) {
            this.startAutoEliminate();
        } else if (arg.startsWith("Eliminate Next")) {
            this.step(true);
        } else if (arg.equals("Prune Irrelevant Variables")) {
            ((QueryWindow)this.parent).removeIrrelevantVariables(null);
        } else if (arg.equals("Don't Prune Irrelevant Variables")) {
            ((QueryWindow)this.parent).dontPrune();
        } else if (arg.equals("Project Observations")) {
            ((QueryWindow)this.parent).projectObservations();
        } else if (arg.equals("Reset Query")) {
            ((QueryWindow)this.parent).resetQuery();
        } else if (arg.equals("Multiply Final Factors")) {
            this.multiplyFinalFactors();
        } else if (arg.equals("Normalize Final Factor")) {
            this.normalize();
        } else if (arg.equals("Current Elimination Order")) {
            this.showOrder();
        } else if (arg.equals("Undo")) {
            this.undo();
        } else {
            super.aPerformed(e);
        }
    }

    @Override
    public void disposeWindows() {
        super.disposeWindows();
        if (this.inspectFactorDialog != null) {
            this.inspectFactorDialog.disposeWindows();
            this.inspectFactorDialog.dispose();
        }
    }

    protected boolean step(boolean populateFactors) {
        try {
            this.step(this.getNodeToEliminate(), populateFactors);
            return true;
        }
        catch (Error er) {
            ((QueryWindow)this.parent).setEliminationItems(false);
            this.isEliminatingByMouse = false;
            this.showMessage("Error", "Error in VE (Memory Error): " + er.getLocalizedMessage());
            return false;
        }
    }

    protected void step(BayesNode node, boolean populateFactors) throws Error {
        this.eliminateNode(node, populateFactors);
        ((QueryWindow)this.parent).updateView();
    }

    protected void multiplyFinalFactors() {
        if (this.query.finalMultiplicationNeeded()) {
            this.query.multiplyFinalFactors();
            Iterator<Factor> iter = this.query.getFactorsRemoved();
            ArrayList<Factor> tempFactorList = new ArrayList<Factor>();
            while (iter.hasNext()) {
                tempFactorList.add(iter.next());
            }
            this.eliminatedFactors.addAll(tempFactorList);
            ((QueryWindow)this.parent).populateFactors();
            this.factorToFactorsEliminatedHashMap.put(((QueryWindow)this.parent).getNewestFactorName(), tempFactorList);
        }
        ((QueryWindow)this.parent).updateView();
    }

    protected void normalize() {
        if (this.query.normalizationNeeded()) {
            try {
                this.query.normalize();
                ArrayList<Factor> eFactors = ((QueryWindow)this.parent).moveRemainingCurrent();
                for (Factor factor : eFactors) {
                    this.eliminatedFactors.add(factor);
                }
                ((QueryWindow)this.parent).populateFactors();
                ((QueryWindow)this.parent).updateView();
            }
            catch (ArithmeticException e) {
                this.showMessage("Error", "Observations were such that the probability of evidence is 0, resulting in a divide by 0.");
                return;
            }
        }
        ((QueryWindow)this.parent).updatePromptLabel();
    }

    protected void finishQuery(boolean moveFinal) {
        double[] results = null;
        if (this.queryNode != null && this.queryNode.isObserved()) {
            results = new double[this.queryNode.getDomain().size()];
            Iterator<String> itr = this.queryNode.getDomain().iterator();
            int i = 0;
            while (itr.hasNext()) {
                results[i++] = this.queryNode.getObservation().equals(itr.next()) ? 1.0 : 0.0;
            }
            this.setPromptLabel("Queries on observed nodes have no steps.");
            ((QueryWindow)this.parent).setIrrelevantButtons(false);
            ((QueryWindow)this.parent).setResetButton(false);
        } else {
            Factor resultFactor;
            Inference.Result result;
            if (this.isOptimizing) {
                result = (Policy.Result)this.query.getResult();
                results = new double[]{result.getNormFactor().iterator().next()};
                BayesGraph mainGraph = ((QueryWindow)this.parent).parentWindow instanceof BayesWindow ? (BayesGraph)((BayesWindow)((QueryWindow)this.parent).parentWindow).returnCanvas().graph : (BayesGraph)((InlineBayesApplet)((QueryWindow)this.parent).parentWindow).getCanvas().graph;
                for (BayesNode curNode : mainGraph.getDecisionNodes()) {
                    curNode.setDecisionFunction(((Policy.Result)result).getDecisionFunction((VariableDecision)((BayesGraph)this.graph).getDecisionNetwork().getVariable(curNode.getLabel()), true));
                    curNode.setDecisionFunctionCreatedBy(7784);
                }
                resultFactor = result.getNormFactor();
            } else {
                result = (Query.Result)this.query.getResult();
                results = new double[(int)result.getFactor().getSize()];
                resultFactor = this.queryNode == null ? result.getFactor() : result.getNormFactor();
                FactorIterator itr = resultFactor.iterator();
                int i = 0;
                while (itr.hasNext()) {
                    results[i++] = itr.next();
                }
            }
            if (moveFinal) {
                ArrayList<Factor> eFactors = ((QueryWindow)this.parent).moveRemainingCurrent();
                for (Factor factor : eFactors) {
                    this.eliminatedFactors.add(factor);
                }
                ((QueryWindow)this.parent).addAnswerFactor(resultFactor, true);
                this.factorToFactorsEliminatedHashMap.put(((QueryWindow)this.parent).getNewestFactorName(), eFactors);
            } else {
                ((QueryWindow)this.parent).clearCurrentFactors();
                ((QueryWindow)this.parent).addAnswerFactor(resultFactor, false);
            }
            this.setPromptLabel("Press \"Reset Query\" to start a new query.\nMaximum Encountered Factor Size: " + this.query.getMaxFactorSizeSoFar());
        }
        this.openAnswerDialog(this.queryNode, results, ((BayesGraph)this.graph).getObservedNodes());
    }

    protected void startAutoEliminate() {
        ((QueryWindow)this.parent).setEliminationItems(false);
        if (this.isMoreToProject()) {
            this.projectAllObservations();
        }
        while (!this.isFinished() && this.step(true)) {
        }
    }

    protected void stopAutoEliminate() {
        if (this.autoElim != null) {
            this.autoElim.setRunning(false);
            this.autoElim.quit();
            this.autoElim = null;
        }
    }

    private void eliminateNode(BayesNode node, boolean populateFactors) throws Error {
        FactorDecision decisionFunction = (FactorDecision)this.query.eliminate(((BayesGraph)this.graph).getDecisionNetwork().getVariable(node.getLabel()));
        Iterator<Factor> itr = this.query.getFactorsRemoved();
        ArrayList<Factor> eFactors = new ArrayList<Factor>();
        while (itr.hasNext()) {
            Factor curFactor = itr.next();
            this.eliminatedFactors.add(curFactor);
            eFactors.add(curFactor);
        }
        ((QueryWindow)this.parent).setElimPromptLabel("Maximum Encountered Factor Size: " + this.query.getMaxFactorSizeSoFar());
        node.setIsEliminated(true);
        node.setNodeAppearance(7781);
        if (populateFactors) {
            ((QueryWindow)this.parent).populateFactors();
        }
        if (decisionFunction != null) {
            ((QueryWindow)this.parent).addDecisionFunction(decisionFunction);
            this.factorToFactorsEliminatedHashMap.put(((QueryWindow)this.parent).getNewestDecisionFunctionName(), eFactors);
        }
        ((QueryWindow)this.parent).setOrderButton(true);
        ((QueryWindow)this.parent).updateElimButtonText();
        this.factorToFactorsEliminatedHashMap.put(((QueryWindow)this.parent).getNewestFactorName(), eFactors);
    }

    protected void projectObservation(BayesNode node) {
        try {
            this.observeNode(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((QueryWindow)this.parent).setIrrelevantButtons(false);
        ((QueryWindow)this.parent).populateFactors();
    }

    protected void projectAllObservations() {
        for (BayesNode curNode : ((BayesGraph)this.graph).getObservedNodes()) {
            if (curNode.isEliminated()) continue;
            this.projectObservation(curNode);
        }
    }

    protected void observeNode(BayesNode node) {
        this.query.projectObservation(((BayesGraph)this.graph).getDecisionNetwork().getVariable(node.getLabel()));
        node.setDrawingExtra(true);
        node.setIsEliminated(true);
        node.updatePosition();
        Iterator<Factor> facItr = this.query.getFactorsRemoved();
        while (facItr.hasNext()) {
            this.eliminatedFactors.add(facItr.next());
        }
    }

    protected void addEliminatedFactor(Factor factor) {
        this.eliminatedFactors.add(factor);
    }

    private BayesNode getNodeToEliminate() {
        return ((BayesGraph)this.graph).getNode(this.query.getProposedVariable(((QueryWindow)this.parent).getEliminationHeuristic()).getName(false));
    }

    public Factor getFactor(int factorID) {
        return this.query.getFactor(factorID);
    }

    protected void removeIrrelevantVars(Iterator<Variable> prunedItr) {
        if (this.queryNode != null && this.queryNode.isObserved()) {
            for (BayesNode curNode : ((BayesGraph)this.graph).getAllNodes()) {
                if (curNode.equals(this.queryNode)) continue;
                curNode.setNodeAppearance(7781);
                curNode.setIsEliminated(true);
            }
        } else {
            Iterator<Variable> varItr = prunedItr != null ? prunedItr : this.query.pruneIrrelevantVariables(true);
            while (varItr.hasNext()) {
                BayesNode curNode = ((BayesGraph)this.graph).getNode(varItr.next().getName(false));
                curNode.setNodeAppearance(7781);
                curNode.setIsEliminated(true);
            }
            if (prunedItr == null) {
                Iterator<Factor> itr = this.query.getFactorsRemoved();
                while (itr.hasNext()) {
                    this.eliminatedFactors.add(itr.next());
                }
            }
        }
        this.repaint();
    }

    protected void setQueryNode(BayesNode node) {
        this.queryNode = node;
        if (node == null || !node.isObserved()) {
            Variable[] queryNode = null;
            queryNode = node != null ? new Variable[]{((BayesGraph)this.graph).getDecisionNetwork().getVariable(node.getLabel())} : new Variable[]{};
            ArrayList<BayesNode> observedNodesList = ((BayesGraph)this.graph).getObservedNodes();
            Variable[] observedVariables = new Variable[observedNodesList.size()];
            int[] observedValues = new int[observedNodesList.size()];
            int i = 0;
            while (i < observedNodesList.size()) {
                BayesNode curNode = observedNodesList.get(i);
                observedVariables[i] = ((BayesGraph)this.graph).getDecisionNetwork().getVariable(curNode.getLabel());
                observedValues[i] = -1;
                int j = 0;
                while (j < observedVariables[i].getDomain().getSize()) {
                    if (observedVariables[i].getDomain().getValue(j).equals(curNode.getObservation())) {
                        observedValues[i] = j;
                        break;
                    }
                    ++j;
                }
                if (observedValues[i] == -1) {
                    this.showMessage("Error", "Observed value for node not found in variable for query, stopping query.");
                    return;
                }
                ++i;
            }
            Configuration config = new Configuration();
            config.setFactorSavingForTracing(true);
            this.query = this.isOptimizing ? new PolicyStepByStep(((BayesGraph)this.graph).getDecisionNetwork(), observedVariables, observedValues, config) : (node != null && node.getNodeType() == 7779 ? new QueryStepByStep(((BayesGraph)this.graph).getDecisionNetwork(), observedVariables, observedValues, config) : new QueryStepByStep(queryNode, ((BayesGraph)this.graph).getDecisionNetwork(), observedVariables, observedValues, config));
            this.setQuery(this.query);
        }
        this.eliminatedFactors.clear();
        this.eliminatedFactors.trimToSize();
    }

    protected void setQuery(InferenceStepByStep<?, ?, ?> queryStep) {
        this.query = queryStep.clone();
        this.isMoreToProject();
        this.eliminatedFactors.clear();
        this.eliminatedFactors.trimToSize();
        System.runFinalization();
        System.gc();
    }

    public ArrayList<Factor> getEliminatedFactors() {
        return this.eliminatedFactors;
    }

    public ArrayList<Factor> getFactorsEliminated(String factorName) {
        return this.factorToFactorsEliminatedHashMap.get(factorName);
    }

    protected void resetQuery() {
        if (((QueryWindow)this.parent).isInvestigatingPeCalculation()) {
            ((QueryWindow)this.parent).setIrrelevantButtons(false);
        }
        for (BayesNode curNode : ((BayesGraph)this.graph).getEliminatedNodes()) {
            if (curNode.isObserved()) {
                curNode.setDrawingExtra(((QueryWindow)this.parent).isInvestigatingPeCalculation());
                curNode.setIsEliminated(((QueryWindow)this.parent).isInvestigatingPeCalculation());
                curNode.updatePosition();
                continue;
            }
            curNode.setIsEliminated(false);
        }
        this.query.reset();
        System.runFinalization();
        System.gc();
        this.removeAllTriangulationArcs();
        this.isEliminatingByMouse = true;
        this.factorToFactorsEliminatedHashMap.clear();
        this.eliminatedFactors.clear();
    }

    @Override
    protected void undo() {
        if (this.query == null) {
            return;
        }
        if (this.query.canGoBack()) {
            if (this.query.getLastStep() == InferenceStepByStep.Operations.INITIALIZATION) {
                this.undoOperation();
            }
            if (this.query.canGoBack()) {
                this.undoOperation();
            }
            if (this.query.canGoBack() && this.query.getLastStep() == InferenceStepByStep.Operations.INITIALIZATION) {
                this.undoOperation();
            }
            ((QueryWindow)this.parent).populateFactors();
            ((QueryWindow)this.parent).updateView();
        }
    }

    private void undoOperation() {
        Iterator<Factor> itr = this.query.getFactorsRemoved();
        while (itr.hasNext()) {
            Factor fac = itr.next();
            this.eliminatedFactors.remove(fac);
        }
        itr = this.query.getFactorsComputed();
        while (itr.hasNext()) {
            ((QueryWindow)this.parent).getFactorNameIDHashMap().remove(((QueryWindow)this.parent).getFactorListName(itr.next()));
        }
        if (this.query.canGoBack()) {
            this.query.back();
        }
    }

    public ArrayList<Factor> getCurrentFactors() {
        ArrayList<Factor> curFactors = new ArrayList<Factor>();
        Iterator<Factor> itr = this.query.getFactorsRemaining();
        while (itr.hasNext()) {
            curFactors.add(itr.next());
        }
        try {
            itr = this.query.getFactorsComputed();
            while (itr.hasNext()) {
                Factor curFactor = itr.next();
                curFactors.add(curFactor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return curFactors;
    }

    protected void updateColours() {
        BayesNode node;
        Variable var;
        if (this.query == null) {
            return;
        }
        for (BayesNode node2 : ((BayesGraph)this.graph).getAllNodes()) {
            node2.setDrawingExtra(false);
            node2.setIsEliminated(false);
        }
        if (this.query.getInferenceFlags().contains((Object)InferenceStepByStep.Flags.HEURISTICS_INITIALIZED)) {
            Iterator<Variable> elimItr = this.query.getPartialEliminationOrdering();
            while (elimItr.hasNext()) {
                var = elimItr.next();
                node = ((BayesGraph)this.graph).getNode(var.getName(false));
                node.setIsEliminated(true);
            }
        }
        Iterator<Variable> observedItr = this.query.getObservedVariables();
        while (observedItr.hasNext()) {
            var = observedItr.next();
            node = ((BayesGraph)this.graph).getNode(var.getName(false));
            node.setIsEliminated(true);
            node.setDrawingExtra(true);
        }
        if (this.query.getInferenceFlags().contains((Object)InferenceStepByStep.Flags.PRUNING_DONE)) {
            Iterator<Variable> prunedItr = this.query.getPrunedVariables();
            while (prunedItr.hasNext()) {
                Variable var2 = prunedItr.next();
                BayesNode node3 = ((BayesGraph)this.graph).getNode(var2.getName(false));
                node3.setIsEliminated(true);
            }
        }
        for (BayesNode curNode : ((BayesGraph)this.graph).getAllNodes()) {
            if (((QueryWindow)this.parent).areIrrelevantButtonsEnabled()) {
                if (this.query == null) continue;
                if (curNode.getNodeType() == 7779) {
                    curNode.setNodeAppearance(7781);
                    continue;
                }
                if (this.query.isIrrelevant(((BayesGraph)this.graph).getDecisionNetwork().getVariable(curNode.getLabel()))) {
                    curNode.setNodeAppearance(curNode.getNodeType());
                    curNode.setNodeAppearance(7782);
                    continue;
                }
                curNode.setNodeAppearance(curNode.getNodeType());
                curNode.setNodeAppearance(7783);
                continue;
            }
            if (curNode.isEliminated() || curNode.getNodeType() == 7779) {
                curNode.setNodeAppearance(7781);
                continue;
            }
            if (this.isValidNodeToEliminate(curNode)) {
                curNode.setNodeAppearance(curNode.getNodeType());
                curNode.setNodeAppearance(7782);
                continue;
            }
            curNode.setNodeAppearance(curNode.getNodeType());
            curNode.setNodeAppearance(7783);
        }
        if (this.queryNode != null) {
            this.queryNode.setNodeAppearance(7780);
        }
        this.repaint();
    }

    protected void addTriangulationArcs(Factor factor) {
        int numVariables = factor.getVariablesNum();
        int i = 0;
        while (i < numVariables) {
            int j = 0;
            while (j < numVariables) {
                if (i != j) {
                    BayesNode node1 = ((BayesGraph)this.graph).getNode(factor.getVariable(i).getName(false));
                    BayesNode node2 = ((BayesGraph)this.graph).getNode(factor.getVariable(j).getName(false));
                    if (((BayesGraph)this.graph).getEdge(node1.getIndex(), node2.getIndex()) == null && ((BayesGraph)this.graph).getEdge(node2.getIndex(), node1.getIndex()) == null) {
                        Edge e = new Edge(this.graph, node1, node2);
                        e.edgeType = 5550;
                        ((BayesGraph)this.graph).addEdge(e);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void removeAllTriangulationArcs() {
        for (Edge curEdge : new ArrayList(((BayesGraph)this.graph).edges)) {
            if (curEdge.getEdgeType() != 5550) continue;
            curEdge.removeFromNodes();
            ((BayesGraph)this.graph).edges.remove(curEdge);
            ((BayesNode)curEdge.start).removeChild((BayesNode)curEdge.end);
            ((BayesNode)curEdge.end).removeParent((BayesNode)curEdge.start);
        }
        this.repaint();
    }

    protected boolean isOptimizing() {
        return this.isOptimizing;
    }

    protected boolean isFinished() {
        int numNodes = ((BayesGraph)this.graph).getAllNodes().size() - 1;
        if (this.queryNode != null && ((BayesGraph)this.graph).isDecisionNetwork(false) && this.queryNode.getNodeType() != 7779) {
            --numNodes;
        } else if (this.queryNode == null && !((BayesGraph)this.graph).isDecisionNetwork(false)) {
            ++numNodes;
        }
        return ((BayesGraph)this.graph).getEliminatedNodes().size() == numNodes;
    }

    protected boolean isMoreToProject() {
        if (this.query != null) {
            return this.query.moreToProject();
        }
        return false;
    }

    protected boolean isMoreToEliminate() {
        if (this.query != null) {
            return this.query.moreToEliminate();
        }
        return false;
    }

    protected boolean isNormalizationNeeded() {
        if (this.query != null) {
            return this.query.normalizationNeeded();
        }
        return false;
    }

    protected boolean isValidNodeToEliminate(BayesNode node) {
        if (node.isEliminated() || node.equals(this.queryNode) || this.queryNode != null && this.queryNode.isObserved() || node.getNodeType() == 7779) {
            return false;
        }
        if (node.isObserved()) {
            return !node.isDrawingExtra();
        }
        if (this.query.moreToProject()) {
            return false;
        }
        if (!this.isOptimizing()) {
            return true;
        }
        if (((QueryWindow)this.parent).areIrrelevantButtonsEnabled()) {
            return false;
        }
        return ((PolicyStepByStep)this.query).canBeEliminated(((BayesGraph)this.graph).getDecisionNetwork().getVariable(node.getLabel()));
    }

    protected String getNextName() {
        return this.getNodeToEliminate().getLabel();
    }

    protected void showOrder() {
        Variable[] elimOrder = new Variable[((BayesGraph)this.graph).getDecisionNetwork().getNumVariables()];
        Iterator<Variable> varItr = this.query.getPartialEliminationOrdering();
        int i = 0;
        while (varItr.hasNext()) {
            elimOrder[i++] = varItr.next();
        }
        new ElimOrderDialog((JFrame)this.parent, elimOrder);
    }

    protected void openInspectFactorDialog(JFrame parent, BayesGraph graph, Factor factor, String factorName) {
        if (this.inspectFactorDialog != null) {
            this.inspectFactorDialog.dispose();
        }
        this.inspectFactorDialog = new InspectFactorDialog(parent, graph, factor, factorName, this.isOptimizing);
        this.inspectFactorDialog.open();
    }
}

