/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.Inference;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrArray;

@NotThreadSafe
public final class Configuration
implements Cloneable {
    private boolean factorSavingForTracing;
    private double factorDistributionThreshold;
    private boolean networkEnforceAcyclicity;
    private boolean networkFactorizeNoisyFactors;
    private boolean pruneIrrelevantVariables;
    private Inference.Heuristics eliminationHeuristic;
    private Variable[] eliminationOrdering;

    public void setFactorSavingForTracing(boolean val) {
        this.factorSavingForTracing = val;
    }

    public boolean getFactorSavingForTracing() {
        return this.factorSavingForTracing;
    }

    public void setFactorDistributionThreshold(double threshold) {
        this.factorDistributionThreshold = threshold;
    }

    public double getFactorDistributionThreshold() {
        return this.factorDistributionThreshold;
    }

    public void setNetworkEnforceAcyclicity(boolean val) {
        this.networkEnforceAcyclicity = val;
    }

    public boolean getNetworkEnforceAcyclicity() {
        return this.networkEnforceAcyclicity;
    }

    public void setNetworkFactorizeNoisyFactors(boolean val) {
        this.networkFactorizeNoisyFactors = val;
    }

    public boolean getNetworkFactorizeNoisyFactors() {
        return this.networkFactorizeNoisyFactors;
    }

    public void setPruneIrrelevantVariables(boolean val) {
        this.pruneIrrelevantVariables = val;
    }

    public boolean getPruneIrrelevantVariables() {
        return this.pruneIrrelevantVariables;
    }

    public void setEliminationHeuristic(Inference.Heuristics heuristic) {
        if (heuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            throw new IllegalArgumentException("Illegal elimination heuristic.");
        }
        if (heuristic.equals((Object)Inference.Heuristics.RANDOM) || heuristic.equals((Object)Inference.Heuristics.SEQUENTIAL) || heuristic.equals((Object)Inference.Heuristics.MAX_CARDINALITY)) {
            this.eliminationHeuristic = heuristic;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_FACTOR) || heuristic.equals((Object)Inference.Heuristics.MIN_WEIGHT)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_FACTOR;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_DEGREE) || heuristic.equals((Object)Inference.Heuristics.MIN_SIZE)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_DEGREE;
        } else if (heuristic.equals((Object)Inference.Heuristics.MIN_FILL) || heuristic.equals((Object)Inference.Heuristics.MIN_DEFICIENCY) || heuristic.equals((Object)Inference.Heuristics.MIN_DISCREPANCY) || heuristic.equals((Object)Inference.Heuristics.DEFAULT)) {
            this.eliminationHeuristic = Inference.Heuristics.MIN_FILL;
        } else {
            throw new IllegalArgumentException("Illegal elimination heuristic.");
        }
        this.eliminationOrdering = null;
    }

    public void setEliminationHeuristic(Variable[] ordering) {
        this.eliminationHeuristic = Inference.Heuristics.GIVEN;
        this.eliminationOrdering = new Variable[ordering.length];
        System.arraycopy(ordering, 0, this.eliminationOrdering, 0, ordering.length);
    }

    public Inference.Heuristics getEliminationHeuristic() {
        return this.eliminationHeuristic;
    }

    Variable[] eliminationOrdering() {
        return this.eliminationOrdering;
    }

    public Iterator<Variable> getEliminationOrdering() {
        if (this.eliminationHeuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            return new ItrArray<Variable>(this.eliminationOrdering, this.eliminationOrdering.length);
        }
        throw new UnsupportedOperationException("Elimination ordering was not specified.");
    }

    public Configuration() {
        this.factorSavingForTracing = false;
        this.factorDistributionThreshold = 1.0E-15;
        this.networkEnforceAcyclicity = true;
        this.networkFactorizeNoisyFactors = true;
        this.pruneIrrelevantVariables = true;
        this.eliminationHeuristic = Inference.ELIMINATION_HEURISTIC_DEFAULT;
        this.eliminationOrdering = null;
    }

    private Configuration(Configuration configuration) {
        this.factorSavingForTracing = configuration.factorSavingForTracing;
        this.factorDistributionThreshold = configuration.factorDistributionThreshold;
        this.networkEnforceAcyclicity = true;
        this.networkFactorizeNoisyFactors = configuration.networkFactorizeNoisyFactors;
        this.pruneIrrelevantVariables = configuration.pruneIrrelevantVariables;
        this.eliminationHeuristic = configuration.eliminationHeuristic;
        this.eliminationOrdering = configuration.eliminationOrdering;
    }

    public void save() {
    }

    public void load() {
    }

    public Configuration clone() {
        return new Configuration(this);
    }

    public String toString(boolean withId) {
        StringBuilder output = new StringBuilder();
        output.append("Factor/DecisionNetwork: save factors for tracing = " + this.factorSavingForTracing + "\n");
        output.append("DecisionNetwork/FactorCPT: threshold = " + this.factorDistributionThreshold + "\n");
        output.append("DecisionNetwork: enforce acyclicity = " + this.networkEnforceAcyclicity + "\n");
        output.append("DecisionNetwork: factorize noisy factors = " + this.networkFactorizeNoisyFactors + "\n");
        output.append("Query/Policy: prune of irrelevant variables = " + this.pruneIrrelevantVariables + "\n");
        if (this.eliminationHeuristic.equals((Object)Inference.Heuristics.GIVEN)) {
            output.append("Query/Policy: elimination ordering given = <");
            int i = 0;
            while (i < this.eliminationOrdering.length - 1) {
                output.append(String.valueOf(this.eliminationOrdering[i].getName(withId)) + ", ");
                ++i;
            }
            output.append(String.valueOf(this.eliminationOrdering[this.eliminationOrdering.length - 1].getName(true)) + ">");
        } else {
            output.append("Query/Policy: elimination heuristic = " + (Object)((Object)this.eliminationHeuristic));
        }
        return output.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

