/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStored;
import org.AIspace.ve.Variable;

public final class FactorDivide
extends FactorStored {
    private Factor dividend;
    private Factor divisor;

    public Factor getDividend() {
        if (this.dividend == null) {
            throw new UnsupportedOperationException("Factor was not saved for tracing!");
        }
        return this.dividend;
    }

    public Factor getDivisor() {
        if (this.divisor == null) {
            throw new UnsupportedOperationException("Factor was not saved for tracing!");
        }
        return this.divisor;
    }

    FactorDivide(Factor dividend, Factor divisor, boolean saveForTracing) {
        super(new Variable[0], false, FactorDivide.computevalue(dividend, divisor), false);
        if (saveForTracing) {
            this.dividend = dividend;
            this.divisor = divisor;
        }
    }

    private static double[] computevalue(Factor dividend, Factor divisor) {
        if (dividend.getSize() != 1L || divisor.getSize() != 1L) {
            throw new IllegalArgumentException("Factors have to represent two constants!");
        }
        double[] result = new double[1];
        try {
            result[0] = dividend.iterator().next() / divisor.iterator().next();
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Divisor factor represents 0!");
        }
        return result;
    }
}

