/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorDirected;
import org.AIspace.ve.FactorInterpretable;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.PairComparable;

public final class FactorObserved
extends Factor
implements FactorInterpretable {
    private final Factor originalFactor;
    private Variable[] observedVariables;
    private int[] observedValuesIndexes;
    private final int[] domainSizeObserved;
    private final int[] valsObserved;
    private final int[] domainSizeBetween;
    private final int numObsBlocks;

    public Factor getOriginalFactor() {
        return this.originalFactor;
    }

    public Iterator<PairComparable<Variable, Integer>> getObservedVariables() {
        if (this.observedVariables != null) {
            return new Iterator<PairComparable<Variable, Integer>>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < FactorObserved.this.observedVariables.length;
                }

                @Override
                public PairComparable<Variable, Integer> next() {
                    if (this.index < FactorObserved.this.observedVariables.length) {
                        return new PairComparable<Variable, Integer>(FactorObserved.this.observedVariables[this.index], FactorObserved.this.observedValuesIndexes[this.index++]);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        throw new UnsupportedOperationException("Data was not saved for tracing!");
    }

    private FactorObserved(Variable[] variables, Factor originalFactor, Variable[] observedVariables, int[] domainSizeObserved, int[] valsObserved, int[] domainSizeBetween, int numObsBlocks, boolean saveForTracing) {
        super(variables, false);
        this.originalFactor = originalFactor;
        if (saveForTracing) {
            this.observedVariables = new Variable[observedVariables.length];
            System.arraycopy(observedVariables, 0, this.observedVariables, 0, observedVariables.length);
            this.observedValuesIndexes = new int[valsObserved.length];
            System.arraycopy(valsObserved, 0, this.observedValuesIndexes, 0, valsObserved.length);
        }
        this.domainSizeObserved = domainSizeObserved;
        this.valsObserved = valsObserved;
        this.domainSizeBetween = domainSizeBetween;
        this.numObsBlocks = numObsBlocks;
    }

    @Override
    public String getInterpretationFunctor() {
        Factor previousFactor = this;
        while (previousFactor instanceof FactorObserved) {
            previousFactor = previousFactor.getOriginalFactor();
        }
        if (previousFactor instanceof FactorInterpretable) {
            return ((FactorInterpretable)((Object)previousFactor)).getInterpretationFunctor();
        }
        return "";
    }

    @Override
    public String getInterpretation(boolean withId) {
        if (this.observedVariables != null) {
            TreeMap<Variable, String> varToDescription = new TreeMap<Variable, String>();
            int i = 0;
            while (i < this.variables.length) {
                varToDescription.put(this.variables[i], this.variables[i].getName(withId));
                ++i;
            }
            Factor previousFactor = this;
            while (previousFactor instanceof FactorObserved) {
                Iterator<PairComparable<Variable, Integer>> observationsIterator = previousFactor.getObservedVariables();
                while (observationsIterator.hasNext()) {
                    PairComparable<Variable, Integer> observation = observationsIterator.next();
                    varToDescription.put((Variable)observation.getFirstElement(), ((Variable)observation.getFirstElement()).getName(withId) + "=" + ((Variable)observation.getFirstElement()).getDomain().getValue((Integer)observation.getSecondElement()));
                }
                previousFactor = previousFactor.getOriginalFactor();
            }
            if (previousFactor instanceof FactorInterpretable) {
                Iterator descriptionsIterator;
                StringBuilder nameString = withId ? new StringBuilder("[" + this.getId() + "]" + ((FactorInterpretable)((Object)previousFactor)).getInterpretationFunctor() + "(") : new StringBuilder(String.valueOf(((FactorInterpretable)((Object)previousFactor)).getInterpretationFunctor()) + "(");
                if (previousFactor instanceof FactorDirected) {
                    nameString.append((String)varToDescription.remove(((FactorDirected)((Object)previousFactor)).getChild()));
                }
                if ((descriptionsIterator = varToDescription.values().iterator()).hasNext()) {
                    if (previousFactor instanceof FactorDirected) {
                        nameString.append(" | ");
                    }
                    nameString.append((String)descriptionsIterator.next());
                }
                while (descriptionsIterator.hasNext()) {
                    nameString.append(", ").append((String)descriptionsIterator.next());
                }
                return nameString.append(")").toString();
            }
        }
        return this.getName(withId);
    }

    @Override
    public FactorIterator iterator() {
        return new FactorIterator(){
            private final FactorIterator factItr;
            private final long[] currBet;
            {
                this.currBet = new long[FactorObserved.this.numObsBlocks + 1];
                int i = 0;
                while (i <= FactorObserved.this.numObsBlocks) {
                    this.currBet[i] = FactorObserved.this.domainSizeBetween[i];
                    ++i;
                }
                this.factItr = FactorObserved.this.originalFactor.iterator();
                this.factItr.backTo(this.factPos());
            }

            @Override
            public boolean hasNext() {
                if (this.currBet[FactorObserved.this.numObsBlocks] > 0L) {
                    return true;
                }
                int i = 0;
                while (i < FactorObserved.this.numObsBlocks) {
                    if (this.currBet[i] > 1L) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public double next() {
                if (this.currBet[FactorObserved.this.numObsBlocks] > 0L) {
                    int n = FactorObserved.this.numObsBlocks;
                    this.currBet[n] = this.currBet[n] - 1L;
                    return this.factItr.next();
                }
                int i = FactorObserved.this.numObsBlocks - 1;
                while (i >= 0) {
                    this.currBet[i + 1] = FactorObserved.this.domainSizeBetween[i + 1];
                    if (this.currBet[i] > 1L) {
                        int n = i;
                        this.currBet[n] = this.currBet[n] - 1L;
                        this.factItr.backTo(this.factPos());
                        int n2 = FactorObserved.this.numObsBlocks;
                        this.currBet[n2] = this.currBet[n2] - 1L;
                        return this.factItr.next();
                    }
                    --i;
                }
                throw new NoSuchElementException();
            }

            @Override
            public long currPos() {
                long pos = (long)FactorObserved.this.domainSizeBetween[0] - this.currBet[0];
                int i = 1;
                while (i <= FactorObserved.this.numObsBlocks) {
                    pos = (pos + 1L) * (long)FactorObserved.this.domainSizeBetween[i] - this.currBet[i];
                    ++i;
                }
                return pos;
            }

            @Override
            public void backTo(long pos) {
                if (pos >= 0L & pos < FactorObserved.this.getSize()) {
                    int i = FactorObserved.this.numObsBlocks;
                    while (i > 0) {
                        this.currBet[i] = (long)FactorObserved.this.domainSizeBetween[i] - pos % (long)FactorObserved.this.domainSizeBetween[i];
                        pos /= (long)FactorObserved.this.domainSizeBetween[i];
                        --i;
                    }
                } else {
                    throw new NoSuchElementException();
                }
                this.currBet[0] = (long)FactorObserved.this.domainSizeBetween[0] - pos;
                this.factItr.backTo(this.factPos());
            }

            private long factPos() {
                long pos = (long)FactorObserved.this.domainSizeBetween[0] - this.currBet[0];
                int i = 0;
                while (i < FactorObserved.this.numObsBlocks) {
                    pos = (pos * (long)FactorObserved.this.domainSizeObserved[i] + (long)FactorObserved.this.valsObserved[i] + 1L) * (long)FactorObserved.this.domainSizeBetween[i + 1] - this.currBet[i + 1];
                    ++i;
                }
                return pos;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public static FactorObserved projectObservation(Factor originalFactor, Variable[] observedVars, int[] observedVals, boolean saveForTracing) {
        variables = Variable.diffVars(originalFactor.variables, observedVars);
        domainSizeObserved = new int[observedVars.length];
        valsObserved = new int[observedVars.length];
        domainSizeBetween = new int[observedVars.length + 1];
        observedIndex = 0;
        observedVariables = null;
        if (saveForTracing) {
            observedVariables = new Variable[originalFactor.getVariablesNum() - variables.length];
        }
        varsIndex = 0;
        originalFactorIndex = 0;
        numObsBlocks = 0;
        domainSizeBetween[0] = 1;
        ** GOTO lbl39
        {
            ++varsIndex;
            do {
                if (originalFactorIndex < originalFactor.variables.length && varsIndex < observedVars.length && observedVars[varsIndex].compareTo(originalFactor.variables[originalFactorIndex]) < 0) continue block0;
                while (originalFactorIndex < originalFactor.variables.length && (varsIndex >= observedVars.length || originalFactor.variables[originalFactorIndex].compareTo(observedVars[varsIndex]) < 0)) {
                    v0 = numObsBlocks;
                    domainSizeBetween[v0] = domainSizeBetween[v0] * originalFactor.variables[originalFactorIndex++].getDomain().getSize();
                    while (originalFactorIndex < originalFactor.variables.length && varsIndex < observedVars.length && observedVars[varsIndex].compareTo(originalFactor.variables[originalFactorIndex]) < 0) {
                        ++varsIndex;
                    }
                }
                if (originalFactorIndex >= originalFactor.variables.length || varsIndex >= observedVars.length) continue;
                domainSizeObserved[numObsBlocks] = 1;
                while (originalFactorIndex < originalFactor.variables.length && varsIndex < observedVars.length && observedVars[varsIndex].equals(originalFactor.variables[originalFactorIndex])) {
                    if (saveForTracing) {
                        observedVariables[observedIndex++] = observedVars[varsIndex];
                    }
                    v1 = numObsBlocks;
                    domainSizeObserved[v1] = domainSizeObserved[v1] * observedVars[varsIndex].getDomain().getSize();
                    valsObserved[numObsBlocks] = valsObserved[numObsBlocks] * observedVars[varsIndex].getDomain().getSize() + observedVals[varsIndex];
                    ++varsIndex;
                    ++originalFactorIndex;
                    while (originalFactorIndex < originalFactor.variables.length && varsIndex < observedVars.length && observedVars[varsIndex].compareTo(originalFactor.variables[originalFactorIndex]) < 0) {
                        ++varsIndex;
                    }
                }
                domainSizeBetween[++numObsBlocks] = 1;
lbl39:
                // 3 sources

            } while (originalFactorIndex < originalFactor.variables.length);
        }
        if (numObsBlocks == 0) {
            throw new IllegalArgumentException("No observation could be projected onto the factor!");
        }
        return new FactorObserved(variables, originalFactor, observedVariables, domainSizeObserved, valsObserved, domainSizeBetween, numObsBlocks, saveForTracing);
    }
}

