/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.HashSet;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.DecisionNetwork;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStoreIndexed;
import org.AIspace.ve.Inference;
import org.AIspace.ve.Variable;

@NotThreadSafe
final class FactorStoreIndexedBN
extends FactorStoreIndexed<Long> {
    FactorStoreIndexedBN(DecisionNetwork dnet, Variable[] toSumOut, Iterator<Factor> initFactorsIterator, int nrInitFactors, Iterator<Variable> variablesIterator, int numVariables, Inference.Heuristics how) {
        super(dnet, toSumOut, initFactorsIterator, nrInitFactors, variablesIterator, numVariables, how);
    }

    private FactorStoreIndexedBN(FactorStoreIndexedBN factorStore) {
        super(factorStore);
        this.varsPQ = new VariableToEliminate[factorStore.varsPQ.length];
        int i = 0;
        while (i < this.numVariablesToEliminate) {
            this.varsPQ[i] = new VariableToEliminate(factorStore.varsPQ[i]);
            if (factorStore.varsPQ[i].factors != null) {
                this.varsPQ[i].factors = (HashSet)this.factorIndex.get(this.varsPQ[i].var);
            }
            this.varToVarInQuery.put(this.varsPQ[i].var, this.varsPQ[i]);
            ++i;
        }
    }

    @Override
    void createHeapSpace(Variable[] toSumOut, int numVariables) {
        this.varsPQ = new VariableToEliminate[this.numVariablesToEliminate];
        int i = 0;
        while (i < this.numVariablesToEliminate) {
            this.varsPQ[i] = new VariableToEliminate(toSumOut[i], numVariables - 1);
            this.varToVarInQuery.put(toSumOut[i], this.varsPQ[i]);
            ++i;
        }
    }

    @Override
    public FactorStoreIndexedBN clone() {
        return new FactorStoreIndexedBN(this);
    }

    final class VariableToEliminate
    extends FactorStoreIndexed.VariableToEliminate {
        VariableToEliminate(Variable variable, int maxNumNeighs) {
            super(variable, maxNumNeighs);
        }

        private VariableToEliminate(FactorStoreIndexed.VariableToEliminate variable) {
            super(variable);
        }

        @Override
        void setMinDegree() {
            this.heuristicValue = Long.valueOf(this.numNeighbors);
        }

        @Override
        void setMinFill() {
            this.heuristicValue = Long.valueOf(this.recomputeMinFill());
        }

        @Override
        void setMinFactor() {
            this.heuristicValue = Long.valueOf(this.recomputeMinFactor());
        }

        @Override
        void setMaxCardinality() {
            this.heuristicValue = Long.valueOf(this.recomputeMaxCardinality());
        }

        @Override
        void setGiven(int index) {
            this.heuristicValue = Long.valueOf(index);
        }

        Long cloneHeuristicValue() {
            return new Long((Long)this.heuristicValue);
        }
    }
}

