/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.HashMap;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStore;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrArray;

@NotThreadSafe
final class FactorStoreSequential
implements FactorStore {
    private final Variable[] variables;
    private int varPos;
    private final int factorMaxSize;
    private final Factor[][] buckets;
    private final int[] bucketSize;
    private final HashMap<Variable, Integer> varToBucketIndex;
    private final Factor[] finalFactors;
    private int numFinalFactors;

    FactorStoreSequential(Variable[] toSumOut, Iterator<Factor> initialFactorsIterator, int nrInitialFactors) {
        this.variables = new Variable[toSumOut.length];
        System.arraycopy(toSumOut, 0, this.variables, 0, toSumOut.length);
        this.varPos = 0;
        if (nrInitialFactors < 1) {
            throw new IllegalArgumentException("Number of initial factors has to be greater than 0.");
        }
        this.factorMaxSize = nrInitialFactors;
        this.buckets = new Factor[toSumOut.length][this.factorMaxSize];
        this.bucketSize = new int[toSumOut.length];
        this.varToBucketIndex = new HashMap(toSumOut.length * 3 / 2);
        this.numFinalFactors = 0;
        this.finalFactors = new Factor[nrInitialFactors];
        int i = 0;
        while (i < toSumOut.length) {
            this.varToBucketIndex.put(toSumOut[i], new Integer(i));
            ++i;
        }
        while (initialFactorsIterator.hasNext()) {
            this.addtoBuckets(initialFactorsIterator.next());
        }
    }

    private FactorStoreSequential(FactorStoreSequential factorStore) {
        this.variables = new Variable[factorStore.variables.length];
        System.arraycopy(factorStore.variables, 0, this.variables, 0, factorStore.variables.length);
        this.varPos = factorStore.varPos;
        this.factorMaxSize = factorStore.factorMaxSize;
        this.buckets = new Factor[factorStore.buckets.length][];
        int i = 0;
        while (i < factorStore.buckets.length) {
            this.buckets[i] = new Factor[factorStore.buckets[i].length];
            System.arraycopy(factorStore.buckets[i], 0, this.buckets[i], 0, factorStore.buckets[i].length);
            ++i;
        }
        this.bucketSize = new int[factorStore.bucketSize.length];
        System.arraycopy(factorStore.bucketSize, 0, this.bucketSize, 0, factorStore.bucketSize.length);
        this.varToBucketIndex = new HashMap<Variable, Integer>(factorStore.varToBucketIndex);
        this.finalFactors = new Factor[factorStore.finalFactors.length];
        System.arraycopy(factorStore.finalFactors, 0, this.finalFactors, 0, factorStore.finalFactors.length);
        this.numFinalFactors = factorStore.numFinalFactors;
    }

    @Override
    public boolean hasNext() {
        return this.varPos < this.variables.length;
    }

    @Override
    public Variable next() {
        if (this.varPos > 0) {
            this.buckets[this.varPos - 1] = null;
        }
        return this.variables[this.varPos++];
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFactorComputed(Factor newFactor) {
        this.addtoBuckets(newFactor);
    }

    private void addtoBuckets(Factor factor) {
        int lowestBucket = Integer.MAX_VALUE;
        int i = 0;
        while (i < factor.getVariablesNum()) {
            Integer pos = this.varToBucketIndex.get(factor.getVariable(i));
            if (pos != null && pos >= this.varPos && pos < lowestBucket) {
                lowestBucket = pos;
            }
            ++i;
        }
        if (lowestBucket == Integer.MAX_VALUE) {
            this.finalFactors[this.numFinalFactors++] = factor;
        } else {
            if (this.buckets[lowestBucket].length == this.bucketSize[lowestBucket]) {
                Factor[] newBucket = new Factor[1 + this.buckets[lowestBucket].length * 2];
                System.arraycopy(this.buckets[lowestBucket], 0, newBucket, 0, this.buckets[lowestBucket].length);
                this.buckets[lowestBucket] = newBucket;
            }
            int n = lowestBucket;
            int n2 = this.bucketSize[n];
            this.bucketSize[n] = n2 + 1;
            this.buckets[lowestBucket][n2] = factor;
        }
    }

    @Override
    public Iterator<Factor> enumFactorsRemoved() {
        return new ItrArray<Factor>(this.buckets[this.varPos - 1], this.bucketSize[this.varPos - 1]);
    }

    @Override
    public Iterator<Factor> enumFactorsFinal() {
        return new ItrArray<Factor>(this.finalFactors, this.numFinalFactors);
    }

    @Override
    public int getNumFactorsFinal() {
        return this.numFinalFactors;
    }

    @Override
    public FactorStoreSequential clone() {
        return new FactorStoreSequential(this);
    }
}

