/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorStore;
import org.AIspace.ve.Variable;
import org.AIspace.ve.tools.ItrArray;
import org.AIspace.ve.tools.ItrIterator;

@NotThreadSafe
final class FactorStoreUnordered
implements FactorStore {
    private final HashMap<Variable, TreeSet<Factor>> buckets;
    private TreeSet<Factor> removedFactors;
    private Factor factorComputed;
    private final TreeSet<Factor> factorsRemaining;
    private final Factor[] finalFactors;
    private int numFinalFactors;

    FactorStoreUnordered(Variable[] toSumOut, Iterator<Factor> initialFactorsIterator, int nrInitialFactors) {
        this.buckets = new HashMap(toSumOut.length * 3 / 2);
        this.removedFactors = null;
        this.factorComputed = null;
        this.factorsRemaining = new TreeSet();
        if (nrInitialFactors < 1) {
            throw new IllegalArgumentException("Number of initial factors has to be greater than 0.");
        }
        this.finalFactors = new Factor[nrInitialFactors + 1];
        this.numFinalFactors = 0;
        Variable[] variableArray = toSumOut;
        int n = toSumOut.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.buckets.put(variable, new TreeSet());
            ++n2;
        }
        while (initialFactorsIterator.hasNext()) {
            this.addtoBuckets(initialFactorsIterator.next());
        }
    }

    private FactorStoreUnordered(FactorStoreUnordered factorStore) {
        this.buckets = new HashMap();
        for (Map.Entry<Variable, TreeSet<Factor>> entry : factorStore.buckets.entrySet()) {
            this.buckets.put(entry.getKey(), new TreeSet(entry.getValue()));
        }
        if (factorStore.removedFactors != null) {
            this.removedFactors = new TreeSet<Factor>((SortedSet<Factor>)factorStore.removedFactors);
        }
        this.factorComputed = factorStore.factorComputed;
        this.factorsRemaining = new TreeSet<Factor>((SortedSet<Factor>)factorStore.factorsRemaining);
        this.finalFactors = new Factor[factorStore.finalFactors.length];
        System.arraycopy(factorStore.finalFactors, 0, this.finalFactors, 0, factorStore.finalFactors.length);
        this.numFinalFactors = factorStore.numFinalFactors;
    }

    @Override
    public boolean hasNext() {
        return !this.buckets.isEmpty();
    }

    @Override
    public Variable next() {
        throw new UnsupportedOperationException("This FactorStore is unsorted. It does not know which Variable will be eliminated next.");
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private void remove(Variable variable) {
        TreeSet<Factor> mainBucket = this.buckets.get(variable);
        if (mainBucket == null) {
            throw new IllegalArgumentException("Variable is not in the FactorStore.");
        }
        for (Factor factor : mainBucket) {
            Iterator<Variable> variablesIterator = factor.getVariables();
            while (variablesIterator.hasNext()) {
                TreeSet<Factor> bucket;
                Variable factorVariable = variablesIterator.next();
                if (factorVariable.equals(variable) || (bucket = this.buckets.get(factorVariable)) == null) continue;
                bucket.remove(factor);
            }
        }
        this.buckets.remove(variable);
    }

    void next(Variable variable) {
        TreeSet<Factor> bucket = this.buckets.get(variable);
        if (bucket == null) {
            throw new IllegalArgumentException("Variable " + variable + " can not be eliminated, it is not in the network now.");
        }
        if (this.factorComputed != null) {
            this.addtoBuckets(this.factorComputed);
        }
        this.removedFactors = bucket;
        this.remove(variable);
        Iterator<Factor> removedFactorsIterator = this.enumFactorsRemoved();
        while (removedFactorsIterator.hasNext()) {
            this.factorsRemaining.remove(removedFactorsIterator.next());
        }
    }

    @Override
    public void addFactorComputed(Factor newFactor) {
        this.factorComputed = newFactor;
    }

    private void addtoBuckets(Factor factor) {
        boolean notAdded = true;
        Iterator<Variable> factorVariablesIterator = factor.getVariables();
        while (factorVariablesIterator.hasNext()) {
            TreeSet<Factor> bucket = this.buckets.get(factorVariablesIterator.next());
            if (bucket == null) continue;
            bucket.add(factor);
            notAdded = false;
        }
        if (notAdded) {
            this.finalFactors[this.numFinalFactors++] = factor;
        } else {
            this.factorsRemaining.add(factor);
        }
    }

    @Override
    public Iterator<Factor> enumFactorsRemoved() {
        if (this.removedFactors != null) {
            return new ItrIterator<Factor>(this.removedFactors.iterator());
        }
        throw new UnsupportedOperationException("None of the variables has been eliminated or pruned yet.");
    }

    boolean existsFactorComputed() {
        return this.factorComputed != null;
    }

    Factor factorComputed() {
        if (this.factorComputed != null) {
            return this.factorComputed;
        }
        throw new UnsupportedOperationException("None of the variables has been eliminated yet.");
    }

    Iterator<Factor> enumFactorsRemaining() {
        return new ItrIterator<Factor>(this.factorsRemaining.iterator());
    }

    @Override
    public Iterator<Factor> enumFactorsFinal() {
        return new ItrArray<Factor>(this.finalFactors, this.numFinalFactors);
    }

    @Override
    public int getNumFactorsFinal() {
        return this.numFinalFactors;
    }

    @Override
    public FactorStoreUnordered clone() {
        return new FactorStoreUnordered(this);
    }
}

