/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.AIspace.ve.Factor;
import org.AIspace.ve.FactorIterator;
import org.AIspace.ve.Variable;

public class FactorStored
extends Factor {
    private final double[] factorValues;

    @Override
    public final double getValue(long index) {
        if (index < 0L || index >= (long)this.factorValues.length) {
            throw new IllegalArgumentException("Given index is outside of the proper range.");
        }
        return this.factorValues[(int)index];
    }

    public FactorStored(Variable[] variables, boolean copyVariables, String values, Pattern separator) {
        super(variables, copyVariables);
        if (Integer.MAX_VALUE < this.getSize()) {
            throw new OutOfMemoryError("New factor is too large (array size greater than Integer.Max_VALUE)!");
        }
        this.factorValues = new double[(int)this.getSize()];
        this.stringToValues(values, separator);
    }

    public FactorStored(Variable[] variables, boolean copyVariables, double[] values, boolean copyValues) {
        super(variables, copyVariables);
        if ((long)values.length != this.getSize()) {
            throw new IllegalArgumentException("Number of provided values is incorrect!");
        }
        if (copyValues) {
            this.factorValues = new double[values.length];
            System.arraycopy(values, 0, this.factorValues, 0, values.length);
        } else {
            this.factorValues = values;
        }
    }

    @Override
    public final FactorIterator iterator() {
        return new FactorIterator(){
            private int curpos = 0;

            @Override
            public boolean hasNext() {
                return this.curpos < FactorStored.this.factorValues.length;
            }

            @Override
            public double next() {
                if (this.curpos < FactorStored.this.factorValues.length) {
                    return FactorStored.this.factorValues[this.curpos++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public long currPos() {
                return this.curpos;
            }

            @Override
            public void backTo(long pos) {
                if (!(pos >= 0L & pos < (long)FactorStored.this.factorValues.length)) {
                    throw new IllegalArgumentException();
                }
                this.curpos = (int)pos;
            }
        };
    }

    private void stringToValues(String string, Pattern separator) {
        Scanner scanner = new Scanner(string);
        scanner.useLocale(Locale.US);
        scanner.useDelimiter(separator);
        int i = 0;
        while (i < this.factorValues.length) {
            if (!scanner.hasNextDouble()) {
                throw new IllegalArgumentException("String contains too few values!");
            }
            this.factorValues[i] = scanner.nextDouble();
            ++i;
        }
        if (scanner.hasNextDouble()) {
            throw new IllegalArgumentException("String contains too many values!");
        }
    }
}

