/*
 * Decompiled with CFR 0.152.
 */
package org.AIspace.ve;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;
import org.AIspace.ve.NamedAndUnique;
import org.AIspace.ve.tools.ItrIterator;

@NotThreadSafe
public class Graph<Node extends Comparable<Node> & NamedAndUnique> {
    protected final TreeMap<Node, TreeSet<Node>> parents = new TreeMap();
    protected final HashMap<Node, HashSet<Node>> ancestors = new HashMap();

    final boolean inGraph(Node node) {
        return this.parents.containsKey(node);
    }

    final void addNode(Node node) {
        TreeSet previousValue = this.parents.put(node, new TreeSet());
        if (previousValue != null) {
            this.parents.put(node, previousValue);
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)node).getName() + "' is already in the graph.");
        }
        this.ancestors.put(node, new HashSet());
    }

    final void removeNode(Node node) {
        if (!this.parents.containsKey(node)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)node).getName() + "' is not in the graph.");
        }
        for (Map.Entry<Node, TreeSet<Node>> entry : this.parents.entrySet()) {
            if (!entry.getValue().remove(node)) continue;
            this.rebuildAncestors((Comparable)entry.getKey());
        }
        this.parents.remove(node);
        this.ancestors.remove(node);
    }

    final Iterator<Node> getNodes() {
        return this.parents.keySet().iterator();
    }

    final int getNodesNum() {
        return this.parents.size();
    }

    final boolean isParent(Node child, Node parent) {
        if (!this.parents.containsKey(child)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)child).getName() + "' is not in the graph.");
        }
        if (!this.parents.containsKey(parent)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)parent).getName() + "' is not in the graph.");
        }
        return this.parents.get(child).contains(parent);
    }

    final boolean couldBeParent(Node child, Node parent) {
        if (!this.parents.containsKey(child)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)child).getName() + "' is not in the graph.");
        }
        if (!this.parents.containsKey(parent)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)parent).getName() + "' is not in the graph.");
        }
        return !this.ancestors.get(parent).contains(child);
    }

    final void addParent(Node child, Node parent, boolean enforceAcyclicity) {
        if (child.equals(parent)) {
            throw new IllegalArgumentException("Node can not be its' own parent.");
        }
        if (enforceAcyclicity && this.ancestors.get(parent).contains(child)) {
            throw new IllegalArgumentException("Edge from node '" + ((NamedAndUnique)parent).getName() + "' to node '" + ((NamedAndUnique)child).getName() + "' introduces a directed cycle in the graph.");
        }
        if (!this.parents.containsKey(parent)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)parent).getName() + "' is not in the graph.");
        }
        TreeSet<Node> nodeParents = this.parents.get(child);
        if (nodeParents == null) {
            throw new IllegalArgumentException("Child node '" + ((NamedAndUnique)child).getName() + "' is not in the graph.");
        }
        if (!nodeParents.add(parent)) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)parent).getName() + "' is already registered as a parent of the node '" + ((NamedAndUnique)child).getName() + "'.");
        }
        HashSet<Node> parentAncestors = this.ancestors.get(parent);
        for (Map.Entry<Node, HashSet<Node>> entry : this.ancestors.entrySet()) {
            HashSet<Node> nodeAncestors = entry.getValue();
            if (!((Comparable)entry.getKey()).equals(child) && !nodeAncestors.contains(child)) continue;
            nodeAncestors.add(parent);
            for (Comparable parentAncestor : parentAncestors) {
                nodeAncestors.add(parentAncestor);
            }
        }
    }

    final void removeParents(Node child) {
        TreeSet<Node> nodeParents = this.parents.get(child);
        if (nodeParents == null) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)child).getName() + "' is not in the graph.");
        }
        nodeParents.clear();
        this.rebuildAncestors(child);
    }

    final Iterator<Node> getParents(Node child) {
        TreeSet<Node> nodeParents = this.parents.get(child);
        if (nodeParents == null) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)child).getName() + "' is not in the graph.");
        }
        return new ItrIterator<Node>(nodeParents.iterator());
    }

    final int getParentsNum(Node child) {
        TreeSet<Node> nodeParents = this.parents.get(child);
        if (nodeParents == null) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)child).getName() + "' is not in the Graph.");
        }
        return nodeParents.size();
    }

    private final void rebuildAncestors(Node descendant) {
        HashSet<Node> descendantAncestors = this.ancestors.get(descendant);
        descendantAncestors.clear();
        for (Comparable comparable : this.parents.get(descendant)) {
            descendantAncestors.add(comparable);
            for (Comparable parentAncestor : this.ancestors.get(comparable)) {
                descendantAncestors.add(parentAncestor);
            }
        }
        for (Map.Entry entry : this.parents.entrySet()) {
            if (!((TreeSet)entry.getValue()).contains(descendant)) continue;
            this.rebuildAncestors((Comparable)entry.getKey());
        }
    }

    final Iterator<Node> getAncestors(Node descendant) {
        HashSet<Node> nodeAncestors = this.ancestors.get(descendant);
        if (nodeAncestors == null) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)descendant).getName() + "' is not in the graph.");
        }
        return new ItrIterator<Node>(nodeAncestors.iterator());
    }

    final int getAncestorsNum(Node descendant) {
        HashSet<Node> nodeAncestors = this.ancestors.get(descendant);
        if (nodeAncestors == null) {
            throw new IllegalArgumentException("Node '" + ((NamedAndUnique)descendant).getName() + "' is not in the Graph.");
        }
        return nodeAncestors.size();
    }

    private final void visit(Node node, LinkedList<Node> order, HashSet<Node> visitedNodes, HashSet<Node> cycleDetector) {
        if (cycleDetector.contains(node)) {
            throw new UnsupportedOperationException("The graph is cyclic.");
        }
        cycleDetector.add(node);
        if (!visitedNodes.contains(node)) {
            visitedNodes.add(node);
            for (Comparable parent : this.parents.get(node)) {
                this.visit(parent, order, visitedNodes, cycleDetector);
            }
            order.addLast(node);
        }
        cycleDetector.remove(node);
    }

    final LinkedList<Node> getTopologicalOrdering() {
        LinkedList order = new LinkedList();
        HashSet visitedNodes = new HashSet();
        HashSet cycleDetector = new HashSet();
        for (Comparable node : this.parents.keySet()) {
            try {
                this.visit(node, order, visitedNodes, cycleDetector);
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException(e.getMessage());
            }
        }
        return order;
    }

    public Graph<Node> clone() {
        Graph<Node> clone = new Graph<Node>();
        for (Map.Entry<Node, TreeSet<Node>> entry : this.parents.entrySet()) {
            clone.parents.put((Comparable)entry.getKey(), new TreeSet(entry.getValue()));
        }
        for (Map.Entry<Node, AbstractSet> entry : this.ancestors.entrySet()) {
            clone.ancestors.put((Comparable)entry.getKey(), new HashSet(entry.getValue()));
        }
        return clone;
    }

    public final String toString() {
        return this.toString(true);
    }

    public String toString(boolean withId) {
        return this.toString(withId, true);
    }

    public String toString(boolean withId, boolean withAncestors) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<Node, TreeSet<Node>> entry : this.parents.entrySet()) {
            output.append("parents(").append(((NamedAndUnique)entry.getKey()).getName(withId)).append(") = {");
            Iterator<Node> parentsIterator = entry.getValue().iterator();
            if (parentsIterator.hasNext()) {
                output.append(((NamedAndUnique)parentsIterator.next()).getName(withId));
            }
            while (parentsIterator.hasNext()) {
                output.append(", ").append(((NamedAndUnique)parentsIterator.next()).getName(withId));
            }
            output.append("}\n");
        }
        if (withAncestors) {
            output.append("\n");
            for (Map.Entry<Node, AbstractSet> entry : this.ancestors.entrySet()) {
                output.append("ancestors(").append(((NamedAndUnique)entry.getKey()).getName(withId)).append(") = {");
                Iterator ancestorsIterator = ((HashSet)entry.getValue()).iterator();
                if (ancestorsIterator.hasNext()) {
                    output.append(((NamedAndUnique)ancestorsIterator.next()).getName(withId));
                }
                while (ancestorsIterator.hasNext()) {
                    output.append(", ").append(((NamedAndUnique)ancestorsIterator.next()).getName(withId));
                }
                output.append("}\n");
            }
        }
        if (output.length() > 0) {
            output.delete(output.length() - 1, output.length());
        }
        return output.toString();
    }
}

